/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import java.text.NumberFormat;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class SQLExecutionLoggerImpl
implements SQLExecutionLogger {
    private final LineCookie lineCookie;
    private final InputOutput inputOutput;
    private boolean inputOutputSelected = false;
    private int errorCount;

    public SQLExecutionLoggerImpl(String displayName, LineCookie lineCookie) {
        this.lineCookie = lineCookie;
        String ioName = NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_SQLFileExecution", (Object)displayName);
        this.inputOutput = IOProvider.getDefault().getIO(ioName, true);
    }

    public void log(SQLExecutionResult result) {
        if (result.getException() != null) {
            this.logException(result);
        } else {
            this.logSuccess(result);
        }
    }

    public void finish(long executionTime) {
        OutputWriter writer = this.inputOutput.getOut();
        writer.println(NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutionFinished", (Object)String.valueOf(this.millisecondsToSeconds(executionTime)), (Object)String.valueOf(this.errorCount)));
        writer.println("");
    }

    public void cancel() {
        OutputWriter writer = this.inputOutput.getErr();
        writer.println(NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
        writer.println("");
    }

    public void close() {
        this.inputOutput.closeInputOutput();
    }

    private void logException(SQLExecutionResult result) {
        ++this.errorCount;
        if (!this.inputOutputSelected) {
            this.inputOutputSelected = true;
            this.inputOutput.select();
        }
        OutputWriter writer = this.inputOutput.getErr();
        writer.println(NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ErrorCodeStateMessage", (Object)String.valueOf(result.getException().getErrorCode()), (Object)result.getException().getSQLState(), (Object)result.getException().getMessage()));
        this.printLineColumn(writer, result.getStatementInfo(), true);
        writer.println("");
    }

    private void logSuccess(SQLExecutionResult result) {
        OutputWriter writer = this.inputOutput.getOut();
        String executionTimeStr = this.millisecondsToSeconds(result.getExecutionTime());
        String successLine = null;
        successLine = result.getRowCount() >= 0 ? NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTimeRows", (Object)String.valueOf(executionTimeStr), (Object)String.valueOf(result.getRowCount())) : NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTime", (Object)String.valueOf(executionTimeStr));
        writer.println(successLine);
        this.printLineColumn(writer, result.getStatementInfo(), false);
        writer.println("");
    }

    private void printLineColumn(OutputWriter writer, StatementInfo statementInfo, boolean hyperlink) {
        String lineColumn = NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_LineColumn", (Object)String.valueOf(statementInfo.getStartLine() + 1), (Object)String.valueOf(statementInfo.getStartColumn() + 1));
        try {
            if (hyperlink) {
                writer.println(lineColumn, (OutputListener)new Hyperlink(statementInfo.getStartLine(), statementInfo.getStartColumn()));
            } else {
                writer.println(lineColumn);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }

    public void logResultSetException(Exception e) {
        this.inputOutput.select();
        OutputWriter writer = this.inputOutput.getErr();
        writer.println(NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ResultSetErrorDetailed", (Object)e.getMessage()));
    }

    private final class Hyperlink
    implements OutputListener {
        private final int line;
        private final int column;

        public Hyperlink(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
            this.goToLine(false);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.goToLine(true);
        }

        private void goToLine(boolean focus) {
            Line l = SQLExecutionLoggerImpl.this.lineCookie.getLineSet().getOriginal(this.line);
            if (!l.isDeleted()) {
                l.show(focus ? 2 : 0, this.column);
            }
        }
    }
}

