/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.jmi;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefPackage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.jmi.Hacks;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class JUtils {
    private static final Icon defIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/public.gif"));
    private static final HashMap icons = new HashMap(15);
    private static final float NAME_IMPORTANCE = 1.0f;
    private static final float PARAMS_PAREN_IMPORTANCE = 0.8f;
    private static final float PARAMETER_TYPE_IMPORTANCE = 0.25f;
    private static final float PARAMETER_NAME_IMPORTANCE = 0.1f;
    private static final float FIELD_TYPE_IMPORTANCE = 0.3f;
    private static final int IN_DESCRIPTION = 0;
    private static final int IN_PARAM = 1;
    private static final int IN_RETURN = 2;
    private static final int IN_THROWS = 3;
    private static final int IN_OTHER = 99;
    private static boolean askMoveInnerClass = true;
    private static final MDRepository repo = JavaModel.getJavaRepository();
    private static WeakReference lastTooltipForRef;
    private static RequestProcessor.Task tooltipTask;
    private static String lastTooltip;
    private static final Object TOOLTIP_DATA_LOCK;
    static final boolean EXTRA_DECORATIONS;
    private static final String LINK_TAG_START = "{@link ";
    private static final char LINK_TAG_END = '}';

    private JUtils() {
    }

    public static Icon iconFor(Object o) {
        boolean stat;
        String key = "";
        boolean washOut = false;
        if (o instanceof Wrapper) {
            o = ((Wrapper)o).getElement();
            washOut = true;
        }
        if (o instanceof Element && !((Element)o).isValid()) {
            return null;
        }
        if (o instanceof Method) {
            Method m = (Method)o;
            boolean bl = stat = (m.getModifiers() & 8) != 0;
            key = (m.getModifiers() & 1) != 0 ? (stat ? "methodStPublic" : "methodPublic") : ((m.getModifiers() & 4) != 0 ? (stat ? "methodStProtected" : "methodProtected") : ((m.getModifiers() & 2) != 0 ? (stat ? "methodStPrivate" : "methodPrivate") : (stat ? "methodStPackage" : "methodPackage")));
        } else if (o instanceof Constructor) {
            Constructor c = (Constructor)o;
            key = (c.getModifiers() & 1) != 0 ? "constructorPublic" : ((c.getModifiers() & 4) != 0 ? "constructorProtected" : ((c.getModifiers() & 2) != 0 ? "constructorPrivate" : "constructorPackage"));
        } else if (o instanceof Field) {
            Field f = (Field)o;
            boolean bl = stat = (f.getModifiers() & 8) != 0;
            key = (f.getModifiers() & 1) != 0 ? (stat ? "variableStPublic" : "variablePublic") : ((f.getModifiers() & 4) != 0 ? (stat ? "variableStProtected" : "variableProtected") : ((f.getModifiers() & 2) != 0 ? (stat ? "variableStPrivate" : "variablePrivate") : (stat ? "variableStPackage" : "variablePackage")));
        } else if (o instanceof JavaClass) {
            JavaClass jc = (JavaClass)o;
            key = jc.isInterface() ? "interface" : "class2";
        } else if (o instanceof DataObject) {
            key = "class";
        }
        Icon icon = (Icon)icons.get(washOut ? key + "_w" : key);
        if (icon == null) {
            String name = "org/netbeans/modules/java/navigation/resources/" + key + ".gif";
            Image img = Utilities.loadImage((String)name);
            if (washOut) {
                img = JUtils.washOutImage(img);
            }
            if (img != null) {
                icon = new ImageIcon(img);
                icons.put(washOut ? key + "_w" : key, icon);
            } else {
                icon = defIcon;
            }
        }
        return icon;
    }

    private static Image washOutImage(Image i) {
        Image result = JUtils.toBufferedImage(i);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setComposite(AlphaComposite.getInstance(10, 0.4f));
        g.fillRect(0, 0, 16, 16);
        return result;
    }

    private static final Image toBufferedImage(Image img) {
        new ImageIcon(img);
        BufferedImage rep = JUtils.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    private static final BufferedImage createBufferedImage(int width, int height) {
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage result = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return result;
    }

    public static void extractName(WeightedString as, Object o, JavaClass declaringClass, boolean useName) {
        if ((o = JUtils.unwrap(o)) instanceof Constructor) {
            Constructor c = (Constructor)o;
            JUtils.extractConstructorName(as, c, declaringClass, useName);
        } else if (o instanceof Method) {
            Method m = (Method)o;
            JUtils.extractMethodName(as, m, declaringClass, useName);
        } else if (o instanceof Field) {
            Field f = (Field)o;
            JUtils.extractFieldName(as, f, declaringClass, useName);
        } else if (o instanceof Parameter) {
            Parameter p = (Parameter)o;
            JUtils.extractParameterName(as, p, 0);
        } else if (o instanceof DataObject) {
            as.append(((DataObject)o).getName(), 1.0f);
        } else if (o instanceof JavaClass) {
            JavaClass jc = (JavaClass)o;
            as.append(jc.getSimpleName(), 1.0f);
        } else if (o instanceof NamedElement) {
            as.append(((NamedElement)o).getName(), 1.0f);
        } else {
            as.append(o.toString(), 1.0f);
        }
    }

    private static void extractMethodName(WeightedString as, Method m, JavaClass declaringClass, boolean useName) {
        boolean isDeprecated;
        String s;
        JavaClass parent;
        JavaClass javaClass = parent = useName && m.refImmediateComposite() instanceof JavaClass ? (JavaClass)m.refImmediateComposite() : null;
        if (useName && parent != declaringClass && parent != null && (s = parent.getSimpleName()).length() > 0) {
            as.startMarkupRun(4);
            as.append(s + ".", 0.7f);
            as.endMarkupRun();
        }
        if (isDeprecated = m.isDeprecated()) {
            as.startMarkupRun(1);
        }
        if (EXTRA_DECORATIONS) {
            if (Hacks.isOverride(m)) {
                as.startMarkupRun(2);
            }
            if ((m.getModifiers() & 0x10) != 0) {
                as.startMarkupRun(128);
            }
        }
        as.append(m.getName(), 1.0f);
        as.append("(", 0.8f);
        List params = m.getParameters();
        if (!params.isEmpty()) {
            Iterator i = params.iterator();
            while (i.hasNext()) {
                JUtils.extractParameterName(as, (Parameter)i.next(), isDeprecated ? 1 : 0);
                if (!i.hasNext()) continue;
                as.append(",", 0.35f);
            }
        }
        as.append(")", 0.8f);
    }

    private static void extractFieldName(WeightedString as, Field f, JavaClass declaringClass, boolean useName) {
        JavaClass parent;
        JavaClass javaClass = parent = useName && f.refImmediateComposite() instanceof JavaClass ? (JavaClass)f.refImmediateComposite() : null;
        if (useName && parent != null && parent != declaringClass) {
            String s = parent.getSimpleName();
            as.startMarkupRun(4);
            as.append(s + ".", 0.7f);
            as.endMarkupRun();
        }
        if (f.isDeprecated()) {
            as.startMarkupRun(1);
        }
        as.append(f.getName(), 1.0f);
        as.startMarkupRun(4);
        if (f.getType() != null) {
            StringBuffer sb = new StringBuffer();
            JUtils.convertToSimpleName(f.getType().getName(), sb);
            as.append(" " + sb.toString(), 0.3f);
        }
    }

    private static void extractConstructorName(WeightedString as, Constructor c, JavaClass declaringClass, boolean useName) {
        JavaClass parent;
        if (c.getDeclaringClass() == null) {
            return;
        }
        JavaClass javaClass = parent = useName && c.refImmediateComposite() instanceof JavaClass ? (JavaClass)c.refImmediateComposite() : null;
        if (useName && parent != null && parent != declaringClass) {
            as.startMarkupRun(4);
            ClassDefinition decl = c.getDeclaringClass();
            String name = decl instanceof JavaClass ? ((JavaClass)decl).getSimpleName() : decl.getName();
            JUtils.append(as, name + ".", '.', 0.7f);
            as.endMarkupRun();
        }
        List l = c.getParameters();
        boolean isDeprecated = c.isDeprecated();
        if (isDeprecated) {
            as.startMarkupRun(1);
        }
        JUtils.append(as, c.getDeclaringClass().getName(), '.', 1.0f);
        as.append("(", 0.8f);
        if (!l.isEmpty()) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                JUtils.extractParameterName(as, (Parameter)i.next(), isDeprecated ? 1 : 0);
                if (!i.hasNext()) continue;
                as.append(",", 0.35f);
            }
        }
        as.append(")", 0.8f);
    }

    private static void extractParameterName(WeightedString as, Parameter p, int mask) {
        String name;
        if (!p.isValid()) {
            return;
        }
        as.startMarkupRun(4 | mask);
        as.append(JUtils.getParameterType(p), 0.25f);
        if (p.isVarArg()) {
            as.append(" ...", 0.1f);
        }
        if ((name = p.getName()) != null && !"".equals(name)) {
            as.append(" " + name, 0.1f);
        }
        as.endMarkupRun();
    }

    private static String getParameterType(Parameter p) {
        TypeReference typeRef = p.getTypeName();
        if (typeRef != null) {
            return typeRef.getName();
        }
        String fullName = p.getType().getName();
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot > 0) {
            return fullName.substring(lastDot + 1);
        }
        return fullName;
    }

    private static void append(WeightedString as, String target, char last, float importance) {
        int start = target.lastIndexOf(last) + 1;
        if (start != -1 && start < target.length()) {
            char[] c = new char[target.length() - start];
            target.getChars(start, target.length(), c, 0);
            as.append(c, importance);
        } else {
            as.append(target, importance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTooltip(WeightedString wString, Object tooltipFor, JavaClass jc, int x, int y, TipHackInvoker invoker) {
        Object object = TOOLTIP_DATA_LOCK;
        synchronized (object) {
            Object lastTooltipFor;
            Object v0 = lastTooltipFor = lastTooltipForRef == null ? null : lastTooltipForRef.get();
            if (lastTooltipFor == tooltipFor) {
                if (lastTooltip != null) {
                    return lastTooltip;
                }
                return "";
            }
            if (tooltipTask != null) {
                boolean cancelled = tooltipTask.cancel();
                tooltipTask = null;
            }
            lastTooltipForRef = new WeakReference<Object>(tooltipFor);
            lastTooltip = null;
        }
        TooltipCalculator tc = new TooltipCalculator(tooltipFor, jc, x, y, invoker);
        Object object2 = TOOLTIP_DATA_LOCK;
        synchronized (object2) {
            tooltipTask = RequestProcessor.getDefault().post((Runnable)tc);
        }
        return "";
    }

    public static String getTooltip(Object o, JavaClass jc) {
        RefFeatured comp;
        Object maybeWrapper = o;
        if ((o = JUtils.unwrap(o)) instanceof Element && !((Element)o).isValid()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(50);
        if (o instanceof Method) {
            JUtils.createMethodTooltip((Method)o, sb, jc);
        } else if (o instanceof Field) {
            JUtils.createFieldTooltip((Field)o, sb, jc);
        } else if (o instanceof Constructor) {
            JUtils.createConstructorTooltip((Constructor)o, sb, jc);
        } else {
            if (o instanceof DataObject) {
                FileObject fob = ((DataObject)o).getPrimaryFile();
                if (fob != null) {
                    return fob.getPath();
                }
                return ((DataObject)o).getName();
            }
            if (o instanceof JavaClass) {
                JUtils.createClassTooltip((JavaClass)o, sb, jc);
            }
        }
        if (o instanceof ClassMember && (comp = ((ClassMember)o).refImmediateComposite()) instanceof JavaClass) {
            sb.append(" on " + ((JavaClass)comp).getName());
        }
        return sb.toString();
    }

    private static void includeInnerMessage(Element e, StringBuffer sb, JavaClass jc) {
        JavaClass parent;
        JavaClass javaClass = parent = e.refImmediateComposite() instanceof JavaClass ? (JavaClass)e.refImmediateComposite() : null;
        if (parent != null && parent.isInner()) {
            StringBuffer clzz = new StringBuffer();
            while (parent != jc && parent != null) {
                clzz.insert(0, parent.getSimpleName());
                parent = parent.refImmediateComposite() instanceof JavaClass ? (JavaClass)parent.refImmediateComposite() : null;
            }
            sb.append(NbBundle.getMessage((Class)JUtils.class, (String)"FMT_InnerClassTip", (Object)clzz));
            sb.append("<br>");
        }
    }

    private static void includeOverrideMessage(Method m, StringBuffer sb) {
        if (Hacks.isOverride(m)) {
            Collection c = JavaModelUtil.getOverriddenMethods((Method)m);
            if (c == null) {
                return;
            }
            JavaClass superClass = m.getDeclaringClass().getSuperClass();
            if (superClass == null) {
                return;
            }
            Method orig = superClass.getMethod(m.getName(), JUtils.getParameterTypeList(m), false);
            boolean isImplementing = orig == null || (orig.getModifiers() & 0x400) != 0;
            StringBuffer names = new StringBuffer(30);
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Method me = (Method)i.next();
                ClassDefinition cd = me.getDeclaringClass();
                names.append(cd.getName());
                if (!i.hasNext()) continue;
                names.append(", ");
            }
            sb.append("<br><hr>");
            sb.append(NbBundle.getMessage((Class)JUtils.class, (String)(isImplementing ? "FMT_ImplementsTip" : "FMT_OverrideTip"), (Object[])new Object[]{m.getName(), names.toString()}));
        }
    }

    private static void includeDocumentedAnnotations(AnnotableElement element, StringBuffer sb) {
        Iterator it = element.getAnnotations().iterator();
        while (it.hasNext()) {
            Annotation ann = (Annotation)it.next();
            AnnotationType type = ann.getType();
            if (type == null) continue;
            type = (AnnotationType)JUtils.getSourceForBinary((ClassDefinition)type);
            Iterator itt = type.getAnnotations().iterator();
            while (itt.hasNext()) {
                AnnotationType meta = (AnnotationType)JUtils.getSourceForBinary((ClassDefinition)((Annotation)itt.next()).getType());
                if (meta == null || !"java.lang.annotation.Documented".equals(meta.getName())) continue;
                sb.append("@" + JUtils.getTypeName((Type)type));
                List values = ann.getAttributeValues();
                if (!values.isEmpty()) {
                    try {
                        StringBuffer vsb = new StringBuffer();
                        Iterator ittt = values.iterator();
                        while (ittt.hasNext()) {
                            AttributeValue av = (AttributeValue)ittt.next();
                            vsb.append(av.getDefinition().getName());
                            vsb.append('=');
                            PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)av.getValue());
                            if (bounds == null) {
                                vsb = null;
                                break;
                            }
                            vsb.append(bounds.getText());
                            if (!ittt.hasNext()) continue;
                            vsb.append(", ");
                        }
                        if (vsb != null) {
                            sb.append('(');
                            sb.append(vsb);
                            sb.append(')');
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                sb.append("<br>");
            }
        }
    }

    private static String getTypeName(Type typ) {
        String result = null;
        if (typ instanceof Array) {
            result = JUtils.getTypeName(((Array)typ).getType()) + "[]";
        }
        if (typ instanceof AnnotationType || typ instanceof ParameterizedType && ((ParameterizedType)typ).getDefinition() instanceof AnnotationType) {
            result = "@" + ((JavaClass)typ).getSimpleName();
        }
        if (typ instanceof JavaClass) {
            result = ((JavaClass)typ).getSimpleName();
        }
        result = result.replaceAll("<", "&lt;");
        return result.replaceAll(">", "&gt;");
    }

    private static List getParameterTypeList(Method m) {
        ArrayList<Type> params = new ArrayList<Type>();
        Iterator i = m.getParameters().iterator();
        while (i.hasNext()) {
            params.add(((Parameter)i.next()).getType());
        }
        return params;
    }

    private static void createMethodTooltip(Method m, StringBuffer sb, JavaClass jc) {
        Method method4javadoc;
        String javadoc;
        sb.append("<html>");
        JUtils.getModifiers(m.getModifiers(), sb);
        if (m.getType().getName() != null) {
            JUtils.htmlizeTypeName(m.getType().getName(), sb, false);
        } else {
            JUtils.htmlizeTypeName("void", sb, false);
        }
        sb.append(' ');
        sb.append("<b><font color=#7C0000>");
        sb.append(m.getName());
        sb.append("</b></font>");
        JUtils.appendParameterList(m.getParameters(), sb);
        sb.append("<br>");
        List annots = m.getAnnotations();
        if (annots != null && annots.size() > 0) {
            JUtils.includeDocumentedAnnotations((AnnotableElement)m, sb);
        }
        if (jc != null) {
            JUtils.includeInnerMessage((Element)m, sb, jc);
        }
        if (((javadoc = m.getJavadocText()) == null || javadoc.length() == 0) && (method4javadoc = JUtils.findSuperWithJavadoc(m)) != null) {
            javadoc = method4javadoc.getJavadocText();
        }
        if (javadoc != null && javadoc.length() > 0) {
            sb.append("<hr>");
            sb.append(JUtils.htmlize(javadoc));
        }
        JUtils.includeOverrideMessage(m, sb);
        sb.append("</html>");
    }

    private static Method findSuperWithJavadoc(Method m) {
        RefFeatured o = m.refImmediateComposite();
        if (o instanceof JavaClass) {
            Method parM;
            JavaClass jc = (JavaClass)o;
            JavaClass parent = jc.getSuperClass();
            if (parent != null && (parM = parent.getMethod(m.getName(), JUtils.obtainParamTypes(m.getParameters()), true)) != null) {
                String txt = parM.getJavadocText();
                if (txt != null && txt.trim().length() > 0) {
                    return parM;
                }
                return JUtils.findSuperWithJavadoc(parM);
            }
            Iterator i = jc.getInterfaces().iterator();
            while (i.hasNext()) {
                String s;
                JavaClass iface;
                Method inM;
                Object o1 = i.next();
                if (!(o1 instanceof JavaClass) || (inM = (iface = (JavaClass)o1).getMethod(m.getName(), JUtils.obtainParamTypes(m.getParameters()), true)) == null || (s = inM.getJavadocText()) == null || s.length() <= 0) continue;
                return inM;
            }
        }
        return null;
    }

    private static List obtainParamTypes(List params) {
        int paramCount = params.size();
        if (paramCount == 0) {
            return params;
        }
        ArrayList<Type> result = new ArrayList<Type>(paramCount);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            result.add(((Parameter)iter.next()).getType());
        }
        return result;
    }

    private static void appendParameterList(List l, StringBuffer sb) {
        sb.append(" ( ");
        int paramsLen = sb.length() - 61;
        HashSet used = null;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            String tname = p.getType().getName();
            if ((paramsLen += tname.length()) + tname.length() + (p.getTypeName() == null ? 0 : p.getTypeName().getName().length()) > 120) {
                sb.append("<br>&nbsp;&nbsp;   ");
                paramsLen = 0;
            }
            JUtils.htmlizeTypeName(tname, sb, false);
            sb.append(' ');
            if (p.getName() != null) {
                sb.append("<font color=#B200B2>");
                sb.append(p.getName());
                sb.append("</font>");
                paramsLen += p.getName().length();
            } else {
                if (used == null) {
                    used = new HashSet();
                }
                String n = JUtils.generateBelievableParameterName(p, used);
                sb.append("<font color=#B200B2>");
                sb.append(n);
                sb.append("</font>");
                paramsLen += n.length();
            }
            if (!i.hasNext()) continue;
            sb.append(", ");
            paramsLen += 2;
        }
        sb.append(" )");
    }

    static void separateClassName(String fullyQualifiedName, StringBuffer appendTo) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            appendTo.append(fullyQualifiedName.substring(lastDot + 1));
        } else {
            appendTo.append(fullyQualifiedName);
        }
    }

    static void convertToSimpleName(String fullyQualifiedName, StringBuffer appendTo) {
        int genericsStart = fullyQualifiedName.indexOf(60);
        if (genericsStart == -1) {
            JUtils.separateClassName(fullyQualifiedName, appendTo);
            return;
        }
        if (fullyQualifiedName.charAt(fullyQualifiedName.length() - 1) != '>') {
            JUtils.separateClassName(fullyQualifiedName, appendTo);
            return;
        }
        JUtils.separateClassName(fullyQualifiedName.substring(0, genericsStart), appendTo);
        appendTo.append("<");
        int paramStart = genericsStart + 1;
        while (paramStart < fullyQualifiedName.length()) {
            int paramEnd;
            int balance = 0;
            block5: for (paramEnd = paramStart; paramEnd < fullyQualifiedName.length() && (fullyQualifiedName.charAt(paramEnd) != ',' || balance > 0); ++paramEnd) {
                switch (fullyQualifiedName.charAt(paramEnd)) {
                    case '<': {
                        ++balance;
                        continue block5;
                    }
                    case '>': {
                        --balance;
                    }
                }
            }
            String genericString = fullyQualifiedName.substring(paramStart, paramEnd);
            int space = genericString.lastIndexOf(32);
            if (space == -1) {
                JUtils.convertToSimpleName(genericString, appendTo);
            } else {
                appendTo.append(genericString.substring(0, space));
                appendTo.append(' ');
                JUtils.convertToSimpleName(genericString.substring(space + 1), appendTo);
            }
            if ((paramStart = paramEnd + 1) >= fullyQualifiedName.length()) continue;
            appendTo.append(", ");
        }
    }

    private static void htmlizeTypeName(String s, StringBuffer sb, boolean highlight) {
        if (highlight) {
            sb.append("<b><font color=#77000>");
        }
        JUtils.convertToSimpleName(s, sb);
        block4: for (int start = sb.length(); start < sb.length(); ++start) {
            switch (sb.charAt(start)) {
                case '<': {
                    sb.replace(start, start + 1, "&lt;");
                    continue block4;
                }
                case '>': {
                    sb.replace(start, start + 1, "&gt;");
                }
            }
        }
        if (highlight) {
            sb.append("</font></b>");
        }
    }

    private static String htmlize(String s) {
        StringBuffer sb = new StringBuffer(256);
        StringBuffer paragraph = new StringBuffer();
        int state = 0;
        StringTokenizer t = new StringTokenizer(s, "\n");
        while (t.hasMoreTokens()) {
            int pos;
            String line = t.nextToken().trim();
            if (!(line = JUtils.extractLinks(line)).startsWith("@")) {
                paragraph.append(line + " ");
                continue;
            }
            JUtils.wrapText(paragraph.toString(), sb);
            paragraph.delete(0, paragraph.length());
            for (pos = 1; pos < line.length() && Character.isJavaIdentifierPart(line.charAt(pos)); ++pos) {
            }
            if (pos == 1) continue;
            int newState = 0;
            String tag = line.substring(1, pos);
            newState = tag.equals("param") ? 1 : (tag.equals("return") ? 2 : (tag.equals("throws") || tag.equals("exception") ? 3 : 99));
            if (state == 0 && state != 99) {
                sb.append("<dl>");
            }
            if (newState != state) {
                sb.append("<dt><b>");
                switch (newState) {
                    case 1: {
                        sb.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ParametersTerm") + ":");
                        break;
                    }
                    case 2: {
                        sb.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ReturnsTerm") + ":");
                        break;
                    }
                    case 3: {
                        sb.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ThrowsTerm") + ":");
                        break;
                    }
                }
                sb.append("</b>");
                sb.append("<dd>");
            } else if (newState != 0 && newState != 99) {
                sb.append("<dd>");
            }
            if (newState == 1) {
                int pos2;
                paragraph.append("<code>");
                for (pos2 = Math.min(pos + 1, line.length()); pos2 < line.length() && Character.isWhitespace(line.charAt(pos2)); ++pos2) {
                }
                pos = pos2;
                while (pos2 < line.length() && Character.isJavaIdentifierPart(line.charAt(pos2))) {
                    ++pos2;
                }
                paragraph.append(line.substring(pos, pos2));
                paragraph.append("</code> - ");
                pos = pos2;
            }
            if (newState != 99) {
                paragraph.append(line.substring(pos) + " ");
            }
            state = newState;
        }
        JUtils.wrapText(paragraph.toString(), sb);
        if (state != 0) {
            sb.append("</dl>");
        }
        return sb.toString();
    }

    private static void wrapText(String s, StringBuffer sb) {
        int pos = 0;
        StringTokenizer t = new StringTokenizer(s, " \t\r\n");
        while (t.hasMoreTokens()) {
            int nextBreak;
            String w = t.nextToken().toLowerCase();
            int tokenLength = w.length();
            int htmlBreakPos = JUtils.findHtmlBreakPos(w);
            int n = nextBreak = htmlBreakPos == -1 ? tokenLength : htmlBreakPos;
            if (pos + nextBreak > 90) {
                sb.append("<br>");
                pos = 0;
            }
            sb.append(w + " ");
            pos = htmlBreakPos == -1 ? (pos += tokenLength + 1) : Math.max(0, tokenLength - nextBreak - 7);
            if (!w.endsWith("</br>") && !w.endsWith("</p>")) continue;
            pos = 0;
        }
    }

    private static int findHtmlBreakPos(String s) {
        int result = s.indexOf("<p>");
        if (result == -1) {
            result = s.indexOf("<br>");
        }
        return result;
    }

    private static void createFieldTooltip(Field f, StringBuffer sb, JavaClass jc) {
        String javadoc;
        sb.append("<html>");
        JUtils.getModifiers(f.getModifiers(), sb);
        sb.append(f.getType().getName());
        sb.append(' ');
        sb.append("<b><font color=#0000B2>");
        sb.append(f.getName());
        sb.append("</font></b>");
        if (jc != null) {
            JUtils.includeInnerMessage((Element)f, sb, jc);
        }
        if ((javadoc = f.getJavadocText()) != null && javadoc.length() > 0) {
            sb.append("<br>");
            sb.append("<hr>");
            sb.append(JUtils.htmlize(javadoc));
        }
        sb.append("</html>");
    }

    private static void createConstructorTooltip(Constructor m, StringBuffer sb, JavaClass jc) {
        String javadoc = m.getJavadocText();
        sb.append("<html>");
        JUtils.getModifiers(m.getModifiers(), sb);
        sb.append("<b><font color=#B28C00>");
        sb.append(((JavaClass)m.refImmediateComposite()).getSimpleName());
        sb.append("</font></b>");
        JUtils.appendParameterList(m.getParameters(), sb);
        if (jc != null) {
            JUtils.includeInnerMessage((Element)m, sb, jc);
        }
        if (javadoc != null && javadoc.length() > 0) {
            sb.append("<br>");
            sb.append("<hr>");
            sb.append(JUtils.htmlize(javadoc));
        }
        sb.append("</html>");
    }

    private static void createClassTooltip(JavaClass source, StringBuffer sb, JavaClass jc) {
        String javadoc = source.getJavadocText();
        sb.append("<html>");
        sb.append(source.getName());
        if (javadoc != null && javadoc.length() > 0) {
            sb.append("<br>");
            sb.append("<hr>");
            sb.append(JUtils.htmlize(javadoc));
        }
        sb.append("</html>");
    }

    private static void getModifiers(int m, StringBuffer sb) {
        boolean hasFirst = false;
        if ((m & 1) != 0) {
            sb.append("public");
            hasFirst = true;
        } else if ((m & 4) != 0) {
            sb.append("protected");
            hasFirst = true;
        } else if ((m & 2) != 0) {
            sb.append("private");
            hasFirst = true;
        }
        if ((m & 0x400) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("abstract");
            hasFirst = true;
        }
        if ((m & 8) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("static");
            hasFirst = true;
        }
        if ((m & 0x10) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("final");
            hasFirst = true;
        }
        if ((m & 0x100) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("native");
            hasFirst = true;
        }
        if ((m & 0x20) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("synchronized");
            hasFirst = true;
        }
        if ((m & 0x80) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("transient");
            hasFirst = true;
        }
        if ((m & 0x40) != 0) {
            if (hasFirst) {
                sb.append(' ');
            }
            sb.append("volatile");
            hasFirst = true;
        }
        if (hasFirst) {
            sb.append(' ');
        }
    }

    public static String generateBelievableParameterName(Parameter p, Set used) {
        int bkt;
        String result;
        String tname = p.getType().getName();
        boolean usedClassName = false;
        if (tname.endsWith("Listener")) {
            result = "l";
        } else if (tname.equals("java.lang.Object")) {
            result = "o";
        } else if (tname.equals("java.lang.Class")) {
            result = "clazz";
        } else if (tname.endsWith("Stream")) {
            result = "stream";
        } else {
            int idx;
            result = tname.toLowerCase();
            bkt = tname.indexOf("[");
            if (bkt > 0) {
                tname = tname.substring(0, bkt - 1);
            }
            if ((idx = result.lastIndexOf(".")) != -1) {
                result = result.substring(idx + 1);
            }
            usedClassName = true;
        }
        if (result.trim().length() == 0) {
            result = "value";
        }
        if ((bkt = result.indexOf("[")) > 0) {
            result = result.substring(0, bkt);
            if (usedClassName) {
                result = result + "s";
            }
        }
        if (!Utilities.isJavaIdentifier((String)tname)) {
            result = new String(new char[tname.charAt(0)]);
        }
        if (JUtils.isPrimitiveTypeName(result)) {
            result = new String(new char[]{result.charAt(0)});
        }
        if (result.length() > 7) {
            result = JUtils.tryMakeAcronym(result);
        }
        String test = result;
        int revs = 0;
        while (used.contains(test)) {
            test = result + ++revs;
        }
        result = test;
        used.add(result);
        return result;
    }

    public static boolean isPrimitiveTypeName(String typeName) {
        return "void".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) || "short".equals(typeName) || "char".equals(typeName) || "boolean".equals(typeName);
    }

    private static String tryMakeAcronym(String s) {
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (!Character.isUpperCase(c[i])) continue;
            sb.append(c[i]);
        }
        if (sb.length() > 1) {
            return sb.toString().toLowerCase();
        }
        return s;
    }

    public static List getClassMembers(JavaDataObject dob, boolean recurse, JavaClass[] jc, boolean includeInners) {
        List result = null;
        Resource r = Hacks.getResourceForDataObject(dob);
        if (r != null && r.isValid()) {
            JavaModel.setClassPath((Resource)r);
            boolean moreThanOne = false;
            Iterator i = r.getClassifiers().iterator();
            while (i.hasNext()) {
                JavaClass clazz = (JavaClass)i.next();
                if (jc[0] == null) {
                    jc[0] = clazz;
                }
                if (result == null) {
                    result = clazz.getFeatures();
                } else {
                    if (!moreThanOne) {
                        List oldResult = result;
                        result = new ArrayList();
                        result.addAll(oldResult);
                        moreThanOne = true;
                    }
                    result.addAll(clazz.getFeatures());
                }
                if (includeInners) {
                    result = JUtils.addInnerClassMembers(result, recurse);
                }
                if (!recurse) continue;
                result = JUtils.addInheritedMembers((ClassDefinition)clazz, result, clazz);
            }
            if (result != null) {
                result = new ArrayList(new HashSet(result));
            }
        }
        return result;
    }

    public static List getClassMembers(JavaClass clazz, boolean recurse, boolean includeInners) {
        JavaModel.setClassPath((Resource)clazz.getResource());
        ArrayList result = clazz.getFeatures();
        if (includeInners) {
            result = JUtils.addInnerClassMembers(result, recurse);
        }
        if (recurse) {
            result = JUtils.addInheritedMembers((ClassDefinition)clazz, result, clazz);
        }
        if (result != null) {
            result = new ArrayList(new HashSet(result));
        }
        return result;
    }

    public static List addInnerClassMembers(List l, boolean inherited) {
        if (!(l instanceof ArrayList) && !(l instanceof LinkedList)) {
            l = new LinkedList(l);
        }
        ArrayList subs = null;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Initializer) {
                i.remove();
                continue;
            }
            if (!(o instanceof JavaClass)) continue;
            if (subs == null) {
                subs = new ArrayList();
            }
            subs.add(o);
            i.remove();
        }
        if (subs != null) {
            i = subs.iterator();
            while (i.hasNext()) {
                JavaClass jc = (JavaClass)i.next();
                l = JUtils.addInnerClassMembers(jc, l, inherited);
            }
        }
        return l;
    }

    private static List addInnerClassMembers(JavaClass clazz, List l, boolean recurse) {
        List nue = clazz.getFeatures();
        Iterator i = nue.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Initializer) continue;
            if (o instanceof JavaClass) {
                l = JUtils.addInnerClassMembers((JavaClass)o, l, recurse);
                continue;
            }
            l.add(o);
        }
        return l;
    }

    private static List addInheritedMembers(ClassDefinition clazz, List l, JavaClass owner) {
        if (!(l instanceof ArrayList)) {
            l = new ArrayList(l);
        }
        ClassDefinition curr = clazz;
        if (clazz instanceof JavaClass && !((JavaClass)clazz).isInterface()) {
            JavaClass binary = clazz.getSuperClass();
            if (binary == null) {
                return l;
            }
            ClassDefinition source = JUtils.getSourceForBinary((ClassDefinition)binary);
            curr = source == null ? binary : source;
            JUtils.addItemMembers(curr, l, owner);
            JUtils.addInheritedMembers(curr, l, owner);
        }
        Iterator i = curr.getInterfaces().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof JavaClass)) continue;
            JUtils.addItemMembers((ClassDefinition)((JavaClass)o), l, owner);
            JUtils.addInheritedMembers((ClassDefinition)((JavaClass)o), l, owner);
        }
        return l;
    }

    private static void addItemMembers(ClassDefinition clazz, List l, JavaClass owner) {
        Iterator i = clazz.getFeatures().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!JUtils.isDisplayableInheritedMember(o, owner)) continue;
            l.add(new Wrapper((Element)o, owner));
        }
    }

    public static ClassDefinition getSourceForBinary(ClassDefinition clazz) {
        return ((JMManager)JavaMetamodel.getManager()).getSourceElementIfExists(clazz);
    }

    private static boolean isDisplayableInheritedMember(Object o, JavaClass owner) {
        boolean result;
        if (!(o instanceof Method || o instanceof Field || o instanceof Constructor)) {
            return false;
        }
        ClassMember cm = (ClassMember)o;
        RefPackage ownerPkg = owner.refImmediatePackage();
        RefPackage memberPkg = cm.refImmediatePackage();
        boolean allowPackage = ownerPkg == null && memberPkg == null || ownerPkg != null && ownerPkg.equals(memberPkg);
        int mods = cm.getModifiers();
        boolean bl = result = (mods & 1) != 0 || (mods & 4) != 0 || allowPackage && (mods & 2) == 0 || cm.refImmediateComposite() == owner;
        if (result && o instanceof Method) {
            result = !JUtils.isOverridenAnywhere(owner, (Method)o);
        }
        return result;
    }

    public static Object unwrap(Object o) {
        if (o instanceof Wrapper) {
            o = ((Wrapper)o).getElement();
        }
        return o;
    }

    public static boolean isWrapper(Object o) {
        return o instanceof Wrapper;
    }

    public static boolean overridesMethod(JavaClass target, Method m) {
        if (target == null) {
            return false;
        }
        ArrayList<Type> params = new ArrayList<Type>();
        Iterator i = m.getParameters().iterator();
        while (i.hasNext()) {
            params.add(((Parameter)i.next()).getType());
        }
        try {
            return target.getMethod(m.getName(), params, false) != null;
        }
        catch (NullPointerException npe) {
            NullPointerException npe2 = new NullPointerException("NPE: target " + target + " method " + m);
            ErrorManager.getDefault().annotate((Throwable)npe2, (Throwable)npe);
            throw npe2;
        }
    }

    private static boolean isOverridenAnywhere(JavaClass target, Method m) {
        JavaClass decClass = (JavaClass)m.getDeclaringClass();
        List params = m.getParameters();
        ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
        Iterator i = params.iterator();
        while (i.hasNext()) {
            paramTypes.add(((Parameter)i.next()).getType());
        }
        String mName = m.getName();
        String decClassName = decClass.getName();
        for (JavaClass i2 = target; i2 != null && !decClassName.equals(i2.getName()); i2 = i2.getSuperClass()) {
            if (i2.getMethod(mName, paramTypes, false) == null) continue;
            return true;
        }
        return false;
    }

    public static String move(ClassMember toMove, ClassMember after) {
        JavaClass toMoveClass;
        if (toMove.equals(after)) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CanMoveToSelf");
        }
        if (toMove.refImmediateComposite() instanceof JavaClass && after.refImmediateComposite() instanceof JavaClass) {
            JavaClass targetClass;
            toMoveClass = (JavaClass)toMove.refImmediateComposite();
            if (!toMoveClass.equals(targetClass = (JavaClass)after.refImmediateComposite())) {
                if (toMoveClass.isInner() && toMoveClass.refImmediateComposite() == targetClass) {
                    return JUtils.askMoveEntireInnerClass(targetClass, toMoveClass, (Element)after, (Element)toMove);
                }
                return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CantMove");
            }
        } else {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CantMove");
        }
        JUtils.repositionElementWithinClass((Element)toMove, (Element)after, toMoveClass);
        return null;
    }

    private static void repositionElementWithinClass(Element toMove, Element after, JavaClass clazz) {
        List features = clazz.getFeatures();
        int toMoveIdx = features.indexOf(toMove);
        int afterIdx = features.indexOf(after);
        if (toMoveIdx != -1 && afterIdx != -1) {
            features.remove(toMoveIdx);
            if (afterIdx > toMoveIdx) {
                --afterIdx;
            }
            features.add(afterIdx, toMove);
        }
    }

    private static String qualifiedNameOf(Object o) {
        if (o instanceof Constructor) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"FMT_Constructor", (Object)((Constructor)o).getDeclaringClass().getName());
        }
        return ((Feature)o).getName();
    }

    private static String askMoveEntireInnerClass(JavaClass target, JavaClass class2move, Element after, Element triedToMove) {
        boolean canMove;
        boolean bl = canMove = !askMoveInnerClass;
        if (!canMove) {
            String title = NbBundle.getMessage((Class)JUtils.class, (String)"TITLE_MoveInnerClass");
            String msg = NbBundle.getMessage((Class)JUtils.class, (String)"MSG_AskMoveInnerClass", (Object[])new Object[]{JUtils.qualifiedNameOf(triedToMove), class2move.getSimpleName()});
            JPanel msgPanel = new JPanel();
            msgPanel.setLayout(new BorderLayout());
            JTextArea jta = new JTextArea(msg);
            jta.setOpaque(false);
            jta.setEditable(false);
            jta.setBorder(BorderFactory.createEmptyBorder());
            JCheckBox cb = new JCheckBox(NbBundle.getMessage((Class)JUtils.class, (String)"MSG_AlwaysDoThis"));
            msgPanel.add((Component)jta, "Center");
            msgPanel.add((Component)cb, "South");
            NotifyDescriptor nd = new NotifyDescriptor((Object)msgPanel, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
            canMove = NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify(nd));
            askMoveInnerClass = cb.isSelected();
            if (!canMove) {
                return "";
            }
        }
        List feat = target.getContents();
        int newLocation = feat.indexOf(after);
        int oldIdx = -1;
        Iterator i = feat.iterator();
        while (i.hasNext()) {
            ++oldIdx;
            Object oh = i.next();
            if (!oh.equals(class2move)) continue;
            break;
        }
        if (oldIdx == -1 || oldIdx == feat.size() || newLocation == -1) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CouldNotLocateClass", (Object)class2move.getSimpleName());
        }
        feat.remove(oldIdx);
        try {
            if (oldIdx < newLocation) {
                --newLocation;
            }
            feat.add(newLocation, class2move);
        }
        catch (Exception e) {
            feat.add(oldIdx, class2move);
            String msg = NbBundle.getMessage((Class)JUtils.class, (String)"MSG_MoveFailed");
            ErrorManager.getDefault().annotate((Throwable)e, msg);
            ErrorManager.getDefault().notify(256, (Throwable)e);
            return msg;
        }
        return null;
    }

    private static String extractLinks(String string) {
        int linkIndex = string.indexOf(LINK_TAG_START);
        if (linkIndex == -1) {
            return string;
        }
        StringBuffer result = new StringBuffer(string.length() + 1);
        int startPos = 0;
        int endPos = -1;
        while (linkIndex != -1) {
            result.append(string.substring(startPos, linkIndex));
            endPos = string.indexOf(125, linkIndex);
            if (endPos == -1) {
                result.append(string.substring(linkIndex + 7));
                break;
            }
            result.append(string.substring(linkIndex + 7, endPos));
            startPos = endPos + 1;
            linkIndex = string.indexOf(LINK_TAG_START, endPos);
        }
        if (endPos != -1 && endPos + 1 < string.length()) {
            result.append(string.substring(endPos + 1));
        }
        return result.toString();
    }

    static {
        TOOLTIP_DATA_LOCK = new Object();
        EXTRA_DECORATIONS = Boolean.getBoolean("nb.navigator.decorate");
    }

    private static final class Wrapper {
        final Element element;
        final JavaClass clazz;

        public Wrapper(Element element, JavaClass clazz) {
            this.element = element;
            this.clazz = clazz;
        }

        public Element getElement() {
            return this.element;
        }

        public JavaClass getOwner() {
            return this.clazz;
        }

        public String toString() {
            return this.clazz.getName() + "." + this.element;
        }

        public int hashCode() {
            return this.clazz.getName().hashCode() * 31 ^ this.element.hashCode();
        }

        public String getClassName() {
            return this.clazz.getSimpleName();
        }

        public boolean equals(Object o) {
            if (o instanceof Wrapper) {
                Wrapper w = (Wrapper)o;
                return w.element == this.element && w.clazz == this.clazz;
            }
            return false;
        }
    }

    public static interface TipHackInvoker {
        public void invokeTip(int var1, int var2);
    }

    private static class TooltipCalculator
    implements Runnable {
        private Object tooltipFor;
        private JavaClass jc;
        private int x;
        private int y;
        private TipHackInvoker invoker;

        TooltipCalculator(Object tooltipFor, JavaClass jc, int x, int y, TipHackInvoker invoker) {
            this.tooltipFor = tooltipFor;
            this.jc = jc;
            this.x = x;
            this.y = y;
            this.invoker = invoker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String result;
            repo.beginTrans(false);
            try {
                result = JUtils.getTooltip(this.tooltipFor, this.jc);
            }
            finally {
                repo.endTrans(false);
            }
            Object object = TOOLTIP_DATA_LOCK;
            synchronized (object) {
                tooltipTask = null;
                if (lastTooltipForRef != null && lastTooltipForRef.get() != this.tooltipFor) {
                    return;
                }
                lastTooltip = result;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TooltipCalculator.this.invoker.invokeTip(TooltipCalculator.this.x, TooltipCalculator.this.y);
                }
            });
        }
    }
}

