/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedList;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.DataSender;
import org.apache.catalina.cluster.tcp.SocketSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledSocketSender
extends DataSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$PooledSocketSender == null ? (class$org$apache$catalina$cluster$tcp$PooledSocketSender = PooledSocketSender.class$("org.apache.catalina.cluster.tcp.PooledSocketSender")) : class$org$apache$catalina$cluster$tcp$PooledSocketSender));
    private static final String info = "PooledSocketSender/2.0";
    private int maxPoolSocketLimit = 25;
    private SenderQueue senderQueue = new SenderQueue(this, this.maxPoolSocketLimit);
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$PooledSocketSender;

    public PooledSocketSender(String domain, InetAddress host, int port) {
        super(domain, host, port);
    }

    public String getInfo() {
        return info;
    }

    public void setMaxPoolSocketLimit(int limit) {
        this.maxPoolSocketLimit = limit;
        this.senderQueue.setLimit(limit);
    }

    public int getMaxPoolSocketLimit() {
        return this.maxPoolSocketLimit;
    }

    public int getInPoolSize() {
        return this.senderQueue.getInPoolSize();
    }

    public int getInUsePoolSize() {
        return this.senderQueue.getInUsePoolSize();
    }

    public synchronized void connect() throws IOException {
        this.senderQueue.open();
        this.setSocketConnected(true);
        ++this.connectCounter;
    }

    public synchronized void disconnect() {
        this.senderQueue.close();
        this.setSocketConnected(false);
        ++this.disconnectCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ClusterData data) throws IOException {
        SocketSender sender;
        if (!this.isConnected()) {
            PooledSocketSender pooledSocketSender = this;
            synchronized (pooledSocketSender) {
                if (!this.isConnected()) {
                    this.connect();
                }
            }
        }
        if ((sender = this.senderQueue.getSender(0L)) == null) {
            log.warn((Object)sm.getString("PoolSocketSender.noMoreSender", (Object)this.getAddress(), (Object)new Integer(this.getPort())));
            return;
        }
        try {
            sender.sendMessage(data);
        }
        finally {
            this.senderQueue.returnSender(sender);
        }
        this.addStats(data.getMessage().length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PooledSocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SenderQueue {
        private int limit = 25;
        PooledSocketSender parent = null;
        private LinkedList queue = new LinkedList();
        private LinkedList inuse = new LinkedList();
        private Object mutex = new Object();
        private boolean isOpen = true;

        public SenderQueue(PooledSocketSender parent, int limit) {
            this.limit = limit;
            this.parent = parent;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public int getInUsePoolSize() {
            return this.inuse.size();
        }

        public int getInPoolSize() {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketSender getSender(long timeout) {
            SocketSender sender = null;
            long start = System.currentTimeMillis();
            long delta = 0L;
            do {
                Object object = this.mutex;
                synchronized (object) {
                    if (!this.isOpen) {
                        throw new IllegalStateException("Socket pool is closed.");
                    }
                    if (this.queue.size() > 0) {
                        sender = (SocketSender)this.queue.removeFirst();
                    } else if (this.inuse.size() < this.limit) {
                        sender = this.getNewSocketSender();
                    } else {
                        try {
                            this.mutex.wait(timeout);
                        }
                        catch (Exception x) {
                            log.warn((Object)DataSender.sm.getString("PoolSocketSender.senderQueue.sender.failed", (Object)this.parent.getAddress(), (Object)new Integer(this.parent.getPort())), (Throwable)x);
                        }
                    }
                    if (sender != null) {
                        this.inuse.add(sender);
                    }
                }
                delta = System.currentTimeMillis() - start;
            } while (this.isOpen && sender == null && (timeout == 0L || delta < timeout));
            return sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnSender(SocketSender sender) {
            Object object = this.mutex;
            synchronized (object) {
                this.queue.add(sender);
                this.inuse.remove(sender);
                this.mutex.notify();
            }
        }

        private SocketSender getNewSocketSender() {
            SocketSender sender = new SocketSender(PooledSocketSender.this.getDomain(), this.parent.getAddress(), this.parent.getPort(), this.parent.getSenderState());
            sender.setKeepAliveMaxRequestCount(this.parent.getKeepAliveMaxRequestCount());
            sender.setKeepAliveTimeout(this.parent.getKeepAliveTimeout());
            sender.setAckTimeout(this.parent.getAckTimeout());
            sender.setWaitForAck(this.parent.isWaitForAck());
            sender.setResend(this.parent.isResend());
            return sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                SocketSender sender;
                int i;
                for (i = 0; i < this.queue.size(); ++i) {
                    sender = (SocketSender)this.queue.get(i);
                    sender.disconnect();
                }
                for (i = 0; i < this.inuse.size(); ++i) {
                    sender = (SocketSender)this.inuse.get(i);
                    sender.disconnect();
                }
                this.queue.clear();
                this.inuse.clear();
                this.isOpen = false;
                this.mutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() {
            Object object = this.mutex;
            synchronized (object) {
                this.isOpen = true;
                this.mutex.notifyAll();
            }
        }
    }
}

