/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import org.netbeans.modules.xml.xdm.nodes.TokenType;

public class Token {
    private static final Token EQUALS_TOKEN = new Token("=", TokenType.TOKEN_ATTR_EQUAL);
    private static final Token CLOSE_ELEMENT = new Token(">", TokenType.TOKEN_ELEMENT_END_TAG);
    private static final Token SELF_CLOSE_ELEMENT = new Token("/>", TokenType.TOKEN_ELEMENT_END_TAG);
    public static final Token CDATA_START = new Token("<![CDATA[", TokenType.TOKEN_CDATA_VAL);
    public static final Token CDATA_END = new Token("]]>", TokenType.TOKEN_CDATA_VAL);
    public static final Token COMMENT_START = new Token("<!--", TokenType.TOKEN_CDATA_VAL);
    public static final Token COMMENT_END = new Token("-->", TokenType.TOKEN_CDATA_VAL);
    private final String value;
    private final TokenType type;

    Token(String val, TokenType type) {
        this.value = val;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public TokenType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        Token token = (Token)obj;
        return token.getValue().equals(this.getValue()) && token.getType().equals((Object)this.getType());
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " '" + this.value + "'";
    }

    public static Token create(String value, TokenType type) {
        Token t = null;
        switch (type) {
            case TOKEN_ATTR_EQUAL: {
                t = EQUALS_TOKEN;
                break;
            }
            case TOKEN_ELEMENT_END_TAG: {
                t = value.length() == 1 ? CLOSE_ELEMENT : SELF_CLOSE_ELEMENT;
                break;
            }
            default: {
                t = new Token(value, type);
            }
        }
        assert (t != null);
        return t;
    }
}

