/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.EventSetPatternNode;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.IdxPropertyPatternNode;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyPatternNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class PatternChildren
extends Children.Keys {
    static final RequestProcessor ANALYZER = new RequestProcessor("Bean patterns analyser", 1);
    private boolean wri = true;
    private Listener elementListener = new Listener(this);
    private RequestProcessor.Task refreshTask;
    private PatternAnalyser patternAnalyser;
    private final JavaClass classElement;
    static /* synthetic */ Class class$org$netbeans$modules$beans$PatternChildren;

    public PatternChildren(JavaClass classElement) {
        this(classElement, true);
    }

    public PatternChildren(JavaClass classElement, boolean isWritable) {
        this.classElement = classElement;
        this.patternAnalyser = new PatternAnalyser(classElement);
        PropertyActionSettings.getDefault().addPropertyChangeListener(this.elementListener);
        this.wri = isWritable;
    }

    protected void addNotify() {
        super.addNotify();
        this.refreshAllKeys();
    }

    protected void refreshAllKeys() {
        this.scheduleRefresh();
    }

    private synchronized void scheduleRefresh() {
        if (this.refreshTask == null) {
            this.refreshTask = ANALYZER.create((Runnable)this.elementListener);
        }
        this.refreshTask.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshKeys(int filter) {
        JMIUtils.beginTrans(false);
        try {
            try {
                this.elementListener.unregisterAll();
                this.elementListener.reassignMethodListener(this.classElement);
                this.elementListener.reassignFieldListener(this.classElement);
                this.elementListener.assignFeaturesListener(this.classElement);
                this.patternAnalyser.analyzeAll();
            }
            finally {
                JMIUtils.endTrans();
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        this.setKeys(this.collectAllKeys());
    }

    private Collection collectAllKeys() {
        LinkedList keys = new LinkedList();
        keys.addAll(this.getKeysOfType(256));
        keys.addAll(this.getKeysOfType(512));
        keys.addAll(this.getKeysOfType(1024));
        return keys;
    }

    PatternAnalyser getPatternAnalyser() {
        return this.patternAnalyser;
    }

    public void removeAll() {
        this.elementListener.unregisterAll();
        this.setKeys(Collections.EMPTY_LIST);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{this.createPatternNode(key)};
    }

    private Node createPatternNode(Object key) {
        if (key instanceof IdxPropertyPattern) {
            return new IdxPropertyPatternNode((IdxPropertyPattern)key, this.wri);
        }
        if (key instanceof PropertyPattern) {
            return new PropertyPatternNode((PropertyPattern)key, this.wri);
        }
        if (key instanceof EventSetPattern) {
            return new EventSetPatternNode((EventSetPattern)key, this.wri);
        }
        ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("Unknown key: " + key));
        return null;
    }

    protected Collection getKeysOfType(int elementType) {
        ArrayList keys = null;
        if ((elementType & 0x100) != 0) {
            keys = new ArrayList(this.patternAnalyser.getPropertyPatterns());
            Collections.sort(keys, new PatternComparator());
        }
        if ((elementType & 0x200) != 0) {
            keys = new ArrayList(this.patternAnalyser.getIdxPropertyPatterns());
            Collections.sort(keys, new PatternComparator());
        }
        if ((elementType & 0x400) != 0) {
            keys = new ArrayList(this.patternAnalyser.getEventSetPatterns());
            Collections.sort(keys, new PatternComparator());
        }
        return keys;
    }

    private static final class PatternComparator
    implements Comparator {
        private PatternComparator() {
        }

        public int compare(Object a, Object b) {
            return ((Pattern)a).getName().compareTo(((Pattern)b).getName());
        }

        public boolean equals(Object c) {
            return c instanceof PatternComparator;
        }
    }

    static final class Listener
    extends WeakReference
    implements MDRChangeListener,
    PropertyChangeListener,
    Runnable {
        List knownFields;
        List knownMethods;
        JavaClass classElement;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Listener(PatternChildren owner) {
            super(owner, Utilities.activeReferenceQueue());
        }

        private PatternChildren getChildren() {
            PatternChildren o = (PatternChildren)((Object)this.get());
            if (o != null) {
                return o;
            }
            this.unregisterAll();
            PropertyActionSettings.getDefault().removePropertyChangeListener(this);
            return null;
        }

        private void reassignMethodListener(JavaClass el) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            List methods = JMIUtils.getMethods((ClassDefinition)el);
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                MDRChangeSource method = (MDRChangeSource)it.next();
                method.addListener((MDRChangeListener)this);
            }
            this.knownMethods = methods;
        }

        private void reassignFieldListener(JavaClass el) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            List fields = JMIUtils.getFields(el);
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                MDRChangeSource field = (MDRChangeSource)it.next();
                field.addListener((MDRChangeListener)this);
            }
            this.knownFields = fields;
        }

        private void assignFeaturesListener(JavaClass el) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            ((MDRChangeSource)el).addListener((MDRChangeListener)this);
            this.classElement = el;
        }

        synchronized void unregisterAll() {
            List methods;
            List fields = this.knownFields;
            if (fields != null) {
                Iterator it = fields.iterator();
                while (it.hasNext()) {
                    MDRChangeSource field = (MDRChangeSource)it.next();
                    field.removeListener((MDRChangeListener)this);
                    this.knownFields = null;
                }
            }
            if ((methods = this.knownMethods) != null) {
                Iterator it = methods.iterator();
                while (it.hasNext()) {
                    MDRChangeSource method = (MDRChangeSource)it.next();
                    method.removeListener((MDRChangeListener)this);
                    this.knownMethods = null;
                }
            }
            if (this.classElement != null) {
                ((MDRChangeSource)this.classElement).removeListener((MDRChangeListener)this);
                this.classElement = null;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object src = e.getSource();
            String name = e.getPropertyName();
            if (PropertyActionSettings.getDefault() == src && !"prop_style".equals(name)) {
                return;
            }
            PatternChildren pch = this.getChildren();
            if (pch != null) {
                pch.scheduleRefresh();
            }
        }

        public void run() {
            PatternChildren pch = this.getChildren();
            if (pch != null) {
                pch.refreshKeys(1792);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent e) {
            PatternChildren pch;
            boolean refresh = false;
            try {
                JMIUtils.beginTrans(false);
                try {
                    refresh = this.checkChangeEvent(e);
                }
                finally {
                    JMIUtils.endTrans();
                }
            }
            catch (JmiException e1) {
                ErrorManager.getDefault().notify(4096, (Throwable)e1);
            }
            if (refresh && (pch = this.getChildren()) != null) {
                pch.refreshAllKeys();
            }
        }

        private boolean checkChangeEvent(MDRChangeEvent e) {
            Object src = e.getSource();
            if (src instanceof Element && ((Element)src).isValid() && e instanceof AttributeEvent) {
                AttributeEvent ae = (AttributeEvent)e;
                String name = ae.getAttributeName();
                if (src instanceof JavaClass ? "contents".equals(name) : "name".equals(name) || "modifiers".equals(name) || "typeName".equals(name) || "parameters".equals(name)) {
                    return true;
                }
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$PatternChildren == null ? (class$org$netbeans$modules$beans$PatternChildren = PatternChildren.class$("org.netbeans.modules.beans.PatternChildren")) : class$org$netbeans$modules$beans$PatternChildren).desiredAssertionStatus();
        }
    }
}

