/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.DefaultPositionBoundsResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.safedelete.AbstractSafeDeleteRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class PersistenceXmlSafeDeleteRefactoring
implements J2EERefactoring {
    private Element element;
    private SafeDeleteRefactoring safeDeleteRefactoring;

    public PersistenceXmlSafeDeleteRefactoring(Element element, SafeDeleteRefactoring safeDeleteRefactoring) {
        this.element = element;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = null;
        for (Object elem : this.element.getResource().getClassifiers()) {
            JavaClass jClass = (JavaClass)elem;
            for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(jClass)) {
                PUDataObject dataObject = ProviderUtil.getPUDataObject((FileObject)ddFile);
                if (!ProviderUtil.isValid((PUDataObject)dataObject)) {
                    Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlSafeDeleteRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ddFile.getPath()));
                    problem = Utility.addProblemsToEnd(problem, newProblem);
                    continue;
                }
                PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits((PUDataObject)dataObject);
                for (int i = 0; i < persistenceUnits.length; ++i) {
                    PersistenceUnit unit = persistenceUnits[i];
                    for (int j = 0; j < unit.getClass2().length; ++j) {
                        if (!unit.getClass2()[j].equals(jClass.getName())) continue;
                        PersistenceXmlSafeDeleteRefactoringElement refactoringElem = new PersistenceXmlSafeDeleteRefactoringElement(unit, jClass.getName(), dataObject, ddFile);
                        refactoringElementsBag.add((AbstractRefactoring)this.safeDeleteRefactoring, (RefactoringElementImplementation)refactoringElem);
                    }
                }
            }
        }
        return problem;
    }

    private static class PersistenceXmlSafeDeleteRefactoringElement
    extends AbstractSafeDeleteRefactoringElement
    implements ExternalChange {
        private PersistenceUnit persistenceUnit;
        private PUDataObject puDataObject;
        private String clazz;

        public PersistenceXmlSafeDeleteRefactoringElement(PersistenceUnit persistenceUnit, String clazz, PUDataObject puDataObject, FileObject parentFile) {
            this.parentFile = parentFile;
            this.clazz = clazz;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = puDataObject;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.clazz};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlSafeDeleteRefactoringElement.class, (String)"TXT_PersistenceXmlSafeDeleteClass"), this.clazz);
        }

        public void performExternalChange() {
            ProviderUtil.removeManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (PUDataObject)this.puDataObject);
        }

        public void undoExternalChange() {
            ProviderUtil.addManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public PositionBounds getPosition() {
            try {
                return new DefaultPositionBoundsResolver(DataObject.find((FileObject)this.parentFile), this.clazz).getPositionBounds();
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
        }
    }
}

