/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.BadgingSupport;
import org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.io.TreeStreamResult;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LayerUtils {
    private static final Map layerHandleCache;
    private static final Set XML_LIKE_TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LayerUtils() {
    }

    static URL[] currentify(URL u, String suffix, ClassPath cp) {
        if (cp == null) {
            return new URL[]{u};
        }
        try {
            if (u.getProtocol().equals("nbres")) {
                FileObject fo;
                String path = u.getFile();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((fo = cp.findResource(path)) != null) {
                    return new URL[]{fo.getURL()};
                }
            } else if (u.getProtocol().equals("nbresloc")) {
                String ext;
                String name;
                String nameext;
                String folder;
                int idx;
                ArrayList<URL> urls = new ArrayList<URL>();
                String path = u.getFile();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((idx = path.lastIndexOf(47)) == -1) {
                    folder = "";
                    nameext = path;
                } else {
                    folder = path.substring(0, idx + 1);
                    nameext = path.substring(idx + 1);
                }
                idx = nameext.lastIndexOf(46);
                if (idx == -1) {
                    name = nameext;
                    ext = "";
                } else {
                    name = nameext.substring(0, idx);
                    ext = nameext.substring(idx);
                }
                ArrayList<String> suffixes = new ArrayList<String>(LayerUtils.computeSubVariants(suffix));
                suffixes.add(suffix);
                Collections.reverse(suffixes);
                Iterator it = suffixes.iterator();
                while (it.hasNext()) {
                    String trysuffix = (String)it.next();
                    String trypath = folder + name + trysuffix + ext;
                    FileObject fo = cp.findResource(trypath);
                    if (fo == null) continue;
                    urls.add(fo.getURL());
                }
                if (!urls.isEmpty()) {
                    return urls.toArray(new URL[urls.size()]);
                }
            }
        }
        catch (FileStateInvalidException fsie) {
            Util.err.notify(16, (Throwable)fsie);
        }
        return new URL[]{u};
    }

    private static List computeSubVariants(String name) {
        int idx = name.indexOf(95);
        if (idx == -1) {
            return Collections.EMPTY_LIST;
        }
        String base = name.substring(0, idx);
        String suffix = name.substring(idx);
        List l = LayerUtils.computeSubVariants(base, suffix);
        return l.subList(0, l.size() - 1);
    }

    private static List computeSubVariants(String base, String suffix) {
        int idx = suffix.indexOf(95, 1);
        if (idx == -1) {
            LinkedList<String> l = new LinkedList<String>();
            l.add(base);
            l.add(base + suffix);
            return l;
        }
        String remainder = suffix.substring(idx);
        List l1 = LayerUtils.computeSubVariants(base, remainder);
        List l2 = LayerUtils.computeSubVariants(base + suffix.substring(0, idx), remainder);
        LinkedList l = new LinkedList(l1);
        l.addAll(l2);
        return l;
    }

    public static LayerHandle layerForProject(NbModuleProject project) {
        LayerHandle handle = (LayerHandle)layerHandleCache.get(project);
        if (handle == null) {
            handle = new LayerHandle(project);
            layerHandleCache.put(project, handle);
        }
        return handle;
    }

    public static String findGeneratedName(FileObject parent, String layerPath) {
        Matcher m = Pattern.compile("(.+/)?([^/.]+)(\\.[^/]+)?").matcher(layerPath);
        if (!m.matches()) {
            throw new IllegalArgumentException(layerPath);
        }
        String base = m.group(2);
        String ext = m.group(3);
        if (ext == null) {
            ext = "";
        } else if (ext.equals(".java")) {
            ext = "_java";
        } else if (XML_LIKE_TYPES.contains(ext)) {
            String upper = ext.substring(1, 2).toUpperCase(Locale.ENGLISH);
            base = base + upper + ext.substring(2);
            ext = ".xml";
        }
        String name = base + ext;
        if (parent == null || parent.getFileObject(name) == null) {
            return name;
        }
        int i = 1;
        while (parent.getFileObject(name = base + '_' + i + ext) != null) {
            ++i;
        }
        return name;
    }

    static SavableTreeEditorCookie cookieForFile(FileObject f) {
        return new CookieImpl(f);
    }

    public static FileSystem getEffectiveSystemFilesystem(Project project) throws IOException {
        if (project instanceof NbModuleProject) {
            NbModuleProject p = (NbModuleProject)project;
            NbModuleTypeProvider.NbModuleType type = Util.getModuleType(p);
            FileSystem projectLayer = LayerUtils.layerForProject(p).layer(false);
            if (type == NbModuleTypeProvider.STANDALONE) {
                Set jars = LayerUtils.getPlatformJarsForStandaloneProject(p);
                FileSystem[] platformLayers = LayerUtils.getPlatformLayers(jars);
                ClassPath cp = LayerUtils.createLayerClasspath(Collections.singleton(p), jars);
                return LayerUtils.mergeFilesystems(projectLayer, platformLayers, cp);
            }
            if (type == NbModuleTypeProvider.SUITE_COMPONENT) {
                SuiteProject suite = SuiteUtils.findSuite(p);
                if (suite == null) {
                    throw new IOException("Could not load suite for " + p);
                }
                ArrayList<FileSystem> readOnlyLayers = new ArrayList<FileSystem>();
                Set modules = SuiteUtils.getSubProjects(suite);
                Iterator it = modules.iterator();
                while (it.hasNext()) {
                    LayerHandle handle;
                    FileSystem roLayer;
                    NbModuleProject sister = (NbModuleProject)it.next();
                    if (sister == p || (roLayer = (handle = LayerUtils.layerForProject(sister)).layer(false)) == null) continue;
                    readOnlyLayers.add(roLayer);
                }
                Set jars = LayerUtils.getPlatformJarsForSuiteComponentProject(p, suite);
                readOnlyLayers.addAll(Arrays.asList(LayerUtils.getPlatformLayers(jars)));
                ClassPath cp = LayerUtils.createLayerClasspath(modules, jars);
                return LayerUtils.mergeFilesystems(projectLayer, readOnlyLayers.toArray(new FileSystem[readOnlyLayers.size()]), cp);
            }
            if (type == NbModuleTypeProvider.NETBEANS_ORG) {
                XMLFileSystem xfs;
                Set projects;
                block10: {
                    projects = LayerUtils.getProjectsForNetBeansOrgProject(p);
                    ArrayList<URL> otherLayerURLs = new ArrayList<URL>();
                    Iterator it = projects.iterator();
                    while (it.hasNext()) {
                        FileObject layerXml;
                        FileObject src;
                        NbModuleProject p2 = (NbModuleProject)it.next();
                        ManifestManager mm = ManifestManager.getInstance(p2.getManifest(), false);
                        String layer = mm.getLayer();
                        if (layer == null || (src = p2.getSourceDirectory()) == null || (layerXml = src.getFileObject(layer)) == null) continue;
                        otherLayerURLs.add(layerXml.getURL());
                    }
                    xfs = new XMLFileSystem();
                    try {
                        xfs.setXmlUrls(otherLayerURLs.toArray(new URL[otherLayerURLs.size()]));
                    }
                    catch (PropertyVetoException ex) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)ex);
                    }
                }
                ClassPath cp = LayerUtils.createLayerClasspath(projects, Collections.EMPTY_SET);
                return LayerUtils.mergeFilesystems(projectLayer, new FileSystem[]{xfs}, cp);
            }
            throw new AssertionError(type);
        }
        if (project instanceof SuiteProject) {
            throw new AssertionError((Object)"XXX not yet implemented");
        }
        throw new IllegalArgumentException(project.toString());
    }

    static Set getPlatformJarsForStandaloneProject(NbModuleProject project) {
        NbPlatform platform = project.getPlatform(true);
        return LayerUtils.getPlatformJars(platform, null, null, null);
    }

    static Set getPlatformJarsForSuiteComponentProject(NbModuleProject project, SuiteProject suite) {
        NbPlatform platform = suite.getPlatform(true);
        PropertyEvaluator eval = suite.getEvaluator();
        String[] includedClusters = SuiteProperties.getArrayProperty(eval, "enabled.clusters");
        String[] excludedClusters = SuiteProperties.getArrayProperty(eval, "disabled.clusters");
        String[] excludedModules = SuiteProperties.getArrayProperty(eval, "disabled.modules");
        return LayerUtils.getPlatformJars(platform, includedClusters, excludedClusters, excludedModules);
    }

    static Set getProjectsForNetBeansOrgProject(NbModuleProject project) throws IOException {
        ModuleList list = project.getModuleList();
        HashSet<NbModuleProject> projects = new HashSet<NbModuleProject>();
        projects.add(project);
        Iterator it = list.getAllEntriesSoft().iterator();
        while (it.hasNext()) {
            ModuleEntry other = (ModuleEntry)it.next();
            if (other.getClusterDirectory().getName().equals("extra")) continue;
            File root = other.getSourceLocation();
            if (!$assertionsDisabled && root == null) {
                throw new AssertionError(other);
            }
            NbModuleProject p2 = (NbModuleProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)root));
            if (p2 == null) continue;
            projects.add(p2);
        }
        return projects;
    }

    private static Set getPlatformJars(NbPlatform platform, String[] includedClusters, String[] excludedClusters, String[] excludedModules) {
        if (platform == null) {
            return Collections.EMPTY_SET;
        }
        Set<String> includedClustersS = includedClusters != null ? new HashSet<String>(Arrays.asList(includedClusters)) : Collections.EMPTY_SET;
        Set<String> excludedClustersS = excludedClusters != null ? new HashSet<String>(Arrays.asList(excludedClusters)) : Collections.EMPTY_SET;
        Set<String> excludedModulesS = excludedModules != null ? new HashSet<String>(Arrays.asList(excludedModules)) : Collections.EMPTY_SET;
        ModuleEntry[] entries = platform.getModules();
        HashSet<File> jars = new HashSet<File>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            if (!includedClustersS.isEmpty() && !includedClustersS.contains(entries[i].getClusterDirectory().getName()) || includedClustersS.isEmpty() && excludedClustersS.contains(entries[i].getClusterDirectory().getName()) || excludedModulesS.contains(entries[i].getCodeNameBase())) continue;
            jars.add(entries[i].getJarLocation());
        }
        return jars;
    }

    private static FileSystem[] getPlatformLayers(Set platformJars) throws IOException {
        ArrayList<XMLFileSystem> layers = new ArrayList<XMLFileSystem>();
        Iterator it = platformJars.iterator();
        block2: while (it.hasNext()) {
            File jar = (File)it.next();
            ManifestManager mm = ManifestManager.getInstanceFromJAR(jar);
            String[] toks = mm.getRequiredTokens();
            for (int i = 0; i < toks.length; ++i) {
                if (toks[i].startsWith("org.openide.modules.os.")) continue block2;
            }
            String layer = mm.getLayer();
            if (layer == null) continue;
            URL u = new URL("jar:" + jar.toURI() + "!/" + layer);
            try {
                XMLFileSystem xfs = new XMLFileSystem(u);
                boolean hasMasks = false;
                Enumeration e = xfs.getRoot().getChildren(true);
                while (e.hasMoreElements()) {
                    FileObject f = (FileObject)e.nextElement();
                    if (!f.getNameExt().endsWith("_hidden")) continue;
                    hasMasks = true;
                    break;
                }
                if (hasMasks) {
                    layers.add(0, xfs);
                    continue;
                }
                layers.add(xfs);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
        }
        return layers.toArray(new FileSystem[layers.size()]);
    }

    static ClassPath createLayerClasspath(Set moduleProjects, Set platformJars) throws IOException {
        ArrayList<URL> roots = new ArrayList<URL>();
        Iterator it = moduleProjects.iterator();
        while (it.hasNext()) {
            NbModuleProject p = (NbModuleProject)it.next();
            FileObject src = p.getSourceDirectory();
            if (src == null) continue;
            roots.add(src.getURL());
        }
        it = platformJars.iterator();
        while (it.hasNext()) {
            File jar = (File)it.next();
            roots.add(FileUtil.getArchiveRoot((URL)jar.toURI().toURL()));
            File locale = new File(jar.getParentFile(), "locale");
            if (!locale.isDirectory()) continue;
            String n = jar.getName();
            int x = n.lastIndexOf(46);
            if (x == -1) {
                x = n.length();
            }
            String base = n.substring(0, x);
            String ext = n.substring(x);
            String[] variants = locale.list();
            if (variants == null) continue;
            for (int i = 0; i < variants.length; ++i) {
                if (!variants[i].startsWith(base) || !variants[i].endsWith(ext) || variants[i].charAt(x) != '_') continue;
                roots.add(FileUtil.getArchiveRoot((URL)new File(locale, variants[i]).toURI().toURL()));
            }
        }
        return ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
    }

    private static FileSystem mergeFilesystems(FileSystem writableLayer, FileSystem[] readOnlyLayers, ClassPath cp) {
        if (writableLayer == null) {
            writableLayer = new XMLFileSystem();
        }
        FileSystem[] layers = new FileSystem[readOnlyLayers.length + 1];
        layers[0] = writableLayer;
        System.arraycopy(readOnlyLayers, 0, layers, 1, readOnlyLayers.length);
        class BadgingMergedFileSystem
        extends MultiFileSystem {
            private final BadgingSupport status;
            private final /* synthetic */ FileSystem[] val$layers;
            private final /* synthetic */ ClassPath val$cp;

            public BadgingMergedFileSystem(FileSystem[] fileSystemArray, ClassPath classPath) {
                this.val$layers = fileSystemArray;
                this.val$cp = classPath;
                super(fileSystemArray);
                this.status = new BadgingSupport((FileSystem)this);
                this.status.setClasspath(this.val$cp);
                this.status.setSuffix("_" + Locale.getDefault());
            }

            public FileSystem.Status getStatus() {
                return this.status;
            }
        }
        return new BadgingMergedFileSystem(layers, cp);
    }

    static {
        $assertionsDisabled = !LayerUtils.class.desiredAssertionStatus();
        layerHandleCache = new WeakHashMap();
        XML_LIKE_TYPES = new HashSet();
        XML_LIKE_TYPES.add(".settings");
        XML_LIKE_TYPES.add(".wstcref");
        XML_LIKE_TYPES.add(".wsmode");
        XML_LIKE_TYPES.add(".wsgrp");
        XML_LIKE_TYPES.add(".wsmgr");
    }

    public static final class LayerHandle {
        private final NbModuleProject project;
        private FileSystem fs;
        private SavableTreeEditorCookie cookie;
        private boolean autosave;

        LayerHandle(NbModuleProject project) {
            this.project = project;
        }

        public synchronized FileSystem layer(boolean create) {
            if (this.fs == null) {
                FileObject xml = this.getLayerFile();
                if (xml == null) {
                    if (!create) {
                        return null;
                    }
                    try {
                        String layerSrcPath = ManifestManager.getInstance(this.project.getManifest(), false).getLayer();
                        if (layerSrcPath == null) {
                            layerSrcPath = this.newLayerPath();
                            FileObject manifest = this.project.getManifestFile();
                            EditableManifest m = Util.loadManifest(manifest);
                            m.setAttribute("OpenIDE-Module-Layer", layerSrcPath, null);
                            Util.storeManifest(manifest, m);
                        }
                        xml = NbModuleProjectGenerator.createLayer(this.project.getProjectDirectory(), this.project.evaluator().getProperty("src.dir") + '/' + this.newLayerPath());
                    }
                    catch (IOException e) {
                        Util.err.notify(1, (Throwable)e);
                        this.fs = FileUtil.createMemoryFileSystem();
                        return this.fs;
                    }
                }
                try {
                    this.cookie = LayerUtils.cookieForFile(xml);
                    this.fs = new WritableXMLFileSystem(xml.getURL(), this.cookie, null);
                }
                catch (FileStateInvalidException e) {
                    throw new AssertionError((Object)e);
                }
                this.cookie.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (LayerHandle.this.autosave && "dirty".equals(evt.getPropertyName())) {
                            try {
                                LayerHandle.this.save();
                            }
                            catch (IOException e) {
                                Util.err.notify(1, (Throwable)e);
                            }
                        }
                    }
                });
            }
            return this.fs;
        }

        public void save() throws IOException {
            if (this.cookie == null) {
                throw new IOException("Cannot save a nonexistent layer");
            }
            this.cookie.save();
        }

        public FileObject getLayerFile() {
            Manifest mf = this.project.getManifest();
            if (mf == null) {
                return null;
            }
            String path = ManifestManager.getInstance(mf, false).getLayer();
            if (path == null) {
                return null;
            }
            return this.project.getSourceDirectory().getFileObject(path);
        }

        public void setAutosave(boolean autosave) {
            this.autosave = autosave;
            if (autosave && this.cookie != null) {
                try {
                    this.cookie.save();
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
        }

        public boolean isAutosave() {
            return this.autosave;
        }

        private String newLayerPath() {
            return this.project.getCodeNameBase().replace('.', '/') + "/layer.xml";
        }
    }

    private static final class CookieImpl
    implements SavableTreeEditorCookie,
    FileChangeListener {
        private TreeDocumentRoot root;
        private boolean dirty;
        private Exception problem;
        private final FileObject f;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean saving;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CookieImpl(FileObject f) {
            this.f = f;
            f.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)f));
        }

        public TreeDocumentRoot getDocumentRoot() {
            return this.root;
        }

        public int getStatus() {
            if (this.problem != null) {
                return 3;
            }
            if (this.root != null) {
                return 1;
            }
            return 0;
        }

        public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
            if (this.root == null) {
                try {
                    boolean oldDirty = this.dirty;
                    int oldStatus = this.getStatus();
                    this.root = new XMLParsingSupport().parse(new InputSource(this.f.getURL().toExternalForm()));
                    this.problem = null;
                    this.dirty = false;
                    this.pcs.firePropertyChange("dirty", oldDirty, false);
                    this.pcs.firePropertyChange("status", oldStatus, 1);
                }
                catch (IOException e) {
                    this.problem = e;
                    throw e;
                }
                catch (TreeException e) {
                    this.problem = e;
                    throw e;
                }
                ((TreeObject)this.root).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        CookieImpl.this.modified();
                    }
                });
            }
            return this.root;
        }

        public Task prepareDocumentRoot() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        private void modified() {
            if (!this.dirty) {
                this.dirty = true;
                this.pcs.firePropertyChange("dirty", false, true);
            }
        }

        public boolean isDirty() {
            return this.dirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void save() throws IOException {
            if (this.root == null || !this.dirty) {
                return;
            }
            if (!$assertionsDisabled && this.saving) {
                throw new AssertionError();
            }
            this.saving = true;
            try {
                FileLock lock = this.f.lock();
                try {
                    OutputStream os = this.f.getOutputStream(lock);
                    try {
                        new TreeStreamResult(os).getWriter(this.root).writeDocument();
                    }
                    catch (TreeException e) {
                        throw (IOException)new IOException(e.toString()).initCause(e);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            finally {
                this.saving = false;
            }
            this.dirty = false;
            this.pcs.firePropertyChange("dirty", true, false);
        }

        public void fileChanged(FileEvent fe) {
            this.changed();
        }

        public void fileDeleted(FileEvent fe) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void fileDataCreated(FileEvent fe) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        private synchronized void changed() {
            if (this.saving) {
                return;
            }
            this.problem = null;
            this.dirty = false;
            this.root = null;
            this.pcs.firePropertyChange("documentRoot", null, null);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$layers$LayerUtils == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerUtils = LayerUtils.class$("org.netbeans.modules.apisupport.project.layers.LayerUtils")) : class$org$netbeans$modules$apisupport$project$layers$LayerUtils).desiredAssertionStatus();
        }
    }

    static interface SavableTreeEditorCookie
    extends TreeEditorCookie {
        public static final String PROP_DIRTY = "dirty";

        public boolean isDirty();

        public void save() throws IOException;
    }
}

