/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.openide.util.HelpCtx;

abstract class NbPropertyPanel
extends JPanel
implements BasicCustomizer.LazyStorage,
PropertyChangeListener,
HelpCtx.Provider {
    private Class helpCtxClass;
    static final String VALID_PROPERTY = "isPanelValid";
    static final String ERROR_MESSAGE_PROPERTY = "errorMessage";
    protected ModuleProperties props;
    private boolean valid = true;
    private String errMessage;

    NbPropertyPanel(ModuleProperties props, Class helpCtxClass) {
        this.props = props;
        this.initComponents();
        props.addPropertyChangeListener(this);
        this.helpCtxClass = helpCtxClass;
    }

    abstract void refresh();

    String getProperty(String key) {
        return this.props.getProperty(key);
    }

    void setProperty(String key, String property) {
        this.props.setProperty(key, property);
    }

    boolean getBooleanProperty(String key) {
        return this.props.getBooleanProperty(key);
    }

    void setBooleanProperty(String key, boolean property) {
        this.props.setBooleanProperty(key, property);
    }

    protected void setValid(boolean valid) {
        if (this.valid != valid) {
            this.valid = valid;
            this.firePropertyChange(VALID_PROPERTY, !valid, valid);
        }
    }

    protected void checkForm() {
    }

    protected void setErrorMessage(String message) {
        this.setWarning(message);
        this.setValid(null == message || "".equals(message));
    }

    protected void setWarning(String message) {
        String newMessage;
        String string = newMessage = message == null ? "" : message;
        if (!newMessage.equals(this.errMessage)) {
            String oldMessage = this.errMessage;
            this.errMessage = newMessage;
            this.firePropertyChange(ERROR_MESSAGE_PROPERTY, oldMessage, newMessage);
        }
    }

    public void store() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("propertiesRefreshed" == evt.getPropertyName()) {
            this.refresh();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("lastSelectedPanel", null, this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpCtxClass);
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(1, 0, 0));
    }

    static abstract class Suite
    extends NbPropertyPanel {
        Suite(SuiteProperties props, Class helpCtxClass) {
            super(props, helpCtxClass);
        }

        SuiteProperties getProperties() {
            return (SuiteProperties)this.props;
        }
    }

    static abstract class Single
    extends NbPropertyPanel {
        Single(SingleModuleProperties props, Class helpCtxClass) {
            super(props, helpCtxClass);
        }

        SingleModuleProperties getProperties() {
            return (SingleModuleProperties)this.props;
        }
    }
}

