/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.DatasourceComboBoxCustomizer;
import org.openide.util.NbBundle;

final class DatasourceComboBoxHelper {
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(DatasourceComboBoxHelper.class, (String)"LBL_NEW_DATASOURCE");
        }
    };
    private Set<Datasource> datasources = new TreeSet<Datasource>(new DatasourceComparator());

    DatasourceComboBoxHelper(final JComboBox combo) {
        combo.setRenderer(new DatasourceListCellRenderer());
        this.populate(combo, null, false);
        combo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selectedItem;
                int keyCode = e.getKeyCode();
                if (10 == keyCode && (selectedItem = combo.getSelectedItem()) == NEW_ITEM) {
                    Datasource ds = DatasourceComboBoxHelper.this.performCreateDsAction(combo);
                    combo.setPopupVisible(false);
                    e.consume();
                    if (ds != null) {
                        DatasourceComboBoxHelper.this.populate(combo, ds, false);
                    }
                }
            }
        });
        combo.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = combo.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = combo.getSelectedItem();
                if (selectedItem == SEPARATOR_ITEM) {
                    int selectedIndex = combo.getSelectedIndex();
                    if (selectedIndex > this.previousIndex) {
                        this.previousIndex = selectedIndex + 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = selectedIndex - 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    }
                    combo.setSelectedItem(this.previousItem);
                } else if ((e.getModifiers() & 0x10) != 0 && selectedItem == NEW_ITEM) {
                    Datasource ds = DatasourceComboBoxHelper.this.performCreateDsAction(combo);
                    combo.setPopupVisible(false);
                    if (ds != null) {
                        DatasourceComboBoxHelper.this.populate(combo, ds, true);
                    }
                }
            }
        });
    }

    private Datasource performCreateDsAction(final JComboBox combo) {
        final DatasourceComboBoxModel model = (DatasourceComboBoxModel)combo.getModel();
        DatasourceComboBoxCustomizer dsc = new DatasourceComboBoxCustomizer(this.datasources);
        boolean accept = dsc.showDialog();
        DatasourceImpl ds = null;
        if (accept && dsc.getPassword() != null) {
            ds = new DatasourceImpl(dsc.getJndiName(), dsc.getUrl(), dsc.getUsername(), dsc.getPassword(), dsc.getDriverClassName());
            this.datasources.add(ds);
        }
        if (ds == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    combo.setSelectedItem(model.getPreviousItem());
                }
            });
        }
        return ds;
    }

    private void populate(final JComboBox combo, final Datasource selectedDatasource, boolean selectItemLater) {
        LinkedList<Datasource> items = new LinkedList<Datasource>(this.datasources);
        if (items.size() > 0) {
            items.add((Datasource)SEPARATOR_ITEM);
        }
        items.add((Datasource)NEW_ITEM);
        Object[] itemsArray = items.toArray();
        DatasourceComboBoxModel model = new DatasourceComboBoxModel(itemsArray);
        combo.setModel(model);
        if (selectedDatasource != null) {
            combo.setSelectedItem(selectedDatasource);
            if (selectItemLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        combo.setSelectedItem(selectedDatasource);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatasourceComparator
    implements Comparator<Datasource> {
        private DatasourceComparator() {
        }

        @Override
        public int compare(Datasource ds1, Datasource ds2) {
            if (ds1 == null) {
                return ds2 == null ? 0 : -1;
            }
            if (ds2 == null) {
                return 1;
            }
            String dispName1 = ds1.getDisplayName();
            String dispName2 = ds2.getDisplayName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static class DatasourceListCellRenderer
    extends DefaultListCellRenderer {
        private DatasourceListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Datasource) {
                Datasource ds = (Datasource)value;
                this.setText(ds != null ? ds.getDisplayName() : "");
                this.setToolTipText(ds.toString());
            } else {
                if (value == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                this.setText(value != null ? value.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    private static class DatasourceComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object[] items;
        private Object selectedItem;
        private Object previousItem;

        DatasourceComboBoxModel(Object[] items) {
            this.items = items;
            if (items.length > 0 && items[0] instanceof Datasource) {
                this.selectedItem = items[0];
            }
        }

        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null || !this.selectedItem.equals(anItem)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = anItem;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public Object getElementAt(int index) {
            return this.items[index];
        }

        public int getSize() {
            return this.items.length;
        }

        Object getPreviousItem() {
            return this.previousItem;
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }

    private static class DatasourceImpl
    implements Datasource {
        private String jndiName;
        private String url;
        private String username;
        private String password;
        private String driverClassName;
        private String displayName;

        public DatasourceImpl(String jndiName, String url, String username, String password, String driverClassName) {
            this.jndiName = jndiName;
            this.url = url;
            this.username = username;
            this.password = password;
            this.driverClassName = driverClassName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.getJndiName() + " [" + this.getUrl() + "]";
            }
            return this.displayName;
        }
    }
}

