/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;

public class EncapsulateFieldsPlugin
extends JavaRefactoringPlugin {
    private Element[] selectedObjects;
    private EncapsulateFieldRefactoring[] refactorings;
    private EncapsulateFieldsRefactoring refactoring;
    private ProgressListener listener = new ProgressListener(){

        public void start(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStart(event.getOperationType(), event.getCount());
        }

        public void step(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStep();
        }

        public void stop(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStop();
        }
    };
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring;

    public EncapsulateFieldsPlugin(EncapsulateFieldsRefactoring refactoring) {
        this.refactoring = refactoring;
        this.selectedObjects = refactoring.getSelectedObjects();
    }

    public Problem checkParameters() {
        return this.setParameters(false, this.refactoring.getRefactorFields(), this.refactoring.getMethodModifier(), this.refactoring.getFieldModifier(), this.refactoring.isAlwaysUseAccessors());
    }

    public Problem fastCheckParameters() {
        return this.setParameters(true, this.refactoring.getRefactorFields(), this.refactoring.getMethodModifier(), this.refactoring.getFieldModifier(), this.refactoring.isAlwaysUseAccessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            Problem result = null;
            this.fireProgressListenerStep();
            for (int i = 0; i < this.selectedObjects.length; ++i) {
                Feature f;
                ClassDefinition cd;
                Problem problem;
                Element jmiObject = this.selectedObjects[i];
                Problem p = EncapsulateFieldsPlugin.isElementAvail(jmiObject);
                if (p != null) {
                    problem = p;
                    return problem;
                }
                if (jmiObject instanceof UnresolvedClass) {
                    problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
                    return problem;
                }
                if (!(jmiObject instanceof Field) || jmiObject instanceof EnumConstant) {
                    if (this.selectedObjects.length == 1 && this.selectedObjects[0] instanceof JavaClass) {
                        Element[] fields = this.refactoring.getFields();
                        if (fields.length == 0) {
                            String pattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring == null ? EncapsulateFieldsPlugin.class$("org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring") : class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring), (String)"ERR_EncapsulateNoFields");
                            String text = new MessageFormat(pattern).format(new Object[]{((JavaClass)this.selectedObjects[0]).getSimpleName()});
                            result = EncapsulateFieldsPlugin.createProblem(result, true, text);
                        } else {
                            this.selectedObjects = fields;
                        }
                    } else {
                        result = EncapsulateFieldsPlugin.createProblem(result, true, NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring == null ? EncapsulateFieldsPlugin.class$("org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring") : class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring), (String)"ERR_EncapsulateWrongType"));
                    }
                } else if (jmiObject instanceof Feature && (cd = (f = (Feature)jmiObject).getDeclaringClass()) != null && cd instanceof JavaClass && ((JavaClass)cd).isInterface()) {
                    result = EncapsulateFieldsPlugin.createProblem(result, true, NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring == null ? EncapsulateFieldsPlugin.class$("org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring") : class$org$netbeans$modules$refactoring$api$EncapsulateFieldsRefactoring), (String)"ERR_EncapsulateInIntf"));
                }
                if (result != null && result.isFatal()) {
                    problem = result;
                    return problem;
                }
                if (CheckUtils.isElementInOpenProject(jmiObject)) continue;
                problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private static final String getCannotRefactor(Resource r) {
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotRefactorFile")).format(new Object[]{r.getName()});
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Problem problem = null;
        Problem lastProblem = null;
        RefactoringSession session = elements.getSession();
        for (int i = 0; i < this.refactorings.length; ++i) {
            if (this.cancelRequest) {
                return null;
            }
            Problem p = this.refactorings[i].prepare(session);
            if (p == null) continue;
            if (problem == null) {
                problem = lastProblem = p;
                continue;
            }
            lastProblem.setNext(p);
            lastProblem = p;
        }
        this.referencesIterator = null;
        return problem;
    }

    public void cancelRequest() {
        if (this.refactorings != null) {
            for (int i = 0; i < this.refactorings.length; ++i) {
                this.refactorings[i].cancelRequest();
            }
        }
    }

    private Problem setParameters(boolean checkOnly, EncapsulateFieldsRefactoring.EncapsulateFieldInfo[] refactorFields, int methodModifier, int fieldModifier, boolean alwaysUseAccessors) {
        if (!checkOnly) {
            this.refactorings = new EncapsulateFieldRefactoring[refactorFields.length];
        }
        Problem problem = null;
        Problem lastProblem = null;
        for (int i = 0; i < refactorFields.length; ++i) {
            Problem p;
            EncapsulateFieldsRefactoring.EncapsulateFieldInfo info = refactorFields[i];
            EncapsulateFieldRefactoring ref = new EncapsulateFieldRefactoring(info.getField());
            if (!checkOnly) {
                this.refactorings[i] = ref;
            }
            ref.setGetterName(info.getGetterName());
            ref.setSetterName(info.getSetterName());
            ref.setMethodModifiers(methodModifier);
            ref.setFieldModifiers(fieldModifier);
            ref.setAlwaysUseAccessors(alwaysUseAccessors);
            if (checkOnly) {
                p = ref.fastCheckParameters();
            } else {
                ref.addProgressListener(this.listener);
                p = ref.checkParameters();
            }
            if (p == null) continue;
            if (problem == null) {
                problem = lastProblem = p;
                continue;
            }
            lastProblem.setNext(p);
            lastProblem = p;
        }
        return problem;
    }
}

