/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.ExtractMethodRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.openide.actions.EditAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ExtractMethodPanel
extends CustomRefactoringPanel {
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final String[] columnNames = new String[]{ExtractMethodPanel.getString("LBL_ExtractMethodColName"), ExtractMethodPanel.getString("LBL_ExtractMethodColType"), "Variable"};
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private ParametersPanel parentPanel;
    private ParamTableModel model;
    private ExtractMethodRefactoring refactoring;
    private boolean initialized;
    private JPanel buttonsPanel;
    private JPanel eastPanel;
    private JPanel fillPanel;
    private JCheckBox isStatic;
    private JComboBox modifiersCombo;
    private JLabel modifiersLabel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel name;
    private JTextField nameField;
    private JTable paramTable;
    private JLabel parameters;
    private JLabel previewChange;
    private JScrollPane westPanel;

    public ExtractMethodPanel(ExtractMethodRefactoring ref, ParametersPanel parent) {
        this.parentPanel = parent;
        this.refactoring = ref;
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
    }

    public void requestFocus() {
        this.nameField.requestFocus();
    }

    public void initialize() {
        if (!this.initialized) {
            this.nameField.setText(this.refactoring.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.nameField.getText().length());
            if (this.refactoring.isStaticMod()) {
                this.isStatic.setSelected(true);
                this.isStatic.setEnabled(false);
            } else {
                this.isStatic.setSelected(false);
            }
            this.setModifier();
            this.setStatic();
            this.initTableData();
            this.nameField.requestFocus();
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent event) {
                }

                public void insertUpdate(DocumentEvent event) {
                    ExtractMethodPanel.this.parentPanel.stateChanged(null);
                    ExtractMethodPanel.this.setPreviewText(event);
                }

                public void removeUpdate(DocumentEvent event) {
                    ExtractMethodPanel.this.parentPanel.stateChanged(null);
                    ExtractMethodPanel.this.setPreviewText(event);
                }
            });
            this.previewChange.setText(this.genDeclarationString(null));
            this.initialized = true;
        }
    }

    private void initComponents() {
        this.parameters = new JLabel();
        this.isStatic = new JCheckBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.modifiersLabel = new JLabel();
        this.modifiersCombo = new JComboBox();
        this.name = new JLabel();
        this.nameField = new JTextField();
        this.previewChange = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodHeader"));
        this.parameters.setLabelFor(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.parameters, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodParameters"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.parameters, gridBagConstraints);
        this.parameters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_paramTable"));
        Mnemonics.setLocalizedText((AbstractButton)this.isStatic, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodStatic"));
        this.isStatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractMethodPanel.this.isStaticActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.isStatic, gridBagConstraints);
        this.isStatic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_DeclareStaticDescription"));
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.moveUpButton.setMnemonic(ExtractMethodPanel.getString("LBL_ExtractMethodMoveUp_MNEM").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodMoveUp"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractMethodPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setMnemonic(ExtractMethodPanel.getString("LBL_ExtractMethodMoveDown_MNEM").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodMoveDown"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractMethodPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, ExtractMethodPanel.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_paramTable"));
        this.paramTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.modifiersLabel.setDisplayedMnemonic(ExtractMethodPanel.getString("LBL_ExtractMethodMods_MNEM").charAt(0));
        this.modifiersLabel.setLabelFor(this.modifiersCombo);
        Mnemonics.setLocalizedText((JLabel)this.modifiersLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodMods"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersCombo.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.modifiersCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractMethodPanel.this.modifiersComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.modifiersCombo, gridBagConstraints);
        this.modifiersCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_methodAcc"));
        this.modifiersCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_methodAcc"));
        this.name.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.name, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ExtractMethodName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_nameField"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)"ACSD_nameField"));
        this.previewChange.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle((Class)ExtractMethodPanel.class).getString("LBL_ExtractMethodPreview")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.previewChange, gridBagConstraints);
    }

    private void isStaticActionPerformed(ActionEvent evt) {
        this.previewChange.setText(this.genDeclarationString(null));
    }

    private void modifiersComboActionPerformed(ActionEvent evt) {
        this.previewChange.setText(this.genDeclarationString(null));
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.doMove(-1);
    }

    public String getMethodName() {
        return this.nameField.getText();
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    protected int getModifier() {
        switch (this.modifiersCombo.getSelectedIndex()) {
            case 3: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 1: {
                return 4;
            }
        }
        return 1;
    }

    boolean isStatic() {
        return this.isStatic.isSelected();
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!ExtractMethodPanel.this.initialized || e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    ExtractMethodPanel.this.setButtons(minIndex, maxIndex);
                } else {
                    ExtractMethodPanel.this.moveDownButton.setEnabled(false);
                    ExtractMethodPanel.this.moveUpButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (!ExtractMethodPanel.this.initialized) {
                    return;
                }
                int[] selectedRows = ExtractMethodPanel.this.paramTable.getSelectedRows();
                if (selectedRows.length != 0) {
                    int min = selectedRows[0];
                    int max = selectedRows[selectedRows.length - 1];
                    ExtractMethodPanel.this.setButtons(min, max);
                }
                ExtractMethodPanel.this.previewChange.setText(ExtractMethodPanel.this.genDeclarationString(null));
                ExtractMethodPanel.this.parentPanel.stateChanged(null);
            }
        };
    }

    private boolean acceptEditedValue() {
        TableCellEditor tce = this.paramTable.getCellEditor();
        if (tce != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int step) {
        this.acceptEditedValue();
        ListSelectionModel selectionModel = this.paramTable.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        selectionModel.clearSelection();
        this.model.moveRow(min, max, min + step);
        selectionModel.addSelectionInterval(min + step, max + step);
    }

    private void setButtons(int min, int max) {
        int r = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(min > 0);
        this.moveDownButton.setEnabled(max < r);
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)ExtractMethodPanel.class, (String)key);
    }

    private void initRenderer() {
        TableColumnModel tcm = this.paramTable.getColumnModel();
        Enumeration<TableColumn> columns = this.paramTable.getColumnModel().getColumns();
        this.paramTable.removeColumn(tcm.getColumn(2));
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            tc.setCellRenderer(new ParamRenderer());
        }
    }

    private void setModifier() {
        int mod = this.refactoring.getModifier();
        if (Modifier.isPrivate(mod)) {
            this.modifiersCombo.setSelectedIndex(3);
        } else if (Modifier.isProtected(mod)) {
            this.modifiersCombo.setSelectedIndex(1);
        } else if (Modifier.isPublic(mod)) {
            this.modifiersCombo.setSelectedIndex(0);
        } else {
            this.modifiersCombo.setSelectedIndex(2);
        }
    }

    private void setStatic() {
        this.isStatic.setSelected(this.refactoring.isStaticMod());
    }

    private void initTableData() {
        ExtractMethodRefactoring.ParameterInfo[] pars = this.refactoring.getParamTable();
        for (int i = 0; i < pars.length; ++i) {
            ExtractMethodRefactoring.ParameterInfo par = pars[i];
            Variable var = par.getVariable();
            Type t = var.getType();
            if (var instanceof Parameter && ((Parameter)var).isVarArg()) {
                JavaModelPackage pack = (JavaModelPackage)t.refImmediatePackage();
                t = pack.getArray().resolveArray(t);
            }
            Object[] row = new Object[]{par.getName(), t.getName(), var};
            this.model.addRow(row);
        }
    }

    private static Action getEditAction() {
        return (EditAction)SystemAction.get((Class)EditAction.class);
    }

    private String genDeclarationString(String newName) {
        int mods = this.getModifier() | (this.isStatic() ? 8 : 0);
        StringBuffer buf = new StringBuffer(50);
        if (mods != 0) {
            buf.append(Modifier.toString(mods));
            buf.append(' ');
        }
        buf.append(this.refactoring.getReturnType().getName());
        buf.append(' ');
        buf.append(newName == null ? this.refactoring.getName() : newName);
        buf.append('(');
        List[] parameters = this.model.getDataVector().toArray(new List[0]);
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                buf.append((String)parameters[i].get(1));
                buf.append(' ');
                buf.append((String)parameters[i].get(0));
                if (i >= parameters.length - 1) continue;
                buf.append(',').append(' ');
            }
        }
        buf.append(')');
        return buf.toString();
    }

    private void setPreviewText(DocumentEvent e) {
        try {
            Document d = e.getDocument();
            this.previewChange.setText(this.genDeclarationString(d.getText(0, d.getLength())));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] data, int rowCount) {
            super(data, rowCount);
        }

        public boolean isCellEditable(int row, int column) {
            if (column > 1) {
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        Color origBackground;

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setBackground(UIManager.getColor("Panel.background"));
            }
            return this;
        }
    }
}

