/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.refactoring.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PushDownPanel
extends CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PushDown_KeepAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, NamedElement.class, Boolean.class};
    private final PushDownRefactoring refactoring;
    private final TableModel tableModel;
    private Set selectedMembers;
    private JavaClass originalType;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JScrollPane membersScrollPane;
    private JTable membersTable;

    public PushDownPanel(PushDownRefactoring refactoring, Set selectedMembers) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = selectedMembers;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
    }

    public void initialize() {
        ArrayList l = new ArrayList();
        l.addAll(this.refactoring.getSourceType().getFeatures());
        l.addAll(this.refactoring.getSourceType().getInterfaceNames());
        Object[][] allMembers = new Object[l.size()][3];
        int i = 0;
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof JavaClass) && !(o instanceof Method) && !(o instanceof Field) && !(o instanceof MultipartId)) continue;
            allMembers[i][0] = this.selectedMembers.contains(o) ? Boolean.TRUE : Boolean.FALSE;
            allMembers[i][1] = o;
            allMembers[i][2] = o instanceof Method ? Boolean.FALSE : null;
            ++i;
        }
        this.members = new Object[i][3];
        if (i > 0) {
            System.arraycopy(allMembers, 0, this.members, 0, i);
        }
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

            protected String extractText(Object value) {
                String displayValue = super.extractText(value);
                if (value instanceof MultipartId) {
                    displayValue = "implements " + displayValue;
                }
                return displayValue;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object object = table.getModel().getValueAt(row, 1);
                if (object instanceof Method && PushDownPanel.this.refactoring.getSourceType().isInterface() && !Modifier.isStatic(((Method)object).getModifiers())) {
                    value = Boolean.TRUE;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.membersScrollPane.setBackground(this.membersTable.getBackground());
        this.membersScrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    public PushDownRefactoring.MemberInfo[] getMembers() {
        ArrayList<PushDownRefactoring.MemberInfo> list = new ArrayList<PushDownRefactoring.MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object element = this.members[i][1];
            PushDownRefactoring.MemberInfo member = element instanceof Field ? new PushDownRefactoring.MemberInfo((Field)element) : (element instanceof JavaClass ? new PushDownRefactoring.MemberInfo((JavaClass)element) : (element instanceof MultipartId ? new PushDownRefactoring.MemberInfo((MultipartId)element) : new PushDownRefactoring.MemberInfo((Method)element, (boolean)((Boolean)this.members[i][2]))));
            list.add(member);
        }
        return list.toArray(new PushDownRefactoring.MemberInfo[list.size()]);
    }

    private void initComponents() {
        this.membersScrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.chooseLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage((Class)PushDownPanel.class, (String)"LBL_PushDown_Header", (Object[])new Object[]{UIUtilities.getDisplayText((NamedElement)this.refactoring.getSourceType())}));
        this.membersScrollPane.setToolTipText("");
        this.membersTable.setModel(this.tableModel);
        this.membersScrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PushDownPanel.class, (String)"ACSD_MembersToPushDown"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PushDownPanel.class, (String)"ACSD_MembersToPushDownDescription"));
        this.add((Component)this.membersScrollPane, "Center");
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage((Class)PushDownPanel.class, (String)"LBL_PushDownLabel"));
        this.add((Component)this.chooseLabel, "North");
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$PushDownPanel == null ? (class$org$netbeans$modules$refactoring$ui$PushDownPanel = PushDownPanel.class$("org.netbeans.modules.refactoring.ui.PushDownPanel")) : class$org$netbeans$modules$refactoring$ui$PushDownPanel), (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getRowCount() {
            return PushDownPanel.this.members.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return PushDownPanel.this.members[rowIndex][columnIndex];
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((PushDownPanel)PushDownPanel.this).members[rowIndex][columnIndex] = value;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (PushDownPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = PushDownPanel.this.members[rowIndex][1];
                return !PushDownPanel.this.refactoring.getSourceType().isInterface() && !Modifier.isStatic(((Method)element).getModifiers());
            }
            return columnIndex == 0;
        }
    }
}

