/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.InitialServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.TargetModuleIDResolver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TargetServer {
    private static final long DISTRIBUTE_TIMEOUT = 120000L;
    private static final long INCREMENTAL_TIMEOUT = 60000L;
    private static final long TIMEOUT = 60000L;
    private Target[] targets;
    private final ServerInstance instance;
    private final DeploymentTarget dtarget;
    private IncrementalDeployment incremental;
    private boolean debugMode = false;
    private Map availablesMap = null;
    private Set deployedRootTMIDs = new HashSet();
    private Set undeployTMIDs = new HashSet();
    private Set distributeTargets = new HashSet();
    private TargetModule[] redeployTargetModules = null;
    private File application = null;
    private File currentContentDir = null;
    private String contextRoot = null;

    public TargetServer(DeploymentTarget target) {
        this.dtarget = target;
        this.instance = this.dtarget.getServer().getServerInstance();
    }

    private void init(ProgressUI ui) throws ServerException {
        if (this.targets == null) {
            this.instance.start(ui);
            this.targets = this.dtarget.getServer().toTargets();
        }
        this.incremental = this.instance.getIncrementalDeployment();
        if (this.incremental != null && !this.checkServiceImplementations()) {
            this.incremental = null;
        }
        try {
            FileObject contentFO = this.dtarget.getModule().getContentDirectory();
            if (contentFO != null) {
                this.currentContentDir = FileUtil.toFile((FileObject)contentFO);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        J2eeModuleProvider.ConfigSupport configSupport = this.dtarget.getConfigSupport();
        if (J2eeModule.WAR.equals(this.dtarget.getModule().getModuleType())) {
            this.contextRoot = configSupport.getWebContextRoot();
        }
        this.processLastTargetModules();
    }

    private boolean canFileDeploy(Target[] targetz, DeployableObject deployable) {
        if (targetz == null || targetz.length != 1) {
            ErrorManager.getDefault().log(1, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            return false;
        }
        return deployable != null && this.instance.getIncrementalDeployment().canFileDeploy(targetz[0], deployable);
    }

    private boolean canFileDeploy(TargetModule[] targetModules, DeployableObject deployable) {
        if (targetModules == null || targetModules.length != 1) {
            ErrorManager.getDefault().log(1, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            return false;
        }
        return deployable != null && this.instance.getIncrementalDeployment().canFileDeploy(targetModules[0].getTarget(), deployable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppChangeDescriptor distributeChanges(TargetModule targetModule, ProgressUI ui) throws IOException {
        ServerFileDistributor sfd = new ServerFileDistributor(this.instance, this.dtarget);
        try {
            AppChangeDescriptor acd;
            ui.setProgressObject(sfd);
            ModuleChangeReporter mcr = this.dtarget.getModuleChangeReporter();
            AppChangeDescriptor appChangeDescriptor = acd = sfd.distribute(targetModule, mcr);
            return appChangeDescriptor;
        }
        finally {
            ui.setProgressObject(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File initialDistribute(Target target, ProgressUI ui) {
        InitialServerFileDistributor sfd = new InitialServerFileDistributor(this.dtarget, target);
        try {
            ui.setProgressObject(sfd);
            File file = sfd.distribute();
            return file;
        }
        finally {
            ui.setProgressObject(null);
        }
    }

    private boolean checkServiceImplementations() {
        String missing = null;
        if (this.instance.getServer().getConfigurationSupport() == null) {
            missing = ConfigurationSupport.class.getName();
        }
        if (missing != null) {
            String msg = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_MissingServiceImplementations", (Object)missing);
            ErrorManager.getDefault().log(1, msg);
            return false;
        }
        return true;
    }

    private TargetModule[] checkUndeployForChangedReferences(Set toRedeploy) {
        if (this.dtarget.getModule().getModuleType() == J2eeModule.WAR) {
            Iterator j = toRedeploy.iterator();
            while (j.hasNext()) {
                File lastContentDir;
                TargetModule deployed = (TargetModule)j.next();
                File file = lastContentDir = deployed.getContentDirectory() == null ? null : new File(deployed.getContentDirectory());
                if ((this.currentContentDir == null || this.currentContentDir.equals(lastContentDir)) && (this.contextRoot == null || this.contextRoot.equals(deployed.getContextRoot()))) continue;
                this.distributeTargets.add(deployed.findTarget());
                this.undeployTMIDs.add(deployed.delegate());
                deployed.remove();
                j.remove();
            }
        }
        return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
    }

    private TargetModule[] checkUndeployForSharedReferences(Target[] toDistribute) {
        HashSet<Target> distSet = new HashSet<Target>(Arrays.asList(toDistribute));
        return this.checkUndeployForSharedReferences(Collections.EMPTY_SET, distSet);
    }

    private TargetModule[] checkUndeployForSharedReferences(Set toRedeploy, Set toDistribute) {
        return this.checkUndeployForSharedReferences(toRedeploy, toDistribute, null);
    }

    /*
     * WARNING - void declaration
     */
    private TargetModule[] checkUndeployForSharedReferences(Set toRedeploy, Set toDistribute, Map queryInfo) {
        List<TargetModuleID> sharerTMIDs;
        if (this.contextRoot == null || toRedeploy.isEmpty() && toDistribute.isEmpty()) {
            return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
        }
        HashSet<Target> allTargets = new HashSet<Target>(Arrays.asList(TargetModule.toTarget(toRedeploy.toArray(new TargetModule[toRedeploy.size()]))));
        allTargets.addAll(toDistribute);
        Target[] targs = allTargets.toArray(new Target[allTargets.size()]);
        boolean shared = false;
        ArrayList<Target> addToDistributeWhenSharedDetected = new ArrayList<Target>();
        ArrayList<TargetModule> removeFromRedeployWhenSharedDetected = new ArrayList<TargetModule>();
        ArrayList<TargetModuleID> addToUndeployWhenSharedDetected = new ArrayList<TargetModuleID>();
        TargetModuleIDResolver tmidResolver = this.instance.getTargetModuleIDResolver();
        if (tmidResolver != null) {
            void var13_13;
            if (queryInfo == null) {
                queryInfo = new HashMap();
                queryInfo.put("contextRoot", this.contextRoot);
            }
            TargetModuleID[] haveSameReferences = TargetModule.EMPTY_TMID_ARRAY;
            if (targs.length > 0) {
                haveSameReferences = tmidResolver.lookupTargetModuleID(queryInfo, targs);
            }
            boolean bl = false;
            while (var13_13 < haveSameReferences.length) {
                haveSameReferences[var13_13] = new TargetModule(TargetServer.keyOf(haveSameReferences[var13_13]), haveSameReferences[var13_13]);
                ++var13_13;
            }
            sharerTMIDs = Arrays.asList(haveSameReferences);
            for (TargetModule targetModule : sharerTMIDs) {
                if (toRedeploy.size() > 0 && !toRedeploy.contains(targetModule) || toDistribute.contains(targetModule.getTarget())) {
                    shared = true;
                    addToUndeployWhenSharedDetected.add(targetModule.delegate());
                    continue;
                }
                removeFromRedeployWhenSharedDetected.add(targetModule);
                addToDistributeWhenSharedDetected.add(targetModule.getTarget());
            }
        }
        if (!shared) {
            sharerTMIDs = TargetModule.findByContextRoot(this.dtarget.getServer(), this.contextRoot);
            sharerTMIDs = TargetModule.initDelegate(sharerTMIDs, this.getAvailableTMIDsMap());
            for (TargetModule targetModule : sharerTMIDs) {
                boolean bl = false;
                for (TargetModule redeploying : toRedeploy) {
                    if (!redeploying.equals(targetModule) || !redeploying.getContentDirectory().equals(targetModule.getContentDirectory())) continue;
                    bl = true;
                    break;
                }
                if (!bl || toDistribute.contains(targetModule.getTarget())) {
                    shared = true;
                    addToUndeployWhenSharedDetected.add(targetModule.delegate());
                    continue;
                }
                removeFromRedeployWhenSharedDetected.add(targetModule);
                addToDistributeWhenSharedDetected.add(targetModule.getTarget());
            }
        }
        if (shared) {
            this.undeployTMIDs.addAll(addToUndeployWhenSharedDetected);
            TargetModule.removeByContextRoot(this.dtarget.getServer(), this.contextRoot);
            toRedeploy.removeAll(removeFromRedeployWhenSharedDetected);
            this.distributeTargets.addAll(addToDistributeWhenSharedDetected);
        }
        return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
    }

    private Map getAvailableTMIDsMap() {
        if (this.availablesMap != null) {
            return this.availablesMap;
        }
        DeploymentManager dm = this.instance.getDeploymentManager();
        this.availablesMap = new HashMap();
        try {
            ModuleType type = (ModuleType)this.dtarget.getModule().getModuleType();
            TargetModuleID[] ids = dm.getAvailableModules(type, this.targets);
            if (ids == null) {
                return this.availablesMap;
            }
            for (int i = 0; i < ids.length; ++i) {
                this.availablesMap.put(TargetServer.keyOf(ids[i]), ids[i]);
            }
        }
        catch (TargetException te) {
            throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException(), (Throwable)te);
        }
        return this.availablesMap;
    }

    private void processLastTargetModules() {
        TargetModule[] targetModules = this.dtarget.getTargetModules();
        if (targetModules == null || targetModules.length == 0) {
            this.distributeTargets.addAll(Arrays.asList(this.targets));
            this.checkUndeployForSharedReferences(this.targets);
            return;
        }
        HashSet<String> targetNames = new HashSet<String>();
        for (int i = 0; i < this.targets.length; ++i) {
            targetNames.add(this.targets[i].getName());
        }
        Set<TargetModule> toRedeploy = new HashSet();
        for (int i = 0; i < targetModules.length; ++i) {
            if (!targetModules[i].getInstanceUrl().equals(this.instance.getUrl()) || !targetNames.contains(targetModules[i].getTargetName())) continue;
            TargetModuleID tmID = (TargetModuleID)this.getAvailableTMIDsMap().get(targetModules[i].getId());
            if (tmID == null) {
                Target target = targetModules[i].findTarget();
                if (target == null) continue;
                this.distributeTargets.add(target);
                continue;
            }
            targetModules[i].initDelegate(tmID);
            toRedeploy.add(targetModules[i]);
        }
        DeploymentManager dm = this.instance.getDeploymentManager();
        if (this.incremental == null && this.getApplication() == null) {
            toRedeploy = Collections.EMPTY_SET;
        } else if (this.incremental == null) {
            long lastModified = this.getApplication().lastModified();
            Iterator j = toRedeploy.iterator();
            while (j.hasNext()) {
                TargetModule deployed = (TargetModule)j.next();
                if (lastModified >= deployed.getTimestamp()) {
                    if (dm.isRedeploySupported()) continue;
                    this.distributeTargets.add(deployed.findTarget());
                    this.undeployTMIDs.add(deployed.delegate());
                    j.remove();
                    continue;
                }
                j.remove();
            }
        }
        this.redeployTargetModules = this.checkUndeployForChangedReferences(toRedeploy);
        HashSet targetSet = new HashSet(this.distributeTargets);
        this.redeployTargetModules = this.checkUndeployForSharedReferences(toRedeploy, targetSet);
    }

    private File getApplication() {
        if (this.application != null) {
            return this.application;
        }
        try {
            FileObject archiveFO = this.dtarget.getModule().getArchive();
            if (archiveFO == null) {
                return null;
            }
            this.application = FileUtil.toFile((FileObject)archiveFO);
            return this.application;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(4096, ioe.getMessage());
            return null;
        }
    }

    public void startTargets(boolean debugMode, ProgressUI ui) throws ServerException {
        this.debugMode = debugMode;
        if (this.instance.getStartServer().isAlsoTargetServer(null)) {
            if (debugMode) {
                this.instance.startDebug(ui);
            } else {
                this.instance.start(ui);
            }
            this.targets = this.dtarget.getServer().toTargets();
            return;
        }
        this.instance.start(ui);
        this.targets = this.dtarget.getServer().toTargets();
        if (debugMode) {
            for (int i = 0; i < this.targets.length; ++i) {
                this.instance.startDebugTarget(this.targets[i], ui);
            }
        } else {
            for (int i = 0; i < this.targets.length; ++i) {
                this.instance.startTarget(this.targets[i], ui);
            }
        }
    }

    private static String keyOf(TargetModuleID tmid) {
        return tmid.toString();
    }

    private TargetModuleID[] saveRootTargetModules(TargetModuleID[] modules) {
        long timestamp = System.currentTimeMillis();
        HashSet<TargetModuleID> originals = new HashSet<TargetModuleID>();
        for (int i = 0; i < modules.length; ++i) {
            if (modules[i].getParentTargetModuleID() != null) continue;
            String id = TargetServer.keyOf(modules[i]);
            String targetName = modules[i].getTarget().getName();
            String fromDir = "";
            if (null != this.currentContentDir) {
                fromDir = this.currentContentDir.getAbsolutePath();
            }
            TargetModule tm = new TargetModule(id, this.instance.getUrl(), timestamp, fromDir, this.contextRoot, modules[i]);
            this.deployedRootTMIDs.add(tm);
            originals.add(modules[i]);
        }
        return originals.toArray(new TargetModuleID[originals.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TargetModule[] deploy(ProgressUI ui, boolean forceRedeploy) throws IOException, ServerException {
        boolean hasDirectory;
        ProgressObject po = null;
        boolean hasActivities = false;
        this.init(ui);
        if (forceRedeploy && this.redeployTargetModules != null) {
            for (int i = 0; i < this.redeployTargetModules.length; ++i) {
                this.distributeTargets.add(this.redeployTargetModules[i].findTarget());
                this.undeployTMIDs.add(this.redeployTargetModules[i].delegate());
                this.redeployTargetModules[i].remove();
            }
            this.redeployTargetModules = null;
        }
        File plan = null;
        DeployableObject deployable = null;
        DeploymentConfigurationProvider dcp = this.dtarget.getDeploymentConfigurationProvider();
        if (dcp != null) {
            deployable = dcp.getDeployableObject(null);
        }
        boolean bl = hasDirectory = this.dtarget.getModule().getContentDirectory() != null;
        if (this.undeployTMIDs.size() > 0) {
            TargetModuleID[] tmIDs = this.undeployTMIDs.toArray(new TargetModuleID[this.undeployTMIDs.size()]);
            ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Undeploying"));
            ProgressObject undeployPO = this.instance.getDeploymentManager().undeploy(tmIDs);
            this.trackProgressObject(ui, undeployPO, 60000L);
        }
        if (this.distributeTargets.size() > 0) {
            hasActivities = true;
            Target[] targetz = this.distributeTargets.toArray(new Target[this.distributeTargets.size()]);
            if (this.incremental != null && hasDirectory && this.canFileDeploy(targetz, deployable)) {
                DeploymentConfiguration cfg = this.dtarget.getDeploymentConfigurationProvider().getDeploymentConfiguration();
                File dir = this.initialDistribute(targetz[0], ui);
                po = this.incremental.initialDeploy(targetz[0], deployable, cfg, dir);
                this.trackDeployProgressObject(ui, po, false);
            } else {
                if (this.getApplication() == null) {
                    throw new RuntimeException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Distributing", (Object)this.application, Arrays.asList(targetz)));
                plan = this.dtarget.getConfigurationFile();
                po = this.instance.getDeploymentManager().distribute(targetz, this.getApplication(), plan);
                this.trackDeployProgressObject(ui, po, false);
            }
        }
        if (this.redeployTargetModules != null && this.redeployTargetModules.length > 0) {
            hasActivities = true;
            if (this.incremental != null && hasDirectory && this.canFileDeploy(this.redeployTargetModules, deployable)) {
                AppChangeDescriptor acd = this.distributeChanges(this.redeployTargetModules[0], ui);
                if (!TargetServer.anyChanged(acd)) return this.dtarget.getTargetModules();
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_IncrementalDeploying", (Object)this.redeployTargetModules[0]));
                po = this.incremental.incrementalDeploy(this.redeployTargetModules[0].delegate(), acd);
                this.trackDeployProgressObject(ui, po, true);
            } else {
                if (this.getApplication() == null) {
                    throw new IllegalArgumentException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Redeploying", (Object)this.application));
                TargetModuleID[] tmids = TargetModule.toTargetModuleID(this.redeployTargetModules);
                if (plan == null) {
                    plan = this.dtarget.getConfigurationFile();
                }
                po = this.instance.getDeploymentManager().redeploy(tmids, this.getApplication(), plan);
                this.trackDeployProgressObject(ui, po, false);
            }
        }
        if (!hasActivities) return this.dtarget.getTargetModules();
        return this.deployedRootTMIDs.toArray(new TargetModule[this.deployedRootTMIDs.size()]);
    }

    public void notifyIncrementalDeployment(TargetModuleID[] modules) {
        if (modules != null && this.incremental != null) {
            for (int i = 0; i < modules.length; ++i) {
                this.incremental.notifyDeployment(modules[i]);
            }
        }
    }

    public static boolean anyChanged(AppChangeDescriptor acd) {
        return acd.manifestChanged() || acd.descriptorChanged() || acd.classesChanged() || acd.ejbsChanged() || acd.serverDescriptorChanged();
    }

    private void trackDeployProgressObject(ProgressUI ui, ProgressObject po, boolean incremental) {
        boolean completed = this.trackProgressObject(ui, po, incremental ? 60000L : 120000L);
        if (completed) {
            TargetModuleID[] modules = po.getResultTargetModuleIDs();
            modules = this.saveRootTargetModules(modules);
            if (!incremental) {
                ProgressObject startPO = this.instance.getDeploymentManager().start(modules);
                this.trackProgressObject(ui, startPO, 60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trackProgressObject(ProgressUI ui, ProgressObject po, long timeout) {
        final AtomicBoolean completed = new AtomicBoolean();
        ui.setProgressObject(po);
        try {
            final CountDownLatch progressFinished = new CountDownLatch(1);
            ProgressListener listener = new ProgressListener(){

                public void handleProgressEvent(ProgressEvent progressEvent) {
                    DeploymentStatus status = progressEvent.getDeploymentStatus();
                    if (status.isCompleted()) {
                        completed.set(true);
                    }
                    if (status.isCompleted() || status.isFailed()) {
                        progressFinished.countDown();
                    }
                }
            };
            po.addProgressListener(listener);
            try {
                DeploymentStatus status = po.getDeploymentStatus();
                if (!status.isCompleted() && !status.isFailed()) {
                    try {
                        progressFinished.await(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                } else if (status.isCompleted()) {
                    completed.set(true);
                }
            }
            finally {
                po.removeProgressListener(listener);
            }
        }
        finally {
            ui.setProgressObject(null);
        }
        return completed.get();
    }
}

