/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.awt.Image;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.ServerRegistryNode;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RefreshAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RestartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StopAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class UISupport {
    private static final WeakHashMap ioWeakMap = new WeakHashMap();

    private UISupport() {
    }

    public static Image getIcon(ServerIcon serverIcon) {
        switch (serverIcon) {
            case EJB_ARCHIVE: {
                return Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejb.png");
            }
            case WAR_ARCHIVE: {
                return Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/war.png");
            }
            case EAR_ARCHIVE: {
                return Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ear.png");
            }
        }
        return UISupport.computeIcon(serverIcon);
    }

    private static Image computeIcon(ServerIcon serverIcon) {
        Image badge;
        Node folderNode = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        Image folder = serverIcon == ServerIcon.EJB_OPENED_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER ? folderNode.getOpenedIcon(1) : folderNode.getIcon(1);
        if (serverIcon == ServerIcon.EJB_FOLDER || serverIcon == ServerIcon.EJB_OPENED_FOLDER) {
            badge = Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejbBadge.png");
        } else if (serverIcon == ServerIcon.WAR_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER) {
            badge = Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/warBadge.png");
        } else if (serverIcon == ServerIcon.EAR_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER) {
            badge = Utilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/earBadge.png");
        } else {
            return null;
        }
        return Utilities.mergeImages((Image)folder, (Image)badge, (int)7, (int)7);
    }

    public static InputOutput getServerIO(String url) {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(url);
        if (si == null) {
            return null;
        }
        InputOutput io = (InputOutput)ioWeakMap.get(si);
        if (io != null) {
            return io;
        }
        Node node = ServerRegistryNode.getServerRegistryNode().getChildren().findChild(si.getUrl());
        if (node == null) {
            return null;
        }
        Action[] actions = new Action[]{new StartAction.OutputAction(node), new DebugAction.OutputAction(node), new RestartAction.OutputAction(node), new StopAction.OutputAction(node), new RefreshAction.OutputAction(node)};
        InputOutput newIO = IOProvider.getDefault().getIO(si.getDisplayName(), actions);
        ioWeakMap.put(si, newIO);
        return newIO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerIcon {
        EJB_ARCHIVE,
        WAR_ARCHIVE,
        EAR_ARCHIVE,
        EJB_FOLDER,
        EAR_FOLDER,
        WAR_FOLDER,
        EJB_OPENED_FOLDER,
        EAR_OPENED_FOLDER,
        WAR_OPENED_FOLDER;

    }
}

