/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.text.MessageFormat;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddViewDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class CreateViewAction
extends DatabaseAction {
    static final long serialVersionUID = -1640355770860785644L;

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            if (!info.getDriverSpecification().areViewsSupported()) {
                String message = MessageFormat.format(CreateViewAction.bundle().getString("MSG_ViewsAreNotSupported"), info.getConnection().getMetaData().getDatabaseProductName().trim());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
                return;
            }
            ViewListNodeInfo nfo = (ViewListNodeInfo)info.getParent(this.nodename);
            Specification spec = (Specification)nfo.getSpecification();
            AddViewDialog dlg = new AddViewDialog(spec, info);
            if (dlg.run()) {
                nfo.addView(dlg.getViewName());
            }
        }
        catch (Exception exc) {
            String message = MessageFormat.format(CreateViewAction.bundle().getString("ERR_UnableToPerformOperation"), node.getName(), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }
}

