/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.earproject.ProjectPropertyProvider;
import org.netbeans.modules.j2ee.earproject.ui.RemoveAction;
import org.netbeans.modules.j2ee.earproject.ui.actions.OpenModuleProjectAction;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class ModuleNode
extends AbstractNode
implements Node.Cookie {
    static final String MODULE_NODE_NAME = "module.node";
    private static Action[] actions;
    private final FileObject projectDirectory;
    private final VisualClassPathItem key;

    public ModuleNode(VisualClassPathItem key, FileObject projectDirectory) {
        super(Children.LEAF);
        this.key = key;
        this.projectDirectory = projectDirectory;
        this.setName(MODULE_NODE_NAME);
        this.setDisplayName(key.getCompletePathInArchive());
        this.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_ModuleNode"));
    }

    public Action[] getActions(boolean context) {
        if (null == actions) {
            actions = new Action[]{SystemAction.get(OpenModuleProjectAction.class), SystemAction.get(RemoveAction.class)};
            this.getCookieSet().add((Node.Cookie)this);
        }
        return actions;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenModuleProjectAction.class);
    }

    public Image getIcon(int type) {
        if (this.key.toString().endsWith("war")) {
            return Utilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/WebModuleNode.gif");
        }
        if (this.key.getRaw().indexOf("j2ee-module-car") > 0) {
            return Utilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/CarModuleNodeIcon.gif");
        }
        return Utilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/EjbModuleNodeIcon.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void removeFromJarContent() {
        ArrayList<VisualClassPathItem> newList = new ArrayList<VisualClassPathItem>();
        Project p = FileOwnerQuery.getOwner((FileObject)this.projectDirectory);
        ProjectPropertyProvider ppp = (ProjectPropertyProvider)p.getLookup().lookup(ProjectPropertyProvider.class);
        EarProjectProperties epp = ppp.getProjectProperties();
        newList.addAll(epp.getJarContentAdditional());
        newList.remove(this.key);
        epp.put("jar.content.additional", newList);
        epp.store();
    }

    public VisualClassPathItem getVCPI() {
        return this.key;
    }

    public boolean canCopy() {
        return false;
    }
}

