/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JCUtilities {
    private static final int javaTokenIDsLength = JavaTokenContext.context.getTokenIDs().length;
    private static final boolean[][] primitivesAssignable = new boolean[javaTokenIDsLength][];
    private static final JCClass[][] primitivesCommonClass = new JCClass[javaTokenIDsLength][];

    private static boolean stringEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static boolean classEqual(JCClass c1, JCClass c2) {
        return c1 == null ? c2 == null : c1.equals(c2);
    }

    private static boolean typeEqual(JCType t1, JCType t2) {
        return t1 == null ? t2 == null : JCUtilities.classEqual(t1.getClazz(), t2.getClazz()) && t1.getArrayDepth() == t2.getArrayDepth();
    }

    private static boolean parameterEqual(JCParameter p1, JCParameter p2) {
        return p1 == null ? p2 == null : JCUtilities.typeEqual(p1.getType(), p2.getType()) && JCUtilities.stringEqual(p1.getName(), p2.getName());
    }

    private static boolean constructorEqual(JCConstructor c1, JCConstructor c2) {
        return c1 == null ? c2 == null : c1.getClazz().equals(c2.getClazz()) && c1.getModifiers() == c2.getModifiers() && JCUtilities.parameterArrayEqual(c1.getParameters(), c2.getParameters()) && JCUtilities.classArrayEqual(c1.getExceptions(), c2.getExceptions());
    }

    private static boolean parameterArrayEqual(JCParameter[] pa1, JCParameter[] pa2) {
        if (pa1.length != pa2.length) {
            return false;
        }
        for (int i = pa1.length - 1; i >= 0; --i) {
            if (JCUtilities.parameterEqual(pa1[i], pa2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean classArrayEqual(JCClass[] ca1, JCClass[] ca2) {
        if (ca1.length != ca2.length) {
            return false;
        }
        for (int i = ca1.length - 1; i >= 0; --i) {
            if (JCUtilities.classEqual(ca1[i], ca2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean fieldArraysEqual(JCField[] fa1, JCField[] fa2) {
        if (fa1.length != fa2.length) {
            return false;
        }
        for (int i = fa1.length - 1; i >= 0; --i) {
            JCField f1 = fa1[i];
            JCField f2 = fa2[i];
            if (JCUtilities.parameterEqual(f1, f2) && f1.getClazz().equals(f2.getClazz()) && f1.getModifiers() == f2.getModifiers()) continue;
            return false;
        }
        return true;
    }

    private static boolean constructorArrayEqual(JCConstructor[] ca1, JCConstructor[] ca2) {
        if (ca1.length != ca2.length) {
            return false;
        }
        for (int i = ca1.length - 1; i >= 0; --i) {
            if (JCUtilities.constructorEqual(ca1[i], ca2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean methodArraysEqual(JCMethod[] ma1, JCMethod[] ma2) {
        if (ma1.length != ma2.length) {
            return false;
        }
        for (int i = ma1.length - 1; i >= 0; --i) {
            JCMethod m1 = ma1[i];
            JCMethod m2 = ma2[i];
            if (JCUtilities.constructorEqual(m1, m2) && JCUtilities.stringEqual(m1.getName(), m2.getName()) && JCUtilities.typeEqual(m1.getReturnType(), m2.getReturnType())) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(JCClass c1, JCClass c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (!c1.equals(c2) || c1.isInterface() != c2.isInterface() || c1.getModifiers() != c2.getModifiers() || !JCUtilities.classEqual(c1.getSuperclass(), c2.getSuperclass())) {
            return false;
        }
        return JCUtilities.fieldArraysEqual(c1.getFields(), c2.getFields()) && JCUtilities.constructorArrayEqual(c1.getConstructors(), c2.getConstructors()) && JCUtilities.methodArraysEqual(c1.getMethods(), c2.getMethods()) && JCUtilities.classArrayEqual(c1.getInterfaces(), c2.getInterfaces());
    }

    private static boolean isDeprecated(int mods) {
        return (mods & 0x100000) != 0;
    }

    public static boolean isDeprecated(Object o) {
        if (o instanceof JCClass) {
            return JCUtilities.isDeprecated(((JCClass)o).getModifiers());
        }
        if (o instanceof JCConstructor) {
            return JCUtilities.isDeprecated(((JCConstructor)o).getModifiers());
        }
        if (o instanceof JCField) {
            return JCUtilities.isDeprecated(((JCField)o).getModifiers());
        }
        return false;
    }

    public static String dumpClass(JCClass c) {
        JCMethod[] mtds;
        JCConstructor[] cons;
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(c.getModifiers()));
        sb.append(c.isInterface() ? " interface " : " class ");
        sb.append(c);
        sb.append(" extends ");
        sb.append(c.getSuperclass());
        JCClass[] ifcs = c.getInterfaces();
        int cntM1 = ifcs.length - 1;
        if (cntM1 >= 0) {
            sb.append(" implements ");
            for (int i = 0; i <= cntM1; ++i) {
                sb.append(ifcs[i].toString());
                if (i >= cntM1) continue;
                sb.append(", ");
            }
        }
        sb.append('\n');
        String indentStr = "    ";
        JCField[] flds = c.getFields();
        if (flds.length > 0) {
            sb.append("FIELDS:\n");
            for (int i = 0; i < flds.length; ++i) {
                sb.append(indentStr);
                sb.append(flds[i]);
                sb.append('\n');
            }
        }
        if ((cons = c.getConstructors()).length > 0) {
            sb.append("CONSTRUCTORS:\n");
            for (int i = 0; i < cons.length; ++i) {
                sb.append(indentStr);
                sb.append(cons[i]);
                sb.append('\n');
            }
        }
        if ((mtds = c.getMethods()).length > 0) {
            sb.append("METHODS:\n");
            for (int i = 0; i < mtds.length; ++i) {
                sb.append(indentStr);
                sb.append(mtds[i]);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static JCClass getExactClass(JCFinder finder, String name, String pkgName) {
        return finder.getExactClass(pkgName.length() != 0 ? pkgName + "." + name : name);
    }

    public static List getConstructors(JCClass cls) {
        return JCUtilities.getConstructors(cls, true);
    }

    public static List getConstructors(JCClass cls, boolean offerDeprecated) {
        TreeSet<JCConstructor> ts = new TreeSet<JCConstructor>();
        JCConstructor[] constructors = cls.getConstructors();
        for (int i = constructors.length - 1; i >= 0; --i) {
            if (!offerDeprecated && JCUtilities.isDeprecated(constructors[i])) continue;
            ts.add(constructors[i]);
        }
        if (constructors.length == 0) {
            ts.add(new JavaCompletion.BaseConstructor(cls, 1, JavaCompletion.EMPTY_PARAMETERS, JavaCompletion.EMPTY_CLASSES));
        }
        return new ArrayList(ts);
    }

    public static List getAllInterfaces(JCFinder finder, JCClass cls) {
        return JCUtilities.getAllInterfaces(finder, cls, true);
    }

    public static List getAllInterfaces(JCFinder finder, JCClass cls, boolean offerDeprecated) {
        ArrayList ret = new ArrayList();
        JCUtilities.collectInterfaces(finder, cls, ret, offerDeprecated);
        return ret;
    }

    private static void collectInterfaces(JCFinder finder, JCClass cls, ArrayList clsList, boolean offerDeprecated) {
        JCClass[] ifcs = cls.getInterfaces();
        if (ifcs != null) {
            for (int i = 0; i < ifcs.length; ++i) {
                if (clsList.contains(ifcs[i])) continue;
                if (offerDeprecated || !JCUtilities.isDeprecated(ifcs[i])) {
                    clsList.add(ifcs[i]);
                }
                if ((cls = finder.getExactClass(ifcs[i].getFullName())) == null) continue;
                JCUtilities.collectInterfaces(finder, cls, clsList, offerDeprecated);
            }
        }
    }

    public static List getSuperclasses(JCFinder finder, JCClass cls) {
        ArrayList<JCClass> clsList = new ArrayList<JCClass>();
        if ((cls = finder.getExactClass(cls.getFullName())) != null) {
            cls = cls.getSuperclass();
        }
        while (cls != null && clsList.indexOf(cls) < 0) {
            clsList.add(cls);
            if ((cls = finder.getExactClass(cls.getFullName())) == null) continue;
            cls = cls.getSuperclass();
        }
        return clsList;
    }

    public static JCClass createSimpleClass(Class c) {
        if (c == null || c.getName() == null) {
            return JavaCompletion.INVALID_CLASS;
        }
        return JCUtilities.createSimpleClassImpl(c.getName());
    }

    private static JCClass createSimpleClassImpl(String className) {
        int dotInd = className.lastIndexOf(46);
        return JavaCompletion.getSimpleClass(className.replace('$', '.'), dotInd >= 0 ? dotInd : 0);
    }

    public static JavaCompletion.BaseType createType(Class c) {
        if (c == null) {
            return JavaCompletion.INVALID_TYPE;
        }
        String className = c.getName();
        int arrayDepth = 0;
        while (className.length() > 0 && className.charAt(0) == '[') {
            ++arrayDepth;
            className = className.substring(1);
        }
        if (arrayDepth > 0) {
            switch (className.charAt(0)) {
                case 'L': {
                    className = className.substring(1, className.length() - 1);
                    break;
                }
                case 'B': {
                    className = "byte";
                    break;
                }
                case 'C': {
                    className = "char";
                    break;
                }
                case 'D': {
                    className = "double";
                    break;
                }
                case 'F': {
                    className = "float";
                    break;
                }
                case 'I': {
                    className = "int";
                    break;
                }
                case 'J': {
                    className = "long";
                    break;
                }
                case 'S': {
                    className = "short";
                    break;
                }
                case 'Z': {
                    className = "boolean";
                }
            }
        }
        return new JavaCompletion.BaseType(JCUtilities.createSimpleClassImpl(className), arrayDepth);
    }

    public static List getClassList(List classNames, boolean storeDeclaredClasses, int classLevel, int fieldLevel, int methodLevel) {
        ArrayList l = new ArrayList();
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            Class<?> c;
            block5: {
                String name = (String)i.next();
                c = null;
                try {
                    c = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Class '" + name + "' not found.");
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    System.err.println("Exception thrown during class rebuild:");
                    t.printStackTrace();
                    if (!(t instanceof OutOfMemoryError)) break block5;
                    throw (OutOfMemoryError)t;
                }
            }
            if (c == null) continue;
            l.addAll(JCUtilities.createClassList(c, storeDeclaredClasses, classLevel, fieldLevel, methodLevel));
        }
        return l;
    }

    private static String strip(String name, String baseName, String suffix) {
        int startInd = 0;
        int endStrip = 0;
        if (name.startsWith(baseName)) {
            startInd = baseName.length();
        }
        if (name.endsWith(suffix)) {
            endStrip = suffix.length();
        }
        return name.substring(startInd, name.length() - endStrip);
    }

    private static String separatorToDot(String s) {
        return s.replace(File.separatorChar, '.');
    }

    private static List createClassList(Class c, boolean storeDeclaredClasses, int classLevel, int fieldLevel, int methodLevel) {
        ArrayList<BaseJCClass> cL = new ArrayList<BaseJCClass>();
        if (c == null) {
            return cL;
        }
        if (JavaCompletion.getLevel(c.getModifiers()) >= classLevel) {
            cL.add(new BaseJCClass(c, classLevel, fieldLevel, methodLevel));
        }
        if (storeDeclaredClasses) {
            try {
                Class<?>[] dC = c.getDeclaredClasses();
                for (int i = 0; i < dC.length; ++i) {
                    if (JavaCompletion.getLevel(dC[i].getModifiers()) < classLevel) continue;
                    cL.addAll(JCUtilities.createClassList(dC[i], storeDeclaredClasses, classLevel, fieldLevel, methodLevel));
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return cL;
    }

    public static List getClassNameList(String packageDirName) {
        File packageDir = new File(packageDirName);
        ArrayList classNames = new ArrayList();
        packageDirName = packageDirName + File.separator;
        if (packageDir.exists()) {
            JCUtilities.getClassListFromSourcesRec(classNames, packageDirName, packageDir);
        }
        return classNames;
    }

    private static void getClassListFromSourcesRec(final List l, final String packageDirName, File curDir) {
        curDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    JCUtilities.getClassListFromSourcesRec(l, packageDirName, f);
                }
                if (f.getName().endsWith(".java")) {
                    l.add(JCUtilities.separatorToDot(JCUtilities.strip(f.getAbsolutePath(), packageDirName, ".java")));
                }
                return false;
            }
        });
    }

    public static boolean getPrimitivesAssignable(int i, int j) {
        return primitivesAssignable[i][j];
    }

    public static boolean isPrimitiveClass(JCClass c) {
        return c.getPackageName().length() == 0 && JavaTokenContext.isTypeOrVoid(c.getName());
    }

    public static JCClass getPrimitivesCommonClass(int i, int j) {
        return primitivesCommonClass[i][j];
    }

    static {
        int[] typeIDs = new int[]{63, 64, 65, 66, 67, 68, 69, 70, 71};
        boolean[][] assignVals = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
        JCClass[][] classesVals = new JCClass[][]{{JavaCompletion.BOOLEAN_CLASS, null, null, null, null, null, null, null, null}, {null, JavaCompletion.BYTE_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.CHAR_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, null}, {null, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.SHORT_CLASS, null}, {null, null, null, null, null, null, null, null, JavaCompletion.VOID_CLASS}};
        for (int i = 0; i < typeIDs.length; ++i) {
            JCUtilities.primitivesAssignable[typeIDs[i]] = new boolean[javaTokenIDsLength];
            JCUtilities.primitivesCommonClass[typeIDs[i]] = new JCClass[javaTokenIDsLength];
            for (int j = 0; j < typeIDs.length; ++j) {
                JCUtilities.primitivesAssignable[typeIDs[i]][typeIDs[j]] = assignVals[i][j];
                JCUtilities.primitivesCommonClass[typeIDs[i]][typeIDs[j]] = classesVals[i][j];
            }
        }
    }

    public static class BaseJCClass
    extends JavaCompletion.AbstractClass {
        Class c;
        int classLevel;
        int fieldLevel;
        int methodLevel;

        public BaseJCClass(Class c, int classLevel, int fieldLevel, int methodLevel) {
            this.c = c;
            this.classLevel = classLevel;
            this.fieldLevel = fieldLevel;
            this.methodLevel = methodLevel;
            JCClass sc = JCUtilities.createSimpleClass(c);
            this.name = sc.getName();
            this.packageName = sc.getPackageName();
            this.modifiers = c.getModifiers();
            if (c.isInterface()) {
                this.modifiers |= 0x200;
            }
        }

        protected void init() {
            int j;
            Class<?>[] dE;
            JCClass[] exceptions;
            Class<?>[] dP;
            JCParameter[] parameters;
            int i;
            this.body = new JavaCompletion.AbstractClass.Body();
            ArrayList<Comparable> lst = new ArrayList<Comparable>();
            this.body.superClass = JCUtilities.createSimpleClass(this.c.getSuperclass());
            Class<?>[] dI = this.c.getInterfaces();
            for (int i2 = 0; i2 < dI.length; ++i2) {
                if (JavaCompletion.getLevel(dI[i2].getModifiers()) < this.classLevel) continue;
                lst.add(JCUtilities.createSimpleClass(dI[i2]));
            }
            this.body.interfaces = new JCClass[lst.size()];
            lst.toArray(this.body.interfaces);
            lst.clear();
            try {
                Field[] dF = this.c.getDeclaredFields();
                for (i = 0; i < dF.length; ++i) {
                    if (JavaCompletion.getLevel(dF[i].getModifiers()) < this.fieldLevel) continue;
                    lst.add(new JavaCompletion.BaseField(this, dF[i].getName(), JCUtilities.createType(dF[i].getType()), dF[i].getModifiers()));
                }
                this.body.fields = new JCField[lst.size()];
                lst.toArray(this.body.fields);
                lst.clear();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            try {
                Constructor<?>[] dC = this.c.getDeclaredConstructors();
                for (i = 0; i < dC.length; ++i) {
                    if (JavaCompletion.getLevel(dC[i].getModifiers()) < this.methodLevel) continue;
                    parameters = JavaCompletion.EMPTY_PARAMETERS;
                    try {
                        dP = dC[i].getParameterTypes();
                        parameters = new JCParameter[dP.length];
                        for (int j2 = 0; j2 < dP.length; ++j2) {
                            parameters[j2] = new JavaCompletion.BaseParameter("", JCUtilities.createType(dP[j2]));
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    exceptions = JavaCompletion.EMPTY_CLASSES;
                    try {
                        dE = dC[i].getExceptionTypes();
                        exceptions = new JCClass[dE.length];
                        for (j = 0; j < dE.length; ++j) {
                            exceptions[j] = JCUtilities.createSimpleClass(dE[j]);
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    lst.add(new JavaCompletion.BaseConstructor(this, dC[i].getModifiers(), parameters, exceptions));
                }
                this.body.constructors = new JCConstructor[lst.size()];
                lst.toArray(this.body.constructors);
                lst.clear();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            try {
                Method[] dM = this.c.getDeclaredMethods();
                for (i = 0; i < dM.length; ++i) {
                    if (JavaCompletion.getLevel(dM[i].getModifiers()) < this.methodLevel) continue;
                    parameters = JavaCompletion.EMPTY_PARAMETERS;
                    try {
                        dP = dM[i].getParameterTypes();
                        parameters = new JCParameter[dP.length];
                        for (int j3 = 0; j3 < dP.length; ++j3) {
                            parameters[j3] = new JavaCompletion.BaseParameter("", JCUtilities.createType(dP[j3]));
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    exceptions = JavaCompletion.EMPTY_CLASSES;
                    try {
                        dE = dM[i].getExceptionTypes();
                        exceptions = new JCClass[dE.length];
                        for (j = 0; j < dE.length; ++j) {
                            exceptions[j] = JCUtilities.createSimpleClass(dE[j]);
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    lst.add(new JavaCompletion.BaseMethod(this, dM[i].getName(), dM[i].getModifiers(), JCUtilities.createType(dM[i].getReturnType()), parameters, exceptions));
                }
                this.body.methods = new JCMethod[lst.size()];
                lst.toArray(this.body.methods);
                lst.clear();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            this.c = null;
        }
    }
}

