/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ModuleUpdate {
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private String codenamebase = null;
    private String specification_version = null;
    private boolean pError = false;
    private boolean l10n = false;
    private boolean fromInstall = false;

    ModuleUpdate(File nbmFile, boolean fromInstall) {
        this.fromInstall = fromInstall;
        this.createFromDistribution(nbmFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromDistribution(File nbmFile) {
        Document document = null;
        Element node = null;
        Element documentElement = null;
        JarFile jf = null;
        InputStream is = null;
        boolean exit = false;
        String errorMessage = null;
        try {
            jf = new JarFile(nbmFile);
            is = jf.getInputStream(jf.getEntry("Info/info.xml"));
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            node = documentElement = document.getDocumentElement();
            if (is != null) {
                is.close();
            }
        }
        catch (SAXException e) {
            errorMessage = "Bad info : " + nbmFile.getAbsolutePath();
            System.out.println(errorMessage);
            e.printStackTrace();
            exit = true;
        }
        catch (IOException e) {
            errorMessage = "Missing info : " + nbmFile.getAbsolutePath();
            System.out.println(errorMessage);
            e.printStackTrace();
            exit = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (jf != null) {
                    jf.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                exit = true;
            }
        }
        if (exit) {
            throw new RuntimeException(errorMessage);
        }
        this.setCodenamebase(this.getAttribute(node, ATTR_CODENAMEBASE));
        NodeList nodeList = node.getElementsByTagName("l10n");
        if (nodeList.getLength() > 0) {
            this.l10n = true;
            Node n = nodeList.item(0);
            this.setSpecification_version(this.getAttribute(n, "module_spec_version"));
        } else {
            nodeList = node.getElementsByTagName("manifest");
            for (int i = 0; i < nodeList.getLength() && nodeList.item(i).getNodeType() == 1 && nodeList.item(i) instanceof Element; ++i) {
                NamedNodeMap attrList = nodeList.item(i).getAttributes();
                for (int j = 0; j < attrList.getLength(); ++j) {
                    Attr attr = (Attr)attrList.item(j);
                    if (attr.getName().equals("OpenIDE-Module")) {
                        this.setCodenamebase(attr.getValue());
                        continue;
                    }
                    if (!attr.getName().equals("OpenIDE-Module-Specification-Version")) continue;
                    this.setSpecification_version(attr.getValue());
                }
            }
        }
    }

    private String getAttribute(Node n, String attribute) {
        Node attr = n.getAttributes().getNamedItem(attribute);
        return attr == null ? null : attr.getNodeValue();
    }

    String getCodenamebase() {
        return this.codenamebase;
    }

    void setCodenamebase(String codenamebase) {
        this.codenamebase = codenamebase;
    }

    String getSpecification_version() {
        return this.specification_version;
    }

    void setSpecification_version(String specification_version) {
        this.specification_version = specification_version;
    }

    public boolean isL10n() {
        return this.l10n;
    }

    public boolean isFromInstall() {
        return this.fromInstall;
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            ModuleUpdate.this.pError = true;
        }

        public void error(SAXParseException e) {
            ModuleUpdate.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            ModuleUpdate.this.pError = true;
        }
    }
}

