/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.customization.multiview.JavaUtilities;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class DefinitionsPanel
extends SaveableSectionInnerPanel {
    private Definitions definitions;
    private WSDLModel model;
    private Node node;
    private boolean wsdlDirty;
    private boolean packageNameDirty;
    private DefinitionsActionListener listener;
    private DefaultItemListener defaultListener;
    private JCheckBox defaultPackageCB;
    private ButtonGroup eamButtonGroup;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableMIMEContentCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel packageLabel;
    private JTextField packageNameText;

    public DefinitionsPanel(SectionView view, Definitions definitions, Node node) {
        super(view);
        this.definitions = definitions;
        this.model = this.definitions.getModel();
        this.node = node;
        this.initComponents();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.enableMIMEContentCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.enableWrapperStyleCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.packageLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.packageNameText.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.defaultPackageCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.enableMIMEContentCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_MIME"));
        this.packageNameText.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_PACKAGE"));
        this.wsdlDirty = false;
        this.packageNameDirty = false;
        this.setInitialPackage();
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultPackageCB);
        this.defaultPackageCB.addItemListener(itemListener);
        this.addValidatee(this.packageNameText);
        this.listener = new DefinitionsActionListener();
        this.addModifier(this.packageNameText);
        this.addModifier(this.defaultPackageCB);
        ActionListener eamListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableAsyncMappingCB);
        this.enableAsyncMappingCB.addActionListener(eamListener);
        ActionListener emcListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(emcListener);
        ActionListener ewsListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableWrapperStyleCB);
        this.enableWrapperStyleCB.addActionListener(ewsListener);
    }

    private void sync() {
        List ee = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (ee.size() == 1) {
            DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
            EnableAsyncMapping eam = dc.getEnableAsyncMapping();
            if (eam != null) {
                this.setEnableAsyncMapping(eam.isEnabled());
            } else {
                this.setEnableAsyncMapping(false);
            }
            EnableWrapperStyle ews = dc.getEnableWrapperStyle();
            if (ews != null) {
                this.setEnableWrapperStyle(ews.isEnabled());
            } else {
                this.setEnableWrapperStyle(true);
            }
            EnableMIMEContent emc = dc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(false);
            }
        } else {
            this.setEnableAsyncMapping(false);
            this.setEnableWrapperStyle(true);
            this.setEnableMIMEContent(false);
        }
    }

    private boolean useDefaultPackage() {
        return this.defaultPackageCB.isSelected();
    }

    public void setEnableAsyncMapping(boolean enable) {
        this.enableAsyncMappingCB.setSelected(enable);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean enable) {
        this.enableWrapperStyleCB.setSelected(enable);
    }

    public boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public void setPackageName(String name) {
        this.packageNameText.setText(name);
    }

    public String getPackageName() {
        return this.packageNameText.getText();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.packageNameText || jComponent == this.defaultPackageCB) {
            this.packageNameDirty = true;
        } else if (jComponent == this.enableWrapperStyleCB) {
            if (ee.size() == 1) {
                DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                EnableWrapperStyle ews = dc.getEnableWrapperStyle();
                if (ews == null) {
                    try {
                        this.model.startTransaction();
                        ews = factory.createEnableWrapperStyle(this.model);
                        ews.setEnabled(this.getEnableWrapperStyle());
                        dc.setEnableWrapperStyle(ews);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        ews.setEnabled(this.getEnableWrapperStyle());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                EnableWrapperStyle ews = factory.createEnableWrapperStyle(this.model);
                try {
                    this.model.startTransaction();
                    ews.setEnabled(this.getEnableWrapperStyle());
                    dc.setEnableWrapperStyle(ews);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.enableAsyncMappingCB) {
            if (ee.size() == 1) {
                DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                EnableAsyncMapping eam = dc.getEnableAsyncMapping();
                if (eam == null) {
                    try {
                        this.model.startTransaction();
                        eam = factory.createEnableAsyncMapping(this.model);
                        eam.setEnabled(this.getEnableAsyncMapping());
                        dc.setEnableAsyncMapping(eam);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        eam.setEnabled(this.getEnableAsyncMapping());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                EnableAsyncMapping eam = factory.createEnableAsyncMapping(this.model);
                try {
                    this.model.startTransaction();
                    eam.setEnabled(this.getEnableAsyncMapping());
                    dc.setEnableAsyncMapping(eam);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.enableMIMEContentCB) {
            if (ee.size() == 1) {
                DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                EnableMIMEContent emc = dc.getEnableMIMEContent();
                if (emc == null) {
                    try {
                        this.model.startTransaction();
                        emc = factory.createEnableMIMEContent(this.model);
                        emc.setEnabled(this.getEnableMIMEContent());
                        dc.setEnableMIMEContent(emc);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent());
                    dc.setEnableMIMEContent(emc);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.packageNameText && !JavaUtilities.isValidPackageName(val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.packageNameText) {
            String pkg = "";
            Client c = (Client)this.node.getLookup().lookup(Client.class);
            if (c != null) {
                pkg = c.getPackageName();
            } else {
                Service s = (Service)this.node.getLookup().lookup(Service.class);
                if (s != null) {
                    pkg = s.getPackageName();
                }
            }
            this.packageNameText.setText(pkg);
        }
    }

    private void setInitialPackage() {
        Client c = (Client)this.node.getLookup().lookup(Client.class);
        if (c != null) {
            if (c.isPackageNameForceReplace()) {
                this.packageNameText.setText(c.getPackageName());
                this.defaultPackageCB.setSelected(false);
            } else {
                this.packageNameText.setEnabled(false);
                this.packageNameText.setBackground(Color.LIGHT_GRAY);
                this.defaultPackageCB.setSelected(true);
            }
        } else {
            Service s = (Service)this.node.getLookup().lookup(Service.class);
            if (s != null) {
                if (s.isPackageNameForceReplace()) {
                    this.packageNameText.setText(s.getPackageName());
                    this.defaultPackageCB.setSelected(false);
                } else {
                    this.packageNameText.setEnabled(false);
                    this.packageNameText.setBackground(Color.LIGHT_GRAY);
                    this.defaultPackageCB.setSelected(true);
                }
            }
        }
    }

    public boolean jaxwsIsDirty() {
        return this.packageNameDirty;
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
        if (this.packageNameDirty) {
            Client client = (Client)this.node.getLookup().lookup(Client.class);
            Service service = (Service)this.node.getLookup().lookup(Service.class);
            String packageName = this.getPackageName();
            if (this.useDefaultPackage() || packageName == null || packageName.trim().equals("")) {
                if (client != null) {
                    client.setPackageNameForceReplace(false);
                } else {
                    service.setPackageNameForceReplace(false);
                }
            } else if (client != null) {
                client.setPackageName(packageName);
                client.setPackageNameForceReplace(true);
            } else {
                service.setPackageName(packageName);
                service.setPackageNameForceReplace(true);
            }
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.emcButtonGroup = new ButtonGroup();
        this.packageLabel = new JLabel();
        this.packageNameText = new JTextField();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        this.enableMIMEContentCB = new JCheckBox();
        this.defaultPackageCB = new JCheckBox();
        this.packageLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PACKAGE_NAME"));
        this.packageLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PACKAGE_NAME"));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setActionCommand(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setActionCommand(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.defaultPackageCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultPackageCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultPackageCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultPackageCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.packageLabel).addPreferredGap(0).add((Component)this.packageNameText, -2, 173, -2).add(26, 26, 26).add((Component)this.defaultPackageCB)).add((Component)this.enableWrapperStyleCB).add((Component)this.enableMIMEContentCB).add((Component)this.enableAsyncMappingCB)).addContainerGap(80, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageNameText, -2, 15, -2).add((Component)this.defaultPackageCB)).add(20, 20, 20).add((Component)this.enableWrapperStyleCB).add(19, 19, 19).add((Component)this.enableMIMEContentCB).add(19, 19, 19).add((Component)this.enableAsyncMappingCB).addContainerGap(23, Short.MAX_VALUE)));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (DefinitionsPanel.this.defaultPackageCB.isSelected()) {
                DefinitionsPanel.this.packageNameText.setEnabled(false);
                DefinitionsPanel.this.packageNameText.setBackground(Color.LIGHT_GRAY);
            } else {
                DefinitionsPanel.this.packageNameText.setEnabled(true);
                DefinitionsPanel.this.packageNameText.setBackground(Color.WHITE);
                DefinitionsPanel.this.packageNameText.requestFocus();
            }
        }
    }

    class DefinitionsActionListener
    implements ActionListener {
        DefinitionsActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DefinitionsPanel.this.setValue((JComponent)e.getSource(), null);
        }
    }
}

