/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

final class SpecialDelegates {
    private static boolean isUnixRootResolved = false;
    private static FileSystem fs = new WinSpecialFs();
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;

    private SpecialDelegates() {
    }

    static FileObject get(ResourcePath resPath) {
        FileObject retVal = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? SpecialDelegates.getForWindows(resPath) : (Utilities.getOperatingSystem() == 16384 ? SpecialDelegates.getForVMS(resPath) : SpecialDelegates.getForUnix(resPath));
        return retVal;
    }

    private static FileObject getForUnix(ResourcePath resPath) {
        FileObject retVal = null;
        if (!isUnixRootResolved) {
            SpecialDelegates.mountUnixRoot();
            retVal = MountTable.getDefault().resolveBestDelegate(resPath.getNormalizedPath());
            isUnixRootResolved = true;
        }
        return retVal;
    }

    private static FileObject getForVMS(ResourcePath resPath) {
        FileObject retVal = null;
        SpecialDelegates.mountVMSRoot(resPath);
        retVal = MountTable.getDefault().resolveBestDelegate(resPath.getNormalizedPath());
        return retVal;
    }

    private static FileObject getForWindows(ResourcePath resPath) {
        WinRootVirtual retVal = null;
        if (resPath.isRoot()) {
            retVal = WinRootVirtual.getDefault();
        } else if (SpecialDelegates.isWinDrive(resPath)) {
            retVal = WindowsDriveProxy.getDefault(resPath);
        } else {
            WindowsDriveProxy winDrive = WindowsDriveProxy.getDefault(resPath);
            if (winDrive != null && !winDrive.isMounted()) {
                winDrive.lfs = SpecialDelegates.mountWinDrive(winDrive.getResource());
                retVal = MountTable.getDefault().resolveBestDelegate(resPath.getNormalizedPath());
            }
        }
        return retVal;
    }

    private static boolean isWinDrive(ResourcePath resPath) {
        boolean root = resPath.getParent().isRoot();
        if (root) {
            root = SpecialDelegates.checkValidWindowsDrive(resPath.getFile()) != null;
        }
        return root;
    }

    private static FileSystem mountWinDrive(ResourcePath mountPointPath) {
        FileSystem retVal = null;
        String rootPath = mountPointPath.getNormalizedPath().substring(1) + "/";
        File root = SpecialDelegates.checkValidWindowsDrive(new File(rootPath));
        if (root != null) {
            retVal = SpecialDelegates.mountLocalFileSystem(root, rootPath);
        }
        return retVal;
    }

    private static void mountUnixRoot() {
        String rootPath = ResourcePath.getRoot().getNormalizedPath();
        File root = new File(rootPath);
        if (root.exists()) {
            SpecialDelegates.mountLocalFileSystem(root, rootPath);
        }
    }

    private static void mountVMSRoot(ResourcePath mountPointPath) {
        String rootPath = mountPointPath.getNormalizedPath();
        File root = new File(rootPath);
        if (root.exists()) {
            SpecialDelegates.mountLocalFileSystem(root, rootPath);
        }
    }

    private static FileSystem mountLocalFileSystem(File root, String rootPath) {
        FileBasedFileSystem retVal;
        try {
            retVal = FileBasedFileSystem.getInstance(root);
            MountTable.getDefault().mount(rootPath, retVal);
        }
        catch (IOException e) {
            retVal = null;
        }
        return retVal;
    }

    static File checkValidWindowsDrive(File root) {
        File retVal = null;
        if (fsv != null) {
            File file = retVal = (SpecialDelegates.isRoot(root) || fsv.isFileSystemRoot(root)) && !fsv.isFloppyDrive(root) ? root : null;
            if (retVal != null && !retVal.exists()) {
                retVal = null;
            }
        } else {
            retVal = SpecialDelegates.isRoot(root) ? root : null;
        }
        return retVal;
    }

    private static boolean isRoot(File root) {
        boolean retval = false;
        if (root.getParentFile() == null) {
            File[] allFiles = File.listRoots();
            for (int i = 0; i < allFiles.length; ++i) {
                File windowsDrive = allFiles[i];
                if (!windowsDrive.equals(root)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    private static File[] listRoots() {
        File[] all = File.listRoots();
        if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && fsv != null) {
            LinkedHashSet<File> roots = new LinkedHashSet<File>();
            for (int i = 0; i < all.length; ++i) {
                File file = SpecialDelegates.checkValidWindowsDrive(all[i]);
                if (file == null) continue;
                roots.add(file);
            }
            all = new File[roots.size()];
            roots.toArray(all);
        }
        return all;
    }

    private static final class WinSpecialFs
    extends FileSystem {
        private WinSpecialFs() {
        }

        public boolean isReadOnly() {
            return false;
        }

        public FileObject getRoot() {
            return WinRootVirtual.getDefault();
        }

        public FileObject findResource(String name) {
            ResourcePath resPath = new ResourcePath(name);
            if (resPath.isRoot()) {
                return this.getRoot();
            }
            return WindowsDriveProxy.getDefault(resPath);
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }

        public SystemAction[] getActions(Set foSet) {
            return this.getActions();
        }

        public String getDisplayName() {
            return null;
        }
    }

    private static final class WindowsDriveProxy
    extends WinRootVirtual {
        static final long serialVersionUID = -1244651321879256718L;
        private transient FileObject delegate;
        private transient boolean isValid = true;
        private static final transient Map instances = new WeakHashMap();
        private transient FileSystem lfs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static WindowsDriveProxy getDefault(ResourcePath resPath) {
            WindowsDriveProxy in;
            String winDrivePath = WindowsDriveProxy.getWindowsDriveSubstr(resPath.getNormalizedPath());
            if (winDrivePath == null) {
                return null;
            }
            resPath = new ResourcePath(winDrivePath);
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WindowsDriveProxy")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;
            synchronized (clazz) {
                in = (WindowsDriveProxy)((Object)instances.get(resPath));
                if (in == null) {
                    in = new WindowsDriveProxy(resPath);
                    instances.put(in.getResource(), in);
                }
            }
            return in;
        }

        private static String getWindowsDriveSubstr(String resPath) {
            int idx = resPath.indexOf(58);
            return idx == -1 ? null : resPath.substring(0, idx + 1);
        }

        private WindowsDriveProxy(ResourcePath resPath) {
            super(resPath);
        }

        public boolean isRoot() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public boolean isData() {
            return false;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public FileObject[] getChildren() {
            FileObject deleg = this.getDelegate(true);
            return deleg != null ? deleg.getChildren() : new FileObject[]{};
        }

        public FileObject getFileObject(String name, String ext) {
            FileObject deleg = this.getDelegate(true);
            return deleg != null ? deleg.getFileObject(name, ext) : null;
        }

        public FileObject getParent() {
            return WinRootVirtual.getDefault();
        }

        private FileObject getDelegate() {
            return this.getDelegate(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject getDelegate(boolean create) {
            if (this.delegate == null && create) {
                this.delegate = new InvalidDummy(this.getResource());
                this.lfs = SpecialDelegates.mountWinDrive(this.getResource());
                this.delegate = MountTable.getDefault().resolveBestDelegate(this.getResource().getNormalizedPath());
                if (this.delegate != null) {
                    Set set = this.getListenerList();
                    synchronized (set) {
                        Iterator it = this.getListenerList().iterator();
                        while (it.hasNext()) {
                            FileChangeListener fcl = (FileChangeListener)it.next();
                            this.delegate.addFileChangeListener(fcl);
                            it.remove();
                        }
                    }
                } else {
                    this.isValid = false;
                }
            }
            return this.delegate;
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.lfs != null ? this.lfs : fs;
        }

        public FileObject createFolder(String name) throws IOException {
            return this.getDelegate() != null ? this.getDelegate().createFolder(name) : super.createFolder(name);
        }

        public FileObject createData(String name, String ext) throws IOException {
            return this.getDelegate() != null ? this.getDelegate().createData(name) : super.createData(name);
        }

        public Object getAttribute(String attrName) {
            return this.getDelegate() != null ? this.getDelegate().getAttribute(attrName) : super.getAttribute(attrName);
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            if (this.getDelegate() != null) {
                this.getDelegate().setAttribute(attrName, value);
            } else {
                super.setAttribute(attrName, value);
            }
        }

        public Enumeration getAttributes() {
            return this.getDelegate() != null ? this.getDelegate().getAttributes() : super.getAttributes();
        }

        public void addFileChangeListener(FileChangeListener fcl) {
            if (this.getDelegate() != null) {
                this.getDelegate().addFileChangeListener(fcl);
            } else {
                super.addFileChangeListener(fcl);
            }
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
            if (this.getDelegate() != null) {
                this.getDelegate().removeFileChangeListener(fcl);
            } else {
                super.removeFileChangeListener(fcl);
            }
        }

        private boolean isMounted() {
            return this.lfs != null;
        }
    }

    private static class WinRootVirtual
    extends InvalidDummy {
        static final long serialVersionUID = -1244651321879256809L;
        private static transient WinRootVirtual instance = null;
        private static transient ArrayList delegs = null;
        private transient Set listenerList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static WinRootVirtual getDefault() {
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WinRootVirtual")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new WinRootVirtual(new ResourcePath(""));
                }
            }
            return instance;
        }

        private WinRootVirtual(ResourcePath resPath) {
            super(resPath);
        }

        public void addFileChangeListener(FileChangeListener fcl) {
            this.getListenerList().add(fcl);
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
            this.getListenerList().remove(fcl);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return fs;
        }

        public boolean isRoot() {
            return true;
        }

        public boolean isFolder() {
            return true;
        }

        public boolean isData() {
            return false;
        }

        public void refresh(boolean expected) {
            FileEvent fe;
            FileObject fo;
            List<FileObject> oldFos = Arrays.asList(this.getChildren());
            delegs = null;
            List<FileObject> newFos = Arrays.asList(this.getChildren());
            HashSet<FileObject> removeSet = new HashSet<FileObject>(oldFos);
            HashSet<FileObject> addSet = new HashSet<FileObject>(newFos);
            removeSet.removeAll(newFos);
            addSet.removeAll(oldFos);
            Iterator iterator = removeSet.iterator();
            while (iterator.hasNext()) {
                fo = (FileObject)iterator.next();
                fe = new FileEvent((FileObject)this, fo);
                this.fireFileDeletedEvent(Collections.enumeration(this.getListenerList()), fe);
            }
            iterator = addSet.iterator();
            while (iterator.hasNext()) {
                fo = (FileObject)iterator.next();
                fe = new FileEvent((FileObject)this, fo);
                if (fo.isFolder()) {
                    this.fireFileFolderCreatedEvent(Collections.enumeration(this.getListenerList()), fe);
                    continue;
                }
                this.fireFileDataCreatedEvent(Collections.enumeration(this.getListenerList()), fe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject[] getChildren() {
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WinRootVirtual")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
            synchronized (clazz) {
                if (delegs == null) {
                    List<File> roots = Arrays.asList(SpecialDelegates.listRoots());
                    delegs = new ArrayList();
                    for (int i = 0; i < roots.size(); ++i) {
                        File root = roots.get(i);
                        ResourcePath resName = this.getResource().getChild(root.getAbsolutePath());
                        WindowsDriveProxy winDrive = WindowsDriveProxy.getDefault(resName);
                        if (winDrive == null) continue;
                        delegs.add(winDrive);
                    }
                }
            }
            FileObject[] retVal = new FileObject[delegs.size()];
            delegs.toArray(retVal);
            return retVal;
        }

        public boolean isValid() {
            return true;
        }

        public FileObject getFileObject(String name, String ext) {
            FileObject retVal = null;
            FileObject[] chlds = this.getChildren();
            for (int i = 0; i < chlds.length; ++i) {
                FileObject chld = chlds[i];
                if (!chld.getName().equals(name) || !chld.getExt().equals(ext)) continue;
                retVal = chld;
                break;
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set getListenerList() {
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WindowsDriveProxy")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;
            synchronized (clazz) {
                if (this.listenerList == null) {
                    this.listenerList = Collections.synchronizedSet(new HashSet());
                }
            }
            return this.listenerList;
        }
    }
}

