/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.editor.structure.api.DocumentModel;

public final class DocumentElement {
    private String name;
    private String type;
    private Position startPos;
    private Position endPos;
    private int startSectionLength;
    private int endSectionLength;
    private DocumentModel model;
    private Attributes attributes;
    private int elementEmpty;
    private boolean isRootElement;
    private static final int ELEMENT_EMPTY_UNSET = 0;
    private static final int ELEMENT_EMPTY_TRUE = 1;
    private static final int ELEMENT_EMPTY_FALSE = 2;
    private HashSet deListeners = new HashSet();
    private final int PRINT_MAX_CHARS = 10;

    DocumentElement(String name, String type, Map attrsMap, int startOffset, int endOffset, DocumentModel model) throws BadLocationException {
        this.name = name;
        this.model = model;
        this.startSectionLength = this.startSectionLength;
        this.endSectionLength = this.endSectionLength;
        this.type = type;
        this.attributes = new Attributes(this, attrsMap);
        this.elementEmpty = 0;
        this.isRootElement = false;
        this.setStartPosition(startOffset);
        this.setEndPosition(endOffset);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Document getDocument() {
        return this.model.getDocument();
    }

    public DocumentElement getElement(int index) {
        return (DocumentElement)this.getChildren().get(index);
    }

    public int getElementCount() {
        return this.getChildren().size();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    public int getElementIndex(int offset) {
        Iterator children = this.getChildren().iterator();
        int min_delta = Integer.MAX_VALUE;
        DocumentElement nearest = null;
        while (children.hasNext()) {
            int end_delta;
            DocumentElement de = (DocumentElement)children.next();
            if (de.getStartOffset() <= offset && de.getEndOffset() > offset) {
                nearest = de;
                break;
            }
            int start_delta = Math.abs(de.getStartOffset() - offset);
            int delta = Math.min(start_delta, end_delta = Math.abs(de.getEndOffset() - offset));
            if (min_delta <= delta) continue;
            nearest = de;
            min_delta = delta;
        }
        if (nearest == null) {
            return -1;
        }
        return this.getChildren().indexOf(nearest);
    }

    public String getName() {
        return this.name;
    }

    public DocumentElement getParentElement() {
        return this.model.getParent(this);
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    void setAttributes(Map attrs) {
        this.attributes = new Attributes(this, attrs);
    }

    void setElementIsEmptyState(boolean state) {
        this.elementEmpty = state ? 1 : 2;
    }

    boolean isEmpty() {
        if (this.elementEmpty == 0) {
            this.elementEmpty = DocumentModel.isEmpty(this) ? 1 : 2;
        }
        return this.elementEmpty == 1;
    }

    public DocumentModel getDocumentModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public List getChildren() {
        return this.model.getChildren(this);
    }

    public void addDocumentElementListener(DocumentElementListener del) {
        this.deListeners.add(del);
    }

    public void removeDocumentElementListener(DocumentElementListener del) {
        this.deListeners.remove(del);
    }

    synchronized void setRootElement(boolean value) {
        this.isRootElement = value;
    }

    boolean isRootElement() {
        return this.isRootElement;
    }

    void setStartPosition(int offset) throws BadLocationException {
        this.startPos = this.model.getDocument().createPosition(offset);
    }

    void setEndPosition(int offset) throws BadLocationException {
        this.endPos = this.model.getDocument().createPosition(offset);
    }

    String getContent() throws BadLocationException {
        return this.model.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
    }

    private void fireDocumentElementEvent(DocumentElementEvent dee) {
        for (DocumentElementListener cl : this.deListeners) {
            switch (dee.getType()) {
                case 2: {
                    cl.elementAdded(dee);
                    break;
                }
                case 3: {
                    cl.elementRemoved(dee);
                    break;
                }
                case 1: {
                    cl.contentChanged(dee);
                    break;
                }
                case 5: {
                    cl.attributesChanged(dee);
                }
            }
        }
    }

    void childAdded(DocumentElement de) {
        this.fireDocumentElementEvent(new DocumentElementEvent(2, this, de));
    }

    void childRemoved(DocumentElement de) {
        this.fireDocumentElementEvent(new DocumentElementEvent(3, this, de));
    }

    void contentChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(1, this, null));
    }

    void attributesChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(5, this, null));
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentElement)) {
            return false;
        }
        DocumentElement de = (DocumentElement)o;
        return de.getName().equals(this.getName()) && de.getType().equals(this.getType()) && de.getStartOffset() == this.getStartOffset() && de.getEndOffset() == this.getEndOffset();
    }

    public String toString() {
        String elementContent = "";
        try {
            elementContent = this.getContent().trim().length() > 10 ? this.getContent().trim().substring(0, 10) + "..." : this.getContent().trim();
        }
        catch (BadLocationException e) {
            elementContent = "error:" + e.getMessage();
        }
        return "DE (" + this.hashCode() + ")[\"" + this.getName() + "\" (" + this.getType() + ") <" + this.getStartOffset() + "-" + this.getEndOffset() + "> '" + this.encodeNewLines(elementContent) + "']";
    }

    private String encodeNewLines(String s) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                encoded.append("\\n");
                continue;
            }
            encoded.append(s.charAt(i));
        }
        return encoded.toString();
    }

    static final class Attributes
    implements AttributeSet {
        private Map attrs;
        private DocumentElement de;

        Attributes(DocumentElement element, Map m) {
            this.de = element;
            this.attrs = m;
        }

        public int getAttributeCount() {
            return this.attrs.size();
        }

        public boolean isDefined(Object attrName) {
            return this.attrs.containsKey(attrName);
        }

        public boolean isEqual(AttributeSet attr) {
            if (this.getAttributeCount() != attr.getAttributeCount()) {
                return false;
            }
            return this.containsAttributes(attr);
        }

        public AttributeSet copyAttributes() {
            HashMap clone = new HashMap(this.getAttributeCount());
            clone.putAll(this.attrs);
            return new Attributes(this.de, clone);
        }

        public Object getAttribute(Object key) {
            return this.attrs.get(key);
        }

        public Enumeration getAttributeNames() {
            return Collections.enumeration(this.attrs.keySet());
        }

        public boolean containsAttribute(Object name, Object value) {
            return value.equals(this.getAttribute(name));
        }

        public boolean containsAttributes(AttributeSet attributes) {
            Enumeration<?> e = attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                Object value;
                Object key = e.nextElement();
                if (this.containsAttribute(key, value = attributes.getAttribute(key))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Enumeration e = this.getAttributeNames();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = this.getAttribute(key);
                sb.append(key);
                sb.append('=');
                sb.append(value);
                sb.append(' ');
            }
            return sb.toString();
        }

        public AttributeSet getResolveParent() {
            return this.de.getParentElement() != null ? this.de.getParentElement().getAttributes() : null;
        }

        public int compareTo(AttributeSet as) {
            return this.toString().compareTo(as.toString());
        }
    }
}

