/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.i18n.java.Util;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.Translator;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public class JavaI18nSupport
extends I18nSupport {
    protected int modifiers = 26;
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public JavaI18nSupport(DataObject sourceDataObject) {
        super(sourceDataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    public I18nString getDefaultI18nString(HardCodedString hcString) {
        DataObject lastResource;
        JavaI18nString i18nString = new JavaI18nString(this);
        ResourceHolder resourceHolder = i18nString.getSupport().getResourceHolder();
        if (resourceHolder.getResource() == null && (lastResource = I18nUtil.getOptions().getLastResource2()) != null) {
            FileObject sourceFile = this.sourceDataObject.getPrimaryFile();
            FileObject bundleFile = lastResource.getPrimaryFile();
            ClassPath execClassPath = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/execute");
            if (execClassPath.getResourceName(bundleFile) != null) {
                resourceHolder.setResource(lastResource);
            }
        }
        if (hcString == null) {
            return i18nString;
        }
        i18nString.setComment("");
        i18nString.setKey(hcString.getText().replace(' ', '_'));
        i18nString.setValue(hcString.getText());
        if (this.isGenerateField() && i18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
            i18nString.setReplaceFormat((String)I18nUtil.getReplaceFormatItems().get(0));
        }
        return i18nString;
    }

    public JPanel getInfo(HardCodedString hcString) {
        return new JavaInfoPanel(hcString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean generateField) {
        this.generateField = generateField;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String initFormat) {
        this.initFormat = initFormat;
    }

    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    public boolean hasAdditionalCustomizer() {
        return true;
    }

    public JPanel getAdditionalCustomizer() {
        return new JavaReplacePanel(this);
    }

    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String name;
        try {
            name = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException npe) {
            this.identifier = "";
            return;
        }
        name = name.length() > 0 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        this.identifier = name;
    }

    private void createField() {
        if (!this.isGenerateField()) {
            return;
        }
        ClassElement sourceClass = this.getSourceClassElement();
        if (sourceClass.getField(Identifier.create((String)this.getIdentifier())) != null) {
            return;
        }
        try {
            FieldElement newField = new FieldElement();
            newField.setName(Identifier.create((String)this.getIdentifier()));
            newField.setModifiers(this.getModifiers());
            newField.setType(Type.parse((String)"java.util.ResourceBundle"));
            newField.setInitValue(this.getInitString());
            if (sourceClass != null) {
                sourceClass.addField(newField);
            }
        }
        catch (SourceException se) {
            ErrorManager.getDefault().notify(1, (Throwable)se);
        }
        catch (NullPointerException npe) {
            ErrorManager.getDefault().notify(1, (Throwable)npe);
        }
    }

    public String getInitString() {
        String initJavaFormat = this.getInitFormat();
        FileObject fo = this.resourceHolder.getResource().getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("bundleNameSlashes", cp.getResourceName(fo, '/', false));
        map.put("bundleNameDots", cp.getResourceName(fo, '.', false));
        map.put("sourceFileName", this.sourceDataObject == null ? "" : this.sourceDataObject.getPrimaryFile().getName());
        return MapFormat.format((String)initJavaFormat, map);
    }

    private ClassElement getSourceClassElement() {
        SourceElement sourceElem = ((SourceCookie)this.sourceDataObject.getCookie(SourceCookie.class)).getSource();
        ClassElement sourceClass = sourceElem.getClass(Identifier.create((String)this.sourceDataObject.getName()));
        if (sourceClass != null) {
            return sourceClass;
        }
        ClassElement[] classes = sourceElem.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            int modifs = classes[i].getModifiers();
            if (!classes[i].isClass() || !Modifier.isPublic(modifs)) continue;
            sourceClass = classes[i];
            break;
        }
        return sourceClass;
    }

    public static class Factory
    extends I18nSupport.Factory {
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JavaI18nSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hcString, StyledDocument document) {
            super(hcString, document);
        }

        protected void setHardCodedString(HardCodedString hcString, StyledDocument document) {
            String hardLine;
            this.getStringText().setText(hcString == null ? "" : hcString.getText());
            if (hcString.getStartPosition() == null) {
                hardLine = "";
            } else {
                int pos = hcString.getStartPosition().getOffset();
                try {
                    Element paragraph = document.getParagraphElement(pos);
                    hardLine = document.getText(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset()).trim();
                }
                catch (BadLocationException ble) {
                    hardLine = "";
                }
            }
            this.getFoundInText().setText(hardLine);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        public void replace(final HardCodedString hcString, I18nString i18nString) {
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            final String newCode = i18nString.getReplaceString();
            final StyledDocument document = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (hcString.getLength() > 0) {
                            document.remove(hcString.getStartPosition().getOffset(), hcString.getLength());
                        }
                        if (newCode != null && newCode.length() > 0) {
                            document.insertString(hcString.getEndPosition().getOffset(), newCode, null);
                        }
                    }
                    catch (BadLocationException ble) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Util.getString("MSG_CouldNotReplace"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    public static class JavaI18nFinder
    implements I18nSupport.I18nFinder {
        protected static final int STATE_JAVA = 0;
        protected static final int STATE_JAVA_A_SLASH = 1;
        protected static final int STATE_LINECOMMENT = 2;
        protected static final int STATE_BLOCKCOMMENT = 3;
        protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
        protected static final int STATE_STRING = 5;
        protected static final int STATE_STRING_A_BSLASH = 6;
        protected static final int STATE_CHAR = 7;
        protected StyledDocument document;
        protected int state;
        protected boolean i18nSearch;
        protected Position lastPosition;
        protected StringBuffer lastJavaString;
        protected char[] buffer;
        protected int position;
        protected int currentStringStart;
        protected int currentStringEnd;

        public JavaI18nFinder(StyledDocument document) {
            this.document = document;
            this.init();
        }

        private void init() {
            this.state = 0;
            this.initJavaStringBuffer();
            this.lastPosition = null;
        }

        protected void reset() {
            this.init();
        }

        public HardCodedString[] findAllHardCodedStrings() {
            this.reset();
            this.i18nSearch = false;
            return this.findAllStrings();
        }

        public HardCodedString findNextHardCodedString() {
            this.i18nSearch = false;
            return this.findNextString();
        }

        public HardCodedString[] findAllI18nStrings() {
            this.reset();
            this.i18nSearch = true;
            return this.findAllStrings();
        }

        public HardCodedString findNextI18nString() {
            this.i18nSearch = true;
            return this.findNextString();
        }

        protected HardCodedString[] findAllStrings() {
            HardCodedString hardString;
            ArrayList<HardCodedString> list = new ArrayList<HardCodedString>();
            while ((hardString = this.findNextString()) != null) {
                list.add(hardString);
            }
            if (list.isEmpty()) {
                return null;
            }
            HardCodedString[] hardStrings = new HardCodedString[list.size()];
            list.toArray(hardStrings);
            return hardStrings;
        }

        protected HardCodedString findNextString() {
            try {
                this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
            }
            catch (BadLocationException ble) {
                if (Boolean.getBoolean("netbeans.debug.exception")) {
                    ble.printStackTrace();
                }
                return null;
            }
            this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            while (this.position < this.buffer.length) {
                char ch = this.buffer[this.position];
                if (ch != '\n') {
                    HardCodedString foundHardString = this.handleCharacter(ch);
                    if (foundHardString != null) {
                        return foundHardString;
                    }
                } else {
                    this.handleNewLineCharacter();
                }
                ++this.position;
            }
            return null;
        }

        protected HardCodedString handleCharacter(char character) {
            if (this.state == 0) {
                return this.handleStateJava(character);
            }
            if (this.state == 1) {
                return this.handleStateJavaASlash(character);
            }
            if (this.state == 7) {
                return this.handleStateChar(character);
            }
            if (this.state == 6) {
                return this.handleStateStringABSlash(character);
            }
            if (this.state == 2) {
                return this.handleStateLineComment(character);
            }
            if (this.state == 3) {
                return this.handleStateBlockComment(character);
            }
            if (this.state == 4) {
                return this.handleStateBlockCommentAStar(character);
            }
            if (this.state == 5) {
                return this.handleStateString(character);
            }
            return null;
        }

        protected void handleNewLineCharacter() {
            if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
                this.initJavaStringBuffer();
                this.currentStringStart = -1;
                this.currentStringEnd = -1;
                this.state = 0;
            } else if (this.state == 3 || this.state == 4) {
                this.state = 3;
            }
        }

        protected HardCodedString handleStateJava(char character) {
            this.lastJavaString.append(character);
            if (character == '/') {
                this.state = 1;
            } else if (character == '\"') {
                this.state = 5;
                if (this.currentStringStart == -1) {
                    this.currentStringStart = this.position;
                }
            } else if (character == '\'') {
                this.state = 7;
            }
            return null;
        }

        protected HardCodedString handleStateJavaASlash(char character) {
            this.lastJavaString.append(character);
            if (character == '/') {
                this.state = 2;
            } else if (character == '*') {
                this.state = 3;
            }
            return null;
        }

        protected HardCodedString handleStateChar(char character) {
            this.lastJavaString.append(character);
            if (character == '\'') {
                this.state = 0;
            }
            return null;
        }

        protected HardCodedString handleStateStringABSlash(char character) {
            this.state = 5;
            return null;
        }

        protected HardCodedString handleStateLineComment(char character) {
            return null;
        }

        protected HardCodedString handleStateBlockComment(char character) {
            if (character == '*') {
                this.state = 4;
            }
            return null;
        }

        protected HardCodedString handleStateBlockCommentAStar(char character) {
            if (character == '/') {
                this.state = 0;
                this.initJavaStringBuffer();
            } else if (character != '*') {
                this.state = 3;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HardCodedString handleStateString(char character) {
            if (character == '\\') {
                this.state = 6;
            } else if (character == '\"') {
                this.state = 0;
                if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                    this.currentStringEnd = this.position + 1;
                    int foundStringLength = this.currentStringEnd - this.currentStringStart;
                    try {
                        Position hardStringStart = this.document.createPosition(this.currentStringStart);
                        Position hardStringEnd = this.document.createPosition(this.currentStringEnd);
                        String hardString = this.document.getText(hardStringStart.getOffset(), foundStringLength);
                        String restBuffer = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                        int endOfLine = restBuffer.indexOf(10);
                        if (endOfLine == -1) {
                            endOfLine = restBuffer.length();
                        }
                        this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, hardString.length()));
                        String restOfLine = this.document.getText(this.currentStringStart + 1 + hardString.length(), this.currentStringEnd + endOfLine - this.currentStringStart - hardString.length());
                        this.lastJavaString.append(restOfLine.replace('\"', '_'));
                        if (this.isSearchedString(this.lastJavaString.toString(), hardString)) {
                            this.lastPosition = hardStringEnd;
                            HardCodedString hardCodedString = new HardCodedString(this.extractString(hardString), hardStringStart, hardStringEnd);
                            return hardCodedString;
                        }
                    }
                    catch (BadLocationException ble) {
                        ErrorManager.getDefault().notify(1, (Throwable)ble);
                    }
                    finally {
                        this.currentStringStart = -1;
                        this.currentStringEnd = -1;
                        this.initJavaStringBuffer();
                    }
                }
            }
            return null;
        }

        private void initJavaStringBuffer() {
            this.lastJavaString = new StringBuffer();
        }

        private String extractString(String sourceString) {
            if (sourceString == null) {
                return "";
            }
            if (sourceString.length() >= 2 && sourceString.charAt(0) == '\"' && sourceString.charAt(sourceString.length() - 1) == '\"') {
                sourceString = sourceString.substring(1, sourceString.length() - 1);
            }
            return sourceString;
        }

        protected boolean isSearchedString(String partHardLine, String hardString) {
            String lineToMatch = UtilConvert.unicodesToChars((String)partHardLine);
            Exception ex = null;
            try {
                String regexp = this.createRegularExpression(hardString);
                return Pattern.compile(regexp).matcher(lineToMatch).find() == this.i18nSearch;
            }
            catch (ParseException ex1) {
                ex = ex1;
            }
            catch (PatternSyntaxException ex2) {
                ex = ex2;
            }
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            String msg = MessageFormat.format(Util.getString("MSG_RegExpCompileError"), hardString);
            Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)msg, 0, 0));
            return NotifyDescriptor.YES_OPTION.equals(answer);
        }

        private String createRegularExpression(String hardString) throws ParseException {
            String regexpForm = this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression();
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("key", hardString);
            map.put("hardString", hardString);
            return Translator.translateRegexp(regexpForm, map);
        }
    }
}

