/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.nodes;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.websvc.registry.actions.DeleteWebServiceAction;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.nodes.WebServicesCookie;
import org.netbeans.modules.websvc.registry.nodes.WebServicesNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class WebServicesNode
extends AbstractNode
implements WebServicesCookie {
    private WebServiceData websvcData;

    public WebServicesNode() {
        this(null);
    }

    public WebServiceData getWebServiceData() {
        return this.websvcData;
    }

    public WebServicesNode(WebServiceData wsData) {
        super((Children)new WebServicesNodeChildren(wsData));
        this.websvcData = wsData;
        this.setName(wsData.getDisplayName());
        this.setIconBaseWithExtension("org/netbeans/modules/websvc/registry/resources/webservice.png");
        this.setShortDescription(wsData.getWSDescription());
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(DeleteWebServiceAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ss = sheet.get("data");
        if (ss == null) {
            ss = new Sheet.Set();
            ss.setName("data");
            ss.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"WS_INFO"));
            ss.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"WS_INFO"));
            sheet.put(ss);
        }
        try {
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)this.websvcData, String.class, "getName", null);
            p.setName("name");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"WS_NAME"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"WS_NAME"));
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)this.websvcData, Integer.class, "getWebServicePort", null);
            p.setName("port");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"WS_PORT"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"WS_PORT"));
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)this.websvcData, String.class, "getURL", null);
            p.setName("URL");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"WS_URL"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"WS_URL"));
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)this.websvcData, String.class, "getWebServiceAddress", null);
            p.setName("Web Service Address");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"WS_ADDRESS"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"WS_ADDRESS"));
            ss.put((Node.Property)p);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        return sheet;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        wsListModel.removeWebService(this.websvcData.getId());
        if (null != this.websvcData.getProxyJarFileName()) {
            String jarFileName = this.websvcData.getProxyJarFileName();
            File wsJarFile = new File(jarFileName);
            if (wsJarFile.getParentFile() == null || !wsJarFile.exists()) {
                wsJarFile = new File(new File(System.getProperty("netbeans.user"), "websvc/"), wsJarFile.getName());
            }
            wsJarFile.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() {
        try {
            ExTransferable et = ExTransferable.create((Transferable)super.clipboardCopy());
            return et;
        }
        catch (IOException ioe) {
            System.err.println("WSLeaf.clipboardCopy: Error");
            ioe.printStackTrace();
            return null;
        }
    }

    public Node.Cookie getCookie(Class type) {
        return super.getCookie(type);
    }
}

