/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.web.CacheMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.CacheMappingTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.SelectedCacheMappingPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;

public class CacheMappingPanel
extends JPanel
implements TableModelListener,
ListSelectionListener {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private WebAppRootCustomizer masterPanel;
    private CacheMappingTableModel cacheMappingModel;
    private SelectedCacheMappingPanel selectedCacheMappingPanel;
    private JPanel cacheMappingButtonPanel;
    private FixedHeightJTable cacheMappingTable;
    private JPanel cacheMappingTablePanel;
    private JButton jBtnAddMapping;
    private JButton jBtnRemoveMapping;
    private JLabel jLblCacheMappingUsageDescription;
    private JLabel jLblCacheMappings;
    private JScrollPane jScrlPnCacheMapping;

    public CacheMappingPanel(WebAppRootCustomizer src) {
        this.masterPanel = src;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblCacheMappingUsageDescription = new JLabel();
        this.cacheMappingTablePanel = new JPanel();
        this.jLblCacheMappings = new JLabel();
        this.jScrlPnCacheMapping = new JScrollPane();
        this.cacheMappingTable = new FixedHeightJTable();
        this.cacheMappingButtonPanel = new JPanel();
        this.jBtnAddMapping = new JButton();
        this.jBtnRemoveMapping = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheMappingsTab"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheMappingsTab"));
        this.jLblCacheMappingUsageDescription.setText(webappBundle.getString("LBL_CacheMappingDescription"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblCacheMappingUsageDescription, gridBagConstraints);
        this.cacheMappingTablePanel.setLayout(new GridBagLayout());
        this.jLblCacheMappings.setLabelFor(this.cacheMappingTable);
        this.jLblCacheMappings.setText(webappBundle.getString("LBL_CacheMappings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.cacheMappingTablePanel.add((Component)this.jLblCacheMappings, gridBagConstraints);
        this.jScrlPnCacheMapping.setViewportView(this.cacheMappingTable);
        this.cacheMappingTable.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheMappingTable"));
        this.cacheMappingTable.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheMappingTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cacheMappingTablePanel.add((Component)this.jScrlPnCacheMapping, gridBagConstraints);
        this.cacheMappingButtonPanel.setLayout(new GridBagLayout());
        this.jBtnAddMapping.setText(commonBundle.getString("LBL_Add"));
        this.jBtnAddMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CacheMappingPanel.this.jBtnAddMappingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.cacheMappingButtonPanel.add((Component)this.jBtnAddMapping, gridBagConstraints);
        this.jBtnAddMapping.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_AddCacheMapping"));
        this.jBtnAddMapping.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_AddCacheMapping"));
        this.jBtnRemoveMapping.setText(commonBundle.getString("LBL_Remove"));
        this.jBtnRemoveMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CacheMappingPanel.this.jBtnRemoveMappingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.cacheMappingButtonPanel.add((Component)this.jBtnRemoveMapping, gridBagConstraints);
        this.jBtnRemoveMapping.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_RemoveCacheMapping"));
        this.jBtnRemoveMapping.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_RemoveCacheMapping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.cacheMappingTablePanel.add((Component)this.cacheMappingButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.cacheMappingTablePanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBtnRemoveMappingActionPerformed(ActionEvent evt) {
        int row = this.cacheMappingTable.getSelectedRow();
        if (row != -1) {
            ListSelectionModel listSelectionModel = this.cacheMappingTable.getSelectionModel();
            boolean savedValueIsAdjusting = listSelectionModel.getValueIsAdjusting();
            try {
                listSelectionModel.setValueIsAdjusting(true);
                this.cacheMappingModel.removeRow(row);
                if (row > 0 && row >= this.cacheMappingModel.getRowCount()) {
                    --row;
                }
                listSelectionModel.setSelectionInterval(row, row);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(savedValueIsAdjusting);
            }
            if (this.cacheMappingModel.getRowCount() > 0) {
                this.jBtnRemoveMapping.requestFocusInWindow();
            } else {
                this.jBtnAddMapping.requestFocusInWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBtnAddMappingActionPerformed(ActionEvent evt) {
        ListSelectionModel listSelectionModel = this.cacheMappingTable.getSelectionModel();
        boolean savedValueIsAdjusting = listSelectionModel.getValueIsAdjusting();
        try {
            listSelectionModel.setValueIsAdjusting(true);
            this.cacheMappingModel.addRow();
            int row = this.cacheMappingModel.getRowCount() - 1;
            listSelectionModel.setSelectionInterval(row, row);
        }
        finally {
            listSelectionModel.setValueIsAdjusting(savedValueIsAdjusting);
        }
    }

    private void initUserComponents() {
        this.cacheMappingModel = new CacheMappingTableModel();
        this.cacheMappingTable.setModel(this.cacheMappingModel);
        this.cacheMappingTable.getSelectionModel().setSelectionMode(0);
        this.selectedCacheMappingPanel = new SelectedCacheMappingPanel(this.masterPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.selectedCacheMappingPanel, gridBagConstraints);
    }

    public void addListeners() {
        this.cacheMappingModel.addTableModelListener(this);
        this.cacheMappingTable.getSelectionModel().addListSelectionListener(this);
    }

    public void removeListeners() {
        this.cacheMappingTable.getSelectionModel().removeListSelectionListener(this);
        this.cacheMappingModel.removeTableModelListener(this);
    }

    public void initFields(WebAppCache cacheBean) {
        List cacheMappings = cacheBean.getCacheMappings();
        this.cacheMappingModel.setData(cacheMappings, cacheBean.getParent().getAppServerVersion());
        ListSelectionModel listSelectionModel = this.cacheMappingTable.getSelectionModel();
        if (cacheMappings != null && cacheMappings.size() > 0) {
            listSelectionModel.setSelectionInterval(0, 0);
            this.handleListSelectionChanged();
        } else {
            this.enableTableAffectedControls();
        }
    }

    private void enableTableAffectedControls() {
        boolean hasMappings = this.cacheMappingModel.getRowCount() > 0;
        boolean hasSelection = this.cacheMappingTable.getSelectionModel().getMinSelectionIndex() != -1;
        this.jBtnRemoveMapping.setEnabled(hasMappings && hasSelection);
        this.selectedCacheMappingPanel.setContainerEnabled(this.selectedCacheMappingPanel, hasMappings && hasSelection);
    }

    private void handleListSelectionChanged() {
        this.enableTableAffectedControls();
        this.selectedCacheMappingPanel.setSelectedCacheMapping(this.getSelectedMapping());
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            try {
                cacheBean.setCacheMappings(this.cacheMappingModel.getData());
                bean.setDirty();
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        this.enableTableAffectedControls();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.handleListSelectionChanged();
        }
    }

    private CacheMapping getSelectedMapping() {
        List mappings = this.cacheMappingModel.getData();
        int row = this.cacheMappingTable.getSelectedRow();
        CacheMapping mapping = row >= 0 && row < mappings.size() ? (CacheMapping)mappings.get(row) : null;
        return mapping;
    }
}

