/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.JavaMethod;
import org.netbeans.modules.j2ee.sun.dd.api.common.Message;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurity;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.AuthorizationEntry;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageEntry;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageSecurityEntryPanel;

public class EditBinding
extends JPanel
implements TableModelListener {
    private static final ResourceBundle webserviceBundle;
    private final Base theBean;
    private final ASDDVersion asVersion;
    private final String asCloneVersion;
    private final MessageSecurityBinding msBinding;
    private final boolean methodAsOperation;
    private Dimension initialPreferredSize;
    private GenericTableModel messageSecurityModel;
    private GenericTablePanel messageSecurityPanel;
    private MessageSecurity[] bindingData;
    private MessageSecurity[] newBindingData;
    private String providerId;
    private JLabel jLblAuthReq;
    private JLabel jLblAuthorizationLayer;
    private JLabel jLblProvIdReq;
    private JLabel jLblProviderId;
    private JTextField jTxtAuthorizationLayer;
    private JTextField jTxtProviderId;
    static GenericTableModel.ParentPropertyFactory messageSecurityFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EditBinding(Base bean, MessageSecurityBinding binding, boolean asOperation, ASDDVersion asDDVersion, String stringVersion) {
        this.theBean = bean;
        this.methodAsOperation = asOperation;
        this.asVersion = asDDVersion;
        this.asCloneVersion = stringVersion;
        this.msBinding = binding;
        this.providerId = this.msBinding.getProviderId();
        this.bindingData = this.expand(binding.getMessageSecurity());
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    public String getProviderId() {
        return this.providerId;
    }

    private void initComponents() {
        this.jLblAuthReq = new JLabel();
        this.jLblAuthorizationLayer = new JLabel();
        this.jTxtAuthorizationLayer = new JTextField();
        this.jLblProvIdReq = new JLabel();
        this.jLblProviderId = new JLabel();
        this.jTxtProviderId = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLblAuthReq.setLabelFor(this.jTxtAuthorizationLayer);
        this.jLblAuthReq.setText("*");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblAuthReq, gridBagConstraints);
        this.jLblAuthorizationLayer.setLabelFor(this.jTxtAuthorizationLayer);
        this.jLblAuthorizationLayer.setText(webserviceBundle.getString("LBL_AuthorizationLayer_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblAuthorizationLayer, gridBagConstraints);
        this.jTxtAuthorizationLayer.setEditable(false);
        this.jTxtAuthorizationLayer.setText("SOAP");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtAuthorizationLayer, gridBagConstraints);
        this.jLblProvIdReq.setLabelFor(this.jTxtProviderId);
        this.jLblProvIdReq.setText("*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblProvIdReq, gridBagConstraints);
        this.jLblProviderId.setLabelFor(this.jTxtProviderId);
        this.jLblProviderId.setText(webserviceBundle.getString("LBL_Provider_Id_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblProviderId, gridBagConstraints);
        this.jTxtProviderId.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditBinding.this.jTxtProviderIdKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtProviderId, gridBagConstraints);
    }

    private void jTxtProviderIdKeyReleased(KeyEvent evt) {
        this.providerId = this.jTxtProviderId.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.initialPreferredSize = this.getPreferredSize();
        ArrayList<GenericTableModel.TableEntry> tableColumns = new ArrayList<GenericTableModel.TableEntry>(5);
        tableColumns.add(new MessageEntry(this.methodAsOperation));
        tableColumns.add(new AuthorizationEntry("RequestProtection", "AuthSource", "ReqAuthSource"));
        tableColumns.add(new AuthorizationEntry("RequestProtection", "AuthRecipient", "ReqAuthRecipient"));
        tableColumns.add(new AuthorizationEntry("ResponseProtection", "AuthSource", "RespAuthSource"));
        tableColumns.add(new AuthorizationEntry("ResponseProtection", "AuthRecipient", "RespAuthRecipient"));
        this.messageSecurityModel = new GenericTableModel(messageSecurityFactory, tableColumns);
        this.messageSecurityModel.addTableModelListener(this);
        this.messageSecurityPanel = new GenericTablePanel(this.messageSecurityModel, webserviceBundle, "MessageSecurity", MessageSecurityEntryPanel.class, "AS_CFG_WebServiceEndpointMessageSecurity", this.methodAsOperation);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.messageSecurityPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_EditBindings"));
        this.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_EditBindings"));
    }

    private void initFields() {
        this.messageSecurityPanel.setModel((CommonDDBean[])this.bindingData, this.asVersion);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtProviderId.setText(this.providerId);
    }

    Collection getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        String newProviderId = this.getProviderId();
        if (!Utils.notEmpty(newProviderId)) {
            errors.add(webserviceBundle.getString("ERR_BlankProviderId"));
        }
        if (this.newBindingData == null || this.newBindingData.length == 0) {
            errors.add(webserviceBundle.getString("ERR_NoSecurityBindings"));
        }
        if (this.newBindingData != null && this.newBindingData.length > 1 && this.hasStarBinding()) {
            errors.add(webserviceBundle.getString("ERR_StarBindingConflict"));
        }
        return errors;
    }

    private boolean hasStarBinding() {
        boolean result = false;
        for (int i = 0; i < this.newBindingData.length; ++i) {
            Message[] msgs;
            String name = null;
            if (this.newBindingData[i] != null && (msgs = this.newBindingData[i].getMessage()) != null && msgs.length > 0 && msgs[0] != null) {
                name = EditBinding.getMethodName(msgs[0]);
            }
            if (!"*".equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void tableChanged(TableModelEvent e) {
        this.newBindingData = this.messageSecurityModel.getData().toArray(new MessageSecurity[0]);
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void commit() {
        MessageSecurityBinding oldBinding = (MessageSecurityBinding)this.msBinding.clone();
        this.msBinding.setAuthLayer("SOAP");
        String newProviderId = this.getProviderId();
        this.msBinding.setProviderId(newProviderId);
        this.newBindingData = this.compress(this.newBindingData);
        this.msBinding.setMessageSecurity(this.newBindingData);
        this.theBean.firePropertyChange("endpointSecurityBinding", oldBinding, this.msBinding);
    }

    private MessageSecurity[] expand(MessageSecurity[] bindingData) {
        MessageSecurity[] result = new MessageSecurity[]{};
        if (bindingData != null && bindingData.length > 0) {
            ArrayList<MessageSecurity> bindings = new ArrayList<MessageSecurity>(bindingData.length * 10);
            for (int i = 0; i < bindingData.length; ++i) {
                MessageSecurity ms = bindingData[i];
                Message[] messages = ms.getMessage();
                if (messages == null || messages.length <= 0) continue;
                if (messages.length == 1) {
                    bindings.add(ms);
                    continue;
                }
                for (int j = 0; j < messages.length; ++j) {
                    MessageSecurity newMS = (MessageSecurity)ms.cloneVersion(this.asCloneVersion);
                    Message newMessage = newMS.getMessage(j);
                    newMS.setMessage(new Message[]{newMessage});
                    bindings.add(newMS);
                }
            }
            result = bindings.toArray(result);
        }
        return result;
    }

    private MessageSecurity[] compress(MessageSecurity[] bindingData) {
        MessageSecurity[] result = null;
        if (bindingData != null && bindingData.length > 0) {
            int elementsToMerge;
            ArrayList<Object> securityList = new ArrayList<Object>(bindingData.length);
            Arrays.sort(bindingData, new MessageSecurityComparator(true));
            MessageSecurityComparator protectionComparator = new MessageSecurityComparator(false);
            for (int i = 0; i < bindingData.length; i += elementsToMerge) {
                int j;
                for (j = i + 1; j < bindingData.length && protectionComparator.compare(bindingData[i], bindingData[j]) == 0; ++j) {
                }
                elementsToMerge = j - i;
                if (!$assertionsDisabled && elementsToMerge <= 0) {
                    throw new AssertionError();
                }
                if (elementsToMerge == 1) {
                    securityList.add(bindingData[i].clone());
                    continue;
                }
                ArrayList<Object> messageList = new ArrayList<Object>(elementsToMerge);
                for (int m = i; m < j; ++m) {
                    Message[] message = bindingData[m].getMessage();
                    if (message == null || message.length <= 0) continue;
                    messageList.add(message[0].clone());
                }
                Message[] messages = messageList.toArray(new Message[0]);
                bindingData[i].setMessage(messages);
                securityList.add(bindingData[i].clone());
            }
            result = securityList.toArray(new MessageSecurity[0]);
        }
        return result;
    }

    private static String getMethodName(Message m) {
        JavaMethod method;
        String name = m.getOperationName();
        if (name == null && (method = m.getJavaMethod()) != null) {
            name = method.getMethodName();
        }
        return name;
    }

    static void editMessageSecurityBinding(JPanel parent, Base theBean, boolean editMethodAsOperation, MessageSecurityBinding binding, ASDDVersion asDDVersion, String stringVersion) {
        EditBinding bindingPanel = new EditBinding(theBean, binding, editMethodAsOperation, asDDVersion, stringVersion);
        bindingPanel.displayDialog(parent, webserviceBundle.getString("TITLE_EditBindings"), "AS_CFG_WebServiceEndpointSecurity");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        do {
            int dialogChoice = dialog.display();
            if (dialogChoice == 0) break;
            if (dialogChoice != 1) continue;
            Collection errors = this.getErrors();
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            this.commit();
        } while (dialog.hasErrors());
    }

    static {
        $assertionsDisabled = !EditBinding.class.desiredAssertionStatus();
        webserviceBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
        messageSecurityFactory = new GenericTableModel.ParentPropertyFactory(){

            public CommonDDBean newParentProperty(ASDDVersion asVersion) {
                return StorageBeanFactory.getStorageBeanFactory(asVersion).createMessageSecurity();
            }
        };
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final EditBinding dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, EditBinding childPanel) {
            super(parent, title);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)childPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList errors = new ArrayList();
            errors.addAll(this.dialogPanel.getErrors());
            this.setErrors(errors);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }

    private static class MessageSecurityComparator
    implements Comparator {
        private boolean sortNames;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MessageSecurityComparator(boolean sn) {
            this.sortNames = sn;
        }

        public int compare(Object o1, Object o2) {
            MessageSecurity ms1 = (MessageSecurity)o1;
            MessageSecurity ms2 = (MessageSecurity)o2;
            int result = Utils.strCompareTo(ms1.getRequestProtectionAuthSource(), ms2.getRequestProtectionAuthSource());
            if (result != 0) {
                return result;
            }
            result = Utils.strCompareTo(ms1.getRequestProtectionAuthRecipient(), ms2.getRequestProtectionAuthRecipient());
            if (result != 0) {
                return result;
            }
            result = Utils.strCompareTo(ms1.getResponseProtectionAuthSource(), ms2.getResponseProtectionAuthSource());
            if (result != 0) {
                return result;
            }
            result = Utils.strCompareTo(ms1.getResponseProtectionAuthRecipient(), ms2.getResponseProtectionAuthRecipient());
            if (result != 0) {
                return result;
            }
            if (this.sortNames) {
                Message[] m1 = ms1.getMessage();
                Message[] m2 = ms2.getMessage();
                if (!$assertionsDisabled && m1.length != 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && m2.length != 1) {
                    throw new AssertionError();
                }
                result = Utils.strCompareTo(EditBinding.getMethodName(m1[0]), EditBinding.getMethodName(m2[0]));
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$j2ee$sun$share$configbean$customizers$webservice$EditBinding == null ? (class$org$netbeans$modules$j2ee$sun$share$configbean$customizers$webservice$EditBinding = EditBinding.class$("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.EditBinding")) : class$org$netbeans$modules$j2ee$sun$share$configbean$customizers$webservice$EditBinding).desiredAssertionStatus();
        }
    }
}

