/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.ClassNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ClassCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    private final JavaClass element;
    private final JavaClass jclass;
    private final Resource resource;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel interfacesPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox superClassCombo;
    private JTextField typeTextField;

    public ClassCustomizer(JavaClass jclass, JavaClass element) {
        this(null, jclass, element);
    }

    public ClassCustomizer(Resource resource, JavaClass element) {
        this(resource, null, element);
    }

    private ClassCustomizer(Resource resource, JavaClass jclass, JavaClass element) {
        this.resource = resource;
        this.jclass = jclass;
        this.element = element;
        this.initComponents();
        this.interfacesPanel.setBorder(new TitledBorder(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Interfaces")));
        int mask = 1025;
        if (resource == null) {
            mask |= 0xE;
        }
        if (!element.isInterface()) {
            mask |= 0x10;
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)element, mask), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)element, mask), "Center");
        if (element.isInterface()) {
            this.superClassCombo.setEnabled(false);
            this.jLabel2.setVisible(false);
            this.superClassCombo.setVisible(false);
        } else {
            JavaClass superclassId = element.getSuperClass();
            this.superClassCombo.setSelectedItem(superclassId == null ? "" : superclassId.getName());
        }
        this.nameTextField.setText(element.getSimpleName());
        this.interfacesPanel.add((Component)new PropertyPanel(ClassNode.createInterfacesProperty(element, true), 2), "Center");
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Type_Mnemonic").charAt(0));
        this.jLabel3.setVisible(false);
        this.typeTextField.setVisible(false);
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.typeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.superClassCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ClassCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassNameTextField"));
        this.jLabel3.setLabelFor(this.typeTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Generic_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeTextField, gridBagConstraints);
        this.typeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassType"));
        this.jLabel2.setLabelFor(this.superClassCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Superclass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.superClassCombo.setEditable(true);
        this.superClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassCustomizer.this.superClassComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.superClassCombo, gridBagConstraints);
        this.superClassCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_SuperClass"));
        this.jLabel4.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.interfacesPanel, gridBagConstraints);
    }

    private void superClassComboActionPerformed(ActionEvent evt) {
        if (!this.superClassCombo.isEnabled()) {
            return;
        }
        JavaClass oldValue = this.element.getSuperClass();
        String oldValueStr = oldValue == null ? "" : oldValue.getName();
        Object item = this.superClassCombo.getSelectedItem();
        if (item == null) {
            this.superClassCombo.setSelectedItem(oldValueStr);
            return;
        }
        String newValueStr = item.toString().trim();
        boolean ok = false;
        if (!oldValueStr.equals(newValueStr)) {
            try {
                MultipartId mid = this.getJModel().getMultipartId().createMultipartId(newValueStr, null, null);
                this.element.setSuperClassName(mid);
                ok = true;
            }
            catch (JmiException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            return;
        }
        this.isOK = ok;
        if (!ok) {
            this.superClassCombo.setSelectedItem(oldValueStr);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.element.getSimpleName();
        boolean ok = false;
        if (!Utilities.isJavaIdentifier((String)newName)) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
            ErrorManager.getDefault().notify((Throwable)x);
        } else {
            if (oldName.equals(newName)) {
                return;
            }
            if (this.resource == null && this.jclass.getInnerClass(newName, true) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, newName) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else {
                try {
                    this.element.setSimpleName(newName);
                    ok = true;
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACS_ClassNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACS_ClassNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassCustomizerDialog"));
    }

    public boolean isOK() {
        this.superClassComboActionPerformed(null);
        if (this.isOK) {
            this.nameTextFieldFocusLost(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return this.jclass != null ? JavaMetamodel.getManager().getJavaExtent((Element)this.jclass) : JavaMetamodel.getManager().getJavaExtent((Element)this.resource);
    }
}

