/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module;

import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.progress.module.InternalHandle;

public class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private DefaultListModel model = new DefaultListModel();
    private InternalHandle explicit;

    public void addHandle(InternalHandle handle) {
        this.model.addElement(handle);
        if (handle.isUserInitialized() && this.explicit == null) {
            this.selectionModel.setSelectionInterval(this.model.size() - 1, this.model.size() - 1);
        }
    }

    public void removeHandle(InternalHandle handle) {
        if (this.explicit == handle) {
            this.explicit = null;
        }
        int index = this.model.indexOf(handle);
        if (this.selectionModel.getMinSelectionIndex() == index) {
            this.changeSelection(index);
        }
        InternalHandle selectedHandle = this.getSelectedHandle();
        this.model.removeElement(handle);
        if (selectedHandle != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(selectedHandle), this.model.indexOf(selectedHandle));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    private void changeSelection(int current) {
        InternalHandle last = null;
        for (int i = 0; i < this.model.size(); ++i) {
            if (current == i) continue;
            InternalHandle handle = (InternalHandle)this.model.getElementAt(i);
            if (handle.isUserInitialized()) {
                last = handle;
                continue;
            }
            if (last != null) continue;
            last = handle;
        }
        if (last != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(last), this.model.indexOf(last));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    public void explicitlySelect(InternalHandle handle) {
        this.explicit = handle;
        int index = this.model.indexOf(this.explicit);
        if (index == -1) {
            // empty if block
        }
        this.selectionModel.setSelectionInterval(index, index);
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    public int getSize() {
        return this.model.size();
    }

    public InternalHandle[] getHandles() {
        Object[] handles = new InternalHandle[this.model.size()];
        this.model.copyInto(handles);
        return handles;
    }

    public InternalHandle getSelectedHandle() {
        int select = this.selectionModel.getMinSelectionIndex();
        if (select != -1 && select >= 0 && select < this.model.size()) {
            return (InternalHandle)this.model.getElementAt(this.selectionModel.getMinSelectionIndex());
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionModel.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selectionModel.removeListSelectionListener(listener);
    }

    public void addListDataListener(ListDataListener listener) {
        this.model.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.model.removeListDataListener(listener);
    }
}

