/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private static Hashtable<String, MessageManager> managers = new Hashtable();
    private ResourceBundle bundle;

    private MessageManager(String packageName) {
        String bundleName = packageName + ".Bundle";
        this.bundle = ResourceBundle.getBundle(bundleName);
    }

    private MessageManager(String baseName, Class clazz) {
        this.bundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), clazz.getClassLoader());
    }

    private static String findName(Class clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            return pref.substring(0, last);
        }
        return "";
    }

    public static MessageManager getManager(Class clazz) {
        String packageName = MessageManager.findName(clazz);
        MessageManager mgr = managers.get(packageName);
        if (mgr == null) {
            String bundleName = packageName.length() == 0 ? "Bundle" : packageName + ".Bundle";
            mgr = new MessageManager(bundleName, clazz);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized MessageManager getManager(String packageName) {
        MessageManager mgr = managers.get(packageName);
        if (mgr == null) {
            mgr = new MessageManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        String str = null;
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = "Cannot find message associated with key '" + key + "'";
        }
        return str;
    }

    public String getString(String key, Object[] args) {
        String iString = null;
        String value = this.getString(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }
}

