/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: script.js,v 1.2 2006/04/03 19:12:46 craig_mcc Exp $
 */


/* =============================================================================
   Blueprints AJAX Components -- Rich Textarea Editor Functions
   ========================================================================== */  


// Does not actually need dojo.io.bind() at this point
// dojo.require("dojo.io.*");
dojo.require("dojo.widget.Editor");


/**
 * Define our component container object (if necessary).
 */
if (bpui_undefined("editor", bpui)) {

  bpui.editor = {


    /**
     * Localizable messages in the default language.  Treat this variable
     * as an associative array keyed by a message identifier.  Robust
     * applications will dynamically replace these messages with a localized
     * version based on the locale of the current user.
     */
    messages : new Object(),


    /**
     * The version number of this script.
     */
    version : {
      major: 0,
      minor: 1,
      patch: 0,
      flag: "",
      toString: function() {
        with (bpui.editor.version) {
          return major + "." + minor + "." + patch + flag;
        }
      }
    },


    /**
     * Start the handling of an onCancel event from a rich textarea editor widget.
     *
     * @param widget Rich Textarea Editor widget that received the event
     */
    startCancel : function(widget) {

      alert("handleCancel(" + widget.widgetId + ")");
      widget.enableToolbar(); // FIXME - Move to finishCancel() when available
                              // FIXME - Need to re-enable editing area also

    },


    /**
     * Start the handling of an onLoad event from a rich textarea editor widget.
     *
     * @param widget Rich Textarea Editor widget that received the event
     */
    startLoad : function(widget) {

      alert("handleLoad(" + widget.widgetId + ")");

    },


    /**
     * Start the handling of an onSave event from a rich textarea editor widget.
     *
     * @param widget Rich Textarea Editor widget that received the event
     */
    startSave : function(widget) {

      alert("handleSave(" + widget.widgetId + ")");
      widget.enableToolbar(); // FIXME - Move to finishSave() when available
                              // FIXME - Need to re-enable editing area also

    },


    /**
     * Wire up event handlers for the specified widget identifier
     *
     * @param widgetId Widget identifier of the editor widget that
     *                 will be the source of the events
     */
    wireEvents : function(widgetId) {

      var widget = dojo.widget.byId(widgetId);

      alert("Wiring up embedded functions on widget " + widget);
      widget.onCancel = bpui.editor.startCancel;
      widget.onLoad = bpui.editor.startLoad;
      widget.onSave = bpui.editor.startSave;

    }


  }


}
