#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CameraSettingsD300',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 58 => 0x69 },
	'about' => { 223 => 'about' },
	'abspeakaudiofilepath' => { 228 => 'absPeakAudioFilePath' },
	'accessorytype' => { 172 => 0x53 },
	'actionadvised' => { 69 => 0x2a },
	'activearea' => { 63 => 0xc68d },
	'actived-lighting' => { 128 => 0x22, 147 => 0x24 },
	'actived-lightingmode' => { 147 => 0x25 },
	'addaspectratioinfo' => { 40 => 0x80e },
	'additionalmodelinformation' => { 216 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 40 => 0x80f, 41 => 0x11, 42 => 0x13, 45 => 0x14 },
	'address' => { 93 => 'Address' },
	'adjustmentmode' => { 197 => [0x15,0x22] },
	'adultcontentwarning' => { 219 => 'AdultContentWarning', 222 => 'adultContentWarning' },
	'advancedraw' => { 149 => 0x76a43203 },
	'advancedscenemode' => { 172 => 0x3d },
	'advisory' => { 226 => 'Advisory' },
	'ae_iso' => { 174 => 0x2 },
	'aeaperture' => { 174 => 0x1 },
	'aebautocancel' => { 40 => 0x104 },
	'aebbracketvalue' => { 35 => 0x11 },
	'aebsequence' => { 40 => 0x105 },
	'aebsequenceautocancel' => { 38 => 0x9, 39 => 0x9, 41 => 0x8, 42 => 0x9, 45 => 0x9, 46 => 0x7 },
	'aebshotcount' => { 40 => 0x106 },
	'aebxv' => { 174 => 0x4 },
	'aeexposuretime' => { 174 => 0x0 },
	'aeextra' => { 174 => 0x7 },
	'aelock' => { 137 => '733.2', 138 => '752.2', 156 => 0x201, 185 => 0x48 },
	'aelockbutton' => { 137 => '733.1', 138 => '752.1' },
	'aemaxaperture' => { 174 => 0x9 },
	'aemaxaperture2' => { 174 => 0xa },
	'aemeteringmode' => { 174 => 0xc },
	'aemeteringsegments' => { 185 => 0x209 },
	'aeminaperture' => { 174 => 0xb },
	'aeminexposuretime' => { 174 => 0x5 },
	'aeprogrammode' => { 174 => 0x6 },
	'aesetting' => { 14 => 0x21 },
	'aexv' => { 174 => 0x3 },
	'af-cpriorityselection' => { 112 => '0.1' },
	'af-onformb-d10' => { 112 => '2.1' },
	'af-spriorityselection' => { 112 => '0.2' },
	'afactivation' => { 112 => '1.1' },
	'afadjustment' => { 185 => 0x72 },
	'afaperture' => { 126 => 0x5, 127 => 0x5 },
	'afarea' => { 198 => 0x11, 199 => 0x11 },
	'afareaillumination' => { 138 => '763.3' },
	'afareamode' => { 105 => 0xe, 110 => 0x0, 111 => 0x5, 138 => 0x2fc },
	'afareamodesetting' => { 137 => 0x2e4 },
	'afareas' => { 156 => 0x304 },
	'afassist' => { 38 => 0x5, 46 => 0x5, 137 => '729.2', 138 => '748.2' },
	'afassistbeam' => { 40 => 0x50e, 41 => 0x4, 42 => 0x5, 43 => 0x4, 44 => 0x4, 45 => 0x5 },
	'afassistilluminator' => { 112 => '1.4' },
	'afassistlamp' => { 172 => 0x31 },
	'afdefocus' => { 175 => 0x6 },
	'afduringliveview' => { 40 => 0x511 },
	'affinetuneadj' => { 135 => 0x2d1, 136 => 0x2dc, 156 => 0x307 },
	'afilluminator' => { 198 => 0x29 },
	'afintegrationtime' => { 175 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 40 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 172 => 0xf, 197 => 0x5 },
	'afonaelockbuttonswitch' => { 40 => 0x702 },
	'afpoint' => { 14 => 0x13, 59 => 0x18, 110 => 0x1, 159 => 0x308 },
	'afpointactivationarea' => { 39 => 0x11, 45 => 0x11 },
	'afpointareaexpansion' => { 40 => 0x508 },
	'afpointautoselection' => { 40 => 0x50b },
	'afpointbrightness' => { 40 => 0x50d },
	'afpointdisplayduringfocus' => { 40 => 0x50c },
	'afpointillumination' => { 39 => 0xa, 112 => '1.3' },
	'afpointmode' => { 178 => 0x3 },
	'afpointposition' => { 60 => 0x2021, 172 => 0x4d },
	'afpointregistration' => { 38 => 0x7 },
	'afpoints' => { 104 => 0x10 },
	'afpointselected' => { 185 => 0xe },
	'afpointselected2' => { 178 => 0x4 },
	'afpointselection' => { 39 => 0xb, 112 => '0.3' },
	'afpointselectionmethod' => { 40 => 0x50f, 41 => 0xc, 42 => 0xd, 45 => 0xd },
	'afpointsinfocus' => { 35 => 0xe, 110 => 0x2, 175 => 0xb, 185 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 11 => 0x38 },
	'afpointspotmetering' => { 39 => 0xd },
	'afpointsunknown1' => { 175 => 0x0 },
	'afpointsunknown2' => { 175 => 0x2 },
	'afpointsused' => { 111 => 0x8 },
	'afpredictor' => { 175 => 0x4 },
	'afresponse' => { 128 => 0xad },
	'afresult' => { 161 => 0x1038 },
	'afsearch' => { 156 => 0x303 },
	'afwithshutter' => { 198 => 0x2a },
	'aggregationtype' => { 220 => 'aggregationType' },
	'agreement' => { 222 => 'agreement' },
	'aiservocontinuousshooting' => { 39 => 0x15 },
	'aiservoimagepriority' => { 40 => 0x503 },
	'aiservotrackingmethod' => { 40 => 0x504 },
	'aiservotrackingsensitivity' => { 39 => 0x14, 40 => 0x502 },
	'album' => { 228 => 'album' },
	'alreadyapplied' => { 211 => 'AlreadyApplied' },
	'alternatetitle' => { 220 => 'alternateTitle' },
	'alttapename' => { 228 => 'altTapeName' },
	'alttimecodetimeformat' => { 228 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 228 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 228 => 'altTimecodeValue' },
	'anti-blur' => { 200 => 0xb04b },
	'antialiasstrength' => { 63 => 0xc632 },
	'aperturerange' => { 40 => 0x10d },
	'apertureringuse' => { 178 => '1.4' },
	'aperturevalue' => { 49 => 0x2, 63 => 0x9202, 161 => 0x1002, 214 => 'ApertureValue' },
	'applekeywords' => { 165 => 'AAPL:Keywords' },
	'applicationnotes' => { 63 => 0x2bc, 173 => 0x2bc },
	'applicationrecordversion' => { 69 => 0x0 },
	'applyshootingmeteringmode' => { 40 => 0x10e },
	'approximatefnumber' => { 170 => 0x313 },
	'armidentifier' => { 70 => 0x78 },
	'armversion' => { 70 => 0x7a },
	'artfilter' => { 156 => 0x529 },
	'artist' => { 63 => 0x13b, 167 => 'Artist', 224 => 'Artist', 228 => 'artist' },
	'artworkcopyrightnotice' => { 216 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 216 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 216 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 216 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 216 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 216 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 160 => 0x1113 },
	'aspectratio' => { 160 => 0x1112, 198 => 0x55 },
	'asshoticcprofile' => { 63 => 0xc68f },
	'asshotneutral' => { 63 => 0xc628 },
	'asshotpreprofilematrix' => { 63 => 0xc690 },
	'asshotprofilename' => { 63 => 0xc6f6 },
	'asshotwhitexy' => { 63 => 0xc629 },
	'assignfuncbutton' => { 40 => 0x70b },
	'assistbuttonfunction' => { 38 => 0xd },
	'attributionname' => { 210 => 'attributionName' },
	'attributionurl' => { 210 => 'attributionURL' },
	'audio' => { 172 => 0x20 },
	'audiochanneltype' => { 228 => 'audioChannelType' },
	'audiocompression' => { 87 => 'Compression' },
	'audiocompressor' => { 228 => 'audioCompressor' },
	'audioduration' => { 69 => 0x99 },
	'audiomoddate' => { 228 => 'audioModDate' },
	'audiooutcue' => { 69 => 0x9a },
	'audiosamplerate' => { 228 => 'audioSampleRate' },
	'audiosampletype' => { 228 => 'audioSampleType' },
	'audiosamplingrate' => { 69 => 0x97 },
	'audiosamplingresolution' => { 69 => 0x98 },
	'audiotype' => { 69 => 0x96 },
	'author' => { 89 => 'Author', 165 => 'Author', 167 => 'Author', 193 => 'Author', 217 => 'Author' },
	'authorsposition' => { 218 => 'AuthorsPosition' },
	'autoaperture' => { 182 => '0.1' },
	'autobracket' => { 197 => 0x19 },
	'autobracketing' => { 67 => 0x1100, 185 => 0x18 },
	'autobracketmodem' => { 112 => '20.2' },
	'autobracketorder' => { 112 => '20.3', 138 => '750.2' },
	'autobracketrelease' => { 128 => 0x8a },
	'autobracketset' => { 112 => '20.1', 138 => '750.1' },
	'autobrightness' => { 211 => 'AutoBrightness' },
	'autocontrast' => { 211 => 'AutoContrast' },
	'autoexposure' => { 211 => 'AutoExposure' },
	'autoexposurebracketing' => { 35 => 0x10 },
	'autofocus' => { 111 => 0x6, 159 => 0x209 },
	'autofp' => { 138 => '755.3' },
	'autoiso' => { 35 => 0x1, 60 => 0x3008, 137 => '730.1', 138 => '749.1' },
	'autoisomax' => { 137 => '730.2', 138 => '749.2' },
	'autoisominshutterspeed' => { 137 => '730.3', 138 => '749.3' },
	'autolightingoptimizer' => { 9 => 0xbe, 10 => 0xbf, 12 => 0xbf, 40 => 0x204, 58 => 0x6f },
	'autolightingoptimizeron' => { 58 => 0x6e },
	'autoredeye' => { 149 => 0xfe28a44f },
	'autorotate' => { 35 => 0x1b },
	'autoshadows' => { 211 => 'AutoShadows' },
	'auxiliarylens' => { 128 => 0x82 },
	'avaperturesetting' => { 178 => 0x13 },
	'avsettingwithoutlens' => { 40 => 0x707 },
	'azimuth' => { 97 => 'Azimuth' },
	'babyage' => { 172 => [0x8010,0x33] },
	'baseexposurecompensation' => { 178 => 0x15 },
	'baseiso' => { 35 => 0x2, 53 => 0x101c },
	'baselineexposure' => { 63 => 0xc62a },
	'baselinenoise' => { 63 => 0xc62b },
	'baselinesharpness' => { 63 => 0xc62c },
	'baseurl' => { 226 => 'BaseURL' },
	'batteryadbodyload' => { 176 => 0x3 },
	'batteryadbodynoload' => { 176 => 0x2 },
	'batteryadgripload' => { 176 => 0x5 },
	'batteryadgripnoload' => { 176 => 0x4 },
	'batteryorder' => { 112 => '11.3' },
	'batterystates' => { 176 => 0x1 },
	'bayergreensplit' => { 63 => 0xc62d },
	'bayerpattern' => { 73 => 0xf902, 107 => 0x17 },
	'beatspliceparamsriseindecibel' => { 228 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 228 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 228 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 228 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 112 => '12.1', 137 => '729.1', 138 => '748.1' },
	'bestqualityscale' => { 63 => 0xc65c },
	'bestshotmode' => { 60 => 0x3007 },
	'bitdepth' => { 94 => 'BitDepth', 107 => 0x11, 133 => 0x41 },
	'bitspercomponent' => { 71 => 0x87 },
	'bitspersample' => { 63 => 0x102, 224 => 'BitsPerSample' },
	'blacklevel' => { 63 => 0xc61a, 161 => 0x1012 },
	'blacklevel2' => { 160 => 0x600, 164 => 0x600 },
	'blackpoint' => { 185 => 0x200 },
	'bluebalance' => { 118 => 0x271, 161 => 0x1018, 173 => 0x12, 185 => 0x1b },
	'bluecurvelimits' => { 57 => 0x1fe },
	'bluecurvepoints' => { 57 => 0x1d4 },
	'bluehue' => { 211 => 'BlueHue' },
	'bluesaturation' => { 211 => 'BlueSaturation' },
	'blurwarning' => { 67 => 0x1300 },
	'bodyfirmwareversion' => { 157 => 0x104, 158 => 0x100, 161 => 0x104 },
	'bracketmode' => { 24 => 0x3 },
	'bracketsequence' => { 60 => 0x301d },
	'bracketshotnumber' => { 24 => 0x5, 178 => 0x9 },
	'bracketstep' => { 102 => 0xe },
	'bracketvalue' => { 24 => 0x4 },
	'brightness' => { 63 => 0xfe53, 88 => 'Brightness', 102 => 0x2c, 130 => 0x34, 198 => 0x22, 211 => 'Brightness' },
	'brightnessadj' => { 57 => 0x114, 142 => 0x0, 152 => 0x2d },
	'brightnessvalue' => { 63 => 0x9203, 161 => 0x1003, 214 => 'BrightnessValue' },
	'bulbduration' => { 35 => 0x18 },
	'burstmode' => { 75 => 0xa, 172 => 0x2a },
	'burstmode2' => { 75 => 0x18 },
	'buttonfunctioncontroloff' => { 40 => 0x70a },
	'bwfilter' => { 102 => 0x2a, 108 => 0x39 },
	'bwmode' => { 161 => 0x203 },
	'by-line' => { 69 => 0x50 },
	'by-linetitle' => { 69 => 0x55 },
	'bytecount' => { 220 => 'byteCount' },
	'calibrationilluminant1' => { 63 => 0xc65a },
	'calibrationilluminant2' => { 63 => 0xc65b },
	'cameracalibrationsig' => { 63 => 0xc6f3 },
	'cameracolorcalibration01' => { 16 => 0x4b, 17 => 0xa4, 18 => 0x85, 19 => 0xa8, 20 => 0xba },
	'cameracolorcalibration02' => { 16 => 0x4f, 17 => 0xa8, 18 => 0x89, 19 => 0xac, 20 => 0xbf },
	'cameracolorcalibration03' => { 16 => 0x53, 17 => 0xac, 18 => 0x8d, 19 => 0xb0, 20 => 0xc4 },
	'cameracolorcalibration04' => { 16 => 0x57, 17 => 0xb0, 18 => 0x91, 19 => 0xb4, 20 => 0xc9 },
	'cameracolorcalibration05' => { 16 => 0x5b, 17 => 0xb4, 18 => 0x95, 19 => 0xb8, 20 => 0xce },
	'cameracolorcalibration06' => { 16 => 0x5f, 17 => 0xb8, 18 => 0x99, 19 => 0xbc, 20 => 0xd3 },
	'cameracolorcalibration07' => { 16 => 0x63, 17 => 0xbc, 18 => 0x9d, 19 => 0xc0, 20 => 0xd8 },
	'cameracolorcalibration08' => { 16 => 0x67, 17 => 0xc0, 18 => 0xa1, 19 => 0xc4, 20 => 0xdd },
	'cameracolorcalibration09' => { 16 => 0x6b, 17 => 0xc4, 18 => 0xa5, 19 => 0xc8, 20 => 0xe2 },
	'cameracolorcalibration10' => { 16 => 0x6f, 17 => 0xc8, 18 => 0xa9, 19 => 0xcc, 20 => 0xe7 },
	'cameracolorcalibration11' => { 16 => 0x73, 17 => 0xcc, 18 => 0xad, 19 => 0xd0, 20 => 0xec },
	'cameracolorcalibration12' => { 16 => 0x77, 17 => 0xd0, 18 => 0xb1, 19 => 0xd4, 20 => 0xf1 },
	'cameracolorcalibration13' => { 16 => 0x7b, 17 => 0xd4, 18 => 0xb5, 19 => 0xd8, 20 => 0xf6 },
	'cameracolorcalibration14' => { 16 => 0x7f, 17 => 0xd8, 18 => 0xb9, 19 => 0xdc, 20 => 0xfb },
	'cameracolorcalibration15' => { 16 => 0x83, 17 => 0xdc, 18 => 0xbd, 19 => 0xe0, 20 => 0x100 },
	'cameraid' => { 161 => 0x209, 196 => 0x209 },
	'cameraiso' => { 14 => 0x10 },
	'cameraorientation' => { 2 => 0x30, 7 => 0x30, 8 => 0x30, 9 => 0x31, 10 => 0x31, 11 => 0x27, 12 => 0x31 },
	'cameraparameters' => { 161 => 0x2050 },
	'cameraprofile' => { 211 => 'CameraProfile' },
	'cameraprofiledigest' => { 211 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 63 => 0xc62f, 207 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 156 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x18, 8 => 0x18, 9 => 0x19, 10 => 0x19, 12 => 0x19, 170 => 0x320, 185 => 0x47 },
	'cameratype' => { 35 => 0x1a, 161 => 0x207 },
	'cameratype2' => { 157 => 0x100 },
	'canonexposuremode' => { 14 => 0x14 },
	'canonfiledescription' => { 53 => 0x805 },
	'canonfilelength' => { 27 => 0xe },
	'canonfirmwareversion' => { 27 => 0x7, 53 => 0x80b },
	'canonflashinfo' => { 53 => 0x1028 },
	'canonflashmode' => { 14 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 14 => 0xa },
	'canonimagetype' => { 27 => 0x6, 53 => 0x815 },
	'canonmodelid' => { 27 => 0x10, 53 => 0x1834 },
	'canonvrd' => { 64 => 'CanonVRD' },
	'caption-abstract' => { 69 => 0x78 },
	'captionwriter' => { 218 => 'CaptionWriter' },
	'casioimagesize' => { 60 => 0x9 },
	'catalogsets' => { 206 => 'CatalogSets' },
	'categories' => { 27 => 0x23 },
	'category' => { 69 => 0xf, 218 => 'Category' },
	'ccdboardversion' => { 170 => 0x331 },
	'ccdscanmode' => { 161 => 0x1039 },
	'ccdsensitivity' => { 139 => 0x6 },
	'ccdversion' => { 170 => 0x330 },
	'celllength' => { 63 => 0x109 },
	'cellwidth' => { 63 => 0x108 },
	'centerafarea' => { 138 => '763.1' },
	'centerweightedareasize' => { 112 => '6.1', 138 => '754.3' },
	'certificate' => { 232 => 'Certificate' },
	'cfapattern' => { 63 => 0xa302 },
	'cfapatterncolumns' => { 214 => 'CFAPatternColumns' },
	'cfapatternrows' => { 214 => 'CFAPatternRows' },
	'cfapatternvalues' => { 214 => 'CFAPatternValues' },
	'channel' => { 220 => 'channel' },
	'channels' => { 87 => 'Channels' },
	'checkmark' => { 57 => 0x26a },
	'childfontfiles' => { 233 => 'FontsChildFontFiles' },
	'chromablurradius' => { 63 => 0xc631 },
	'chromaticaberration' => { 58 => 0x66 },
	'chromaticaberrationb' => { 211 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 58 => 0x6b },
	'chromaticaberrationon' => { 58 => 0x62 },
	'chromaticaberrationr' => { 211 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 58 => 0x6a },
	'chrominancenoisereduction' => { 58 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 58 => 0x60 },
	'city' => { 69 => 0x5a, 93 => 'City', 218 => 'City' },
	'clarity' => { 211 => 'Clarity' },
	'classifystate' => { 69 => 0xe1 },
	'clmodeshootingspeed' => { 112 => '9.2' },
	'cmcontrast' => { 164 => 0x2022 },
	'cmexposurecompensation' => { 164 => 0x2000 },
	'cmhue' => { 164 => 0x2021 },
	'cmsaturation' => { 164 => 0x2020 },
	'cmsharpness' => { 164 => 0x2023 },
	'cmwhitebalance' => { 164 => 0x2001 },
	'cmwhitebalancecomp' => { 164 => 0x2002 },
	'cmwhitebalancegraypoint' => { 164 => 0x2010 },
	'codec' => { 101 => 'Codec' },
	'codedcharacterset' => { 70 => 0x5a },
	'coloraberrationcontrol' => { 149 => 0xc89224b },
	'coloradjustment' => { 197 => 0x14 },
	'coloradjustmentmode' => { 196 => 0x210 },
	'coloranta' => { 233 => 'ColorantsA' },
	'colorantb' => { 233 => 'ColorantsB' },
	'colorantblack' => { 233 => 'ColorantsBlack' },
	'colorantblue' => { 233 => 'ColorantsBlue' },
	'colorantcyan' => { 233 => 'ColorantsCyan' },
	'colorantgreen' => { 233 => 'ColorantsGreen' },
	'colorantl' => { 233 => 'ColorantsL' },
	'colorantmagenta' => { 233 => 'ColorantsMagenta' },
	'colorantmode' => { 233 => 'ColorantsMode' },
	'colorantred' => { 233 => 'ColorantsRed' },
	'colorantswatchname' => { 233 => 'ColorantsSwatchName' },
	'coloranttype' => { 233 => 'ColorantsType' },
	'colorantyellow' => { 233 => 'ColorantsYellow' },
	'colorbalance' => { 88 => 'ColorBalance' },
	'colorbalanceadj' => { 149 => 0x76a43202 },
	'colorbalanceblue' => { 102 => 0x1e },
	'colorbalancegreen' => { 102 => 0x1d },
	'colorbalancered' => { 102 => 0x1c },
	'colorblur' => { 58 => 0x65 },
	'colorbooster' => { 149 => 0x5f0e7d23 },
	'colorboostlevel' => { 143 => 0x1 },
	'colorboosttype' => { 143 => 0x0 },
	'colorclass' => { 188 => 0xde },
	'colorcompensationfilter' => { 200 => 0xb022 },
	'colorcontrol' => { 161 => 0x102b },
	'colordataversion' => { 18 => 0x0, 19 => 0x0 },
	'coloreffect' => { 172 => 0x28 },
	'colorfilter' => { 59 => 0x17, 102 => 0x29, 108 => 0x38, 187 => 0x17 },
	'colorgain' => { 133 => 0x51 },
	'colorhue' => { 128 => 0x8d },
	'colorimetricreference' => { 63 => 0xc6bf },
	'colormatrix' => { 160 => 0x200, 161 => 0x1011 },
	'colormatrix2' => { 164 => 0x200 },
	'colormatrixa' => { 185 => 0x203 },
	'colormatrixb' => { 185 => 0x204 },
	'colormatrixnumber' => { 161 => 0x1019 },
	'colormode' => { 60 => 0x3015, 67 => 0x1210, 75 => 0x66, 102 => 0x28, 105 => 0x16, 106 => 0x101, 108 => 0x7, 128 => 0x3, 139 => 0x4, 172 => 0x32, 200 => 0xb029, 218 => 'ColorMode' },
	'colormoirereduction' => { 150 => 0x15 },
	'colormoirereductionmode' => { 150 => 0x5 },
	'colornoisereduction' => { 211 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 150 => 0x18 },
	'colornoisereductionsharpness' => { 150 => 0x1c },
	'colorplanes' => { 66 => 0x2 },
	'colorprofile' => { 102 => 0x33 },
	'colorrepresentation' => { 71 => 0x3c },
	'colorreproduction' => { 200 => 0xb020 },
	'colorsequence' => { 71 => 0x41 },
	'colorspace' => { 21 => 0x3, 27 => 0xb4, 53 => 0x10b4, 63 => 0xa001, 94 => 'ColorSpace', 103 => 0x2f, 104 => 0x25, 128 => 0x1e, 156 => 0x507, 185 => 0x37, 197 => 0xb, 214 => 'ColorSpace' },
	'colortempasshot' => { 16 => 0x1d, 17 => 0x26, 18 => 0x43, 19 => 0x43, 20 => 0x4b },
	'colortempauto' => { 16 => 0x22, 17 => 0x1c, 18 => 0x48, 19 => 0x48, 20 => 0x50 },
	'colortempcloudy' => { 16 => 0x31, 17 => 0x35, 18 => 0x5c, 19 => 0x61, 20 => 0x69 },
	'colortempcustom' => { 18 => 0x84 },
	'colortempcustom1' => { 16 => 0x45 },
	'colortempcustom2' => { 16 => 0x4a },
	'colortempdaylight' => { 16 => 0x27, 17 => 0x2b, 18 => 0x52, 19 => 0x57, 20 => 0x5f },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 7 => 0x73, 8 => 0x73, 9 => 0x77, 10 => 0x73, 11 => 0x58, 12 => 0x73, 27 => 0xae, 33 => 0x9, 53 => 0x10ae, 67 => 0x1005, 74 => 0x846, 88 => 'ColorTemperature', 103 => [0x6e,0x49], 104 => 0x3f, 105 => 0x5e, 106 => 0x10b, 108 => 0x3c, 170 => 0x321, 185 => 0x50, 200 => 0xb021 },
	'colortemperaturebg' => { 161 => 0x1013 },
	'colortemperaturerg' => { 161 => 0x1014 },
	'colortempflash' => { 16 => 0x40, 17 => 0x49, 18 => 0x70, 19 => 0x75, 20 => 0x7d },
	'colortempflashdata' => { 18 => 0x24a },
	'colortempfluorescent' => { 16 => 0x3b, 17 => 0x3f, 18 => 0x66, 19 => 0x6b, 20 => 0x73 },
	'colortempkelvin' => { 17 => 0x44, 18 => 0x6b, 19 => 0x70, 20 => 0x78 },
	'colortempmeasured' => { 18 => 0x4d, 19 => 0x4d, 20 => 0x55 },
	'colortemppc1' => { 17 => 0x94, 18 => 0x75 },
	'colortemppc2' => { 17 => 0x99, 18 => 0x7a },
	'colortemppc3' => { 17 => 0x9e, 18 => 0x7f },
	'colortempshade' => { 16 => 0x2c, 17 => 0x30, 18 => 0x57, 19 => 0x5c, 20 => 0x64 },
	'colortemptungsten' => { 16 => 0x36, 17 => 0x3a, 18 => 0x61, 19 => 0x66, 20 => 0x6e },
	'colortempunknown' => { 17 => 0x21, 19 => 0x52, 20 => 0x5a },
	'colortempunknown10' => { 17 => 0x76, 19 => 0xa2, 20 => 0xaa },
	'colortempunknown11' => { 17 => 0x7b, 19 => 0xa7, 20 => 0xaf },
	'colortempunknown12' => { 17 => 0x80, 20 => 0xb4 },
	'colortempunknown13' => { 17 => 0x85, 20 => 0xb9 },
	'colortempunknown14' => { 17 => 0x8a },
	'colortempunknown15' => { 17 => 0x8f },
	'colortempunknown16' => { 17 => 0xa3 },
	'colortempunknown2' => { 17 => 0x4e, 19 => 0x7a, 20 => 0x82 },
	'colortempunknown3' => { 17 => 0x53, 19 => 0x7f, 20 => 0x87 },
	'colortempunknown4' => { 17 => 0x58, 19 => 0x84, 20 => 0x8c },
	'colortempunknown5' => { 17 => 0x5d, 19 => 0x89, 20 => 0x91 },
	'colortempunknown6' => { 17 => 0x62, 19 => 0x8e, 20 => 0x96 },
	'colortempunknown7' => { 17 => 0x67, 19 => 0x93, 20 => 0x9b },
	'colortempunknown8' => { 17 => 0x6c, 19 => 0x98, 20 => 0xa0 },
	'colortempunknown9' => { 17 => 0x71, 19 => 0x9d, 20 => 0xa5 },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 14 => 0x2a, 21 => 0x2 },
	'colortoneadj' => { 57 => 0x11e },
	'colortonefaithful' => { 11 => 0x107 },
	'colortonelandscape' => { 11 => 0x105 },
	'colortoneneutral' => { 11 => 0x106 },
	'colortoneportrait' => { 11 => 0x104 },
	'colortonestandard' => { 11 => 0x103 },
	'colortoneuserdef1' => { 11 => 0x109 },
	'colortoneuserdef2' => { 11 => 0x10a },
	'colortoneuserdef3' => { 11 => 0x10b },
	'commanddials' => { 138 => '753.1' },
	'commanddialsaperturesetting' => { 112 => '16.3' },
	'commanddialschangemainsub' => { 112 => '16.2' },
	'commanddialsmenuandplayback' => { 112 => '16.4' },
	'commanddialsreverserotation' => { 112 => '16.1' },
	'commanderchannel' => { 138 => '758.2' },
	'commandergroupa_manualoutput' => { 138 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 138 => '761.1' },
	'commandergroupamode' => { 138 => '759.2' },
	'commandergroupb_manualoutput' => { 138 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 138 => '762.1' },
	'commandergroupbmode' => { 138 => '759.3' },
	'commanderinternalflash' => { 138 => '759.1' },
	'commanderinternalmanualoutput' => { 138 => '760.2' },
	'commanderinternalttlcomp' => { 138 => '760.1' },
	'comment' => { 0 => 0x2, 64 => 'Comment', 89 => 'Comment', 167 => 'Comment' },
	'complianceprofile' => { 220 => 'complianceProfile' },
	'componentsconfiguration' => { 63 => 0x9101, 94 => 'Components', 214 => 'ComponentsConfiguration' },
	'componentversion' => { 53 => 0x80c },
	'composer' => { 228 => 'composer' },
	'compressedbitsperpixel' => { 63 => 0x9102, 214 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 106 => 0x40, 161 => 0x40 },
	'compression' => { 63 => 0x103, 224 => 'Compression' },
	'compressionfactor' => { 156 => 0x50d },
	'compressionratio' => { 94 => 'Compression', 161 => 0x1034 },
	'constrainedcropheight' => { 57 => 0x266, 188 => 0xd6 },
	'constrainedcropwidth' => { 57 => 0x262, 188 => 0xd5 },
	'contact' => { 69 => 0x76 },
	'contentlocationcode' => { 69 => 0x1a },
	'contentlocationname' => { 69 => 0x1b },
	'continuousdrive' => { 14 => 0x5 },
	'continuousshootingspeed' => { 40 => 0x610 },
	'continuousshotlimit' => { 40 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 14 => 0xd, 59 => 0xc, 60 => [0x3012,0x20], 63 => [0xa408,0xfe54], 67 => [0x1004,0x1006], 88 => 'Contrast', 102 => 0x20, 103 => 0x31, 104 => 0x27, 105 => 0x19, 108 => 0x2, 130 => 0x33, 161 => 0x1029, 172 => [0x2c,0x39], 185 => 0x20, 187 => 0xc, 197 => 0xd, 198 => 0x1d, 199 => 0x1a, 211 => 'Contrast', 214 => 'Contrast' },
	'contrastadj' => { 57 => 0x115, 152 => 0x2c },
	'contrastfaithful' => { 11 => 0xec },
	'contrastlandscape' => { 11 => 0xea },
	'contrastmonochrome' => { 11 => 0xed },
	'contrastneutral' => { 11 => 0xeb },
	'contrastportrait' => { 11 => 0xe9 },
	'contrastsetting' => { 156 => 0x505, 164 => 0x1012 },
	'contraststandard' => { 11 => 0xe8 },
	'contrastuserdef1' => { 11 => 0xee },
	'contrastuserdef2' => { 11 => 0xef },
	'contrastuserdef3' => { 11 => 0xf0 },
	'contributedmediadurationscale' => { 228 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 228 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 228 => 'contributedMediaManaged' },
	'contributedmediapath' => { 228 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 228 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 228 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 228 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 228 => 'contributedMediaWebStatement' },
	'contributor' => { 212 => 'contributor' },
	'contributors' => { 89 => 'Contributors' },
	'controlledvocabularyterm' => { 216 => 'CVterm' },
	'controllerboardversion' => { 170 => 0x332 },
	'controlmode' => { 35 => 0x12 },
	'conversionlens' => { 172 => 0x35 },
	'converter' => { 63 => 0xfe4d, 139 => 0xb, 211 => 'Converter' },
	'converttograyscale' => { 211 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 63 => 0x8298, 89 => 'Copyright', 167 => 'Copyright', 193 => 'Copyright', 217 => 'Copyright', 220 => 'copyright', 222 => 'copyright', 224 => 'Copyright', 228 => 'copyright' },
	'copyrightflag' => { 191 => 0x40a },
	'copyrightnotice' => { 69 => 0x74 },
	'copyrightownerid' => { 219 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 219 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 219 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 219 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 219 => 'CopyrightStatus' },
	'coringfilter' => { 160 => 0x310, 161 => 0x102d, 164 => 0x310 },
	'coringvalues' => { 160 => 0x311, 164 => 0x311 },
	'corporateentity' => { 220 => 'corporateEntity' },
	'country' => { 93 => 'Country', 218 => 'Country' },
	'country-primarylocationcode' => { 69 => 0x64 },
	'country-primarylocationname' => { 69 => 0x65 },
	'countrycode' => { 189 => 'CountryCode', 215 => 'CountryCode' },
	'coverage' => { 212 => 'coverage' },
	'coverdate' => { 220 => 'coverDate' },
	'coverdisplaydate' => { 220 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 185 => 0x28 },
	'crc32' => { 213 => 'crc32' },
	'createdate' => { 63 => 0x9004, 89 => 'CreateDate', 165 => 'CreationDate', 193 => 'CreationDate', 226 => 'CreateDate' },
	'creationdate' => { 217 => 'CreationDate', 220 => 'creationDate' },
	'creationtime' => { 167 => 'Creation Time' },
	'creativestyle' => { 198 => 0x1a, 199 => 0x18 },
	'creator' => { 165 => 'Creator', 193 => 'Creator', 212 => 'creator', 217 => 'Creator' },
	'creatoraddress' => { 215 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 215 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 215 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 215 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 215 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 226 => 'CreatorTool' },
	'creatorworkemail' => { 215 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 215 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 215 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 69 => 0x6e, 218 => 'Credit' },
	'creditline' => { 222 => 'creditLine' },
	'creditlinereq' => { 231 => 'CreditLineReq' },
	'creditlinerequired' => { 219 => 'CreditLineRequired' },
	'cropactive' => { 57 => 0x244 },
	'cropangle' => { 211 => 'CropAngle' },
	'cropaspectratio' => { 57 => 0x260 },
	'cropbottom' => { 66 => 0x9, 144 => 0x36, 188 => 0xdc, 211 => 'CropBottom' },
	'cropheight' => { 57 => 0x24c, 160 => 0x615, 164 => 0x615, 211 => 'CropHeight' },
	'crophispeed' => { 128 => 0x1b },
	'cropleft' => { 57 => 0x246, 66 => 0x6, 144 => 0x1e, 160 => 0x612, 164 => 0x612, 188 => 0xd9, 211 => 'CropLeft' },
	'cropoutputheight' => { 144 => 0xce },
	'cropoutputheightinches' => { 144 => 0x96 },
	'cropoutputpixels' => { 144 => 0xd6 },
	'cropoutputresolution' => { 144 => 0xb6 },
	'cropoutputscale' => { 144 => 0xbe },
	'cropoutputwidth' => { 144 => 0xc6 },
	'cropoutputwidthinches' => { 144 => 0x8e },
	'cropright' => { 66 => 0x8, 144 => 0x2e, 188 => 0xdb, 211 => 'CropRight' },
	'croprotation' => { 66 => 0xb },
	'cropscaledresolution' => { 144 => 0x9e },
	'cropsourceresolution' => { 144 => 0xae },
	'croptop' => { 57 => 0x248, 66 => 0x7, 144 => 0x26, 160 => 0x613, 164 => 0x613, 188 => 0xda, 211 => 'CropTop' },
	'cropunit' => { 211 => 'CropUnit' },
	'cropunits' => { 211 => 'CropUnits' },
	'cropwidth' => { 57 => 0x24a, 160 => 0x614, 164 => 0x614, 211 => 'CropWidth' },
	'currenticcprofile' => { 63 => 0xc691 },
	'currentpreprofilematrix' => { 63 => 0xc692 },
	'curves' => { 149 => 0x76a43201 },
	'custom1' => { 219 => 'Custom1' },
	'custom10' => { 219 => 'Custom10' },
	'custom2' => { 219 => 'Custom2' },
	'custom3' => { 219 => 'Custom3' },
	'custom4' => { 219 => 'Custom4' },
	'custom5' => { 219 => 'Custom5' },
	'custom6' => { 219 => 'Custom6' },
	'custom7' => { 219 => 'Custom7' },
	'custom8' => { 219 => 'Custom8' },
	'custom9' => { 219 => 'Custom9' },
	'customrendered' => { 63 => 0xa401, 214 => 'CustomRendered' },
	'customsaturation' => { 156 => 0x503 },
	'd-lightinghq' => { 149 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 145 => 0x2 },
	'd-lightinghqhighlight' => { 145 => 0x1 },
	'd-lightinghqselected' => { 149 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 145 => 0x0 },
	'd-lightinghs' => { 149 => 0xce5554aa },
	'd-lightinghsadjustment' => { 146 => 0x0 },
	'd-lightinghscolorboost' => { 146 => 0x1 },
	'datacompressionmethod' => { 71 => 0x6e },
	'dataimprint' => { 102 => 0x34 },
	'date' => { 185 => 0x6, 212 => 'date' },
	'dateacquired' => { 207 => 'DateAcquired' },
	'datecreated' => { 69 => 0x37, 218 => 'DateCreated' },
	'datedisplayformat' => { 141 => 0x3 },
	'daterecieved' => { 220 => 'dateRecieved' },
	'datesent' => { 70 => 0x46 },
	'datestampmode' => { 27 => 0x1c },
	'datetime' => { 224 => 'DateTime' },
	'datetimedigitized' => { 214 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 56 => 0x0, 63 => 0x9003, 86 => 0x14, 89 => 'OriginalDate', 214 => 'DateTimeOriginal' },
	'datetimestamp' => { 75 => 0x64 },
	'daylightsavings' => { 141 => 0x2 },
	'declination' => { 97 => 'Declination' },
	'decposition' => { 102 => 0x32 },
	'defaultcroporigin' => { 63 => 0xc61f },
	'defaultcropsize' => { 63 => 0xc620 },
	'defaultscale' => { 63 => 0xc61e },
	'defringe' => { 211 => 'Defringe' },
	'deletedimagecount' => { 128 => 0xa6, 134 => 0x6e },
	'derivedfromalternatepaths' => { 229 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 229 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 229 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 229 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 229 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 229 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 229 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 229 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 229 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 229 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 229 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 229 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 229 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 229 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 229 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 229 => 'DerivedFromVersionID' },
	'description' => { 167 => 'Description', 212 => 'description' },
	'destination' => { 70 => 0x5 },
	'destinationcity' => { 185 => 0x24 },
	'destinationcitycode' => { 187 => 0x1001 },
	'destinationdst' => { 185 => 0x26 },
	'developmentdynamicrange' => { 67 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 214 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 214 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 214 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 40 => 0x706 },
	'digitalcreationdate' => { 69 => 0x3e },
	'digitalcreationtime' => { 69 => 0x3f },
	'digitaldeehighlightadj' => { 133 => 0x202 },
	'digitaldeeshadowadj' => { 133 => 0x200 },
	'digitaldeethreshold' => { 133 => 0x201 },
	'digitalgain' => { 33 => 0xb },
	'digitalgem' => { 123 => 0x0 },
	'digitalice' => { 133 => 0x100 },
	'digitalimageguid' => { 216 => 'DigImageGUID' },
	'digitalroc' => { 132 => 0x0 },
	'digitalsourcefiletype' => { 216 => 'DigitalSourcefileType' },
	'digitalzoom' => { 14 => 0xc, 59 => 0xa, 75 => 0x68, 88 => 'DigitalZoom', 102 => 0xc, 128 => 0x86, 139 => 0xa, 161 => 0x204, 185 => 0x1e, 187 => 0xa, 196 => 0x204 },
	'digitalzoomon' => { 196 => 0x21b },
	'digitalzoomratio' => { 63 => 0xa404, 214 => 'DigitalZoomRatio' },
	'directory' => { 64 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 7 => 0x13f, 8 => 0x133, 9 => 0x1df, 10 => [0x1a3,0x1a7], 12 => [0x1a3,0x1c7] },
	'directorynumber' => { 119 => 0x6 },
	'disclaimer' => { 167 => 'Disclaimer' },
	'displayaperture' => { 14 => 0x23 },
	'displayedunitsx' => { 192 => 0x2 },
	'displayedunitsy' => { 192 => 0x6 },
	'distance1' => { 75 => 0x28 },
	'distance2' => { 75 => 0x2c },
	'distance3' => { 75 => 0x30 },
	'distance4' => { 75 => 0x34 },
	'distortioncorrection' => { 58 => 0x67, 156 => 0x50b },
	'distortioncorrection2' => { 160 => 0x1011 },
	'distortioncorrectionon' => { 58 => 0x63 },
	'distributor' => { 220 => 'distributor' },
	'dngbackwardversion' => { 63 => 0xc613 },
	'dnglensinfo' => { 63 => 0xc630 },
	'dngversion' => { 63 => 0xc612 },
	'document' => { 167 => 'Document' },
	'documenthistory' => { 69 => 0xe7 },
	'documentid' => { 229 => 'DocumentID' },
	'documentname' => { 63 => 0x10d },
	'documentnotes' => { 69 => 0xe6 },
	'doi' => { 220 => 'doi' },
	'dotrange' => { 63 => 0x150 },
	'drivemode' => { 102 => 0x6, 105 => 0x1e, 156 => 0x600, 185 => 0x34, 197 => 0x3, 198 => 0x4 },
	'drivemode2' => { 178 => 0x7 },
	'dspfirmwareversion' => { 185 => 0x27 },
	'duration' => { 87 => 'Duration', 101 => 'Duration' },
	'durationscale' => { 228 => 'durationScale' },
	'durationvalue' => { 228 => 'durationValue' },
	'dynamicafarea' => { 112 => '0.4' },
	'dynamicrange' => { 67 => 0x1400 },
	'dynamicrangeexpansion' => { 185 => 0x69 },
	'dynamicrangemax' => { 57 => 0x7c },
	'dynamicrangemin' => { 57 => 0x7a },
	'dynamicrangeoptimizer' => { 105 => 0x27, 200 => 0xb025 },
	'dynamicrangeoptimizerlevel' => { 198 => 0x19, 199 => 0x17 },
	'dynamicrangeoptimizermode' => { 198 => 0x18, 199 => 0x16 },
	'dynamicrangesetting' => { 67 => 0x1402 },
	'e-dialinprogram' => { 178 => '1.3' },
	'easyexposurecompensation' => { 112 => '5.4' },
	'easymode' => { 14 => 0xb },
	'edgenoisereduction' => { 150 => 0x4 },
	'edition' => { 220 => 'edition' },
	'editorialupdate' => { 69 => 0x8 },
	'editstatus' => { 69 => 0x7, 189 => 'EditStatus' },
	'effectivelv' => { 185 => 0x2d },
	'effectivemaxaperture' => { 126 => 0x12, 127 => 0x13 },
	'eissn' => { 220 => 'eIssn' },
	'elevation' => { 97 => 'Elevation' },
	'email' => { 89 => 'EMail' },
	'embargodate' => { 220 => 'embargoDate', 222 => 'embargoDate' },
	'endingpage' => { 220 => 'endingPage' },
	'enduserid' => { 219 => 'EndUserEndUserID' },
	'endusername' => { 219 => 'EndUserEndUserName' },
	'engineer' => { 228 => 'engineer' },
	'enhancedarktones' => { 142 => 0x8 },
	'enhancement' => { 59 => 0x16, 60 => 0x3016 },
	'enhancer' => { 160 => 0x300 },
	'enhancervalues' => { 160 => 0x301 },
	'envelopenumber' => { 70 => 0x28 },
	'envelopepriority' => { 70 => 0x3c },
	'enveloperecordversion' => { 70 => 0x0 },
	'epsonimageheight' => { 161 => 0x20c },
	'epsonimagewidth' => { 161 => 0x20b },
	'epsonsoftware' => { 161 => 0x20d },
	'equipmentinstitution' => { 203 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 203 => 'EquipmentManufacturer' },
	'equipmentversion' => { 157 => 0x0 },
	'ettlii' => { 40 => 0x304, 41 => 0xd, 42 => 0xe, 43 => 0x7, 44 => 0x7, 45 => 0xe },
	'event' => { 206 => 'Event', 216 => 'Event', 220 => 'event' },
	'evsteps' => { 178 => '1.2', 180 => 0x0 },
	'evstepsize' => { 138 => '748.7' },
	'exclusivityenddate' => { 222 => 'exclusivityEndDate' },
	'excursiontolerance' => { 71 => 0x82 },
	'exif' => { 64 => 'EXIF' },
	'exifbyteorder' => { 64 => 'ExifByteOrder' },
	'exifcamerainfo' => { 69 => 0xe8 },
	'exifimageheight' => { 63 => 0xa003, 214 => 'PixelYDimension' },
	'exifimagewidth' => { 63 => 0xa002, 214 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 64 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 63 => 0x9000, 214 => 'ExifVersion' },
	'exitpupilposition' => { 126 => 0x4, 127 => 0x4 },
	'expirationdate' => { 69 => 0x25, 220 => 'expirationDate', 222 => 'expirationDate' },
	'expirationtime' => { 69 => 0x26 },
	'exposure' => { 63 => 0xfe51, 211 => 'Exposure' },
	'exposureadj' => { 147 => 0x0 },
	'exposureadj2' => { 147 => 0x12 },
	'exposurebracketstepsize' => { 178 => 0x8 },
	'exposurebracketvalue' => { 128 => 0x19 },
	'exposurecompensation' => { 35 => 0x6, 49 => 0x0, 63 => 0x9204, 75 => 0x24, 88 => 'ExposureComp', 102 => 0xd, 103 => 0x53, 104 => 0x1e, 105 => 0x1, 161 => 0x1006, 185 => 0x16, 197 => [0xc,0x35], 214 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 105 => 0x47 },
	'exposurecontrolstepsize' => { 112 => '5.2' },
	'exposuredelaymode' => { 112 => '9.1', 138 => '754.4' },
	'exposuredifference' => { 128 => 0xe },
	'exposureindex' => { 63 => 0xa215, 214 => 'ExposureIndex' },
	'exposurelevelincrements' => { 38 => 0x6, 39 => 0x6, 40 => 0x101, 41 => 0x5, 42 => 0x6, 43 => 0x5, 44 => 0x5, 45 => 0x6, 46 => 0x4, 198 => 0x58 },
	'exposuremode' => { 63 => 0xa402, 88 => 'ExposureMode', 102 => 0x1, 103 => 0xa, 104 => 0x0, 105 => 0x0, 156 => 0x200, 197 => 0x8, 200 => 0xb041, 214 => 'ExposureMode' },
	'exposuremodeinmanual' => { 40 => 0x10b },
	'exposureprogram' => { 63 => 0x8822, 198 => 0x3c, 199 => 0x3c, 214 => 'ExposureProgram' },
	'exposureshift' => { 156 => 0x203 },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x6, 35 => 0x16, 63 => 0x829a, 73 => 0xfd05, 75 => 0x20, 76 => 0xfa24, 78 => 0xf104, 81 => 0x12, 83 => 0x38, 86 => 0x10, 88 => 'ExposureTime', 102 => 0x9, 103 => 0x35, 104 => 0x48, 185 => 0x12, 197 => 0x32, 214 => 'ExposureTime' },
	'exposuretime2' => { 197 => 0x33 },
	'exposurevalue' => { 74 => 0x3 },
	'exposurewarning' => { 67 => 0x1302 },
	'exrauto' => { 67 => 0x1033 },
	'exrmode' => { 67 => 0x1034 },
	'extendedwbdetect' => { 156 => 0x902 },
	'extender' => { 157 => 0x301 },
	'extenderfirmwareversion' => { 157 => 0x304 },
	'extendermagnification' => { 90 => 'Magnification' },
	'extendermake' => { 90 => 'Make' },
	'extendermodel' => { 90 => 'Model', 157 => 0x303 },
	'extenderserialnumber' => { 90 => 'SerialNumber', 157 => 0x302 },
	'externalflash' => { 159 => 0x1201 },
	'externalflashae1' => { 161 => 0x101f },
	'externalflashae1_0' => { 161 => 0x101b },
	'externalflashae2' => { 161 => 0x1020 },
	'externalflashae2_0' => { 161 => 0x101c },
	'externalflashbounce' => { 159 => 0x1204, 161 => 0x1026, 181 => 0x1a },
	'externalflashexposurecomp' => { 181 => 0x19 },
	'externalflashfirmware' => { 120 => 0x6, 121 => 0x6, 122 => 0x6 },
	'externalflashflags' => { 120 => 0x8, 121 => 0x8, 122 => 0x8 },
	'externalflashguidenumber' => { 159 => 0x1203, 181 => '24.1' },
	'externalflashgvalue' => { 161 => 0x1025 },
	'externalflashmode' => { 161 => 0x1028, 181 => 0x2 },
	'externalflashzoom' => { 159 => 0x1205, 161 => 0x1027 },
	'externalsensorbrightnessvalue' => { 170 => 0x311 },
	'face0position' => { 22 => 0x8 },
	'face1position' => { 22 => 0xa, 168 => 0x1 },
	'face2position' => { 22 => 0xc, 168 => 0x5 },
	'face3position' => { 22 => 0xe, 168 => 0x9 },
	'face4position' => { 22 => 0x10, 168 => 0xd },
	'face5position' => { 22 => 0x12, 168 => 0x11 },
	'face6position' => { 22 => 0x14 },
	'face7position' => { 22 => 0x16 },
	'face8position' => { 22 => 0x18 },
	'facedetect' => { 160 => 0x1200 },
	'facedetectarea' => { 160 => 0x1201 },
	'facedetectframeheight' => { 22 => 0x4 },
	'facedetectframewidth' => { 22 => 0x3 },
	'facepositions' => { 67 => 0x4103 },
	'facesdetected' => { 22 => 0x2, 23 => 0x2, 67 => 0x4100, 172 => 0x3f },
	'facesrecognized' => { 169 => 0x0 },
	'ffid' => { 213 => 'ffid' },
	'fieldcount' => { 161 => 0x103f },
	'filedatarate' => { 228 => 'fileDataRate' },
	'fileformat' => { 51 => 0x0, 70 => 0x14 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 7 => 0x133, 8 => 0x13f, 9 => 0x1d3, 10 => [0x197,0x19b], 12 => [0x197,0x1bb] },
	'filemodifydate' => { 64 => 'FileModifyDate' },
	'filename' => { 64 => 'FileName' },
	'filenameasdelivered' => { 219 => 'FileNameAsDelivered' },
	'filenumber' => { 24 => 0x1, 27 => 0x8, 53 => 0x1817, 119 => 0x8 },
	'filenumbermemory' => { 102 => 0x1a },
	'filenumbersequence' => { 112 => '11.2' },
	'filesource' => { 63 => 0xa300, 67 => 0x8000, 214 => 'FileSource' },
	'fileversion' => { 70 => 0x16 },
	'fillflashautoreduction' => { 38 => 0xe, 39 => 0xe, 46 => 0xa },
	'filllight' => { 211 => 'FillLight' },
	'fillorder' => { 63 => 0x10a },
	'filmmode' => { 67 => 0x1401, 172 => 0x42 },
	'filmtype' => { 133 => 0x2 },
	'filter' => { 60 => 0x3017 },
	'filtereffect' => { 24 => 0xe, 130 => 0x37 },
	'filtereffectmonochrome' => { 11 => 0xff },
	'finderdisplayduringexposure' => { 39 => 0x1 },
	'finetuneoptcenterweighted' => { 112 => '6.2' },
	'finetuneoptmatrixmetering' => { 112 => '7.1' },
	'finetuneoptspotmetering' => { 112 => '7.2' },
	'finetunestepsize' => { 112 => '5.3' },
	'firmware' => { 161 => 0x405, 197 => [0x17,0x3b], 209 => 'Firmware' },
	'firmwaredate' => { 59 => 0x15, 60 => 0x2001 },
	'firmwareid' => { 107 => 0x0 },
	'firmwarerevision' => { 11 => 0xa4, 27 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 7 => 0xff, 8 => 0x107, 74 => 0xce5, 86 => 0x57, 88 => 'FirmwareVersion', 172 => 0x2 },
	'firstpublicationdate' => { 219 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 69 => 0x16 },
	'flash' => { 63 => 0x9209, 103 => 0x1f, 104 => 0x15 },
	'flashactivity' => { 14 => 0x1c },
	'flashbatterylevel' => { 18 => 0x249 },
	'flashbias' => { 172 => 0x24 },
	'flashbits' => { 14 => 0x1d },
	'flashchargelevel' => { 161 => 0x1010 },
	'flashcommandermode' => { 120 => '9.1', 121 => '9.1', 122 => '9.1' },
	'flashcompensation' => { 209 => 'FlashCompensation' },
	'flashcontrolmode' => { 120 => '9.2', 121 => '9.2', 122 => '9.2', 156 => 0x404 },
	'flashdevice' => { 161 => 0x1005 },
	'flashdistance' => { 60 => 0x2034 },
	'flashenergy' => { 63 => 0xa20b, 214 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 128 => 0x18 },
	'flashexposurecomp' => { 35 => 0xf, 67 => 0x1011, 91 => 'ExposureComp', 102 => 0x23, 106 => 0x104, 120 => 0xa, 121 => 0xa, 122 => 0xa, 128 => 0x12, 156 => 0x401, 161 => 0x1023, 185 => 0x4d, 197 => 0x3a, 200 => 0x104 },
	'flashexposurecompset' => { 174 => 0xe },
	'flashexposurelock' => { 24 => 0x19 },
	'flashfired' => { 75 => 0x5d, 91 => 'Fired', 102 => 0x14, 138 => '590.3', 172 => 0x8007, 214 => 'FlashFired' },
	'flashfiring' => { 40 => 0x306, 41 => 0x6, 42 => 0x7, 45 => 0x7 },
	'flashfirmwareversion' => { 157 => 0x1002 },
	'flashfocallength' => { 120 => 0xb, 121 => 0xc, 122 => 0xc },
	'flashfunction' => { 214 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 120 => 0xf, 121 => '16.1', 122 => '17.1' },
	'flashgroupaexposurecomp' => { 120 => 0x11, 121 => 0x12, 122 => 0x13 },
	'flashgroupaoutput' => { 120 => 0x11, 121 => 0x12, 122 => 0x13 },
	'flashgroupbcontrolmode' => { 120 => 0x10, 121 => '17.1', 122 => '18.1' },
	'flashgroupbexposurecomp' => { 120 => 0x12, 121 => 0x13, 122 => 0x14 },
	'flashgroupboutput' => { 120 => 0x12, 121 => 0x13, 122 => 0x14 },
	'flashgroupccontrolmode' => { 121 => '17.2', 122 => '18.2' },
	'flashgroupcexposurecomp' => { 121 => 0x14, 122 => 0x15 },
	'flashgroupcoutput' => { 121 => 0x14, 122 => 0x15 },
	'flashguidenumber' => { 35 => 0xd, 50 => 0x0, 91 => 'GuideNumber' },
	'flashintensity' => { 59 => [0x19,0x5], 156 => 0x405 },
	'flashlevel' => { 137 => 0x2e2 },
	'flashmake' => { 91 => 'Make' },
	'flashmanufacturer' => { 207 => 'FlashManufacturer' },
	'flashmetering' => { 102 => 0x3f, 105 => 0x1c },
	'flashmeteringsegments' => { 185 => 0x20a },
	'flashmode' => { 59 => 0x4, 75 => 0x5c, 91 => 'Mode', 102 => 0x2, 103 => 0x20, 104 => 0x16, 105 => 0xf, 128 => 0x87, 156 => 0x400, 161 => 0x1004, 185 => 0xc, 187 => 0x4, 194 => 0x20, 196 => 0x225, 198 => 0x23, 199 => 0x23, 214 => 'FlashMode' },
	'flashmodel' => { 91 => 'Model', 157 => 0x1001, 207 => 'FlashModel' },
	'flashoptions' => { 178 => 0x2 },
	'flashoptions2' => { 178 => 0x10 },
	'flashoutput' => { 18 => 0x248, 35 => 0x21, 120 => 0xa, 121 => 0xa, 122 => 0xa },
	'flashpixversion' => { 63 => 0xa000, 214 => 'FlashpixVersion' },
	'flashredeyemode' => { 214 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 156 => 0x403 },
	'flashreturn' => { 214 => 'FlashReturn' },
	'flashserialnumber' => { 91 => 'SerialNumber', 157 => 0x1003 },
	'flashsetting' => { 128 => 0x8 },
	'flashshutterspeed' => { 112 => '19.2', 138 => '755.2' },
	'flashstatus' => { 181 => 0x0 },
	'flashsyncspeed' => { 112 => '19.1' },
	'flashsyncspeedav' => { 38 => 0x3, 40 => 0x10f, 41 => 0x2, 42 => 0x3, 43 => 0x2, 44 => 0x2, 45 => 0x3, 46 => 0x6 },
	'flashthreshold' => { 50 => 0x1 },
	'flashtype' => { 91 => 'Type', 128 => 0x9, 157 => 0x1000 },
	'flashwarning' => { 138 => '755.1', 172 => 0x62 },
	'flickerreduce' => { 196 => 0x218 },
	'fliphorizontal' => { 149 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x5, 35 => 0x15, 63 => 0x829d, 73 => 0xfd04, 75 => 0x1e, 76 => 0xfa23, 78 => 0xf103, 81 => 0x13, 83 => 0x3c, 86 => 0xc, 95 => 'FNumber', 102 => 0xa, 103 => 0x36, 104 => 0x47, 185 => 0x13, 197 => 0x31, 214 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1d, 8 => 0x1d, 9 => 0x1e, 10 => 0x1e, 11 => 0x28, 12 => 0x1e, 26 => 0x1, 60 => 0x1d, 63 => 0x920a, 81 => 0x1d, 95 => 'FocalLength', 102 => 0x12, 126 => 0xa, 127 => 0xb, 182 => 0x9, 185 => 0x1d, 214 => 'FocalLength' },
	'focallengthin35mmformat' => { 63 => 0xa405, 214 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 157 => 0x103, 161 => 0x205 },
	'focalplaneresolutionunit' => { 63 => 0xa210, 214 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 63 => 0xa20e, 214 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 26 => 0x2 },
	'focalplanexunknown' => { 26 => 0x2 },
	'focalplaneyresolution' => { 63 => 0xa20f, 214 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 26 => 0x3 },
	'focalplaneyunknown' => { 26 => 0x3 },
	'focaltype' => { 4 => 0x2d, 26 => 0x0 },
	'focalunits' => { 14 => 0x19 },
	'focus' => { 139 => 0x8 },
	'focusarea' => { 102 => 0x31 },
	'focusareaselection' => { 138 => '763.2' },
	'focuscontinuous' => { 14 => 0x20 },
	'focusdistance' => { 95 => 'FocusDistance', 102 => 0x13, 126 => 0x9, 127 => 0xa, 159 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x45, 8 => 0x45, 9 => 0x52, 10 => 0x52, 12 => 0x52, 35 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x43, 8 => 0x43, 9 => 0x50, 10 => 0x50, 12 => 0x50, 35 => 0x13 },
	'focusinfoversion' => { 159 => 0x0 },
	'focusingscreen' => { 39 => 0x0, 40 => 0x80b, 45 => 0x0 },
	'focusmode' => { 14 => 0x7, 59 => 0x3, 60 => [0x3003,0xd], 67 => 0x1021, 75 => 0x38, 88 => 'FocusMode', 102 => 0x30, 104 => 0xe, 105 => 0xc, 128 => 0x7, 156 => 0x301, 161 => 0x100b, 172 => 0x7, 185 => 0xd, 187 => 0x3, 198 => 0x10, 199 => 0x10 },
	'focusmode2' => { 178 => '3.1' },
	'focusmodesetting' => { 137 => 0x2e3 },
	'focuspixel' => { 67 => 0x1023 },
	'focuspointwrap' => { 112 => '1.2' },
	'focusposition' => { 126 => 0x8, 127 => 0x8, 185 => 0x10 },
	'focusprocess' => { 156 => 0x302 },
	'focusrange' => { 14 => 0x12, 161 => 0x100a },
	'focussetting' => { 197 => 0x6 },
	'focusstepcount' => { 159 => 0x301, 161 => 0x100e },
	'focusstepinfinity' => { 159 => 0x303 },
	'focusstepnear' => { 159 => 0x304 },
	'focustrackinglockon' => { 112 => '0.5' },
	'focuswarning' => { 67 => 0x1301 },
	'foldername' => { 102 => 0x27 },
	'fontcomposite' => { 233 => 'FontsComposite' },
	'fontface' => { 233 => 'FontsFontFace' },
	'fontfamily' => { 233 => 'FontsFontFamily' },
	'fontfilename' => { 233 => 'FontsFontFileName' },
	'fontname' => { 233 => 'FontsFontName' },
	'fonttype' => { 233 => 'FontsFontType' },
	'fontversion' => { 233 => 'FontsVersionString' },
	'for' => { 193 => 'For' },
	'format' => { 212 => 'format' },
	'forwardmatrix1' => { 63 => 0xc714 },
	'forwardmatrix2' => { 63 => 0xc715 },
	'framenum' => { 188 => 0xd7 },
	'framenumber' => { 67 => 0x8003, 185 => 0x29 },
	'freebytes' => { 53 => 0x1 },
	'freememorycardimages' => { 103 => [0x37,0x54], 104 => [0x2d,0x4a], 105 => 0x32 },
	'fujiflashmode' => { 67 => 0x1010 },
	'fullsizeimage' => { 94 => 'data' },
	'fullsizeimagename' => { 94 => '1Name' },
	'fullsizeimagetype' => { 94 => '0Type' },
	'functionbutton' => { 138 => '753.2' },
	'gainbase' => { 160 => 0x610 },
	'gaincontrol' => { 63 => 0xa407, 214 => 'GainControl' },
	'gamma' => { 63 => 0xa500 },
	'gammacompensatedvalue' => { 71 => 0x91 },
	'genre' => { 220 => 'genre', 228 => 'genre' },
	'geography' => { 221 => 'geography' },
	'geotag' => { 64 => 'Geotag' },
	'geotime' => { 64 => 'Geotime' },
	'globalaltitude' => { 191 => 0x419 },
	'globalangle' => { 191 => 0x40d },
	'gpsaltitude' => { 68 => 0x6, 92 => 'Altitude', 214 => 'GPSAltitude' },
	'gpsaltituderef' => { 68 => 0x5, 214 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 68 => 0x1c, 214 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 68 => 0x1d },
	'gpsdatetime' => { 92 => 'DateTime', 214 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 68 => 0x18, 92 => 'Bearing', 214 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 68 => 0x17, 214 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 68 => 0x1a, 92 => 'Distance', 214 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 68 => 0x19, 214 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 68 => 0x14, 214 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 68 => 0x13 },
	'gpsdestlongitude' => { 68 => 0x16, 214 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 68 => 0x15 },
	'gpsdifferential' => { 68 => 0x1e, 92 => 'Differential', 214 => 'GPSDifferential' },
	'gpsdop' => { 68 => 0xb, 214 => 'GPSDOP' },
	'gpsimgdirection' => { 68 => 0x11, 214 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 68 => 0x10, 214 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 68 => 0x2, 92 => 'Latitude', 214 => 'GPSLatitude' },
	'gpslatituderef' => { 68 => 0x1 },
	'gpslongitude' => { 68 => 0x4, 92 => 'Longitude', 214 => 'GPSLongitude' },
	'gpslongituderef' => { 68 => 0x3 },
	'gpsmapdatum' => { 68 => 0x12, 92 => 'Datum', 214 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 68 => 0xa, 92 => 'MeasureMode', 214 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 68 => 0x1b, 214 => 'GPSProcessingMethod' },
	'gpssatellites' => { 68 => 0x8, 92 => 'Satellites', 214 => 'GPSSatellites' },
	'gpsspeed' => { 68 => 0xd, 92 => 'Speed', 214 => 'GPSSpeed' },
	'gpsspeedref' => { 68 => 0xc, 214 => 'GPSSpeedRef' },
	'gpsstatus' => { 68 => 0x9, 214 => 'GPSStatus' },
	'gpstimestamp' => { 68 => 0x7 },
	'gpstrack' => { 68 => 0xf, 92 => 'Heading', 214 => 'GPSTrack' },
	'gpstrackref' => { 68 => 0xe, 214 => 'GPSTrackRef' },
	'gpsversionid' => { 68 => 0x0, 214 => 'GPSVersionID' },
	'gradation' => { 156 => 0x50f },
	'graymixeraqua' => { 211 => 'GrayMixerAqua' },
	'graymixerblue' => { 211 => 'GrayMixerBlue' },
	'graymixergreen' => { 211 => 'GrayMixerGreen' },
	'graymixermagenta' => { 211 => 'GrayMixerMagenta' },
	'graymixerorange' => { 211 => 'GrayMixerOrange' },
	'graymixerpurple' => { 211 => 'GrayMixerPurple' },
	'graymixerred' => { 211 => 'GrayMixerRed' },
	'graymixeryellow' => { 211 => 'GrayMixerYellow' },
	'grayresponseunit' => { 63 => 0x122 },
	'greencurvelimits' => { 57 => 0x1c4 },
	'greencurvepoints' => { 57 => 0x19a },
	'greenhue' => { 211 => 'GreenHue' },
	'greensaturation' => { 211 => 'GreenSaturation' },
	'griddisplay' => { 112 => '12.3', 138 => '754.1' },
	'halftonehints' => { 63 => 0x141 },
	'hasalternative' => { 220 => 'hasAlternative' },
	'hascorrection' => { 220 => 'hasCorrection' },
	'hascrop' => { 211 => 'HasCrop' },
	'hasextendedxmp' => { 230 => 'HasExtendedXMP' },
	'haspreviousversion' => { 220 => 'hasPreviousVersion' },
	'hassettings' => { 211 => 'HasSettings' },
	'hastranslation' => { 220 => 'hasTranslation' },
	'headline' => { 69 => 0x69, 218 => 'Headline' },
	'hierarchicalsubject' => { 204 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 9 => 0xbb, 10 => 0xbd, 12 => 0xbd, 40 => 0x202, 128 => 0xb1, 185 => 0x71, 198 => 0x2c },
	'highlight' => { 197 => 0xf },
	'highlightprotection' => { 148 => 0x6 },
	'highlightrecovery' => { 211 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 10 => 0x7, 12 => 0x7, 40 => 0x203 },
	'history' => { 218 => 'History' },
	'historyaction' => { 229 => 'HistoryAction' },
	'historychanged' => { 229 => 'HistoryChanged' },
	'historyinstanceid' => { 229 => 'HistoryInstanceID' },
	'historyparameters' => { 229 => 'HistoryParameters' },
	'historysoftwareagent' => { 229 => 'HistorySoftwareAgent' },
	'historywhen' => { 229 => 'HistoryWhen' },
	'hometowncity' => { 60 => 0x3006, 185 => 0x23 },
	'hometowncitycode' => { 187 => 0x1000 },
	'hometowndst' => { 185 => 0x25 },
	'hostcomputer' => { 63 => 0x13c },
	'hue' => { 108 => 0x3b },
	'hueadj' => { 152 => 0x2f },
	'hueadjustment' => { 103 => 0x4a, 104 => 0x40, 128 => 0x92, 130 => 0x36 },
	'hueadjustmentaqua' => { 211 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 211 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 211 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 211 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 211 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 211 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 211 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 211 => 'HueAdjustmentYellow' },
	'huesetting' => { 164 => 0x1011 },
	'icc_profile' => { 64 => 'ICC_Profile' },
	'iccprofilename' => { 218 => 'ICCProfile' },
	'identifier' => { 212 => 'identifier', 226 => 'Identifier' },
	'illumination' => { 138 => '748.5' },
	'imageadjustment' => { 128 => 0x80, 139 => 0x5 },
	'imagealterationconstraints' => { 219 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 185 => 0x38 },
	'imageauthentication' => { 128 => 0x20 },
	'imageboundary' => { 128 => 0x16 },
	'imagecount' => { 128 => 0xa5 },
	'imagecreatorid' => { 219 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 219 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 219 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 128 => 0xa2 },
	'imagedescription' => { 63 => 0x10e, 224 => 'ImageDescription' },
	'imageduplicationconstraints' => { 219 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 149 => 0xfe443a45 },
	'imagefileconstraints' => { 219 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 219 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 219 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 63 => 0x101, 107 => 0xc, 224 => 'ImageLength' },
	'imagehistory' => { 63 => 0x9213 },
	'imageidnumber' => { 170 => 0x340 },
	'imagenumber' => { 11 => 0xd0, 63 => 0x9211, 88 => 'ImageNumber', 103 => 0xae, 104 => 0x5e, 209 => 'ImageNumber' },
	'imagenumber2' => { 104 => 0x62 },
	'imageoptimization' => { 128 => 0xa9 },
	'imageorientation' => { 69 => 0x83 },
	'imageprocessing' => { 128 => 0x1a, 185 => 0x32 },
	'imageprocessingcount' => { 185 => 0x41 },
	'imageprocessingversion' => { 160 => 0x0 },
	'imagequality' => { 88 => 'ImageQuality', 138 => '708.1', 172 => 0x1 },
	'imagequality2' => { 156 => 0x603 },
	'imagereview' => { 137 => '729.4', 138 => '748.4' },
	'imagereviewtime' => { 137 => 0x2db },
	'imagesize' => { 94 => 'ImageSize' },
	'imagesizerestriction' => { 222 => 'imageSizeRestriction' },
	'imagesourcedata' => { 63 => 0x935c },
	'imagestabilization' => { 14 => 0x22, 60 => 0x3020, 88 => 'ImageStabilization', 103 => 0xbd, 104 => 0x71, 105 => 0x57, 106 => [0x18,0x107,0x113], 128 => 0xac, 159 => 0x1600, 172 => 0x1a, 198 => 0x3d, 200 => 0xb026 },
	'imagestyle' => { 198 => 0x2d },
	'imagesupplierid' => { 219 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 219 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 219 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 185 => 0x4f },
	'imagetype' => { 69 => 0x82, 219 => 'ImageType' },
	'imageuniqueid' => { 27 => 0x28, 63 => 0xa420, 214 => 'ImageUniqueID' },
	'imagewidth' => { 63 => 0x100, 107 => 0xe, 224 => 'ImageWidth' },
	'incrementaltemperature' => { 211 => 'IncrementalTemperature' },
	'incrementaltint' => { 211 => 'IncrementalTint' },
	'industry' => { 220 => 'industry', 221 => 'industry' },
	'infinitylensstep' => { 161 => 0x103b },
	'infobuttonwhenshooting' => { 40 => 0x409 },
	'ingredientsalternatepaths' => { 229 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 229 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 229 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 229 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 229 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 229 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 229 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 229 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 229 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 229 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 229 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 229 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 229 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 229 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 229 => 'IngredientsToPart' },
	'ingredientsversionid' => { 229 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 112 => '8.3' },
	'inkset' => { 63 => 0x14c },
	'instanceid' => { 229 => 'InstanceID' },
	'instructions' => { 218 => 'Instructions' },
	'instrument' => { 228 => 'instrument' },
	'intellectualgenre' => { 215 => 'IntellectualGenre' },
	'interchangecolorspace' => { 71 => 0x40 },
	'internalflash' => { 102 => 0x2b, 112 => '22.1', 137 => '737.1', 138 => '756.1', 159 => 0x1208 },
	'internalflashae1' => { 161 => 0x1021 },
	'internalflashae1_0' => { 161 => 0x101d },
	'internalflashae2' => { 161 => 0x1022 },
	'internalflashae2_0' => { 161 => 0x101e },
	'internalflashmode' => { 181 => 0x1 },
	'internalflashstrength' => { 181 => 0x3 },
	'internalflashtable' => { 161 => 0x1024 },
	'internalserialnumber' => { 27 => 0x96, 34 => 0x9, 67 => 0x10, 157 => 0x102, 172 => 0x25, 177 => 0x4 },
	'interopindex' => { 63 => 0x1 },
	'interopversion' => { 63 => 0x2 },
	'intervallength' => { 102 => 0x10 },
	'intervalmode' => { 102 => 0x26 },
	'intervalnumber' => { 102 => 0x11 },
	'introtimescale' => { 228 => 'introTimeScale' },
	'introtimevalue' => { 228 => 'introTimeValue' },
	'iptc-naa' => { 63 => 0x83bb, 173 => 0x83bb },
	'iptcbitspersample' => { 71 => 0x56 },
	'iptcdigest' => { 191 => 0x425 },
	'iptcimageheight' => { 71 => 0x1e },
	'iptcimagerotation' => { 71 => 0x66 },
	'iptcimagewidth' => { 71 => 0x14 },
	'iptclastedited' => { 216 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 71 => 0xa },
	'iptcpixelheight' => { 71 => 0x32 },
	'iptcpixelwidth' => { 71 => 0x28 },
	'isbn' => { 220 => 'isbn' },
	'iscorrectionof' => { 220 => 'isCorrectionOf' },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x0, 59 => 0x14, 60 => [0x3014,0x14], 63 => 0x8827, 73 => 0xfd06, 74 => 0x1784, 75 => 0x60, 76 => [0xfa2e,0xfa46], 77 => [0x27,0x28], 78 => 0xf105, 81 => 0x14, 83 => 0x4e, 86 => 0x34, 88 => 'ISO', 102 => 0x8, 124 => 0x0, 128 => 0x2, 173 => 0x17, 185 => 0x14, 187 => 0x14, 214 => 'ISOSpeedRatings' },
	'iso2' => { 124 => 0x6, 134 => 0x256, 135 => 0x25c, 136 => 0x265 },
	'isoexpansion' => { 40 => 0x103, 41 => 0x7, 42 => 0x8, 45 => 0x8, 124 => 0x4 },
	'isoexpansion2' => { 124 => 0xa },
	'isofloor' => { 178 => 0x6 },
	'isoselection' => { 128 => 0xf },
	'isosetting' => { 75 => 0x5e, 88 => 'ISOSetting', 102 => 0x24, 103 => 0x26, 104 => 0x1c, 108 => 0x6, 128 => 0x13, 178 => '17.3', 194 => 0x27, 198 => 0x16, 199 => 0x14 },
	'isospeedexpansion' => { 39 => 0x3 },
	'isospeedincrements' => { 40 => 0x102 },
	'isospeedrange' => { 40 => 0x103 },
	'isostepsize' => { 112 => '5.1' },
	'isovalue' => { 161 => 0x1001 },
	'issn' => { 220 => 'issn' },
	'issueidentifier' => { 220 => 'issueIdentifier' },
	'issuename' => { 220 => 'issueName' },
	'istranslationof' => { 220 => 'isTranslationOf' },
	'jobid' => { 69 => 0xb8 },
	'jobrefid' => { 227 => 'JobRefId' },
	'jobrefname' => { 227 => 'JobRefName' },
	'jobrefurl' => { 227 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66 },
	'jpgfromraw' => { 53 => 0x2007, 61 => 'JpgFromRaw', 173 => 0x2e },
	'jpgfromrawlength' => { 63 => [0x117,0x202] },
	'jpgfromrawstart' => { 63 => [0x111,0x201] },
	'jpgrecordedpixels' => { 178 => 0xe },
	'key' => { 228 => 'key' },
	'keyword' => { 220 => 'keyword' },
	'keywords' => { 69 => 0x19, 89 => 'Keywords', 165 => 'Keywords', 193 => 'Keywords', 217 => 'Keywords' },
	'killdate' => { 220 => 'killDate' },
	'kodakimageheight' => { 73 => 0xf908, 75 => 0xe, 76 => [0xfa1e,0xfa52], 82 => 0x70 },
	'kodakimagewidth' => { 73 => 0xf907, 75 => 0xc, 76 => [0xfa1d,0xfa51], 82 => 0x6c },
	'kodakinfotype' => { 73 => 0xfa00 },
	'kodakmaker' => { 82 => 0x8 },
	'kodakmodel' => { 75 => 0x0, 82 => 0x28 },
	'label' => { 167 => 'Label', 226 => 'Label' },
	'language' => { 212 => 'language' },
	'languageidentifier' => { 69 => 0x87 },
	'lastfilenumber' => { 102 => 0x1b },
	'lastkeywordiptc' => { 207 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 207 => 'LastKeywordXMP' },
	'lasturl' => { 229 => 'LastURL' },
	'lc1' => { 182 => 0x2 },
	'lc10' => { 182 => 0xb },
	'lc11' => { 182 => 0xc },
	'lc12' => { 182 => 0xd },
	'lc14' => { 182 => 0xf },
	'lc15' => { 182 => 0x10 },
	'lc2' => { 182 => 0x3 },
	'lc3' => { 182 => 0x4 },
	'lc4' => { 182 => 0x5 },
	'lc5' => { 182 => 0x6 },
	'lc6' => { 182 => 0x7 },
	'lc7' => { 182 => 0x8 },
	'lcddisplayatpoweron' => { 40 => 0x811, 44 => 0xa },
	'lcddisplayreturntoshoot' => { 45 => 0x12 },
	'lcdillumination' => { 112 => '16.5' },
	'lcdilluminationduringbulb' => { 40 => 0x408 },
	'lcdpanels' => { 39 => 0x8 },
	'lcheditor' => { 149 => 0x8ae85e },
	'legacyiptcdigest' => { 218 => 'LegacyIPTCDigest' },
	'lens' => { 63 => 0xfdea, 128 => 0x84, 197 => 0xa, 209 => 'Lens' },
	'lensafstopbutton' => { 38 => 0x11, 39 => 0x13, 40 => 0x506, 41 => 0x10, 42 => 0x12, 45 => 0x13, 46 => 0x9 },
	'lensaperturerange' => { 197 => 0x30 },
	'lensdistortionparams' => { 161 => 0x206 },
	'lensdrivenoaf' => { 40 => 0x505 },
	'lensfirmwareversion' => { 157 => 0x204 },
	'lensfstops' => { 125 => 0x7, 126 => 0xc, 127 => 0xd, 128 => 0x8b, 182 => '0.3' },
	'lensid' => { 209 => 'LensID' },
	'lensidnumber' => { 125 => 0x6, 126 => 0xb, 127 => 0xc },
	'lensinfo' => { 209 => 'LensInfo' },
	'lenskind' => { 182 => 0x1 },
	'lensmake' => { 95 => 'Make' },
	'lensmanufacturer' => { 207 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 7 => 0x92b, 8 => 0x933, 27 => 0x95, 95 => 'Model', 207 => 'LensModel' },
	'lensproperties' => { 157 => 0x20b },
	'lensserialnumber' => { 95 => 'SerialNumber', 157 => 0x202, 172 => 0x52 },
	'lenstemperature' => { 161 => 0x1008 },
	'lenstype' => { 2 => 0xe3, 3 => 0xd, 4 => 0xd, 5 => 0x112, 6 => 0xd, 7 => 0xd7, 8 => 0xdf, 9 => 0xf7, 10 => 0xeb, 11 => [0xd,0x98], 12 => 0xe7, 14 => 0x16, 106 => 0x10c, 128 => 0x83, 157 => 0x201, 170 => 0x310, 172 => 0x51, 183 => 0x0, 184 => 0x0, 185 => 0x3f, 200 => 0xb027 },
	'levelgaugepitch' => { 156 => 0x904 },
	'levelgaugeroll' => { 156 => 0x903 },
	'license' => { 210 => 'license' },
	'licenseeid' => { 219 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 219 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 219 => 'LicenseeImageNotes' },
	'licenseename' => { 219 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 219 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 219 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 219 => 'LicenseeTransactionID' },
	'licenseid' => { 219 => 'LicenseID' },
	'licensestartdate' => { 219 => 'LicenseStartDate' },
	'licensetransactiondate' => { 219 => 'LicenseTransactionDate' },
	'licensetype' => { 213 => 'licensetype' },
	'licensorcity' => { 219 => 'LicensorLicensorCity' },
	'licensorcountry' => { 219 => 'LicensorLicensorCountry' },
	'licensoremail' => { 219 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 219 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 219 => 'LicensorLicensorID' },
	'licensorimageid' => { 219 => 'LicensorImageID' },
	'licensorname' => { 219 => 'LicensorLicensorName' },
	'licensornotes' => { 219 => 'LicensorNotes' },
	'licensorpostalcode' => { 219 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 219 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 219 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 219 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 219 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 219 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 219 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 219 => 'LicensorTransactionID' },
	'licensorurl' => { 219 => 'LicensorLicensorURL' },
	'lightcondition' => { 161 => 0x1009 },
	'lightreading' => { 185 => 0x15 },
	'lightsource' => { 63 => 0x9208, 128 => 0x90, 164 => 0x1000, 214 => 'LightSource' },
	'lightsourcespecial' => { 196 => 0x21d },
	'lightvaluecenter' => { 161 => 0x103d },
	'lightvalueperiphery' => { 161 => 0x103e },
	'linearresponselimit' => { 63 => 0xc62e },
	'liveviewexposuresimulation' => { 40 => 0x810 },
	'liveviewshooting' => { 24 => 0x13 },
	'localafarea' => { 105 => 0xd },
	'localafareapoint' => { 198 => 0x12, 199 => 0x12 },
	'localcaption' => { 69 => 0x79 },
	'localizedcameramodel' => { 63 => 0xc615 },
	'location' => { 206 => 'Location', 215 => 'Location', 220 => 'location' },
	'locationcreatedcity' => { 216 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 216 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 216 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 216 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 216 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 216 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 216 => 'LocationShownCity' },
	'locationshowncountrycode' => { 216 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 216 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 216 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 216 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 216 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 40 => 0x709 },
	'logcomment' => { 228 => 'logComment' },
	'longexposurenoisereduction' => { 40 => 0x201, 41 => 0x1, 42 => 0x2, 43 => 0x1, 44 => 0x1, 45 => 0x2, 46 => 0x1, 198 => 0x2b, 200 => 0xb04e },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 7 => 0xda, 9 => 0xfa, 10 => 0xee, 11 => 0x95, 12 => 0xea, 14 => 0x17 },
	'loop' => { 228 => 'loop' },
	'luminanceadjustmentaqua' => { 211 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 211 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 211 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 211 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 211 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 211 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 211 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 211 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 58 => 0x5f },
	'luminancenr_tiff_jpeg' => { 58 => 0x6d },
	'luminancesmoothing' => { 211 => 'LuminanceSmoothing' },
	'm16cversion' => { 170 => 0x333 },
	'macro' => { 67 => 0x1020, 161 => 0x202, 194 => 0x21, 196 => 0x202, 200 => 0xb040 },
	'macromode' => { 14 => 0x1, 102 => 0xb, 156 => 0x300, 172 => 0x1c },
	'magnifiedview' => { 42 => 0x11, 44 => 0x9 },
	'maindialexposurecomp' => { 138 => '748.6' },
	'make' => { 54 => 0x0, 63 => 0x10f, 88 => 'Make', 167 => 'Make', 173 => 0x10f, 224 => 'Make' },
	'makernote' => { 214 => 'MakerNote' },
	'makernotecanon' => { 62 => 'MakN', 63 => 0x927c },
	'makernotecasio' => { 62 => 'MakN', 63 => 0x927c },
	'makernotecasio2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotefujifilm' => { 62 => 'MakN', 63 => 0x927c },
	'makernotehp' => { 62 => 'MakN', 63 => 0x927c },
	'makernotehp2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotehp4' => { 62 => 'MakN', 63 => 0x927c },
	'makernotehp6' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteisl' => { 62 => 'MakN', 63 => 0x927c },
	'makernotejvc' => { 62 => 'MakN', 63 => 0x927c },
	'makernotejvctext' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak10' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak1a' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak1b' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak3' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak4' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak5' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak6a' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak6b' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak7' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak8a' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak8b' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodak9' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekodakunknown' => { 62 => 'MakN', 63 => 0x927c },
	'makernotekyocera' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteleica' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteleica2' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteleica3' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteminolta' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteminolta2' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteminolta3' => { 62 => 'MakN', 63 => 0x927c },
	'makernotenikon' => { 62 => 'MakN', 63 => 0x927c },
	'makernotenikon2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotenikon3' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteoffset' => { 196 => 0xff },
	'makernoteolympus' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteolympus2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepanasonic' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepanasonic2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepentax' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepentax2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepentax3' => { 62 => 'MakN', 63 => 0x927c },
	'makernotepentax4' => { 62 => 'MakN', 63 => 0x927c },
	'makernotericoh' => { 62 => 'MakN', 63 => 0x927c },
	'makernotericohtext' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesafety' => { 63 => 0xc635 },
	'makernotesamsung' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesanyo' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesanyoc4' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesanyopatch' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesigma' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesony' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesony2' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesony3' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesony4' => { 62 => 'MakN', 63 => 0x927c },
	'makernotesonysrf' => { 62 => 'MakN', 63 => 0x927c },
	'makernotetype' => { 195 => 0x1 },
	'makernoteunknown' => { 62 => 'MakN', 63 => 0x927c },
	'makernoteversion' => { 106 => 0x0, 128 => 0x1, 161 => 0x0, 172 => 0x8000, 195 => 0x2, 197 => 0x1d },
	'managedfromalternatepaths' => { 229 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 229 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 229 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 229 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 229 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 229 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 229 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 229 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 229 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 229 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 229 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 229 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 229 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 229 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 229 => 'ManagedFromToPart' },
	'managedfromversionid' => { 229 => 'ManagedFromVersionID' },
	'manager' => { 229 => 'Manager' },
	'managervariant' => { 229 => 'ManagerVariant' },
	'manageto' => { 229 => 'ManageTo' },
	'manageui' => { 229 => 'ManageUI' },
	'manometerpressure' => { 156 => 0x900 },
	'manometerreading' => { 156 => 0x901 },
	'manualflash' => { 159 => 0x1209 },
	'manualflashoutput' => { 14 => 0x29, 137 => '737.2', 138 => '756.2' },
	'manualflashstrength' => { 156 => 0x406 },
	'manualfocusdistance' => { 128 => 0x85, 161 => 0x100c, 196 => 0x223 },
	'manualtv' => { 39 => 0x5, 40 => 0x705 },
	'manufacturedate' => { 177 => 0x1 },
	'marked' => { 217 => 'Marked', 232 => 'Marked' },
	'markerscomment' => { 228 => 'markersComment' },
	'markerscuepointparamskey' => { 228 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 228 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 228 => 'markersCuePointType' },
	'markersduration' => { 228 => 'markersDuration' },
	'markerslocation' => { 228 => 'markersLocation' },
	'markersname' => { 228 => 'markersName' },
	'markersprobability' => { 228 => 'markersProbability' },
	'markersspeaker' => { 228 => 'markersSpeaker' },
	'markersstarttime' => { 228 => 'markersStartTime' },
	'markerstarget' => { 228 => 'markersTarget' },
	'markerstype' => { 228 => 'markersType' },
	'maskedareas' => { 63 => 0xc68e },
	'masterdocumentid' => { 69 => 0xb9 },
	'mastergain' => { 133 => 0x50 },
	'maxaperture' => { 14 => 0x1a, 78 => 0x6103, 95 => 'MaxAperture', 102 => 0x17, 182 => '14.1' },
	'maxapertureatcurrentfocal' => { 157 => 0x20a },
	'maxapertureatmaxfocal' => { 67 => 0x1407, 95 => 'MaxApertureAtMaxFocal', 125 => 0xb, 126 => 0x10, 127 => 0x11, 157 => 0x206 },
	'maxapertureatminfocal' => { 67 => 0x1406, 125 => 0xa, 126 => 0xf, 127 => 0x10, 157 => 0x205 },
	'maxaperturevalue' => { 63 => 0x9205, 214 => 'MaxApertureValue' },
	'maxavailheight' => { 216 => 'MaxAvailHeight' },
	'maxavailwidth' => { 216 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 112 => '10.1' },
	'maxfocallength' => { 67 => 0x1405, 95 => 'MaxFocalLength', 125 => 0x9, 126 => 0xe, 127 => 0xf, 157 => 0x208 },
	'maximumdensityrange' => { 71 => 0x8c },
	'maxpagesizeh' => { 233 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 233 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 233 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 63 => 0x119 },
	'mb-d10batteries' => { 112 => '11.4' },
	'mb-d80batteries' => { 138 => '754.5' },
	'mcuversion' => { 125 => 0xc, 126 => 0x11, 127 => 0x12 },
	'md5digest' => { 96 => 'zmd5' },
	'measuredev' => { 35 => 0x3, 53 => 0x1814, 88 => 'MeasuredEV' },
	'measuredev2' => { 35 => 0x17 },
	'measuredlv' => { 170 => 0x312 },
	'measuredrggb' => { 28 => 0x1 },
	'measuredrggbdata' => { 18 => 0x287 },
	'mediaconstraints' => { 219 => 'MediaConstraints' },
	'mediasummarycode' => { 219 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 38 => 0xb, 41 => 0xa, 42 => 0xb, 45 => 0xb },
	'menubuttonreturn' => { 46 => 0xb },
	'metadatadate' => { 226 => 'MetadataDate' },
	'metadatamoddate' => { 228 => 'metadataModDate' },
	'metering' => { 137 => 0x2df },
	'meteringmode' => { 14 => 0x11, 63 => 0x9207, 75 => 0x1c, 102 => 0x7, 103 => 0x25, 156 => 0x202, 185 => 0x17, 197 => 0x9, 198 => 0x15, 199 => 0x13, 214 => 'MeteringMode' },
	'meteringmode2' => { 178 => '2.1' },
	'meteringmode3' => { 178 => '16.1' },
	'meteringtime' => { 112 => '21.2', 137 => '732.2', 138 => '751.2' },
	'mieversion' => { 96 => '0Vers' },
	'minaperture' => { 14 => 0x1b, 95 => 'MinAperture', 182 => '0.2' },
	'minfocallength' => { 67 => 0x1404, 95 => 'MinFocalLength', 125 => 0x8, 126 => 0xd, 127 => 0xe, 157 => 0x207 },
	'minoltadate' => { 102 => 0x15 },
	'minoltaimagesize' => { 102 => 0x4, 103 => 0xc, 104 => 0x2, 106 => 0x103 },
	'minoltamodelid' => { 102 => 0x25 },
	'minoltaquality' => { 102 => 0x5, 103 => 0xd, 104 => 0x3, 106 => [0x102,0x103] },
	'minoltatime' => { 102 => 0x16 },
	'minormodelagedisclosure' => { 219 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 63 => 0x118 },
	'mirrorlockup' => { 38 => 0xc, 39 => 0xc, 40 => 0x60f, 41 => 0xb, 42 => 0xc, 43 => 0x6, 44 => 0x6, 45 => 0xc, 46 => 0x3 },
	'moddate' => { 217 => 'ModDate' },
	'model' => { 54 => 0x6, 63 => 0x110, 88 => 'Model', 167 => 'Model', 173 => 0x110, 224 => 'Model' },
	'modelage' => { 216 => 'ModelAge' },
	'modelingflash' => { 112 => '20.4', 138 => '755.4' },
	'modelreleaseid' => { 219 => 'ModelReleaseID' },
	'modelreleasestatus' => { 219 => 'ModelReleaseStatus' },
	'modificationdate' => { 220 => 'modificationDate' },
	'modifiedcolortemp' => { 29 => 0x9 },
	'modifieddigitalgain' => { 29 => 0xb },
	'modifiedparamflag' => { 25 => 0x1 },
	'modifiedpicturestyle' => { 29 => 0xa },
	'modifiedsaturation' => { 156 => 0x504 },
	'modifiedsensorbluelevel' => { 29 => 0x5 },
	'modifiedsensorredlevel' => { 29 => 0x4 },
	'modifiedsharpness' => { 29 => 0x2 },
	'modifiedsharpnessfreq' => { 29 => 0x3 },
	'modifiedtonecurve' => { 29 => 0x1 },
	'modifiedwhitebalance' => { 29 => 0x8 },
	'modifiedwhitebalanceblue' => { 29 => 0x7 },
	'modifiedwhitebalancered' => { 29 => 0x6 },
	'modifydate' => { 63 => 0x132, 89 => 'ModifyDate', 165 => 'ModDate', 166 => 'tIME', 193 => 'ModDate', 226 => 'ModifyDate' },
	'moirefilter' => { 63 => 0xfe58, 211 => 'MoireFilter' },
	'monitorofftime' => { 112 => '17.2', 137 => '732.1', 138 => '751.1' },
	'monochromecontrast' => { 58 => 0x3c },
	'monochromefiltereffect' => { 58 => 0x3a },
	'monochromelinear' => { 58 => 0x3d },
	'monochromesharpness' => { 58 => 0x3e },
	'monochrometoningeffect' => { 58 => 0x3b },
	'monthdaycreated' => { 75 => 0x12, 83 => 0xe },
	'morepermissions' => { 210 => 'morePermissions' },
	'multiexposureautogain' => { 129 => 0x3 },
	'multiexposuremode' => { 129 => 0x1 },
	'multiexposureshots' => { 129 => 0x2 },
	'multipleexposuremode' => { 160 => 0x101c },
	'multipleexposureset' => { 178 => '10.1' },
	'multisample' => { 133 => 0x40 },
	'multiselector' => { 112 => '8.4' },
	'multiselectorplaybackmode' => { 112 => '8.2' },
	'multiselectorshootmode' => { 112 => '8.1' },
	'mycolormode' => { 30 => 0x2 },
	'nativedigest' => { 214 => 'NativeDigest', 224 => 'NativeDigest' },
	'ncdfileinfo' => { 74 => 0x414 },
	'ndfilter' => { 35 => 0x1c },
	'nearlensstep' => { 161 => 0x103c },
	'nefcompression' => { 128 => 0x93 },
	'newsphotoversion' => { 71 => 0x0 },
	'nickname' => { 226 => 'Nickname' },
	'nikoncaptureversion' => { 128 => 0xe09 },
	'nikoniccprofile' => { 128 => 0xe1d },
	'nikonimagesize' => { 138 => 0x2c4 },
	'noisefilter' => { 156 => 0x527 },
	'noisereduction' => { 24 => 0x8, 67 => 0x100b, 103 => 0xb0, 104 => 0x60, 105 => 0x3f, 128 => 0x95, 149 => 0x753dcbc0, 150 => 0x17, 156 => 0x50a, 161 => 0x103a, 172 => 0x2d, 185 => 0x49 },
	'noisereduction2' => { 160 => 0x1010 },
	'noisereductionapplied' => { 63 => 0xc6f7 },
	'noisereductionintensity' => { 150 => 0x9 },
	'noisereductionmethod' => { 150 => 0x11 },
	'noisereductionsharpness' => { 150 => 0xd },
	'nomemorycard' => { 112 => '21.1', 137 => '729.3', 138 => '748.3' },
	'nominalmaxaperture' => { 182 => 0xa },
	'nominalminaperture' => { 182 => '10.1' },
	'notes' => { 202 => 'Notes' },
	'npages' => { 233 => 'NPages' },
	'nullrecord' => { 53 => 0x0 },
	'number' => { 220 => 'number' },
	'numberofbeats' => { 228 => 'numberOfBeats' },
	'numfacepositions' => { 168 => 0x0 },
	'numindexentries' => { 71 => 0x54 },
	'object' => { 220 => 'object' },
	'objectattributereference' => { 69 => 0x4 },
	'objectcycle' => { 69 => 0x4b },
	'objectdistance' => { 59 => 0x6, 60 => 0x2022 },
	'objectname' => { 69 => 0x5 },
	'objectpreviewdata' => { 69 => 0xca },
	'objectpreviewfileformat' => { 69 => 0xc8 },
	'objectpreviewfileversion' => { 69 => 0xc9 },
	'objecttypereference' => { 69 => 0x3 },
	'oecfcolumns' => { 214 => 'OECFColumns' },
	'oecfnames' => { 214 => 'OECFNames' },
	'oecfrows' => { 214 => 'OECFRows' },
	'oecfvalues' => { 214 => 'OECFValues' },
	'offsetschema' => { 63 => 0xea1d },
	'oldsubfiletype' => { 63 => 0xff },
	'olympusimageheight' => { 161 => 0x102f },
	'olympusimagewidth' => { 161 => 0x102e },
	'onetouchwb' => { 161 => 0x302 },
	'opticalzoom' => { 76 => 0xfa3d, 78 => [0x6006,0xf006], 79 => 0x1000, 80 => 0xf, 83 => 0x1e, 95 => 'OpticalZoom' },
	'opticalzoomcode' => { 35 => 0xa },
	'opticalzoommode' => { 172 => 0x34 },
	'opticalzoomon' => { 196 => 0x219 },
	'optionenddate' => { 222 => 'optionEndDate' },
	'ordernumber' => { 67 => 0x8002 },
	'organisationinimagecode' => { 216 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 216 => 'OrganisationInImageName' },
	'organization' => { 220 => 'organization' },
	'orientation' => { 63 => 0x112, 173 => 0x112, 224 => 'Orientation' },
	'originaldecisiondata' => { 61 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 27 => 0x83 },
	'originaldocumentid' => { 229 => 'OriginalDocumentID' },
	'originalfilename' => { 53 => 0x816, 74 => 0x3e9, 84 => 0x20 },
	'originalimageheight' => { 66 => 0x1 },
	'originalimagewidth' => { 66 => 0x0 },
	'originalrawfiledata' => { 63 => 0xc68c },
	'originalrawfiledigest' => { 63 => 0xc71d },
	'originalrawfilename' => { 63 => 0xc68b },
	'originaltransmissionreference' => { 69 => 0x67 },
	'originatingprogram' => { 69 => 0x41 },
	'originplatform' => { 220 => 'originPlatform' },
	'os' => { 213 => 'os' },
	'otherconditions' => { 219 => 'OtherConditions' },
	'otherconstraints' => { 219 => 'OtherConstraints' },
	'otherimageinfo' => { 219 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 219 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 219 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 219 => 'OtherLicenseRequirements' },
	'outcuescale' => { 228 => 'outCueScale' },
	'outcuevalue' => { 228 => 'outCueValue' },
	'outputimageheight' => { 113 => 0x3 },
	'outputimagewidth' => { 113 => 0x2 },
	'outputresolution' => { 113 => 0x4 },
	'owner' => { 232 => 'Owner' },
	'ownerid' => { 69 => 0xbc },
	'ownername' => { 27 => 0x9, 53 => 0x810, 63 => 0xfde8, 88 => 'OwnerName', 209 => 'OwnerName' },
	'padding' => { 63 => 0xea1c },
	'pageimage' => { 226 => 'PageInfoImage' },
	'pageimageformat' => { 226 => 'PageInfoFormat' },
	'pageimageheight' => { 226 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 226 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 226 => 'PageInfoWidth' },
	'pagename' => { 63 => 0x11d },
	'pagenumber' => { 63 => 0x129 },
	'pagerange' => { 220 => 'pageRange' },
	'panasonicexifversion' => { 172 => 0x26 },
	'panasonicrawversion' => { 173 => 0x1 },
	'panasonictitle' => { 63 => 0xc6d2 },
	'panasonictitle2' => { 63 => 0xc6d3 },
	'panoramadirection' => { 31 => 0x5 },
	'panoramaframenumber' => { 31 => 0x2 },
	'panoramamode' => { 75 => 0x3c, 156 => 0x601 },
	'parametricdarks' => { 211 => 'ParametricDarks' },
	'parametrichighlights' => { 211 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 211 => 'ParametricHighlightSplit' },
	'parametriclights' => { 211 => 'ParametricLights' },
	'parametricmidtonesplit' => { 211 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 211 => 'ParametricShadows' },
	'parametricshadowsplit' => { 211 => 'ParametricShadowSplit' },
	'patientid' => { 203 => 'PatientID' },
	'patientsbirthdate' => { 203 => 'PatientDOB' },
	'patientsname' => { 203 => 'PatientName' },
	'patientssex' => { 203 => 'PatientSex' },
	'pdfversion' => { 217 => 'PDFVersion' },
	'pentaximagesize' => { 185 => 0x9 },
	'pentaxmodelid' => { 177 => 0x0, 185 => 0x5 },
	'pentaxmodeltype' => { 185 => 0x1 },
	'pentaxversion' => { 185 => 0x0 },
	'people' => { 206 => 'People' },
	'peripheralillumination' => { 58 => 0x68 },
	'peripheralilluminationon' => { 58 => 0x64 },
	'peripherallighting' => { 36 => 0x1 },
	'peripherallightingsetting' => { 37 => 0x5 },
	'peripherallightingvalue' => { 36 => 0x3 },
	'permissions' => { 222 => 'permissions' },
	'person' => { 220 => 'person' },
	'personinimage' => { 216 => 'PersonInImage' },
	'pf0customfuncregistration' => { 48 => 0x1 },
	'pf10retainprogramshift' => { 48 => 0xb },
	'pf13drivepriority' => { 48 => 0xe },
	'pf14disablefocussearch' => { 48 => 0xf },
	'pf15disableafassistbeam' => { 48 => 0x10 },
	'pf16autofocuspointshoot' => { 48 => 0x11 },
	'pf17disableafpointsel' => { 48 => 0x12 },
	'pf18enableautoafpointsel' => { 48 => 0x13 },
	'pf19continuousshootspeed' => { 48 => 0x14 },
	'pf19shootingspeedhigh' => { 47 => 0xa },
	'pf19shootingspeedlow' => { 47 => 0x9 },
	'pf1disableshootingmodes' => { 48 => 0x2 },
	'pf1value' => { 47 => 0x1 },
	'pf20limitcontinousshots' => { 48 => 0x15 },
	'pf20maxcontinousshots' => { 47 => 0xb },
	'pf21enablequietoperation' => { 48 => 0x16 },
	'pf23felocktime' => { 47 => 0xd },
	'pf23postreleasetime' => { 47 => 0xe },
	'pf23settimerlengths' => { 48 => 0x18 },
	'pf23shutterbuttontime' => { 47 => 0xc },
	'pf24lightlcdduringbulb' => { 48 => 0x19 },
	'pf25aemode' => { 47 => 0xf },
	'pf25afmode' => { 47 => 0x12 },
	'pf25afpointsel' => { 47 => 0x13 },
	'pf25colormatrix' => { 47 => 0x17 },
	'pf25defaultclearsettings' => { 48 => 0x1a },
	'pf25drivemode' => { 47 => 0x11 },
	'pf25imagesize' => { 47 => 0x14 },
	'pf25meteringmode' => { 47 => 0x10 },
	'pf25parameters' => { 47 => 0x16 },
	'pf25wbmode' => { 47 => 0x15 },
	'pf26shortenreleaselag' => { 48 => 0x1b },
	'pf27reversedialrotation' => { 48 => 0x1c },
	'pf27value' => { 47 => 0x18 },
	'pf28noquickdialexpcomp' => { 48 => 0x1d },
	'pf29quickdialswitchoff' => { 48 => 0x1e },
	'pf2disablemeteringmodes' => { 48 => 0x3 },
	'pf2value' => { 47 => 0x2 },
	'pf30enlargementmode' => { 48 => 0x1f },
	'pf31originaldecisiondata' => { 48 => 0x20 },
	'pf3manualexposuremetering' => { 48 => 0x4 },
	'pf3value' => { 47 => 0x3 },
	'pf4exposuretimelimits' => { 48 => 0x5 },
	'pf4exposuretimemax' => { 47 => 0x5 },
	'pf4exposuretimemin' => { 47 => 0x4 },
	'pf5aperturelimits' => { 48 => 0x6 },
	'pf5aperturemax' => { 47 => 0x7 },
	'pf5aperturemin' => { 47 => 0x6 },
	'pf6presetshootingmodes' => { 48 => 0x7 },
	'pf7bracketcontinuousshoot' => { 48 => 0x8 },
	'pf8bracketshots' => { 47 => 0x8 },
	'pf8setbracketshots' => { 48 => 0x9 },
	'pf9changebracketsequence' => { 48 => 0xa },
	'phonenumber' => { 89 => 'Phone' },
	'photoeffect' => { 14 => 0x28 },
	'photoeffects' => { 149 => 0xab5eca5e },
	'photoeffectsblue' => { 151 => 0x8 },
	'photoeffectsgreen' => { 151 => 0x6 },
	'photoeffectsred' => { 151 => 0x4 },
	'photoeffectstype' => { 151 => 0x0 },
	'photoinfoplayback' => { 112 => '16.6' },
	'photometricinterpretation' => { 63 => 0x106, 224 => 'PhotometricInterpretation' },
	'photoshopquality' => { 190 => 0x0 },
	'pictinfo' => { 196 => 0x208 },
	'picturecontrol' => { 149 => 0xe2173c47 },
	'picturecontrolactive' => { 152 => 0x0 },
	'picturecontroladjust' => { 130 => 0x30 },
	'picturecontrolbase' => { 130 => 0x18 },
	'picturecontrolmode' => { 152 => 0x13 },
	'picturecontrolname' => { 130 => 0x4 },
	'picturecontrolquickadjust' => { 130 => 0x31 },
	'picturefinish' => { 103 => 0x71 },
	'picturemode' => { 67 => 0x1031, 156 => 0x520, 185 => [0xb,0x33] },
	'picturemode2' => { 178 => 0x0 },
	'picturemodebwfilter' => { 156 => 0x525 },
	'picturemodecontrast' => { 156 => 0x523 },
	'picturemodehue' => { 156 => 0x522 },
	'picturemodesaturation' => { 156 => 0x521 },
	'picturemodesharpness' => { 156 => 0x524 },
	'picturemodetone' => { 156 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 9 => 0xab, 10 => 0xa7, 11 => 0x6c, 12 => 0xa7, 33 => 0xa, 58 => 0x2 },
	'planarconfiguration' => { 63 => 0x11c, 224 => 'PlanarConfiguration' },
	'platenames' => { 233 => 'PlateNames' },
	'plusversion' => { 219 => 'Version' },
	'pngwarning' => { 167 => 'Warning' },
	'postalcode' => { 93 => 'PostalCode' },
	'postcropvignetteamount' => { 211 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 211 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 211 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 211 => 'PostCropVignetteRoundness' },
	'powersource' => { 176 => 0x0 },
	'precaptureframes' => { 161 => 0x300 },
	'predictor' => { 63 => 0x13d },
	'prefs' => { 69 => 0xdd, 189 => 'Prefs' },
	'preservedfilename' => { 229 => 'PreservedFileName' },
	'previewapplicationname' => { 63 => 0xc716 },
	'previewapplicationversion' => { 63 => 0xc717 },
	'previewcolorspace' => { 63 => 0xc71a },
	'previewdatetime' => { 63 => 0xc71b },
	'previewheight' => { 76 => 0xfa58 },
	'previewimage' => { 60 => 0x2000, 61 => 'PreviewImage', 62 => 'MakN', 63 => 0x927c, 64 => 'PreviewImage', 65 => 0x4, 98 => 'data', 106 => 0x81, 161 => 0x280, 200 => 0x2001 },
	'previewimageborders' => { 185 => 0x3e },
	'previewimageheight' => { 32 => 0x4 },
	'previewimagelength' => { 32 => 0x2, 60 => 0x3, 63 => [0x117,0x202], 106 => 0x89, 131 => 0x202, 156 => 0x102, 161 => 0x1037, 185 => 0x3, 194 => 0x1e, 197 => 0x1b },
	'previewimagename' => { 98 => '1Name' },
	'previewimagesize' => { 60 => 0x2, 81 => 0x2, 98 => 'ImageSize', 185 => 0x2, 197 => 0x1c },
	'previewimagestart' => { 32 => 0x5, 60 => 0x4, 63 => [0x111,0x201], 106 => 0x88, 131 => 0x201, 156 => 0x101, 161 => 0x1036, 185 => 0x4, 194 => 0x1c, 197 => 0x1a },
	'previewimagetype' => { 98 => '0Type' },
	'previewimagevalid' => { 156 => 0x100, 161 => 0x1035 },
	'previewimagewidth' => { 32 => 0x3 },
	'previewquality' => { 32 => 0x1 },
	'previewsettingsdigest' => { 63 => 0xc719 },
	'previewsettingsname' => { 63 => 0xc718 },
	'previewwidth' => { 76 => 0xfa57 },
	'primaryafpoint' => { 111 => 0x7 },
	'primarychromaticities' => { 63 => 0x13f, 224 => 'PrimaryChromaticities' },
	'printim' => { 63 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 105 => 0x1d, 198 => 0x28 },
	'privatertkinfo' => { 204 => 'privateRTKInfo' },
	'processingsoftware' => { 63 => 0xb },
	'producer' => { 165 => 'Producer', 217 => 'Producer' },
	'productid' => { 70 => 0x32 },
	'productioncode' => { 177 => 0x2 },
	'productorserviceconstraints' => { 219 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 63 => 0xc6f4 },
	'profilecopyright' => { 63 => 0xc6fe },
	'profileembedpolicy' => { 63 => 0xc6fd },
	'profilehuesatmapdata1' => { 63 => 0xc6fa },
	'profilehuesatmapdata2' => { 63 => 0xc6fb },
	'profilehuesatmapdims' => { 63 => 0xc6f9 },
	'profilelooktabledata' => { 63 => 0xc726 },
	'profilelooktabledims' => { 63 => 0xc725 },
	'profilename' => { 63 => 0xc6f8 },
	'profiletonecurve' => { 63 => 0xc6fc },
	'programiso' => { 172 => 0x3c },
	'programline' => { 178 => '1.1' },
	'programmode' => { 108 => 0x5 },
	'programshift' => { 128 => 0xd },
	'programversion' => { 69 => 0x46 },
	'projectrefpath' => { 228 => 'projectRefPath' },
	'projectreftype' => { 228 => 'projectRefType' },
	'propertyreleaseid' => { 219 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 219 => 'PropertyReleaseStatus' },
	'province-state' => { 69 => 0x5f },
	'publicationdate' => { 220 => 'publicationDate' },
	'publicationname' => { 220 => 'publicationName' },
	'publisher' => { 212 => 'publisher' },
	'pulldown' => { 228 => 'pullDown' },
	'quality' => { 0 => 0x1, 14 => 0x3, 59 => 0x2, 60 => 0x3002, 67 => 0x1000, 75 => 0x9, 128 => 0x4, 139 => 0x3, 161 => 0x201, 170 => 0x300, 185 => 0x8, 187 => 0x2, 197 => 0x16, 198 => 0x56, 200 => [0x102,0xb047] },
	'qualitymode' => { 60 => 0x8 },
	'quantizationmethod' => { 71 => 0x78 },
	'quickadjust' => { 152 => 0x2a },
	'quickcontroldialinmeter' => { 40 => 0x703 },
	'quickshot' => { 196 => 0x213 },
	'rasterizedcaption' => { 69 => 0x7d },
	'rating' => { 63 => 0x4746, 188 => 0xdf, 213 => 'rating', 226 => 'Rating' },
	'ratingpercent' => { 63 => 0x4749, 207 => 'Rating' },
	'rawandjpgrecording' => { 38 => 0x8, 178 => 0xd },
	'rawbrightnessadj' => { 57 => 0x38 },
	'rawcoloradj' => { 57 => 0x2e },
	'rawcolortoneadj' => { 58 => 0xd },
	'rawcontrastadj' => { 58 => 0xf },
	'rawcropbottom' => { 188 => 0xd4 },
	'rawcropleft' => { 188 => 0xd1 },
	'rawcropright' => { 188 => 0xd3 },
	'rawcroptop' => { 188 => 0xd2 },
	'rawcustomsaturation' => { 57 => 0x30 },
	'rawcustomtone' => { 57 => 0x34 },
	'rawdatauniqueid' => { 63 => 0xc65d },
	'rawdepth' => { 107 => 0x10 },
	'rawdevautogradation' => { 163 => 0x119 },
	'rawdevcolorspace' => { 162 => 0x108, 163 => 0x109 },
	'rawdevcontrastvalue' => { 162 => 0x106, 163 => 0x105 },
	'rawdeveditstatus' => { 162 => 0x10b },
	'rawdevengine' => { 162 => 0x109, 163 => 0x10b },
	'rawdevexposurebiasvalue' => { 162 => 0x100, 163 => 0x100 },
	'rawdevgradation' => { 163 => 0x112 },
	'rawdevgraypoint' => { 162 => 0x103, 163 => 0x104 },
	'rawdevmemorycoloremphasis' => { 162 => 0x105, 163 => 0x108 },
	'rawdevnoisereduction' => { 162 => 0x10a, 163 => 0x10a },
	'rawdevpicturemode' => { 163 => 0x10c },
	'rawdevpm_bwfilter' => { 163 => 0x110 },
	'rawdevpmcontrast' => { 163 => 0x10e },
	'rawdevpmnoisefilter' => { 163 => 0x120 },
	'rawdevpmpicturetone' => { 163 => 0x111 },
	'rawdevpmsaturation' => { 163 => 0x10d },
	'rawdevpmsharpness' => { 163 => 0x10f },
	'rawdevsaturation3' => { 163 => 0x113 },
	'rawdevsaturationemphasis' => { 162 => 0x104, 163 => 0x107 },
	'rawdevsettings' => { 162 => 0x10c },
	'rawdevsharpnessvalue' => { 162 => 0x107, 163 => 0x106 },
	'rawdevversion' => { 162 => 0x0, 163 => 0x0 },
	'rawdevwbfineadjustment' => { 162 => 0x102, 163 => 0x103 },
	'rawdevwhitebalance' => { 163 => 0x101 },
	'rawdevwhitebalancevalue' => { 162 => 0x101, 163 => 0x102 },
	'rawfile' => { 63 => 0xfe4c },
	'rawfilename' => { 211 => 'RawFileName' },
	'rawhighlightpoint' => { 58 => 0x12 },
	'rawimagecenter' => { 128 => 0x99 },
	'rawimagedigest' => { 63 => 0xc71c },
	'rawimagesize' => { 185 => 0x39 },
	'rawinfoversion' => { 164 => 0x0 },
	'rawjpgheight' => { 55 => 0x4 },
	'rawjpgquality' => { 24 => 0x6, 55 => 0x1 },
	'rawjpgsize' => { 24 => 0x7, 55 => 0x2 },
	'rawjpgwidth' => { 55 => 0x3 },
	'rawlinear' => { 58 => 0x10 },
	'rawmeasuredrggb' => { 17 => 0x26a, 19 => 0x280 },
	'rawsaturationadj' => { 58 => 0xe },
	'rawshadowpoint' => { 58 => 0x13 },
	'rawsharpnessadj' => { 58 => 0x11 },
	'recognizedface1age' => { 169 => 0x20 },
	'recognizedface1name' => { 169 => 0x4 },
	'recognizedface1position' => { 169 => 0x18 },
	'recognizedface2age' => { 169 => 0x50 },
	'recognizedface2name' => { 169 => 0x34 },
	'recognizedface2position' => { 169 => 0x48 },
	'recognizedface3age' => { 169 => 0x80 },
	'recognizedface3name' => { 169 => 0x64 },
	'recognizedface3position' => { 169 => 0x78 },
	'recognizedfaceflags' => { 172 => 0x63 },
	'recordid' => { 53 => 0x1804 },
	'recordingmode' => { 59 => 0x1, 187 => 0x1 },
	'recordmode' => { 14 => 0x9, 60 => 0x3000 },
	'recordshutterrelease' => { 196 => 0x217 },
	'redbalance' => { 118 => 0x270, 161 => 0x1017, 173 => 0x11, 185 => 0x1c },
	'redcurvelimits' => { 57 => 0x18a },
	'redcurvepoints' => { 57 => 0x160 },
	'redeyecorrection' => { 153 => 0x0 },
	'redeyeinfo' => { 211 => 'RedEyeInfo' },
	'redeyereduction' => { 105 => 0x41 },
	'redhue' => { 211 => 'RedHue' },
	'redsaturation' => { 211 => 'RedSaturation' },
	'referenceblackwhite' => { 63 => 0x214, 224 => 'ReferenceBlackWhite' },
	'referencedate' => { 69 => 0x2f },
	'referencenumber' => { 69 => 0x32 },
	'references' => { 89 => 'References' },
	'referenceservice' => { 69 => 0x2d },
	'regionconstraints' => { 219 => 'RegionConstraints' },
	'regionpersondisplayname' => { 205 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 205 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 216 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 216 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 87 => 'data' },
	'relatedaudiofilename' => { 87 => '1Name' },
	'relatedaudiofiletype' => { 87 => '0Type' },
	'relatedimagefileformat' => { 63 => 0x1000 },
	'relatedimageheight' => { 63 => 0x1002 },
	'relatedimagewidth' => { 63 => 0x1001 },
	'relatedsoundfile' => { 63 => 0xa004, 214 => 'RelatedSoundFile' },
	'relatedvideofile' => { 101 => 'data' },
	'relatedvideofilename' => { 101 => '1Name' },
	'relatedvideofiletype' => { 101 => '0Type' },
	'relation' => { 212 => 'relation' },
	'relativepeakaudiofilepath' => { 228 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 228 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 228 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 112 => '16.8' },
	'releasedate' => { 69 => 0x1e, 228 => 'releaseDate' },
	'releasesetting' => { 53 => 0x1016 },
	'releasetime' => { 69 => 0x23 },
	'remoteonduration' => { 137 => '732.4', 138 => '752.3' },
	'renditionclass' => { 229 => 'RenditionClass' },
	'renditionofalternatepaths' => { 229 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 229 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 229 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 229 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 229 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 229 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 229 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 229 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 229 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 229 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 229 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 229 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 229 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 229 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 229 => 'RenditionOfToPart' },
	'renditionofversionid' => { 229 => 'RenditionOfVersionID' },
	'renditionparams' => { 229 => 'RenditionParams' },
	'repeatingflashcount' => { 120 => 0xd, 121 => 0xe, 122 => 0xe, 138 => '757.2' },
	'repeatingflashoutput' => { 138 => '757.1' },
	'repeatingflashrate' => { 120 => 0xc, 121 => 0xd, 122 => 0xd, 138 => '758.1' },
	'resampleparamsquality' => { 228 => 'resampleParamsQuality' },
	'resaved' => { 196 => 0x21e },
	'resolution' => { 94 => 'Resolution' },
	'resolutionmode' => { 197 => 0x4 },
	'resolutionunit' => { 63 => 0x128, 72 => 0x2, 224 => 'ResolutionUnit' },
	'restrictions' => { 222 => 'restrictions' },
	'retouchhistory' => { 128 => 0x9e },
	'retouchinfo' => { 211 => 'RetouchInfo' },
	'reuse' => { 219 => 'Reuse' },
	'reuseallowed' => { 231 => 'ReuseAllowed' },
	'reuseprohibited' => { 222 => 'reuseProhibited' },
	'reverseindicators' => { 112 => '11.1' },
	'revision' => { 213 => 'revision' },
	'rgbcurvelimits' => { 57 => 0x238 },
	'rgbcurvepoints' => { 57 => 0x20e },
	'ricohdate' => { 194 => 0x6 },
	'ricohimageheight' => { 194 => 0x2 },
	'ricohimagewidth' => { 194 => 0x0 },
	'rightascension' => { 97 => 'RightAscension' },
	'rights' => { 212 => 'rights' },
	'rightsagent' => { 220 => 'rightsAgent', 222 => 'rightsAgent' },
	'rightsowner' => { 222 => 'rightsOwner' },
	'romoperationmode' => { 53 => 0x80d },
	'rotation' => { 13 => 0x17, 52 => 0x3, 57 => 0x26e, 66 => 0x4, 97 => 'Rotation', 103 => [0x65,0x50], 104 => 0x46, 105 => 0x5a, 138 => '590.1', 149 => 0x76a43207, 172 => 0x30, 178 => '17.2', 188 => 0xd8, 198 => 0x3f, 199 => 0x3f },
	'routing' => { 193 => 'Routing' },
	'rowsperstrip' => { 63 => 0x116 },
	'rpp' => { 208 => 'rpp' },
	'safetyshift' => { 40 => 0x108 },
	'safetyshiftinavortv' => { 38 => 0x10, 39 => 0x10, 41 => 0xf, 42 => 0x10, 45 => 0x10 },
	'samplebits' => { 87 => 'SampleBits' },
	'samplerate' => { 87 => 'SampleRate' },
	'samplesperpixel' => { 63 => 0x115, 224 => 'SamplesPerPixel' },
	'samplestructure' => { 71 => 0x5a },
	'sanyoquality' => { 196 => 0x201 },
	'sanyothumbnail' => { 196 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 14 => 0xe, 21 => 0x1, 59 => 0xd, 60 => [0x3013,0x1f], 63 => [0xa409,0xfe55], 67 => 0x1003, 88 => 'Saturation', 102 => 0x1f, 103 => 0x32, 104 => 0x28, 105 => 0x1a, 108 => 0x1, 128 => [0x94,0xaa], 130 => 0x35, 172 => 0x40, 185 => 0x1f, 187 => 0xd, 194 => 0x28, 197 => 0x10, 198 => 0x1e, 199 => 0x1b, 211 => 'Saturation', 214 => 'Saturation' },
	'saturationadj' => { 57 => 0x116, 148 => 0x1, 152 => 0x2e },
	'saturationadjustmentaqua' => { 211 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 211 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 211 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 211 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 211 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 211 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 211 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 211 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 11 => 0xfe },
	'saturationlandscape' => { 11 => 0xfc },
	'saturationneutral' => { 11 => 0xfd },
	'saturationportrait' => { 11 => 0xfb },
	'saturationsetting' => { 164 => 0x1010 },
	'saturationstandard' => { 11 => 0xfa },
	'saturationuserdef1' => { 11 => 0x100 },
	'saturationuserdef2' => { 11 => 0x101 },
	'saturationuserdef3' => { 11 => 0x102 },
	'saveid' => { 229 => 'SaveID' },
	'scaletype' => { 228 => 'scaleType' },
	'scanimageenhancer' => { 133 => 0x60 },
	'scanningdirection' => { 71 => 0x64 },
	'scene' => { 215 => 'Scene', 228 => 'scene' },
	'scenearea' => { 159 => 0x211, 161 => 0x1031 },
	'sceneassist' => { 128 => 0x9c },
	'scenecapturetype' => { 63 => 0xa406, 214 => 'SceneCaptureType' },
	'scenedetect' => { 159 => 0x210, 161 => 0x1030 },
	'scenedetectdata' => { 159 => 0x212, 161 => 0x1033 },
	'scenemode' => { 76 => 0xfa02, 106 => 0x100, 128 => 0x8f, 156 => 0x509, 161 => 0x403, 172 => 0x8001, 200 => 0xb023 },
	'scenemodeused' => { 78 => [0x6002,0xf002] },
	'sceneselect' => { 196 => 0x21f },
	'scenetype' => { 63 => 0xa301, 214 => 'SceneType' },
	'section' => { 220 => 'section' },
	'securityclassification' => { 63 => 0x9212 },
	'selectableafpoint' => { 40 => 0x509 },
	'selftimer' => { 14 => 0x2, 60 => 0x3001, 172 => 0x2e, 196 => 0x214 },
	'selftimer2' => { 35 => 0x1d },
	'selftimermode' => { 63 => 0x882b },
	'selftimertime' => { 53 => 0x1806, 112 => '17.1', 137 => '732.3', 138 => '751.3' },
	'seminfo' => { 63 => 0x8546 },
	'sensingmethod' => { 63 => 0xa217, 214 => 'SensingMethod' },
	'sensitivityadjust' => { 185 => 0x40 },
	'sensitivitysteps' => { 178 => '17.4', 180 => 0x1 },
	'sensorbluelevel' => { 33 => 0x5 },
	'sensorcleaning' => { 46 => 0xd },
	'sensorfullheight' => { 73 => 0xf904 },
	'sensorfullwidth' => { 73 => 0xf903 },
	'sensorheight' => { 73 => 0xf901, 76 => 0xfa21, 107 => 0x8 },
	'sensorpixelsize' => { 128 => 0x9a },
	'sensorredlevel' => { 33 => 0x4 },
	'sensorsize' => { 88 => 'SensorSize' },
	'sensortemperature' => { 159 => 0x1500, 161 => 0x1007 },
	'sensorwidth' => { 73 => 0xf900, 76 => 0xfa20, 107 => 0xa },
	'sequencenumber' => { 35 => 0x9, 60 => 0x301c, 67 => 0x1101, 75 => 0x1d, 172 => 0x2b },
	'sequenceshotinterval' => { 196 => 0x224 },
	'sequentialshot' => { 196 => 0x20e },
	'serialnumber' => { 27 => 0xc, 53 => 0x180b, 63 => 0xfde9, 73 => 0xfa04, 76 => 0xfa19, 85 => 0x0, 86 => 0xa8, 88 => 'SerialNumber', 128 => 0xa0, 157 => 0x101, 161 => [0x404,0x101a], 170 => 0x303, 197 => 0x2, 209 => 'SerialNumber' },
	'serialnumberformat' => { 27 => 0x15, 53 => 0x183b },
	'seriesdatetime' => { 203 => 'SeriesDateTime' },
	'seriesdescription' => { 203 => 'SeriesDescription' },
	'seriesmodality' => { 203 => 'SeriesModality' },
	'seriesnumber' => { 203 => 'SeriesNumber' },
	'serviceidentifier' => { 70 => 0x1e },
	'setbuttoncrosskeysfunc' => { 43 => 0x0, 44 => 0x0 },
	'setbuttonwhenshooting' => { 38 => 0x1, 40 => 0x704, 46 => 0xc },
	'setfunctionwhenshooting' => { 41 => 0x0, 42 => 0x1, 45 => 0x1 },
	'shadingcompensation' => { 156 => 0x50c },
	'shadingcompensation2' => { 160 => 0x1012 },
	'shadow' => { 197 => 0xe },
	'shadowprotection' => { 148 => 0x0 },
	'shadows' => { 63 => 0xfe52, 211 => 'Shadows' },
	'shadowscale' => { 63 => 0xc633 },
	'shadowtint' => { 211 => 'ShadowTint' },
	'shakereduction' => { 186 => 0x1 },
	'sharpendetail' => { 211 => 'SharpenDetail' },
	'sharpenedgemasking' => { 211 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 152 => 0x2b },
	'sharpenradius' => { 211 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 14 => 0xf, 33 => 0x2, 59 => 0xb, 60 => [0x3011,0x21], 63 => [0xa40a,0xfe56], 67 => 0x1001, 75 => 0x6b, 83 => 0x37, 88 => 'Sharpness', 102 => 0x21, 103 => 0x30, 104 => 0x26, 105 => 0x18, 108 => 0x3, 128 => 0x6, 130 => 0x32, 161 => 0x100f, 172 => 0x41, 185 => 0x21, 187 => 0xb, 194 => 0x22, 195 => 0x1003, 197 => 0x11, 198 => 0x1c, 199 => 0x19, 211 => 'Sharpness', 214 => 'Sharpness' },
	'sharpnessadj' => { 57 => 0x25a },
	'sharpnessfactor' => { 161 => 0x102a },
	'sharpnessfaithful' => { 11 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 33 => 0x3 },
	'sharpnesslandscape' => { 11 => 0xf3 },
	'sharpnessmonochrome' => { 11 => 0xf6 },
	'sharpnessneutral' => { 11 => 0xf4 },
	'sharpnessportrait' => { 11 => 0xf2 },
	'sharpnesssetting' => { 156 => 0x506, 164 => 0x1013 },
	'sharpnessstandard' => { 11 => 0xf1 },
	'sharpnessuserdef1' => { 11 => 0xf7 },
	'sharpnessuserdef2' => { 11 => 0xf8 },
	'sharpnessuserdef3' => { 11 => 0xf9 },
	'shootinginfodisplay' => { 112 => '12.2' },
	'shootingmode' => { 88 => 'ShootingMode', 128 => 0x89, 172 => 0x1f },
	'shootingmodesetting' => { 137 => '734.1' },
	'shortdescription' => { 213 => 'shortdescription' },
	'shortdocumentid' => { 69 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 7 => 0xd8, 9 => 0xf8, 10 => 0xec, 11 => 0x93, 12 => 0xe8, 14 => 0x18 },
	'shortownername' => { 11 => 0xac },
	'shortreleasetimelag' => { 40 => 0x80d },
	'shotdate' => { 228 => 'shotDate' },
	'shotlocation' => { 228 => 'shotLocation' },
	'shotname' => { 228 => 'shotName' },
	'shutter-aelock' => { 38 => 0x4, 40 => 0x701, 41 => 0x3, 42 => 0x4, 43 => 0x3, 44 => 0x3, 45 => 0x4, 46 => 0x2 },
	'shutteraelbutton' => { 39 => 0x4 },
	'shutterbuttonafonbutton' => { 40 => 0x701 },
	'shuttercount' => { 5 => 0x176, 24 => 0x1, 134 => [0x6a,0x157,0x276], 135 => 0x279, 136 => 0x284, 137 => 0x246, 138 => 0x24a, 185 => 0x5d },
	'shuttercurtainsync' => { 38 => 0xf, 39 => 0xf, 40 => 0x305, 41 => 0xe, 42 => 0xf, 43 => 0x8, 44 => 0x8, 45 => 0xf, 46 => 0x8 },
	'shuttermode' => { 75 => 0x1b },
	'shutterreleasebuttonae-l' => { 112 => '16.7' },
	'shutterreleasemethod' => { 53 => 0x1010 },
	'shutterreleasenocfcard' => { 38 => 0x2, 39 => 0x2, 46 => 0xf },
	'shutterreleasetiming' => { 53 => 0x1011 },
	'shutterspeedrange' => { 40 => 0x10c },
	'shutterspeedvalue' => { 49 => 0x1, 63 => 0x9201, 161 => 0x1000, 214 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 218 => 'SidecarForExtension' },
	'similarityindex' => { 69 => 0xe4 },
	'slaveflashmeteringsegments' => { 185 => 0x20b },
	'slowshutter' => { 35 => 0x8 },
	'slowsync' => { 67 => 0x1030 },
	'smoothness' => { 63 => 0xfe57, 211 => 'Smoothness' },
	'software' => { 63 => 0x131, 89 => 'Software', 167 => 'Software', 197 => 0x18, 224 => 'Software' },
	'softwareversion' => { 196 => 0x207 },
	'sonydatetime' => { 201 => 0x6 },
	'sonyimagesize' => { 105 => 0x3b, 198 => 0x54, 199 => 0x54 },
	'sonyquality' => { 105 => 0x3c },
	'source' => { 69 => 0x73, 167 => 'Source', 212 => 'source', 213 => 'source', 218 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 214 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 214 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 214 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 214 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 228 => 'speakerPlacement' },
	'specialinstructions' => { 69 => 0x28 },
	'specialmode' => { 161 => 0x200, 196 => 0x200 },
	'spectralsensitivity' => { 63 => 0x8824, 214 => 'SpectralSensitivity' },
	'splittoningbalance' => { 211 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 211 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 211 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 211 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 211 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 102 => 0x2d },
	'spotfocuspointy' => { 102 => 0x2e },
	'spotmeteringmode' => { 14 => 0x27 },
	'spotmeterlinktoafpoint' => { 40 => 0x107 },
	'sractive' => { 178 => '17.1' },
	'srawquality' => { 14 => 0x2e },
	'srfocallength' => { 186 => 0x3 },
	'srhalfpresstime' => { 186 => 0x2 },
	'srresult' => { 186 => 0x0 },
	'startingpage' => { 220 => 'startingPage' },
	'starttimecodetimeformat' => { 228 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 228 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 228 => 'startTimecodeValue' },
	'state' => { 93 => 'State', 218 => 'State' },
	'status' => { 206 => 'Status' },
	'storagemethod' => { 107 => 0x12 },
	'straightenangle' => { 149 => 0x2fc08431 },
	'stretchmode' => { 228 => 'stretchMode' },
	'studydatetime' => { 203 => 'StudyDateTime' },
	'studydescription' => { 203 => 'StudyDescription' },
	'studyid' => { 203 => 'StudyID' },
	'studyphysician' => { 203 => 'StudyPhysician' },
	'sub-location' => { 69 => 0x5c },
	'subfiledata' => { 96 => 'data' },
	'subfiledirectory' => { 96 => '1Directory' },
	'subfilemimetype' => { 96 => '2MIME' },
	'subfilename' => { 96 => '1Name' },
	'subfileresource' => { 96 => 'rsrc' },
	'subfiletype' => { 63 => 0xfe, 96 => '0Type' },
	'subject' => { 165 => 'Subject', 193 => 'Subject', 212 => 'subject', 217 => 'Subject' },
	'subjectarea' => { 63 => 0x9214, 214 => 'SubjectArea' },
	'subjectcode' => { 215 => 'SubjectCode' },
	'subjectdistance' => { 63 => 0x9206, 75 => 0x3e, 214 => 'SubjectDistance' },
	'subjectdistancerange' => { 63 => 0xa40c, 214 => 'SubjectDistanceRange' },
	'subjectlocation' => { 63 => 0xa214, 214 => 'SubjectLocation' },
	'subjectprogram' => { 102 => 0x22 },
	'subjectreference' => { 69 => 0xc },
	'subsectime' => { 63 => 0x9290 },
	'subsectimedigitized' => { 63 => 0x9292 },
	'subsectimeoriginal' => { 63 => 0x9291 },
	'subsection1' => { 220 => 'subsection1' },
	'subsection2' => { 220 => 'subsection2' },
	'subsection3' => { 220 => 'subsection3' },
	'subsection4' => { 220 => 'subsection4' },
	'superimposeddisplay' => { 38 => 0xa, 40 => 0x510, 41 => 0x9, 42 => 0xa, 45 => 0xa, 46 => 0xe },
	'supermacro' => { 27 => 0x1a },
	'supplementalcategories' => { 69 => 0x14, 218 => 'SupplementalCategories' },
	'supplementaltype' => { 71 => 0x37 },
	'svisosetting' => { 178 => 0x14 },
	'switchtoregisteredafpoint' => { 39 => 0x12, 40 => 0x50a },
	'tagged' => { 188 => 0xdd },
	'tapename' => { 228 => 'tapeName' },
	'targetaperture' => { 35 => 0x4 },
	'targetcompressionratio' => { 51 => 0x1 },
	'targetdistancesetting' => { 53 => 0x1807 },
	'targetexposuretime' => { 35 => 0x5 },
	'targetimagetype' => { 53 => 0x100a },
	'teaser' => { 220 => 'teaser' },
	'teleconverter' => { 106 => 0x105, 200 => 0x105 },
	'temperature' => { 211 => 'Temperature' },
	'tempo' => { 228 => 'tempo' },
	'termsandconditionstext' => { 219 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 219 => 'TermsAndConditionsURL' },
	'textstamp' => { 172 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 63 => 0x107 },
	'thumbnailfilename' => { 53 => 0x817 },
	'thumbnailformat' => { 226 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 76 => 0xfa55, 226 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 53 => 0x2008, 61 => 'ThumbnailImage', 65 => 0x3, 99 => 'data', 161 => 0x100, 226 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 99 => '1Name' },
	'thumbnailimagesize' => { 99 => 'ImageSize' },
	'thumbnailimagetype' => { 99 => '0Type' },
	'thumbnailimagevalidarea' => { 27 => 0x13 },
	'thumbnaillength' => { 63 => 0x202 },
	'thumbnailoffset' => { 63 => 0x201 },
	'thumbnailwidth' => { 76 => 0xfa54, 226 => 'ThumbnailsWidth' },
	'ticker' => { 220 => 'ticker' },
	'tilelength' => { 63 => 0x143 },
	'tilewidth' => { 63 => 0x142 },
	'time' => { 74 => 0x401, 185 => 0x7 },
	'timecreated' => { 69 => 0x3c, 75 => 0x14, 83 => 0x10, 189 => 'TimeCreated' },
	'timeperiod' => { 220 => 'timePeriod' },
	'timerfunctionbutton' => { 137 => '734.2' },
	'timerlength' => { 40 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 228 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 228 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 228 => 'timeScaleParamsQuality' },
	'timesent' => { 70 => 0x50 },
	'timesignature' => { 228 => 'timeSignature' },
	'timesincepoweron' => { 172 => 0x29 },
	'timestamp' => { 5 => 0x45e, 11 => 0x11c, 167 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 141 => 0x0 },
	'timezonecode' => { 56 => 0x1 },
	'timezoneinfo' => { 56 => 0x2 },
	'timezoneoffset' => { 63 => 0x882a },
	'tint' => { 211 => 'Tint' },
	'title' => { 89 => 'Title', 165 => 'Title', 167 => 'Title', 193 => 'Title', 212 => 'title', 217 => 'Title' },
	'tonecomp' => { 128 => 0x81 },
	'tonecurve' => { 33 => 0x1, 185 => 0x402, 211 => 'ToneCurve' },
	'tonecurveactive' => { 57 => 0x110 },
	'tonecurvefilename' => { 74 => 0x1391 },
	'tonecurvename' => { 211 => 'ToneCurveName' },
	'tonecurveproperty' => { 57 => 0x3c },
	'tonecurves' => { 185 => 0x403 },
	'toningeffect' => { 24 => 0xf, 128 => 0xb3, 130 => 0x38 },
	'toningeffectmonochrome' => { 11 => 0x108 },
	'toningsaturation' => { 130 => 0x39 },
	'totalzoom' => { 75 => 0x62 },
	'tracknumber' => { 228 => 'trackNumber' },
	'tracksframerate' => { 228 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 228 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 228 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 228 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 228 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 228 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 228 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 228 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 228 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 228 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 228 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 228 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 228 => 'TracksMarkersType' },
	'trackstrackname' => { 228 => 'TracksTrackName' },
	'trackstracktype' => { 228 => 'TracksTrackType' },
	'trailersignature' => { 96 => 'zmie' },
	'transferfunction' => { 63 => 0x12d, 224 => 'TransferFunction' },
	'transform' => { 172 => [0x8012,0x59] },
	'transmissionreference' => { 218 => 'TransmissionReference' },
	'trapped' => { 165 => 'Trapped', 217 => 'Trapped' },
	'travelday' => { 172 => 0x36 },
	'ttl_da_adown' => { 181 => 0x5 },
	'ttl_da_aup' => { 181 => 0x4 },
	'ttl_da_bdown' => { 181 => 0x7 },
	'ttl_da_bup' => { 181 => 0x6 },
	'tvexposuretimesetting' => { 178 => 0x12 },
	'type' => { 212 => 'type' },
	'uniquecameramodel' => { 63 => 0xc614 },
	'uniquedocumentid' => { 69 => 0xbb },
	'uniqueobjectname' => { 70 => 0x64 },
	'unknownblock' => { 160 => 0x1103 },
	'unknowncompensation' => { 197 => 0xc },
	'unknownev' => { 74 => 0x1 },
	'unknownnumber' => { 53 => 0x180b },
	'unsharp1color' => { 154 => 0x13 },
	'unsharp1halowidth' => { 154 => 0x19 },
	'unsharp1intensity' => { 154 => 0x17 },
	'unsharp1threshold' => { 154 => 0x1b },
	'unsharp2color' => { 154 => 0x2e },
	'unsharp2halowidth' => { 154 => 0x34 },
	'unsharp2intensity' => { 154 => 0x32 },
	'unsharp2threshold' => { 154 => 0x36 },
	'unsharp3color' => { 154 => 0x49 },
	'unsharp3halowidth' => { 154 => 0x4f },
	'unsharp3intensity' => { 154 => 0x4d },
	'unsharp3threshold' => { 154 => 0x51 },
	'unsharp4color' => { 154 => 0x64 },
	'unsharp4halowidth' => { 154 => 0x6a },
	'unsharp4intensity' => { 154 => 0x68 },
	'unsharp4threshold' => { 154 => 0x6c },
	'unsharpcount' => { 154 => 0x0 },
	'unsharpmask' => { 149 => 0x76a43200 },
	'urgency' => { 69 => 0xa, 218 => 'Urgency' },
	'url' => { 89 => 'URL', 167 => 'URL', 191 => 0x40b, 220 => 'url' },
	'usablemeteringmodes' => { 40 => 0x10a },
	'usableshootingmodes' => { 40 => 0x109 },
	'usage' => { 221 => 'usage' },
	'usagefee' => { 222 => 'usageFee' },
	'usageterms' => { 232 => 'UsageTerms' },
	'usercomment' => { 53 => 0x805, 63 => 0x9286, 214 => 'UserComment' },
	'userdef1picturestyle' => { 11 => 0x10c },
	'userdef2picturestyle' => { 11 => 0x10e },
	'userdef3picturestyle' => { 11 => 0x110 },
	'userfields' => { 206 => 'UserFields' },
	'userprofile' => { 170 => 0x302 },
	'usmlenselectronicmf' => { 39 => 0x7, 40 => 0x501 },
	'utmeasting' => { 100 => 'Easting' },
	'utmmapdatum' => { 100 => 'Datum' },
	'utmnorthing' => { 100 => 'Northing' },
	'utmzone' => { 100 => 'Zone' },
	'uv-irfiltercorrection' => { 170 => 0x325 },
	'validbits' => { 160 => 0x611, 161 => 0x102c },
	'validpixeldepth' => { 164 => 0x611 },
	'variousmodes' => { 75 => 0x26 },
	'variousmodes2' => { 75 => 0x3a },
	'variprogram' => { 128 => 0xab },
	'version' => { 67 => 0x0, 193 => 'Version', 211 => 'Version' },
	'versionid' => { 229 => 'VersionID' },
	'versionidentifier' => { 220 => 'versionIdentifier' },
	'versionscomments' => { 229 => 'VersionsComments' },
	'versionseventaction' => { 229 => 'VersionsEventAction' },
	'versionseventchanged' => { 229 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 229 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 229 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 229 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 229 => 'VersionsEventWhen' },
	'versionsmodifier' => { 229 => 'VersionsModifier' },
	'versionsmodifydate' => { 229 => 'VersionsModifyDate' },
	'versionsversion' => { 229 => 'VersionsVersion' },
	'vibrance' => { 211 => 'Vibrance' },
	'vibrationreduction' => { 134 => [0x75,0x82,0x1ae], 137 => '586.1', 138 => '590.2', 140 => 0x4 },
	'videoalphamode' => { 228 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 228 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 228 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 228 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 228 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 228 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 228 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 228 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 228 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 228 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 228 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 228 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 228 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 228 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 228 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 228 => 'videoColorSpace' },
	'videocompressor' => { 228 => 'videoCompressor' },
	'videofieldorder' => { 228 => 'videoFieldOrder' },
	'videoframerate' => { 228 => 'videoFrameRate' },
	'videoframesizeh' => { 228 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 228 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 228 => 'videoFrameSizeW' },
	'videomoddate' => { 228 => 'videoModDate' },
	'videopixelaspectratio' => { 228 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 228 => 'videoPixelDepth' },
	'viewfinderwarning' => { 112 => '12.4', 138 => '754.2' },
	'viewinfoduringexposure' => { 40 => 0x407 },
	'vignetteamount' => { 211 => 'VignetteAmount' },
	'vignettecontrol' => { 128 => 0x2a, 149 => 0x76a43205 },
	'vignettecontrolintensity' => { 149 => 0xac6bd5c0 },
	'vignettemidpoint' => { 211 => 'VignetteMidpoint' },
	'voicememo' => { 196 => 0x216 },
	'volume' => { 220 => 'volume' },
	'vr_0x66' => { 134 => 0x66 },
	'vrdoffset' => { 27 => 0xd0 },
	'wb_gbrglevels' => { 109 => 0x4 },
	'wb_glevel' => { 160 => 0x11f },
	'wb_glevel3000k' => { 160 => 0x113 },
	'wb_glevel3300k' => { 160 => 0x114 },
	'wb_glevel3600k' => { 160 => 0x115 },
	'wb_glevel3900k' => { 160 => 0x116 },
	'wb_glevel4000k' => { 160 => 0x117 },
	'wb_glevel4300k' => { 160 => 0x118 },
	'wb_glevel4500k' => { 160 => 0x119 },
	'wb_glevel4800k' => { 160 => 0x11a },
	'wb_glevel5300k' => { 160 => 0x11b },
	'wb_glevel6000k' => { 160 => 0x11c },
	'wb_glevel6600k' => { 160 => 0x11d },
	'wb_glevel7500k' => { 160 => 0x11e },
	'wb_grbglevels' => { 117 => 0x0 },
	'wb_rbgglevels' => { 114 => 0x0 },
	'wb_rblevels' => { 128 => 0xc, 160 => 0x100 },
	'wb_rblevels3000k' => { 160 => 0x102 },
	'wb_rblevels3300k' => { 160 => 0x103 },
	'wb_rblevels3600k' => { 160 => 0x104 },
	'wb_rblevels3900k' => { 160 => 0x105 },
	'wb_rblevels4000k' => { 160 => 0x106 },
	'wb_rblevels4300k' => { 160 => 0x107 },
	'wb_rblevels4500k' => { 160 => 0x108 },
	'wb_rblevels4800k' => { 160 => 0x109 },
	'wb_rblevels5300k' => { 160 => 0x10a },
	'wb_rblevels6000k' => { 160 => 0x10b },
	'wb_rblevels6600k' => { 160 => 0x10c },
	'wb_rblevels7500k' => { 160 => 0x10d },
	'wb_rblevelsauto' => { 164 => 0x110 },
	'wb_rblevelscloudy' => { 164 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 164 => 0x132 },
	'wb_rblevelscwb1' => { 160 => 0x10e },
	'wb_rblevelscwb2' => { 160 => 0x10f },
	'wb_rblevelscwb3' => { 160 => 0x110 },
	'wb_rblevelscwb4' => { 160 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 164 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 164 => 0x131 },
	'wb_rblevelseveningsunlight' => { 164 => 0x124 },
	'wb_rblevelsfineweather' => { 164 => 0x122 },
	'wb_rblevelsshade' => { 164 => 0x120 },
	'wb_rblevelstungsten' => { 164 => 0x123 },
	'wb_rblevelsused' => { 164 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 164 => 0x133 },
	'wb_rgbglevels' => { 116 => 0x0 },
	'wb_rgblevels' => { 171 => 0xd },
	'wb_rggblevels' => { 109 => 0x4, 115 => 0x0 },
	'wb_rggblevelsasshot' => { 16 => 0x19, 17 => 0x22, 18 => 0x3f, 19 => 0x3f, 20 => 0x47 },
	'wb_rggblevelsauto' => { 15 => 0x0, 16 => 0x1e, 17 => 0x18, 18 => 0x44, 19 => 0x44, 20 => 0x4c },
	'wb_rggblevelscloudy' => { 15 => 0xc, 16 => 0x2d, 17 => 0x31, 18 => 0x58, 19 => 0x5d, 20 => 0x65, 185 => 0x20f },
	'wb_rggblevelscustom' => { 15 => 0x1c, 18 => 0x80 },
	'wb_rggblevelscustom1' => { 16 => 0x41 },
	'wb_rggblevelscustom2' => { 16 => 0x46 },
	'wb_rggblevelsdaylight' => { 15 => 0x4, 16 => 0x23, 17 => 0x27, 18 => 0x4e, 19 => 0x53, 20 => 0x5b, 185 => 0x20d },
	'wb_rggblevelsflash' => { 15 => 0x18, 16 => 0x3c, 17 => 0x45, 18 => 0x6c, 19 => 0x71, 20 => 0x79, 185 => 0x214 },
	'wb_rggblevelsfluorescent' => { 15 => 0x14, 16 => 0x37, 17 => 0x3b, 18 => 0x62, 19 => 0x67, 20 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 185 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 185 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 185 => 0x213 },
	'wb_rggblevelskelvin' => { 15 => 0x20, 17 => 0x40, 18 => 0x67, 19 => 0x6c, 20 => 0x74 },
	'wb_rggblevelsmeasured' => { 18 => 0x49, 19 => 0x49, 20 => 0x51 },
	'wb_rggblevelspc1' => { 17 => 0x90, 18 => 0x71 },
	'wb_rggblevelspc2' => { 17 => 0x95, 18 => 0x76 },
	'wb_rggblevelspc3' => { 17 => 0x9a, 18 => 0x7b },
	'wb_rggblevelsshade' => { 15 => 0x8, 16 => 0x28, 17 => 0x2c, 18 => 0x53, 19 => 0x58, 20 => 0x60, 185 => 0x20e },
	'wb_rggblevelstungsten' => { 15 => 0x10, 16 => 0x32, 17 => 0x36, 18 => 0x5d, 19 => 0x62, 20 => 0x6a, 185 => 0x210 },
	'wb_rggblevelsunknown' => { 17 => 0x1d, 19 => 0x4e, 20 => 0x56 },
	'wb_rggblevelsunknown10' => { 17 => 0x72, 19 => 0x9e, 20 => 0xa6 },
	'wb_rggblevelsunknown11' => { 17 => 0x77, 19 => 0xa3, 20 => 0xab },
	'wb_rggblevelsunknown12' => { 17 => 0x7c, 20 => 0xb0 },
	'wb_rggblevelsunknown13' => { 17 => 0x81, 20 => 0xb5 },
	'wb_rggblevelsunknown14' => { 17 => 0x86 },
	'wb_rggblevelsunknown15' => { 17 => 0x8b },
	'wb_rggblevelsunknown16' => { 17 => 0x9f },
	'wb_rggblevelsunknown2' => { 17 => 0x4a, 19 => 0x76, 20 => 0x7e },
	'wb_rggblevelsunknown3' => { 17 => 0x4f, 19 => 0x7b, 20 => 0x83 },
	'wb_rggblevelsunknown4' => { 17 => 0x54, 19 => 0x80, 20 => 0x88 },
	'wb_rggblevelsunknown5' => { 17 => 0x59, 19 => 0x85, 20 => 0x8d },
	'wb_rggblevelsunknown6' => { 17 => 0x5e, 19 => 0x8a, 20 => 0x92 },
	'wb_rggblevelsunknown7' => { 17 => 0x63, 19 => 0x8f, 20 => 0x97 },
	'wb_rggblevelsunknown8' => { 17 => 0x68, 19 => 0x94, 20 => 0x9c },
	'wb_rggblevelsunknown9' => { 17 => 0x6d, 19 => 0x99, 20 => 0xa1 },
	'wbadjbluebalance' => { 155 => 0x8 },
	'wbadjcolortemp' => { 57 => 0x1a },
	'wbadjlighting' => { 155 => 0x15 },
	'wbadjlightingsubtype' => { 155 => 0x14 },
	'wbadjmode' => { 155 => 0x10 },
	'wbadjredbalance' => { 155 => 0x0 },
	'wbadjrgblevels' => { 57 => 0x8 },
	'wbadjtemperature' => { 155 => 0x18 },
	'wbadjtint' => { 155 => 0x25 },
	'wbadjustab' => { 172 => 0x46 },
	'wbadjustgm' => { 172 => 0x47 },
	'wbbluelevel' => { 170 => 0x324, 172 => 0x8006, 173 => 0x26 },
	'wbbracketmode' => { 24 => 0x9 },
	'wbbracketvalueab' => { 24 => 0xc },
	'wbbracketvaluegm' => { 24 => 0xd },
	'wbfinetuneactive' => { 57 => 0x24 },
	'wbfinetunesaturation' => { 57 => 0x28 },
	'wbfinetunetone' => { 57 => 0x2c },
	'wbgreenlevel' => { 170 => 0x323, 172 => 0x8005, 173 => 0x25 },
	'wbmediaimagesizesetting' => { 40 => 0x708 },
	'wbmode' => { 108 => 0x4, 161 => 0x1015 },
	'wbredlevel' => { 170 => 0x322, 172 => 0x8004, 173 => 0x24 },
	'wbscale' => { 109 => 0x0 },
	'wbshiftab' => { 33 => 0xc, 179 => 0x10 },
	'wbshiftgm' => { 33 => 0xd },
	'wbshiftmg' => { 179 => 0x11 },
	'webstatement' => { 232 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 7 => 0x6f, 8 => 0x6f, 9 => 0x73, 10 => 0x6f, 11 => 0x54, 12 => 0x6f, 33 => 0x8, 35 => 0x7, 59 => 0x7, 60 => [0x19,0x2012], 63 => [0xa403,0xfe4e], 67 => 0x1002, 75 => 0x40, 102 => 0x3, 103 => 0xe, 104 => 0x4, 105 => 0xb, 128 => 0x5, 139 => 0x7, 170 => 0x304, 172 => 0x3, 185 => 0x19, 187 => 0x7, 194 => 0x26, 197 => [0x3c,0x7], 211 => 'WhiteBalance', 214 => 'WhiteBalance' },
	'whitebalance2' => { 156 => 0x500 },
	'whitebalanceadj' => { 57 => 0x18, 149 => 0x76a43204 },
	'whitebalancebias' => { 60 => 0x2011, 161 => 0x304, 172 => 0x23 },
	'whitebalanceblue' => { 33 => 0x7 },
	'whitebalancebracket' => { 156 => 0x502, 161 => 0x303 },
	'whitebalancecomp' => { 164 => 0x1001 },
	'whitebalancefinetune' => { 67 => 0x100a, 128 => 0xb, 198 => 0x6, 200 => 0x112 },
	'whitebalancemode' => { 185 => 0x1a },
	'whitebalancered' => { 33 => 0x6 },
	'whitebalanceset' => { 178 => 0xa },
	'whitebalancetemperature' => { 156 => 0x501 },
	'whiteboard' => { 161 => 0x301 },
	'whitelevel' => { 63 => 0xc61d },
	'whitepoint' => { 63 => 0x13e, 185 => 0x201, 224 => 'WhitePoint' },
	'widefocuszone' => { 102 => 0x2f },
	'widerange' => { 196 => 0x20f },
	'wordcount' => { 220 => 'wordCount' },
	'workcolorspace' => { 57 => 0x270 },
	'worldtimelocation' => { 172 => 0x3a, 185 => 0x22 },
	'writer-editor' => { 69 => 0x7a },
	'x3filllight' => { 197 => 0x12 },
	'xmp' => { 64 => 'XMP' },
	'xmptoolkit' => { 225 => 'xmptk' },
	'xpauthor' => { 63 => 0x9c9d },
	'xpcomment' => { 63 => 0x9c9c },
	'xpkeywords' => { 63 => 0x9c9e },
	'xposition' => { 63 => 0x11e },
	'xpsubject' => { 63 => 0x9c9f },
	'xptitle' => { 63 => 0x9c9b },
	'xresolution' => { 63 => 0x11a, 72 => 0x3, 192 => 0x0, 224 => 'XResolution' },
	'xyresolution' => { 66 => 0x3 },
	'ycbcrcoefficients' => { 63 => 0x211, 224 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 63 => 0x213, 224 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 63 => 0x212, 224 => 'YCbCrSubSampling' },
	'yearcreated' => { 75 => 0x10, 83 => 0xc },
	'yposition' => { 63 => 0x11f },
	'yresolution' => { 63 => 0x11b, 72 => 0x5, 192 => 0x4, 224 => 'YResolution' },
	'zonematching' => { 106 => 0x10a, 108 => 0x3a, 200 => 0xb024 },
	'zonematchingon' => { 104 => 0x75 },
	'zonematchingvalue' => { 198 => 0x1f },
	'zoomsourcewidth' => { 14 => 0x24 },
	'zoomstepcount' => { 159 => 0x300, 161 => 0x100d },
	'zoomtargetwidth' => { 14 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationdata' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsd300' => 1,
	'camerasettingsifd' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'entrypoint' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikon_0x00b9' => 1,
	'nikon_avitags_0x000d' => 1,
	'nikon_avitags_0x000e' => 1,
	'nikon_avitags_0x0015' => 1,
	'nikon_avitags_0x0017' => 1,
	'nikon_avitags_0x0019' => 1,
	'nikon_avitags_0x001c' => 1,
	'nikon_avitags_0x801a' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikondata' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureinfo' => 1,
	'picturemimetype' => 1,
	'picturetype' => 1,
	'pieceinfo' => 1,
	'pitchangle' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollangle' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'synchronizedlyrictext' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2009, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
