/*
 * Decompiled with CFR 0.152.
 */
package jde.ui.design;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import jde.ui.design.LocalStringBundle;
import jde.ui.design.StringBundleEvent;
import jde.ui.design.StringBundleEventListener;

public class StringBundle {
    String fName;
    LocalStringBundle fMasterStrings;
    Vector fTranslatedStrings = new Vector();
    Vector fStringBundleEventListeners = new Vector();

    public StringBundle(String name, String masterLanguage, String masterCountry) {
        this.fName = name;
        this.fMasterStrings = new LocalStringBundle(masterLanguage, masterCountry);
    }

    public StringBundle(String name) {
        this(name, "en", "US");
    }

    public String getName() {
        return this.fName;
    }

    public int getSize() {
        return this.fMasterStrings.getSize();
    }

    public void setKey(String key, int n) {
        this.fMasterStrings.setKey(key, n);
    }

    public String getKey(int n) {
        return this.fMasterStrings.getKey(n);
    }

    public String getString(int n) {
        return this.fMasterStrings.getString(n);
    }

    public void addString() {
        int index = this.fMasterStrings.addString();
        Iterator i = ((AbstractList)this.fTranslatedStrings).iterator();
        while (i.hasNext()) {
            LocalStringBundle translatedStrings = (LocalStringBundle)i.next();
            translatedStrings.addString();
        }
        StringBundleEvent event = new StringBundleEvent(this, 0, index);
        this.postStringBundleEvent(event);
    }

    public void setString(String string, int n) {
        this.fMasterStrings.setString(string, n);
    }

    public void write() {
    }

    protected void postStringBundleEvent(StringBundleEvent event) {
        Iterator i = ((AbstractList)this.fStringBundleEventListeners).iterator();
        while (i.hasNext()) {
            StringBundleEventListener l = (StringBundleEventListener)i.next();
            l.handleEvent(event);
        }
    }

    public void addStringBundleEventListener(StringBundleEventListener l) {
        this.fStringBundleEventListeners.addElement(l);
    }

    public void removeStringBundleEventListener(StringBundleEventListener listener) {
        Iterator i = ((AbstractList)this.fStringBundleEventListeners).iterator();
        StringBundleEventListener l = (StringBundleEventListener)i.next();
        while (i.hasNext()) {
            if (l == listener) {
                i.remove();
                break;
            }
            l = (StringBundleEventListener)i.next();
        }
    }

    public String toString() {
        return this.fName;
    }
}

