/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ResultSetClosingStatement
implements Statement {
    static Logger logger = Logger.getLogger(ResultSetClosingStatement.class);
    protected Statement actualStatement;
    protected Connection con;
    protected ResultSet results;
    protected String lastQuery;

    ResultSetClosingStatement(Connection con, Statement actualStmt) {
        this.con = con;
        this.actualStatement = actualStmt;
        this.results = null;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        long startTime = 0L;
        long queryTime = 0L;
        this.lastQuery = sql;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(sql.hashCode() + ", " + sql));
            startTime = System.currentTimeMillis();
        }
        this.results = this.actualStatement.executeQuery(sql);
        if (logger.isDebugEnabled()) {
            queryTime = System.currentTimeMillis() - startTime;
            logger.debug((Object)("low level query time for " + sql.hashCode() + " (ms): " + queryTime));
        }
        return this.results;
    }

    public int executeUpdate(String sql) throws SQLException {
        logger.debug((Object)sql);
        this.lastQuery = sql;
        int rowCount = this.actualStatement.executeUpdate(sql);
        logger.debug((Object)("Affected " + rowCount + " rows"));
        return rowCount;
    }

    public void close() throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        this.actualStatement.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.actualStatement.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.actualStatement.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.actualStatement.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.actualStatement.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.actualStatement.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.actualStatement.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.actualStatement.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.actualStatement.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.actualStatement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.actualStatement.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.actualStatement.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not allowed by ResultSetClosingStatement");
    }

    public ResultSet getResultSet() throws SQLException {
        return this.results;
    }

    public int getUpdateCount() throws SQLException {
        return this.actualStatement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException("Not allowed by ResultSetClosingStatement");
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.actualStatement.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.actualStatement.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.actualStatement.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.actualStatement.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.actualStatement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.actualStatement.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.actualStatement.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.actualStatement.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.actualStatement.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void finalize() {
        try {
            if (this.results != null) {
                this.results.close();
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("Couldn't close result set in finalizer: " + e));
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }
}

