/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.unix;

import com.darwinsys.unix.UnixPasswdEntry;
import java.util.List;
import java.util.regex.Matcher;
import junit.framework.TestCase;

public class UnixPasswdEntryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testRegEx() {
        String sample = "foo:*:101:102:Foo Bar:/home/foo:/bin/ksh";
        Matcher m = UnixPasswdEntry.patt.matcher(sample);
        UnixPasswdEntryTest.assertTrue((String)"line matches", (boolean)m.matches());
        UnixPasswdEntryTest.assertEquals((String)"match name", (String)"foo", (String)m.group(1));
        UnixPasswdEntryTest.assertEquals((String)"match dummy pw", (String)"*", (String)m.group(2));
        UnixPasswdEntryTest.assertEquals((String)"match uid", (String)"101", (String)m.group(3));
        UnixPasswdEntryTest.assertEquals((String)"match gid", (String)"102", (String)m.group(4));
        UnixPasswdEntryTest.assertEquals((String)"match gecos", (String)"Foo Bar", (String)m.group(5));
        UnixPasswdEntryTest.assertEquals((String)"match homedir", (String)"/home/foo", (String)m.group(6));
        UnixPasswdEntryTest.assertEquals((String)"match shell", (String)"/bin/ksh", (String)m.group(7));
    }

    public void testGetPwEntriesString() throws Exception {
        List<UnixPasswdEntry> pwEntries = UnixPasswdEntry.getPwEntries();
        UnixPasswdEntryTest.assertNotNull(pwEntries);
        UnixPasswdEntryTest.assertTrue((String)"at least root & current user", (pwEntries.size() > 2 ? 1 : 0) != 0);
        String loggedInAs = System.getProperty("user.name");
        for (UnixPasswdEntry ent : pwEntries) {
            if (!loggedInAs.equals(ent.getName())) continue;
            System.out.println("Current user = " + ent);
            return;
        }
        UnixPasswdEntryTest.fail((String)"Did not find entry for current user name");
    }
}

