/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.DatabaseListChangeEvent;
import ca.sqlpower.architect.DatabaseListChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlDotIni
implements DataSourceCollection {
    private boolean dontAutoSave;
    List<DatabaseListChangeListener> listeners;
    DatabaseListChangeListener saver = new DatabaseListChangeListener(){

        public void databaseAdded(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        public void databaseRemoved(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        private void saveIfFileKnown() {
            if (PlDotIni.this.dontAutoSave) {
                return;
            }
            if (PlDotIni.this.lastFileAccessed != null) {
                try {
                    PlDotIni.this.write(PlDotIni.this.lastFileAccessed);
                }
                catch (IOException e) {
                    logger.error((Object)"Error auto-saving PL.INI file", (Throwable)e);
                }
            }
        }
    };
    private static final Logger logger = Logger.getLogger(PlDotIni.class);
    private final List<Object> fileSections = new ArrayList<Object>();
    private long fileTime;
    boolean shuttingDown = false;
    int WAIT_TIME = 30;
    Thread monitor = new Thread(){

        public void run() {
            while (!PlDotIni.this.shuttingDown) {
                try {
                    long newFileTime;
                    Thread.sleep(PlDotIni.this.WAIT_TIME * 1000);
                    if (PlDotIni.this.lastFileAccessed == null || (newFileTime = PlDotIni.this.lastFileAccessed.lastModified()) == PlDotIni.this.fileTime) continue;
                    logger.debug((Object)"Re-reading PL.INI file because it has been modified externally.");
                    PlDotIni.this.read(PlDotIni.this.lastFileAccessed);
                    PlDotIni.this.fileTime = newFileTime;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    File lastFileAccessed;

    public PlDotIni() {
        this.listeners = new ArrayList<DatabaseListChangeListener>();
        this.listeners.add(this.saver);
    }

    Object getSection(int number) {
        return this.fileSections.get(number);
    }

    int getSectionCount() {
        return this.fileSections.size();
    }

    @Override
    public void read(File location) throws IOException {
        if (!location.canRead()) {
            throw new IOException("pl.ini file is not readable: " + location.getAbsolutePath());
        }
        this.fileTime = location.lastModified();
        this.lastFileAccessed = location;
        this.read(new FileInputStream(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(InputStream inStream) throws IOException {
        logger.info((Object)"Beginning to read/merge new pl.ini data");
        ReadState mode = ReadState.READ_GENERIC;
        try {
            this.dontAutoSave = true;
            ArchitectDataSourceType currentType = null;
            ArchitectDataSource currentDS = null;
            Section currentSection = new Section(null);
            BufferedInputStream in = new BufferedInputStream(inStream);
            byte[] lineBytes = null;
            while ((lineBytes = this.readLine(in)) != null) {
                String value;
                String key;
                String line = new String(lineBytes);
                logger.debug((Object)("Read in new line: " + line));
                if (line.startsWith("[")) {
                    this.mergeFileData(mode, currentType, currentDS, currentSection);
                }
                if (line.startsWith("[Databases_")) {
                    logger.debug((Object)("It's a new database connection spec!" + this.fileSections));
                    currentDS = new ArchitectDataSource();
                    mode = ReadState.READ_DS;
                    continue;
                }
                if (line.startsWith("[Database Types_")) {
                    logger.debug((Object)("It's a new database type!" + this.fileSections));
                    currentType = new ArchitectDataSourceType();
                    mode = ReadState.READ_TYPE;
                    continue;
                }
                if (line.startsWith("[")) {
                    logger.debug((Object)"It's a new generic section!");
                    currentSection = new Section(line.substring(1, line.length() - 1));
                    mode = ReadState.READ_GENERIC;
                    continue;
                }
                int equalsIdx = line.indexOf(61);
                if (equalsIdx > 0) {
                    key = line.substring(0, equalsIdx);
                    value = line.substring(equalsIdx + 1, line.length());
                } else {
                    key = line;
                    value = null;
                }
                logger.debug((Object)("key=" + key + ",val=" + value));
                if (mode == ReadState.READ_DS) {
                    if (key.equals("PWD") && value != null) {
                        byte[] cypherBytes = new byte[lineBytes.length - equalsIdx - 1];
                        System.arraycopy(lineBytes, equalsIdx + 1, cypherBytes, 0, cypherBytes.length);
                        value = PlDotIni.decryptPassword(9, cypherBytes);
                    }
                    currentDS.put(key, value);
                    continue;
                }
                if (mode == ReadState.READ_TYPE) {
                    currentType.putProperty(key, value);
                    continue;
                }
                if (mode != ReadState.READ_GENERIC) continue;
                currentSection.put(key, value);
            }
            in.close();
            this.mergeFileData(mode, currentType, currentDS, currentSection);
            for (Object o : this.fileSections) {
                ArchitectDataSource ds;
                String typeName;
                if (o instanceof ArchitectDataSourceType) {
                    ArchitectDataSourceType dst = (ArchitectDataSourceType)o;
                    String parentTypeName = dst.getProperty("Parent Type");
                    if (parentTypeName == null) continue;
                    ArchitectDataSourceType parentType = this.getDataSourceType(parentTypeName);
                    if (parentType == null) {
                        throw new IllegalStateException("Database type \"" + dst.getName() + "\" refers to parent type \"" + parentTypeName + "\", which doesn't exist");
                    }
                    dst.setParentType(parentType);
                    continue;
                }
                if (!(o instanceof ArchitectDataSource) || (typeName = (ds = (ArchitectDataSource)o).getPropertiesMap().get("Connection Type")) == null) continue;
                ArchitectDataSourceType type = this.getDataSourceType(typeName);
                if (type == null) {
                    throw new IllegalStateException("Database connection \"" + ds.getName() + "\" refers to database type \"" + typeName + "\", which doesn't exist");
                }
                logger.debug((Object)("The data source type \"" + type + "\" is being set as the parent type of" + ds));
                ds.setParentType(type);
            }
        }
        finally {
            this.dontAutoSave = false;
        }
        logger.info((Object)"Finished reading file.");
    }

    private void mergeFileData(ReadState mode, ArchitectDataSourceType currentType, ArchitectDataSource currentDS, Section currentSection) {
        if (mode == ReadState.READ_DS) {
            this.mergeDataSource(currentDS);
        } else if (mode == ReadState.READ_GENERIC) {
            this.mergeSection(currentSection);
        } else if (mode == ReadState.READ_TYPE) {
            if (currentType.getProperties().size() > 0) {
                this.mergeDataSourceType(currentType);
            }
        } else {
            throw new IllegalArgumentException("Unknown read state. Can't merge");
        }
    }

    private void mergeSection(Section currentSection) {
        logger.debug((Object)("Attempting to merge Section: \"" + currentSection.getName() + "\""));
        for (Object o : this.fileSections) {
            Section s;
            if (!(o instanceof Section) || ((s = (Section)o).getName() != null || currentSection.getName() != null) && (s.getName() == null || !s.getName().equals(currentSection.getName()))) continue;
            logger.debug((Object)"Found a section to merge, now merging");
            s.merge(currentSection);
            return;
        }
        logger.debug((Object)"Didn't find section to merge. Adding...");
        this.fileSections.add(currentSection);
    }

    private byte[] readLine(BufferedInputStream in) throws IOException {
        int ch;
        int MAX_LINE_LENGTH = 10000;
        byte[] buffer = new byte[10000];
        int lineSize = 0;
        while ((ch = in.read()) != -1 && lineSize < 10000) {
            buffer[lineSize] = (byte)ch;
            if (++lineSize < 2 || buffer[lineSize - 2] != 13 || buffer[lineSize - 1] != 10) continue;
            lineSize -= 2;
            break;
        }
        if (ch == -1 && lineSize == 0) {
            return null;
        }
        if (lineSize == 10000) {
            logger.error((Object)"Maximum line size exceeded while reading pl.ini.  Line will be split up.");
        }
        byte[] chopBuffer = new byte[lineSize];
        System.arraycopy(buffer, 0, chopBuffer, 0, lineSize);
        return chopBuffer;
    }

    @Override
    public void write() throws IOException {
        if (this.lastFileAccessed == null) {
            throw new IllegalStateException("Can't determine location for saving");
        }
        this.write(this.lastFileAccessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File location) throws IOException {
        logger.debug((Object)("Writing to " + location));
        try {
            this.dontAutoSave = true;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));
            this.write(out);
            ((OutputStream)out).close();
            this.lastFileAccessed = location;
            this.fileTime = location.lastModified();
        }
        finally {
            this.dontAutoSave = false;
        }
    }

    public void write(OutputStream out) throws IOException {
        int dbNum = 1;
        int typeNum = 1;
        for (Object next : this.fileSections) {
            if (next instanceof Section) {
                this.writeSection(out, ((Section)next).getName(), ((Section)next).getPropertiesMap());
                continue;
            }
            if (next instanceof ArchitectDataSource) {
                this.writeSection(out, "Databases_" + dbNum, ((ArchitectDataSource)next).getPropertiesMap());
                ++dbNum;
                continue;
            }
            if (next instanceof ArchitectDataSourceType) {
                this.writeSection(out, "Database Types_" + typeNum, ((ArchitectDataSourceType)next).getProperties());
                ++typeNum;
                continue;
            }
            if (next == null) {
                logger.error((Object)"write: Null section");
                continue;
            }
            logger.error((Object)("write: Unknown section type: " + next.getClass().getName()));
        }
    }

    private void writeSection(OutputStream out, String name, Map properties) throws IOException {
        if (name != null) {
            String sectionHeading = "[" + name + "]" + "\r\n";
            out.write(sectionHeading.getBytes());
        }
        String s = null;
        s = (String)properties.get("Logical");
        if (s != null) {
            out.write("Logical".getBytes());
            out.write("=".getBytes());
            out.write(s.getBytes());
            out.write("\r\n".getBytes());
        }
        for (Map.Entry ent : properties.entrySet()) {
            if (ent.getKey().equals("Logical")) continue;
            out.write(((String)ent.getKey()).getBytes());
            if (ent.getValue() != null) {
                byte[] val = ent.getKey().equals("PWD") ? this.encryptPassword(9, (String)ent.getValue()) : ((String)ent.getValue()).getBytes();
                out.write("=".getBytes());
                out.write(val);
            }
            out.write("\r\n".getBytes());
        }
    }

    @Override
    public ArchitectDataSource getDataSource(String name) {
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSource)) continue;
            ArchitectDataSource ds = (ArchitectDataSource)next;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking if data source " + ds + " is PL Logical connection " + name));
            }
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    public ArchitectDataSourceType getDataSourceType(String name) {
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSourceType)) continue;
            ArchitectDataSourceType dst = (ArchitectDataSourceType)next;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking if data source type " + dst + " is called " + name));
            }
            if (!dst.getName().equals(name)) continue;
            return dst;
        }
        return null;
    }

    @Override
    public List<ArchitectDataSourceType> getDataSourceTypes() {
        ArrayList<ArchitectDataSourceType> list = new ArrayList<ArchitectDataSourceType>();
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSourceType)) continue;
            ArchitectDataSourceType dst = (ArchitectDataSourceType)next;
            list.add(dst);
        }
        return list;
    }

    @Override
    public List<ArchitectDataSource> getConnections() {
        ArrayList<ArchitectDataSource> connections = new ArrayList<ArchitectDataSource>();
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSource)) continue;
            connections.add((ArchitectDataSource)next);
        }
        Collections.sort(connections, new ArchitectDataSource.DefaultComparator());
        return connections;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            return "PlDotIni: toString: Couldn't create string description: " + e.getMessage();
        }
        return ((Object)out).toString();
    }

    private byte[] encryptPassword(int key, String plaintext) {
        byte[] cyphertext = new byte[plaintext.length()];
        for (int i = 0; i < plaintext.length(); ++i) {
            int temp = plaintext.charAt(i);
            temp = i % 2 == 1 ? (temp -= key) : (temp += key);
            cyphertext[i] = (byte)(temp ^= 10 - key);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            for (int i = 0; i < cyphertext.length; ++i) {
                nums.append(cyphertext[i]);
                nums.append(' ');
            }
            logger.debug((Object)("Encrypt: Plaintext: \"" + plaintext + "\"; cyphertext=(" + nums + ")"));
        }
        return cyphertext;
    }

    public static String decryptPassword(int number, byte[] cyphertext) {
        StringBuffer plaintext = new StringBuffer(cyphertext.length);
        int n = cyphertext.length;
        for (int i = 0; i < n; ++i) {
            int temp = cyphertext[i] & 0xFF ^ 10 - number;
            temp = i % 2 == 1 ? (temp += number) : (temp -= number);
            plaintext.append((char)temp);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            for (int i = 0; i < cyphertext.length; ++i) {
                nums.append(cyphertext[i]);
                nums.append(' ');
            }
            logger.debug((Object)("Decrypt: cyphertext=(" + nums + "); Plaintext: \"" + plaintext + "\""));
        }
        return plaintext.toString();
    }

    @Override
    public void addDataSource(ArchitectDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            ArchitectDataSource oneDbcs;
            if (!(o instanceof ArchitectDataSource) || !newName.equalsIgnoreCase((oneDbcs = (ArchitectDataSource)o).getDisplayName())) continue;
            throw new IllegalArgumentException("There is already a datasource with the name " + newName);
        }
        this.addDataSourceImpl(dbcs);
    }

    @Override
    public void mergeDataSource(ArchitectDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            ArchitectDataSource oneDbcs;
            if (!(o instanceof ArchitectDataSource) || !newName.equalsIgnoreCase((oneDbcs = (ArchitectDataSource)o).getDisplayName())) continue;
            for (Map.Entry<String, String> ent : dbcs.getPropertiesMap().entrySet()) {
                oneDbcs.put(ent.getKey(), ent.getValue());
            }
            return;
        }
        this.addDataSourceImpl(dbcs);
    }

    @Override
    public void removeDataSource(ArchitectDataSource dbcs) {
        for (int where = 0; where < this.fileSections.size(); ++where) {
            ArchitectDataSource current;
            Object o = this.fileSections.get(where);
            if (!(o instanceof ArchitectDataSource) || !(current = (ArchitectDataSource)o).getName().equals(dbcs.getName())) continue;
            this.fileSections.remove(where);
            this.fireRemoveEvent(where, dbcs);
            return;
        }
        throw new IllegalArgumentException("dbcs not in list");
    }

    @Override
    public void mergeDataSourceType(ArchitectDataSourceType dst) {
        logger.debug((Object)("Merging data source type " + dst.getName()));
        String newName = dst.getName();
        if (newName == null) {
            throw new IllegalArgumentException("Can't merge a nameless data source type: " + dst);
        }
        for (Object o : this.fileSections) {
            ArchitectDataSourceType current;
            if (!(o instanceof ArchitectDataSourceType) || !newName.equalsIgnoreCase((current = (ArchitectDataSourceType)o).getName())) continue;
            logger.debug((Object)"    Found it");
            for (Map.Entry<String, String> ent : dst.getProperties().entrySet()) {
                current.putProperty(ent.getKey(), ent.getValue());
            }
            return;
        }
        logger.debug((Object)"    Not found.. adding");
        this.addDataSourceType(dst);
    }

    private void addDataSourceImpl(ArchitectDataSource dbcs) {
        this.fileSections.add(dbcs);
        this.fireAddEvent(dbcs);
    }

    @Override
    public void addDataSourceType(ArchitectDataSourceType dataSourceType) {
        this.fileSections.add(dataSourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddEvent(ArchitectDataSource dbcs) {
        int index = this.fileSections.size() - 1;
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, index, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseAdded(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveEvent(int i, ArchitectDataSource dbcs) {
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, i, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadState {
        READ_DS,
        READ_GENERIC,
        READ_TYPE;

    }

    static class Section {
        private String name;
        private Map properties;

        public Section(String name) {
            this.name = name;
            this.properties = new LinkedHashMap();
        }

        public Object put(String key, String value) {
            return this.properties.put(key, value);
        }

        public Map getPropertiesMap() {
            return this.properties;
        }

        public String getName() {
            return this.name;
        }

        public void merge(Section s) {
            this.properties.keySet().retainAll(s.properties.keySet());
            this.properties.putAll(s.properties);
        }
    }
}

