/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.DBTreeModel;
import ca.sqlpower.sql.DataMover;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class DataMoverPanel {
    private JPanel panel;
    private JTree sourceTree;
    private JTree destTree;
    private JCheckBox truncateDestinationTableBox;
    private Action okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            try {
                DataMoverPanel.this.doDataMove();
            }
            catch (Exception ex) {
                ASUtils.showExceptionDialog("Failed to move data", ex);
            }
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            try {
                Window w = SwingUtilities.getWindowAncestor(DataMoverPanel.this.panel);
                if (w != null) {
                    w.dispose();
                }
            }
            catch (Exception ex) {
                ASUtils.showExceptionDialog("Failed to move data", ex);
            }
        }
    };

    public DataMoverPanel(ArchitectSession session) throws ArchitectException {
        ArrayList<SQLDatabase> dblist = new ArrayList<SQLDatabase>();
        for (ArchitectDataSource ds : session.getUserSettings().getConnections()) {
            dblist.add(new SQLDatabase(ds));
        }
        this.sourceTree = new JTree(new DBTreeModel(dblist, session));
        this.sourceTree.setRootVisible(false);
        this.sourceTree.setShowsRootHandles(true);
        this.sourceTree.setCellRenderer(new DBTreeCellRenderer(session));
        this.destTree = new JTree(new DBTreeModel(dblist, session));
        this.destTree.setRootVisible(false);
        this.destTree.setShowsRootHandles(true);
        this.destTree.setCellRenderer(new DBTreeCellRenderer(session));
        PanelBuilder pb = new PanelBuilder(new FormLayout("pref:grow,8dlu,pref:grow", "pref,4dlu,fill:pref:grow,4dlu,pref,4dlu,pref"));
        pb.getLayout().addGroupedColumn(1);
        pb.getLayout().addGroupedColumn(3);
        CellConstraints cc = new CellConstraints();
        pb.addLabel("Source", cc.xy(1, 1));
        pb.addLabel("Destination", cc.xy(3, 1));
        pb.add((Component)new JScrollPane(this.sourceTree), cc.xy(1, 3));
        pb.add((Component)new JScrollPane(this.destTree), cc.xy(3, 3));
        this.truncateDestinationTableBox = new JCheckBox("Truncate Destination Table?");
        pb.add((Component)this.truncateDestinationTableBox, cc.xy(3, 5));
        pb.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)new JButton(this.okAction), (JButton)new JButton(this.cancelAction)), cc.xyw(1, 7, 3));
        pb.setDefaultDialogBorder();
        this.panel = pb.getPanel();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void doDataMove() throws SQLException, ArchitectException {
        TreePath[] sourcePaths = this.sourceTree.getSelectionPaths();
        int tableCount = 0;
        int rowCount = 0;
        for (TreePath sourcePath : sourcePaths) {
            SQLTable sourceTable = (SQLTable)sourcePath.getLastPathComponent();
            int thisCount = this.moveSingleTable(sourceTable);
            if (thisCount == -1) {
                int choice = JOptionPane.showConfirmDialog(this.panel, "Continue copying remaining tables?");
                if (choice == 0) continue;
                break;
            }
            ++tableCount;
            rowCount += thisCount;
        }
        JOptionPane.showMessageDialog(this.panel, "Copied data from " + tableCount + " tables (" + rowCount + " rows in total)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int moveSingleTable(SQLTable sourceTable) throws SQLException, ArchitectException {
        SQLDatabase sourceDB = DataMoverPanel.getParentDatabase(sourceTable);
        TreePath destPath = this.destTree.getSelectionPath();
        SQLObject destObject = (SQLObject)destPath.getLastPathComponent();
        SQLDatabase destDB = DataMoverPanel.getParentDatabase(destObject);
        String destCatalogName = null;
        String destSchemaName = null;
        String destTableName = sourceTable.getName();
        for (SQLObject tmpSqlObj = destObject; tmpSqlObj != null; tmpSqlObj = tmpSqlObj.getParent()) {
            if (tmpSqlObj instanceof SQLTable) {
                destTableName = tmpSqlObj.getName();
            }
            if (tmpSqlObj instanceof SQLCatalog) {
                destCatalogName = tmpSqlObj.getName();
            }
            if (!(tmpSqlObj instanceof SQLSchema)) continue;
            destSchemaName = tmpSqlObj.getName();
        }
        boolean needToCreate = false;
        SQLTable destTable = destDB.getTableByName(destCatalogName, destSchemaName, destTableName);
        if (destTable == null) {
            needToCreate = true;
            destTable = ArchitectUtils.addSimulatedTable(destDB, destCatalogName, destSchemaName, destTableName);
        }
        Connection sourceCon = null;
        Connection destCon = null;
        try {
            int count;
            sourceCon = sourceDB.getConnection();
            destCon = destDB.getConnection();
            String sourceQualifiedName = DDLUtils.toQualifiedName(sourceTable.getCatalogName(), sourceTable.getSchemaName(), sourceTable.getName());
            String destQualifiedName = DDLUtils.toQualifiedName(destCatalogName, destSchemaName, destTableName);
            if (needToCreate) {
                int choice = JOptionPane.showConfirmDialog(this.panel, "The destination table\n" + destQualifiedName + "\nDoes not exist.  Create it?");
                if (choice != 0) {
                    int n = -1;
                    return n;
                }
                DDLGenerator ddlg = DDLUtils.createDDLGenerator(destDB.getDataSource());
                ddlg.addTable(destTable);
                ddlg.generateDDLStatements(destDB);
                Statement stmt = null;
                try {
                    stmt = destCon.createStatement();
                    for (DDLStatement ddlstmt : ddlg.getDdlStatements()) {
                        stmt.executeUpdate(ddlstmt.getSQLText());
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            DataMover mover = new DataMover(destCon, sourceCon);
            mover.setCreatingDestinationTable(false);
            mover.setTruncatingDestinationTable(this.truncateDestinationTableBox.isSelected());
            mover.setDebug(true);
            JOptionPane.showMessageDialog(this.panel, "About to copy\n" + sourceQualifiedName + "\nto\n" + destQualifiedName);
            int n = count = mover.copyTable(destQualifiedName, sourceQualifiedName);
            return n;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        finally {
            sourceCon.close();
            destCon.close();
        }
    }

    private static SQLDatabase getParentDatabase(SQLObject obj) {
        while (obj != null) {
            if (obj instanceof SQLDatabase) {
                return (SQLDatabase)obj;
            }
            obj = obj.getParent();
        }
        return null;
    }
}

