/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.IndexColumnTableCellEditor;
import ca.sqlpower.architect.swingui.IndexColumnTableModel;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import ca.sqlpower.util.table.EditableJTable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class IndexEditPanel
extends JPanel
implements ArchitectPanel {
    protected SQLIndex index;
    protected SQLTable parent;
    protected SQLIndex indexCopy;
    JTextField name;
    JCheckBox unique;
    JComboBox indexType;
    JTextField qualifier;
    JTextField filterCondition;
    EditableJTable columnsList;
    protected LinkedList<UndoCompoundEventListener> undoEventListeners = new LinkedList();

    public IndexEditPanel(SQLIndex index) throws ArchitectException {
        super((LayoutManager)new FormLayout("pref,4dlu,pref,4dlu,pref:grow,4dlu,pref", "pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref:grow,4dlu,pref,4dlu"));
        this.createGUI(index, index.getParentTable());
    }

    public IndexEditPanel(SQLIndex index, SQLTable parent) throws ArchitectException {
        super((LayoutManager)new FormLayout("pref,4dlu,pref,4dlu,pref:grow,4dlu,pref", "pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref:grow,4dlu,pref,4dlu"));
        this.createGUI(index, parent);
    }

    private void createGUI(SQLIndex index, SQLTable parent) throws ArchitectException {
        this.parent = parent;
        this.addUndoEventListener(ArchitectFrame.getMainInstance().getProject().getUndoManager().getEventAdapter());
        PanelBuilder pb = new PanelBuilder((FormLayout)this.getLayout(), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel("Index Name"), cc.xy(1, 1));
        this.name = new JTextField("", 30);
        pb.add((Component)this.name, cc.xyw(3, 1, 4));
        pb.add((Component)new JLabel("Unique"), cc.xy(1, 3));
        this.unique = new JCheckBox();
        pb.add((Component)this.unique, cc.xy(3, 3));
        pb.add((Component)new JLabel("Index Type"), cc.xy(1, 5));
        this.indexType = new JComboBox<SQLIndex.IndexType>(SQLIndex.IndexType.values());
        pb.add((Component)this.indexType, cc.xyw(3, 5, 4));
        pb.add((Component)new JLabel("Qualifier"), cc.xy(1, 7));
        this.qualifier = new JTextField();
        pb.add((Component)this.qualifier, cc.xyw(3, 7, 4));
        pb.add((Component)new JLabel("Filter Condition"), cc.xy(1, 9));
        this.filterCondition = new JTextField();
        pb.add((Component)this.filterCondition, cc.xyw(3, 9, 4));
        this.editIndex(index);
        this.columnsList = new EditableJTable();
        this.columnsList.setModel((TableModel)new IndexColumnTableModel(this.indexCopy, parent));
        this.columnsList.setDefaultEditor(SQLColumn.class, (TableCellEditor)new IndexColumnTableCellEditor());
        this.columnsList.setAutoResizeMode(1);
        pb.add((Component)new JScrollPane((Component)this.columnsList), cc.xyw(1, 11, 6));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGridded((JComponent)new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent e) {
                try {
                    SQLIndex sQLIndex = IndexEditPanel.this.indexCopy;
                    SQLIndex sQLIndex2 = IndexEditPanel.this.indexCopy;
                    sQLIndex2.getClass();
                    sQLIndex.addChild(sQLIndex2.new SQLIndex.Column("New", false, false));
                }
                catch (ArchitectException e1) {
                    throw new ArchitectRuntimeException(e1);
                }
            }
        }));
        bb.addGridded((JComponent)new JButton(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                IndexEditPanel.this.indexCopy.removeChild(IndexEditPanel.this.columnsList.getSelectedRow());
            }
        }));
        pb.add((Component)bb.getPanel(), cc.xyw(1, 13, 6));
        this.loadIndexIntoPanel();
    }

    public void editIndex(SQLIndex index) throws ArchitectException {
        this.index = index;
        this.name.setText(index.getName());
        this.indexCopy = new SQLIndex(index);
        this.indexCopy.setPrimaryKeyIndex(false);
    }

    private void loadIndexIntoPanel() {
        this.name.setText(this.index.getName());
        this.unique.setSelected(this.index.isUnique());
        this.qualifier.setText(this.index.getQualifier());
        this.filterCondition.setText(this.index.getFilterCondition());
        this.indexType.setSelectedItem((Object)this.index.getType());
    }

    protected SQLIndex getIndexCopy() {
        return this.indexCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyChanges() {
        this.startCompoundEdit("Index Properties Change");
        try {
            StringBuffer warnings = new StringBuffer();
            if (this.name.getText().trim().length() == 0) {
                warnings.append("The index cannot be assigned a blank name \n");
            }
            if (this.index.isPrimaryKeyIndex()) {
                for (SQLIndex.Column c : this.indexCopy.getChildren()) {
                    if (c.getColumn() != null) continue;
                    warnings.append("Can only add columns to the primary key\n");
                    break;
                }
            }
            if (warnings.toString().length() == 0) {
                this.index.makeColumnsLike(this.indexCopy);
                SQLTable parentTable = this.parent;
                if (this.index.isPrimaryKeyIndex()) {
                    try {
                        parentTable.setMagicEnabled(false);
                        for (SQLColumn c : parentTable.getColumns()) {
                            c.setPrimaryKeySeq(null);
                        }
                        int i = 0;
                        for (SQLIndex.Column c : this.indexCopy.getChildren()) {
                            SQLColumn column = c.getColumn();
                            if (column == null) continue;
                            column.setPrimaryKeySeq(Integer.MAX_VALUE);
                            parentTable.removeColumn(column);
                            parentTable.addColumn(i, column);
                            ++i;
                        }
                    }
                    finally {
                        parentTable.setMagicEnabled(true);
                    }
                }
                this.index.setName(this.name.getText());
                this.index.setUnique(this.unique.isSelected());
                this.index.setType((SQLIndex.IndexType)((Object)this.indexType.getSelectedItem()));
                this.index.setQualifier(this.qualifier.getText());
                this.index.setFilterCondition(this.filterCondition.getText());
                SQLTable.Folder<SQLIndex> indicesFolder = parentTable.getIndicesFolder();
                List children = indicesFolder.getChildren();
                if (!children.contains(this.index)) {
                    indicesFolder.addChild(this.index);
                }
                boolean bl = true;
                return bl;
            }
            JOptionPane.showMessageDialog(this, warnings.toString());
            boolean bl = false;
            return bl;
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
        finally {
            this.endCompoundEdit("Ending new compound edit event in index edit panel");
        }
    }

    public void discardChanges() {
    }

    public void addUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.add(l);
    }

    public void removeUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    protected void fireUndoCompoundEvent(UndoCompoundEvent e) {
        Iterator it = this.undoEventListeners.iterator();
        if (e.getType().isStartEvent()) {
            while (it.hasNext()) {
                ((UndoCompoundEventListener)it.next()).compoundEditStart(e);
            }
        } else {
            while (it.hasNext()) {
                ((UndoCompoundEventListener)it.next()).compoundEditEnd(e);
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, message));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getNameText() {
        return this.name.getText();
    }

    public void setNameText(String newName) {
        this.name.setText(newName);
    }
}

