/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ProfileResultsViewer;
import ca.sqlpower.architect.swingui.ProfileRowComponent;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ProfileManagerView
extends JPanel
implements ProfileChangeListener {
    private static Logger logger = Logger.getLogger(ProfileManagerView.class);
    ProfileManager pm;
    static final int VISIBLE_ROWS = 8;
    final ResultListPanel resultListPanel;
    final JScrollPane scrollPane;
    final JLabel statusText;
    final JTextField searchText;
    private Comparator<ProfileRowComponent> comparator;
    List<ProfileRowComponent> list = new ArrayList<ProfileRowComponent>();
    List<ProfileRowComponent> showingRows = new ArrayList<ProfileRowComponent>();

    public ProfileManagerView(final ProfileManager pm) {
        this.pm = pm;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.add((Component)topPanel, "North");
        topPanel.add(new JLabel("Search"));
        this.searchText = new JTextField(10);
        this.searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ProfileManagerView.this.doSearch(ProfileManagerView.this.searchText.getText());
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        topPanel.add(this.searchText);
        ImageIcon clearSearchIcon = ASUtils.createJLFIcon("general/Delete", "Clear Search", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 16));
        JButton clearSearchButton = new JButton(clearSearchIcon);
        clearSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileManagerView.this.searchText.setText("");
                ProfileManagerView.this.doSearch("");
            }
        });
        topPanel.add(clearSearchButton);
        this.comparator = new TableProfileNameComparator();
        JLabel orderByLabel = new JLabel("Order by");
        topPanel.add(orderByLabel);
        final JRadioButton nameRadioButton = new JRadioButton("Name");
        topPanel.add(nameRadioButton);
        JRadioButton dateRadioButton = new JRadioButton("Date");
        topPanel.add(dateRadioButton);
        ActionListener radioListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (nameRadioButton.isSelected()) {
                    ProfileManagerView.this.setComparator(new TableProfileNameComparator());
                } else {
                    ProfileManagerView.this.setComparator(new TableProfileDateComparator());
                }
            }
        };
        nameRadioButton.addActionListener(radioListener);
        dateRadioButton.addActionListener(radioListener);
        ButtonGroup group = new ButtonGroup();
        group.add(nameRadioButton);
        group.add(dateRadioButton);
        nameRadioButton.setSelected(true);
        this.resultListPanel = new ResultListPanel();
        this.resultListPanel.setBackground(UIManager.getColor("List.background"));
        this.resultListPanel.setLayout(new GridLayout(0, 1));
        for (TableProfileResult result : pm.getTableResults()) {
            ProfileRowComponent myRowComponent = new ProfileRowComponent(result, pm);
            this.list.add(myRowComponent);
            myRowComponent.addSelectionListener(this.resultListPanel);
            this.resultListPanel.add(myRowComponent);
            this.showingRows.add(myRowComponent);
        }
        this.scrollPane = new JScrollPane(this.resultListPanel);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
        AbstractAction viewAllAction = new AbstractAction("View All"){

            public void actionPerformed(ActionEvent e) {
                ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer((TableProfileManager)pm);
                profileResultsViewer.clearScanList();
                for (ProfileRowComponent rowComp : ProfileManagerView.this.showingRows) {
                    TableProfileResult result = rowComp.getResult();
                    profileResultsViewer.addTableProfileResultToScan(result);
                    profileResultsViewer.addTableProfileResult(result);
                }
                profileResultsViewer.getDialog().setVisible(true);
            }
        };
        bottomPanel.add(new JButton(viewAllAction));
        AbstractAction viewSelectedAction = new AbstractAction("View Selected"){

            public void actionPerformed(ActionEvent e) {
                ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer((TableProfileManager)pm);
                profileResultsViewer.clearScanList();
                for (ProfileRowComponent rowComp : ProfileManagerView.this.showingRows) {
                    if (!rowComp.isSelected()) continue;
                    TableProfileResult result = rowComp.getResult();
                    profileResultsViewer.addTableProfileResultToScan(result);
                    profileResultsViewer.addTableProfileResult(result);
                }
                profileResultsViewer.getDialog().setVisible(true);
            }
        };
        bottomPanel.add(new JButton(viewSelectedAction));
        this.statusText = new JLabel();
        this.updateStatus();
        bottomPanel.add(this.statusText);
        AbstractAction deleteAllAction = new AbstractAction("Delete All"){

            public void actionPerformed(ActionEvent e) {
                int confirm = JOptionPane.showConfirmDialog(ArchitectFrame.getMainInstance(), "Are you sure you want to delete all your profile data?\n(this cannot be undone)", "Delete All?", 0);
                if (confirm == 0) {
                    ProfileManagerView.this.resultListPanel.removeAll();
                    ProfileManagerView.this.list.clear();
                    ProfileManagerView.this.showingRows.clear();
                    pm.clear();
                    ProfileManagerView.this.resultListPanel.revalidate();
                }
            }
        };
        bottomPanel.add(new JButton(deleteAllAction));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container c;
                for (c = ProfileManagerView.this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
                }
                if (c != null) {
                    c.setVisible(false);
                }
            }
        });
        bottomPanel.add(closeButton);
    }

    private void updateStatus() {
        int totalNumber = this.list.size();
        int numberShowing = this.showingRows.size();
        this.statusText.setText(String.format("Showing %d of %d Profiles", numberShowing, totalNumber));
    }

    private void updateResultListPanel() {
        this.resultListPanel.removeAll();
        for (ProfileRowComponent r : this.showingRows) {
            this.resultListPanel.add(r);
        }
        this.resultListPanel.revalidate();
    }

    protected void doSearch(String text) {
        this.showingRows.clear();
        if (text == null || text.length() == 0) {
            for (ProfileRowComponent r : this.list) {
                this.showingRows.add(r);
            }
        } else {
            String searchText = text.toLowerCase();
            for (ProfileRowComponent r : this.list) {
                if (!((SQLTable)r.getResult().getProfiledObject()).getName().toLowerCase().contains(searchText)) continue;
                this.showingRows.add(r);
            }
        }
        Collections.sort(this.showingRows, this.comparator);
        this.updateResultListPanel();
        this.updateStatus();
    }

    private void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.doSearch(this.searchText.getText());
    }

    public void profilesAdded(ProfileChangeEvent e) {
        logger.debug((Object)"ProfileManagerView.profileAdded(): table profile added");
        ArrayList<ProfileResult> profileResult = new ArrayList<ProfileResult>(e.getProfileResult());
        for (ProfileResult pr : profileResult) {
            if (pr instanceof TableProfileResult) {
                ProfileRowComponent myRowComponent = new ProfileRowComponent((TableProfileResult)pr, this.pm);
                myRowComponent.addSelectionListener(this.resultListPanel);
                this.list.add(myRowComponent);
                continue;
            }
            logger.debug((Object)("Cannot create a component based on the profile result " + pr));
        }
        this.doSearch(this.searchText.getText());
    }

    public void profilesRemoved(ProfileChangeEvent e) {
        List<ProfileResult> profileResults = e.getProfileResult();
        logger.debug((Object)("ProfileManagerView.profileRemoved(): " + profileResults + ": profiles deleted"));
        block0: for (ProfileResult profileResult : profileResults) {
            for (ProfileRowComponent view : this.list) {
                if (!view.getResult().equals(profileResult)) continue;
                this.list.remove(view);
                view.removeSelectionListener(this.resultListPanel);
                continue block0;
            }
        }
        this.doSearch(this.searchText.getText());
    }

    public void profileListChanged(ProfileChangeEvent e) {
        logger.debug((Object)"ProfileChanged method not yet implemented.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableProfileDateComparator
    implements Comparator<ProfileRowComponent> {
        private TableProfileDateComparator() {
        }

        @Override
        public int compare(ProfileRowComponent o1, ProfileRowComponent o2) {
            TableProfileResult tpr1 = o1.getResult();
            TableProfileResult tpr2 = o2.getResult();
            if (tpr1.getCreateStartTime() < tpr2.getCreateStartTime()) {
                return -1;
            }
            if (tpr1.getCreateStartTime() > tpr2.getCreateStartTime()) {
                return 1;
            }
            int result = ((SQLTable)tpr1.getProfiledObject()).getName().compareTo(((SQLTable)tpr2.getProfiledObject()).getName());
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableProfileNameComparator
    implements Comparator<ProfileRowComponent> {
        private TableProfileNameComparator() {
        }

        @Override
        public int compare(ProfileRowComponent o1, ProfileRowComponent o2) {
            TableProfileResult tpr1 = o1.getResult();
            TableProfileResult tpr2 = o2.getResult();
            int result = ((SQLTable)tpr1.getProfiledObject()).getName().compareTo(((SQLTable)tpr2.getProfiledObject()).getName());
            if (result != 0) {
                return result;
            }
            if (tpr1.getCreateStartTime() < tpr2.getCreateStartTime()) {
                return -1;
            }
            if (tpr1.getCreateStartTime() > tpr2.getCreateStartTime()) {
                return 1;
            }
            return 0;
        }
    }

    private class ResultListPanel
    extends JPanel
    implements Scrollable,
    SelectionListener {
        private ProfileRowComponent lastSelectedRow;
        private boolean ignoreSelectionEvents = false;

        private ResultListPanel() {
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return d;
        }

        public Dimension getPreferredScrollableViewportSize() {
            if (ProfileManagerView.this.list.size() == 0) {
                return super.getPreferredSize();
            }
            Dimension d = super.getPreferredSize();
            d.height = ProfileManagerView.this.list.get((int)0).getPreferredSize().height * 8;
            d.width = Math.max(ProfileManagerView.this.resultListPanel.getPreferredSize().width, d.width);
            return d;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 15;
        }

        public void itemDeselected(SelectionEvent e) {
            if (this.ignoreSelectionEvents) {
                return;
            }
            this.ignoreSelectionEvents = true;
            this.ignoreSelectionEvents = false;
        }

        public void itemSelected(SelectionEvent e) {
            if (this.ignoreSelectionEvents) {
                return;
            }
            this.ignoreSelectionEvents = true;
            ProfileRowComponent selectedRow = (ProfileRowComponent)e.getSource();
            if (e.getMultiselectType() == 4) {
                this.lastSelectedRow = selectedRow;
                for (ProfileRowComponent row : ProfileManagerView.this.list) {
                    if (row == selectedRow) continue;
                    row.setSelected(false, 4);
                }
            } else if (e.getMultiselectType() == 8) {
                this.lastSelectedRow = selectedRow;
            } else if (e.getMultiselectType() == 16) {
                int lastSelectedRowIndex = ProfileManagerView.this.showingRows.indexOf(this.lastSelectedRow);
                int selectedRowIndex = ProfileManagerView.this.showingRows.indexOf(selectedRow);
                int start = Math.min(lastSelectedRowIndex, selectedRowIndex);
                int end = Math.max(lastSelectedRowIndex, selectedRowIndex);
                for (int i = 0; i < ProfileManagerView.this.showingRows.size(); ++i) {
                    if (i < start || i > end) {
                        ProfileManagerView.this.showingRows.get(i).setSelected(false, 4);
                        continue;
                    }
                    ProfileManagerView.this.showingRows.get(i).setSelected(true, 4);
                }
            }
            this.ignoreSelectionEvents = false;
        }
    }
}

