/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CreateTableAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(CreateTableAction.class);
    protected PlayPen pp;

    public CreateTableAction() {
        super("New Table", ASUtils.createIcon("NewTable", "New Table", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "New Table");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 0));
    }

    public void actionPerformed(ActionEvent evt) {
        this.pp.fireCancel();
        SQLTable t = null;
        try {
            t = new SQLTable();
            t.initFolders(true);
        }
        catch (ArchitectException e) {
            logger.error((Object)("Couldn't add folder to table \"" + t.getName() + "\""), (Throwable)e);
            JOptionPane.showMessageDialog(null, "Failed to add folder to table:\n" + e.getMessage());
        }
        t.setName("New_Table");
        TablePane tp = new TablePane(t, this.pp);
        this.pp.addFloating(tp);
        PlayPen.setMouseMode(PlayPen.MouseModeType.CREATING_TABLE);
    }

    public void setPlayPen(PlayPen pp) {
        this.pp = pp;
    }
}

