/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.CommonCloseAction;
import ca.sqlpower.architect.swingui.EngineExecPanel;
import ca.sqlpower.architect.swingui.JDefaultButton;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RunPLAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(RunPLAction.class);

    public void actionPerformed(ActionEvent e) {
        File plEngine = new File(ArchitectFrame.getMainInstance().getUserSettings().getETLUserSettings().getString("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        File plDir = plEngine.getParentFile();
        File engineExe = new File(plDir, "PowerLoader_odbc.exe");
        final StringBuffer commandLine = this.getPLCommandLine();
        logger.debug((Object)"Running pl");
        if (engineExe.exists()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Process proc = Runtime.getRuntime().exec(commandLine.toString());
                        JDialog pld = new JDialog((Frame)ArchitectFrame.getMainInstance(), "Power*Loader Engine");
                        EngineExecPanel eep = new EngineExecPanel(commandLine.toString(), proc);
                        pld.setContentPane(eep);
                        CommonCloseAction closeAction = new CommonCloseAction(pld);
                        JButton abortButton = new JButton(eep.getAbortAction());
                        JDefaultButton closeButton = new JDefaultButton(closeAction);
                        JCheckBox scrollLockCheckBox = new JCheckBox(eep.getScrollBarLockAction());
                        JPanel buttonPanel = new JPanel(new FlowLayout(1));
                        buttonPanel.add(abortButton);
                        buttonPanel.add(closeButton);
                        buttonPanel.add(scrollLockCheckBox);
                        eep.add((Component)buttonPanel, "South");
                        pld.getRootPane().setDefaultButton(closeButton);
                        pld.pack();
                        pld.setLocationRelativeTo(ArchitectFrame.getMainInstance());
                        pld.setVisible(true);
                    }
                    catch (IOException ie) {
                        JOptionPane.showMessageDialog(ArchitectFrame.getMainInstance(), "Unexpected Exception running Engine:\n" + ie);
                        logger.error((Object)"IOException while trying to run engine.", (Throwable)ie);
                    }
                }
            });
        }
    }

    private StringBuffer getPLCommandLine() {
        JTextArea args = new JTextArea();
        return new StringBuffer(args.getText());
    }
}

