/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.valve.AccessLogValveForm;
import org.apache.webapp.admin.valve.RemoteAddrValveForm;
import org.apache.webapp.admin.valve.RemoteHostValveForm;
import org.apache.webapp.admin.valve.RequestDumperValveForm;
import org.apache.webapp.admin.valve.SingleSignOnValveForm;

public class EditValveAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName vname = null;
        Object sb = null;
        try {
            vname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.valveName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        String parent = request.getParameter("parent");
        String valveType = null;
        String attribute = null;
        try {
            attribute = "className";
            String className = (String)this.mBServer.getAttribute(vname, attribute);
            int period = className.lastIndexOf(".");
            if (period >= 0) {
                valveType = className.substring(period + 1);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        if ("AccessLogValve".equalsIgnoreCase(valveType)) {
            this.setUpAccessLogValve(vname, request, response);
        } else if ("RemoteAddrValve".equalsIgnoreCase(valveType)) {
            this.setUpRemoteAddrValve(vname, request, response);
        } else if ("RemoteHostValve".equalsIgnoreCase(valveType)) {
            this.setUpRemoteHostValve(vname, request, response);
        } else if ("RequestDumperValve".equalsIgnoreCase(valveType)) {
            this.setUpRequestDumperValve(vname, request, response);
        } else if ("SingleSignOn".equalsIgnoreCase(valveType)) {
            this.setUpSingleSignOnValve(vname, request, response);
        }
        return mapping.findForward(valveType);
    }

    private void setUpAccessLogValve(ObjectName vname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String parent = request.getParameter("parent");
        AccessLogValveForm valveFm = new AccessLogValveForm();
        session.setAttribute("accessLogValveForm", (Object)valveFm);
        valveFm.setAdminAction("Edit");
        valveFm.setObjectName(vname.toString());
        valveFm.setParentObjectName(parent);
        String valveType = "AccessLogValve";
        StringBuffer sb = new StringBuffer("");
        String host = vname.getKeyProperty("host");
        String context = vname.getKeyProperty("path");
        if (host != null) {
            sb.append("Host (" + host + ") > ");
        }
        if (context != null) {
            sb.append("Context (" + context + ") > ");
        }
        sb.append("Valve");
        valveFm.setNodeLabel(sb.toString());
        valveFm.setValveType(valveType);
        valveFm.setBooleanVals(Lists.getBooleanValues());
        String attribute = null;
        try {
            attribute = "directory";
            valveFm.setDirectory((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "pattern";
            valveFm.setPattern((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "prefix";
            valveFm.setPrefix((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "suffix";
            valveFm.setSuffix((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "resolveHosts";
            valveFm.setResolveHosts(((Boolean)this.mBServer.getAttribute(vname, attribute)).toString());
            attribute = "rotatable";
            valveFm.setRotatable(((Boolean)this.mBServer.getAttribute(vname, attribute)).toString());
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpRequestDumperValve(ObjectName vname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String parent = request.getParameter("parent");
        RequestDumperValveForm valveFm = new RequestDumperValveForm();
        session.setAttribute("requestDumperValveForm", (Object)valveFm);
        valveFm.setAdminAction("Edit");
        valveFm.setObjectName(vname.toString());
        valveFm.setParentObjectName(parent);
        String valveType = "RequestDumperValve";
        StringBuffer sb = new StringBuffer("Valve (");
        sb.append(valveType);
        sb.append(")");
        valveFm.setNodeLabel(sb.toString());
        valveFm.setValveType(valveType);
        Object attribute = null;
    }

    private void setUpSingleSignOnValve(ObjectName vname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String parent = request.getParameter("parent");
        SingleSignOnValveForm valveFm = new SingleSignOnValveForm();
        session.setAttribute("singleSignOnValveForm", (Object)valveFm);
        valveFm.setAdminAction("Edit");
        valveFm.setObjectName(vname.toString());
        valveFm.setParentObjectName(parent);
        String valveType = "SingleSignOn";
        StringBuffer sb = new StringBuffer("Valve (");
        sb.append(valveType);
        sb.append(")");
        valveFm.setNodeLabel(sb.toString());
        valveFm.setValveType(valveType);
        Object attribute = null;
    }

    private void setUpRemoteAddrValve(ObjectName vname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String parent = request.getParameter("parent");
        RemoteAddrValveForm valveFm = new RemoteAddrValveForm();
        session.setAttribute("remoteAddrValveForm", (Object)valveFm);
        valveFm.setAdminAction("Edit");
        valveFm.setObjectName(vname.toString());
        valveFm.setParentObjectName(parent);
        String valveType = "RemoteAddrValve";
        StringBuffer sb = new StringBuffer("Valve (");
        sb.append(valveType);
        sb.append(")");
        valveFm.setNodeLabel(sb.toString());
        valveFm.setValveType(valveType);
        String attribute = null;
        try {
            attribute = "allow";
            valveFm.setAllow((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "deny";
            valveFm.setDeny((String)this.mBServer.getAttribute(vname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpRemoteHostValve(ObjectName vname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String parent = request.getParameter("parent");
        RemoteHostValveForm valveFm = new RemoteHostValveForm();
        session.setAttribute("remoteHostValveForm", (Object)valveFm);
        valveFm.setAdminAction("Edit");
        valveFm.setObjectName(vname.toString());
        valveFm.setParentObjectName(parent);
        String valveType = "RemoteHostValve";
        StringBuffer sb = new StringBuffer("Valve (");
        sb.append(valveType);
        sb.append(")");
        valveFm.setNodeLabel(sb.toString());
        valveFm.setValveType(valveType);
        String attribute = null;
        try {
            attribute = "allow";
            valveFm.setAllow((String)this.mBServer.getAttribute(vname, attribute));
            attribute = "deny";
            valveFm.setDeny((String)this.mBServer.getAttribute(vname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }
}

