/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.bridge.ClassesCollection;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.FeaturesCollection;
import org.netbeans.modules.java.bridge.ObjectsCollection;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;

class TopClassesCollection
extends ClassesCollection {
    private Resource resource;
    private SourceElementImpl sourceImpl;

    public TopClassesCollection(FeaturesCollection members, Resource resource, SourceElementImpl sourceImpl) {
        super(members);
        this.resource = resource;
        this.sourceImpl = sourceImpl;
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        JavaClass res = this.members.createClass((ClassElement)elem);
        return res;
    }

    public boolean isClassMember() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFeatures() {
        this.members.repository.beginTrans(false);
        try {
            List list = this.resource.getClassifiers();
            return list;
        }
        finally {
            this.members.repository.endTrans();
        }
    }

    public boolean isValid() {
        return this.resource.isValid();
    }

    public Element createElement(RefObject topClass) {
        return (ClassElement)this.members.model.createTopClass((SourceElement)this.sourceImpl.getElement(), (JavaClass)topClass).getElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMembers(Element[] items) throws SourceException {
        if (items.length == 0) {
            return;
        }
        this.members.repository.beginTrans(true);
        boolean failed = true;
        try {
            if (this.isValid()) {
                this.members.parentImpl.setClassPath();
                List features = this.getFeatures();
                for (int x = 0; x < items.length; ++x) {
                    features.add(this.createFeature((RefObject)this.members.javaClass, items[x]));
                }
                failed = false;
            } else {
                failed = false;
                this.members.parentImpl.throwIsInvalid();
            }
        }
        finally {
            this.members.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMembers(Element[] items) throws SourceException {
        this.members.repository.beginTrans(true);
        boolean failed = true;
        try {
            if (this.isValid()) {
                this.members.parentImpl.setClassPath();
                List features = this.getFeatures();
                features.clear();
                for (int x = 0; x < items.length; ++x) {
                    features.add(this.createFeature((RefObject)this.members.javaClass, items[x]));
                }
                failed = false;
            } else {
                failed = false;
                this.members.parentImpl.throwIsInvalid();
            }
        }
        finally {
            this.members.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassElement getClass(Identifier name) {
        String clsName = name.getName();
        if (clsName == null) {
            return null;
        }
        this.members.repository.beginTrans(false);
        try {
            if (this.isValid()) {
                Iterator iter = this.resource.getClassifiers().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof JavaClass)) continue;
                    JavaClass cls = (JavaClass)obj;
                    String clsFullName = cls.getName();
                    String clsSimpleName = cls.getSimpleName();
                    if (!clsName.equals(clsSimpleName)) continue;
                    String fqn = name.getFullName();
                    if (!fqn.equals(clsSimpleName) && !fqn.equals(clsFullName)) {
                        ClassElement classElement = null;
                        return classElement;
                    }
                    ClassElement classElement = (ClassElement)this.cachedElement((RefObject)cls);
                    return classElement;
                }
                ClassElement classElement = null;
                return classElement;
            }
            ClassElement classElement = null;
            return classElement;
        }
        finally {
            this.members.repository.endTrans(false);
        }
    }

    static class TopClassesListener
    extends ObjectsCollection.FeaturesListener {
        TopClassesListener(ElementImpl impl) {
            super(impl);
            this.fireMembers = false;
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                ((MDRChangeSource)this.javaElement).addListener((MDRChangeListener)this);
                this.features = new ArrayList();
                Iterator iter = ((Resource)this.javaElement).getClassifiers().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof JavaClass)) continue;
                    this.features.add(obj);
                }
            }
        }

        public ObjectsCollection getFeatureCollection(RefObject feature) {
            return ((SourceElementImpl)this.impl).topClasses;
        }

        protected boolean isWatchedAttribute(AttributeEvent ev) {
            return ev.getAttributeName().equals("classifiers");
        }

        public Element cachedElement(RefObject f) {
            if (f instanceof JavaClass) {
                return ((SourceElementImpl)this.impl).topClasses.cachedElement(f);
            }
            return null;
        }
    }
}

