/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreeListByKey;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreeListByKeyRepos;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SinglevaluedBtree;
import org.netbeans.mdr.util.MapEntryImpl;

public class MultivaluedBtree
extends Btree
implements MultivaluedIndex {
    private WeakHashMap listsByKey_cache = new WeakHashMap();

    public MultivaluedBtree(String name, Storage.EntryType keyType, Storage.EntryType dataType, boolean uniqueValues, BtreePageSource pageSource) throws StorageException {
        super(name, keyType, dataType, pageSource);
        this.uniqueValues = uniqueValues;
    }

    protected void init() throws StorageException {
        this.uniqueKeys = false;
        super.init();
    }

    public MultivaluedBtree() {
    }

    public Collection getItems(Object key) throws StorageException {
        WeakReference ref = (WeakReference)this.listsByKey_cache.get(new BtreeListByKey.Key(key));
        BtreeListByKey list = null;
        if (ref != null) {
            list = (BtreeListByKey)ref.get();
        }
        if (list == null) {
            list = new BtreeListByKey(this, key);
            this.listsByKey_cache.put(list, new WeakReference<BtreeListByKey>(list));
        }
        return list;
    }

    public Collection getObjects(Object key, SinglevaluedIndex repos) throws StorageException {
        WeakReference ref = (WeakReference)this.listsByKey_cache.get(new BtreeListByKey.Key(key));
        BtreeListByKey list = null;
        if (ref != null) {
            list = (BtreeListByKey)ref.get();
        }
        if (list == null) {
            list = new BtreeListByKey(this, key);
            this.listsByKey_cache.put(list, new WeakReference<BtreeListByKey>(list));
        }
        return new BtreeListByKeyRepos(list, repos);
    }

    public boolean isUnique() {
        return this.uniqueValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, Object value) throws StorageException {
        this.beginWrite();
        try {
            byte[] keyBuffer = this.keyInfo.toBuffer(key);
            if (keyBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
            }
            byte[] dataBuffer = this.dataInfo.toBuffer(value);
            if (dataBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid data type for this index: {0} received, {1} expected", value.getClass().getName(), this.dataInfo.typeName()));
            }
            BtreePage root = this.pageSource.getPage(this.rootPageId, this);
            boolean result = root.remove(keyBuffer, dataBuffer);
            if (result) {
                this.updateKeyModCount(key);
            }
            this.pageSource.unpinPage(root);
            boolean bl = result;
            return bl;
        }
        finally {
            this.endWrite();
        }
    }

    public void add(Object key, Object data) throws StorageException {
        super.add(key, data);
        this.updateKeyModCount(key);
    }

    public boolean remove(Object key) throws StorageException {
        boolean result = super.remove(key);
        if (result) {
            this.updateKeyModCount(key);
        }
        return result;
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        byte[] prefixBytes = this.keyInfo.toBuffer(prefix);
        SearchResult location = this.getLocation(prefixBytes);
        if (location.entryNum == location.page.numEntries()) {
            BtreePage.getNext(null, location);
        }
        while (location.entryNum < location.page.numEntries() && SinglevaluedBtree.isPrefix(prefixBytes, location.page.getKey(location.entryNum))) {
            byte[] key = location.page.getKey(location.entryNum);
            Object keyObject = this.keyInfo.objectFromBuffer(key, primaryIndex);
            Collection data = this.getObjects(keyObject, primaryIndex);
            MapEntryImpl entry = new MapEntryImpl(keyObject, data);
            result.add(entry);
            int size = data.size();
            location.page.findNth(location, key, size, false);
        }
        return result;
    }

    private static boolean isPrefix(byte[] prefix, byte[] key) {
        if (prefix.length > key.length) {
            return false;
        }
        for (int x = 0; x < prefix.length; ++x) {
            if (prefix[x] == key[x]) continue;
            return false;
        }
        return true;
    }

    protected void updateKeyModCount(Object key) {
        WeakReference ref = (WeakReference)this.listsByKey_cache.get(new BtreeListByKey.Key(key));
        if (ref == null) {
            return;
        }
        BtreeListByKey list = null;
        list = (BtreeListByKey)ref.get();
        if (list != null) {
            list.increaseModCount();
        }
    }
}

