/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;

public class CachedPage
extends IntrusiveList.Member {
    PageID key = null;
    private int pinCount = 0;
    boolean isDirty = false;
    boolean heldForLog = false;
    public byte[] contents;
    private FileCache owner = null;

    CachedPage(int size) {
        this.contents = new byte[size];
    }

    public FileCache getOwner() {
        return this.owner;
    }

    public synchronized void setWritable() throws StorageException {
        this.owner.setWritable(this);
    }

    void reInit(FileCache owner, PageID id) {
        this.owner = owner;
        this.key = id;
        this.pinCount = 0;
        this.isDirty = false;
        this.heldForLog = false;
    }

    public int pin(FileCache owner) {
        assert (this.pinCount == 0 || this.owner == owner);
        this.owner = owner;
        return this.pinCount++;
    }

    public int getPinCount() {
        return this.pinCount;
    }

    public int innerUnpin() {
        --this.pinCount;
        return this.pinCount;
    }

    public void unpin() throws StorageException {
        this.owner.unpin(this);
    }

    public String toString() {
        StringBuffer debug = new StringBuffer("" + this.key);
        if (this.pinCount > 0) {
            debug.append(" pin count: " + this.pinCount);
        }
        if (this.isDirty) {
            debug.append(" dirty");
        }
        if (this.heldForLog) {
            debug.append(" held");
        }
        debug.append("\n");
        int j = 0;
        int i = 0;
        while (i < this.contents.length) {
            if (j >= 16) {
                debug.append("\n");
                j = 0;
            }
            int data = this.contents[i] & 0xFF;
            debug.append(Integer.toHexString(data));
            debug.append(" ");
            ++i;
            ++j;
        }
        debug.append("\n");
        return debug.toString();
    }
}

