/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.StorageTransientDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;
import org.netbeans.mdr.util.Logger;

public class FileCache {
    private String[] fileNames;
    private int[] fileSize;
    private FileHeader header;
    private LogFile log;
    private boolean inXact;
    private static int pageSize;
    private static ArrayList pages;
    private static HashMap pageHash;
    private static IntrusiveList freePages;
    private static HashSet instances;
    private HashMap heldForLog;
    private long newTimeStamp;
    private static int hits;
    private static int misses;
    private static int extensions;
    private static int pagesFlushed;
    private int logFlushes = 0;
    private static int flushFailure;
    private static int commitFailure;
    private ArrayList toNotify;
    private static final int MAX_FILES = 200;
    private static final Map OPEN_FILES_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeFile(String fileName) throws IOException {
        RandomAccessFile file;
        Map map = OPEN_FILES_CACHE;
        synchronized (map) {
            file = (RandomAccessFile)OPEN_FILES_CACHE.remove(fileName);
        }
        if (file != null) {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomAccessFile getFile(String fileName) throws IOException {
        RandomAccessFile result;
        Map map = OPEN_FILES_CACHE;
        synchronized (map) {
            result = (RandomAccessFile)OPEN_FILES_CACHE.get(fileName);
            if (result == null) {
                result = new RandomAccessFile(fileName, "rw");
                OPEN_FILES_CACHE.put(fileName, result);
            }
        }
        return result;
    }

    static int checkForForcedFailure(String property, int count) {
        if (count == -1) {
            Integer failCount = Integer.getInteger(property);
            int n = count = failCount == null ? 0 : failCount;
        }
        if (count > 0 && --count == 0) {
            System.exit(1);
        }
        return count;
    }

    private static void addPages(int numToAdd) {
        for (int i = 0; i < numToAdd; ++i) {
            CachedPage page = new CachedPage(pageSize);
            pages.add(page);
            freePages.addLast(page);
        }
    }

    void holdForLog(CachedPage page) {
        page.heldForLog = true;
        this.heldForLog.put(page.key, page);
    }

    void logWasFlushed() {
        for (CachedPage page : this.heldForLog.values()) {
            page.heldForLog = false;
            if (page.getPinCount() != 0) continue;
            freePages.addFirst(page);
        }
        this.heldForLog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCache(String[] fileNames, String baseName) throws StorageException {
        this.fileNames = new String[fileNames.length];
        boolean failure = true;
        try {
            try {
                int i;
                RandomAccessFile[] files = new RandomAccessFile[fileNames.length];
                this.fileSize = new int[fileNames.length];
                for (i = 0; i < fileNames.length; ++i) {
                    files[i] = FileCache.getFile(fileNames[i]);
                    this.fileNames[i] = fileNames[i];
                }
                FileHeader tmpHeader = new FileHeader(files[0]);
                this.log = new LogFile(this, baseName, 2048, fileNames.length, tmpHeader.fileId);
                for (i = 0; i < fileNames.length; ++i) {
                    this.fileSize[i] = (int)files[i].length();
                    FileHeader hdr = new FileHeader(files[i]);
                    if (i == 0) {
                        this.header = hdr;
                        continue;
                    }
                    if (hdr.equals(this.header)) continue;
                    throw new StoragePersistentDataException("Files are not consistent");
                }
                this.heldForLog = new HashMap();
                failure = false;
                instances.add(this);
            }
            finally {
                if (failure) {
                    for (int i = 0; i < this.fileNames.length; ++i) {
                        if (this.fileNames[i] == null) continue;
                        FileCache.closeFile(this.fileNames[i]);
                    }
                    if (this.log != null) {
                        this.log.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    RandomAccessFile[] getFiles() throws IOException {
        return FileCache.getFiles(this.fileNames);
    }

    static RandomAccessFile[] getFiles(String[] fileNames) throws IOException {
        RandomAccessFile[] files = new RandomAccessFile[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = FileCache.getFile(fileNames[i]);
        }
        return files;
    }

    public synchronized void abort() throws StorageException {
        this.closeFiles();
    }

    public synchronized void close() throws StorageException {
        this.commit();
        Iterator itr = pages.iterator();
        while (itr.hasNext()) {
            CachedPage page = (CachedPage)itr.next();
            if (page.getOwner() != this) continue;
            if (pages.size() > 128) {
                itr.remove();
                freePages.remove(page);
                continue;
            }
            freePages.addLast(page);
            page.reInit(null, null);
        }
        Iterator it = pageHash.keySet().iterator();
        while (it.hasNext()) {
            HashKey entry = (HashKey)it.next();
            if (entry.owner != this) continue;
            it.remove();
        }
        this.closeFiles();
    }

    private void closeFiles() throws StorageException {
        try {
            for (int i = 0; i < this.fileNames.length; ++i) {
                FileCache.closeFile(this.fileNames[i]);
            }
            this.log.close();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        finally {
            instances.remove(this);
        }
    }

    public synchronized void commit() throws StorageException {
        commitFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.commitFailure", commitFailure);
        if (this.toNotify != null) {
            for (NotifyOnCommit obj : this.toNotify) {
                obj.prepareToCommit();
            }
        }
        if (this.inXact) {
            for (int i = 0; i < this.fileNames.length; ++i) {
                CachedPage first = this.getPage(i, 0);
                this.setWritable(first);
                FileHeader.updateTime(first, this.newTimeStamp);
                first.unpin();
            }
            this.log.flush();
            for (CachedPage page : pages) {
                if (!page.isDirty || page.getOwner() != this) continue;
                FileCache.flushOne(page);
            }
            this.log.commit();
            this.header.timeStamp = this.newTimeStamp;
            this.inXact = false;
        }
    }

    private static void flushOne(CachedPage page) throws StorageException {
        try {
            flushFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.flushFailure", flushFailure);
            FileCache owner = page.getOwner();
            assert (owner != null);
            if (!instances.contains(owner)) {
                return;
            }
            RandomAccessFile file = FileCache.getFile(owner.fileNames[page.key.fileIndex]);
            file.seek(page.key.offset);
            file.write(page.contents);
            page.isDirty = false;
            ++pagesFlushed;
            if (page.key.offset >= owner.fileSize[page.key.fileIndex]) {
                owner.fileSize[page.key.fileIndex] = page.key.offset + pageSize;
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public synchronized void unpin(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.unpin(pages[i]);
        }
    }

    public synchronized void unpin(CachedPage page) throws StorageException {
        if (page.getPinCount() <= 0) {
            throw new StorageTransientDataException("Attempt to unpin page which is not pinned");
        }
        if (page.innerUnpin() == 0 && !page.heldForLog) {
            freePages.addFirst(page);
        }
    }

    public synchronized CachedPage[] getPages(int fileidx, int first, int size) throws StorageException {
        CachedPage[] retval = new CachedPage[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = FileCache.getPage(this, new PageID(fileidx, pageSize * (first + i)), false);
        }
        return retval;
    }

    public synchronized CachedPage getPage(int fileidx, int pageNum) throws StorageException {
        return FileCache.getPage(this, new PageID(fileidx, pageNum * pageSize), false);
    }

    synchronized CachedPage getPage(PageID page) throws StorageException {
        return FileCache.getPage(this, page, false);
    }

    private static CachedPage getPage(FileCache instance, PageID id, boolean fromCacheOnly) throws StorageException {
        HashKey key = new HashKey(instance, id);
        CachedPage page = (CachedPage)pageHash.get(key);
        if (page != null) {
            if (page.pin(instance) == 0 && !page.heldForLog) {
                freePages.remove(page);
            }
            ++hits;
            return page;
        }
        if (fromCacheOnly) {
            return null;
        }
        CachedPage free = (CachedPage)freePages.removeLast();
        if (free == null) {
            for (FileCache cache : instances) {
                if (cache.heldForLog.isEmpty()) continue;
                cache.log.flush();
                ++cache.logFlushes;
            }
            free = (CachedPage)freePages.removeLast();
        }
        if (free == null) {
            int increment = (pages.size() + 1) / 2;
            FileCache.addPages(increment);
            ++extensions;
            free = (CachedPage)freePages.removeLast();
        }
        if (free.isDirty) {
            FileCache.flushOne(free);
        }
        if (free.key != null && free.getOwner() != null) {
            pageHash.remove(new HashKey(free.getOwner(), free.key));
        }
        free.reInit(instance, id);
        pageHash.put(key, free);
        if (id.offset >= instance.fileSize[id.fileIndex]) {
            Arrays.fill(free.contents, (byte)0);
        } else {
            try {
                RandomAccessFile file = FileCache.getFile(instance.fileNames[id.fileIndex]);
                file.seek(id.offset);
                file.readFully(free.contents);
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
        free.pin(instance);
        ++misses;
        return free;
    }

    public synchronized void setWritable(CachedPage page) throws StorageException {
        if (page.isDirty) {
            return;
        }
        if (!this.inXact) {
            this.newTimeStamp = System.currentTimeMillis();
            this.log.begin(this.fileNames, this.header.timeStamp, this.newTimeStamp);
            this.inXact = true;
        }
        this.log.addPageToLog(page);
        page.isDirty = true;
    }

    public synchronized void setWritable(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.setWritable(pages[i]);
        }
    }

    public void dumpCache(PrintStream strm) {
        strm.println("Cached files:");
        for (int i = 0; i < this.fileNames.length; ++i) {
            strm.println(Integer.toString(i) + ": " + this.fileNames[i] + " size: " + this.fileSize[i]);
        }
        strm.println("");
        strm.println(Integer.toString(pages.size()) + " pages");
        Iterator itr = pages.iterator();
        int num = 0;
        while (itr.hasNext()) {
            strm.println(Integer.toString(num++) + ":");
            strm.print(((CachedPage)itr.next()).toString());
        }
    }

    public void showStats(PrintStream strm) {
        this.showStats(new PrintWriter(strm));
    }

    public void showStats(PrintWriter strm) {
        int pinned = 0;
        int dirty = 0;
        int held = 0;
        for (int i = 0; i < pages.size(); ++i) {
            CachedPage pg = (CachedPage)pages.get(i);
            if (pg.getPinCount() > 0) {
                ++pinned;
            }
            if (pg.isDirty) {
                ++dirty;
            }
            if (!pg.heldForLog) continue;
            ++held;
        }
        strm.println("Page counts: total = " + pages.size() + " pinned = " + pinned + " dirty = " + dirty + " held = " + held);
        strm.println("Cache hits: " + hits + " misses: " + misses + " hit rate: " + 100.0 * (double)hits / (double)(hits + misses));
        strm.println(pagesFlushed + " pages written");
        strm.println("Log file flushed to free pages " + this.logFlushes + " times");
        strm.println("Cache made bigger " + extensions + " times");
        strm.flush();
    }

    int getPageSize() {
        return pageSize;
    }

    public synchronized void addNotifier(NotifyOnCommit notified) {
        if (this.toNotify == null) {
            this.toNotify = new ArrayList();
        }
        this.toNotify.add(notified);
    }

    static {
        instances = new HashSet();
        hits = 0;
        misses = 0;
        extensions = 0;
        pagesFlushed = 0;
        flushFailure = -1;
        commitFailure = -1;
        OPEN_FILES_CACHE = new LinkedHashMap(400, 0.5f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > 200) {
                    RandomAccessFile file = (RandomAccessFile)eldest.getValue();
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        Logger.getDefault().notify((Throwable)e);
                    }
                    return true;
                }
                return false;
            }
        };
        pages = new ArrayList(128);
        pageHash = new HashMap();
        freePages = new IntrusiveList();
        pageSize = 2048;
        FileCache.addPages(128);
    }

    public static interface NotifyOnCommit {
        public void prepareToCommit() throws StorageException;
    }

    private static class HashKey {
        public final FileCache owner;
        public final PageID id;

        public HashKey(FileCache owner, PageID id) {
            this.owner = owner;
            this.id = id;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof HashKey && ((HashKey)o).owner == this.owner && ((HashKey)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.owner.hashCode() + 31 * this.id.hashCode();
        }
    }
}

