/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;

public class ProjectModel {
    private File baseFolder;
    private File nbProjectFolder;
    private PropertyEvaluator evaluator;
    private String sourceLevel;
    private List sourceFolders;
    public List javaCompilationUnitsList;
    private Set addedSourceFolders;
    private Set removedSourceFolders;
    public static final String TYPE_JAVA = "java";
    public static final String CLASSPATH_MODE_COMPILE = "compile";
    private static final SpecificationVersion JDK_MAX_SUPPORTED_VERSION;
    private final Set listeners = new HashSet(1);
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectModel(File baseFolder, File nbProjectFolder, PropertyEvaluator evaluator, List sourceFolders, List compUnits) {
        this.baseFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
        this.evaluator = evaluator;
        this.sourceFolders = sourceFolders;
        this.javaCompilationUnitsList = compUnits;
        if (this.javaCompilationUnitsList.size() > 0) {
            this.sourceLevel = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).sourceLevel;
        }
        if (this.sourceLevel == null) {
            this.setSourceLevel(ProjectModel.getDefaultSourceLevel());
        }
        this.resetState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    private void resetState() {
        this.addedSourceFolders = new HashSet();
        this.removedSourceFolders = new HashSet();
    }

    public static ProjectModel createEmptyModel(File baseFolder, File nbProjectFolder, PropertyEvaluator evaluator) {
        return new ProjectModel(baseFolder, nbProjectFolder, evaluator, new ArrayList(), new ArrayList());
    }

    public static ProjectModel createModel(final File baseFolder, final File nbProjectFolder, final PropertyEvaluator evaluator, final AntProjectHelper helper) {
        return (ProjectModel)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                ProjectModel pm = new ProjectModel(baseFolder, nbProjectFolder, evaluator, JavaProjectGenerator.getSourceFolders(helper, ProjectModel.TYPE_JAVA), JavaProjectGenerator.getJavaCompilationUnits(helper, Util.getAuxiliaryConfiguration((AntProjectHelper)helper)));
                ProjectModel.updateStyle(pm.sourceFolders);
                return pm;
            }
        });
    }

    public static void instantiateJavaProject(AntProjectHelper helper, ProjectModel model) throws IOException {
        List subprojects;
        List sourceFolders = model.updatePrincipalSourceFolders(model.sourceFolders, true);
        if (sourceFolders.size() > 0) {
            JavaProjectGenerator.putSourceFolders(helper, sourceFolders, null);
        }
        if (sourceFolders.size() > 0) {
            JavaProjectGenerator.putSourceViews(helper, sourceFolders, null);
        }
        JavaProjectGenerator.putJavaCompilationUnits(helper, Util.getAuxiliaryConfiguration((AntProjectHelper)helper), model.javaCompilationUnitsList);
        List exports = JavaProjectGenerator.guessExports(model.evaluator, model.baseFolder, JavaProjectGenerator.getTargetMappings(helper), model.javaCompilationUnitsList);
        if (exports.size() > 0) {
            JavaProjectGenerator.putExports(helper, exports);
        }
        if ((subprojects = JavaProjectGenerator.guessSubprojects(model.evaluator, model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder)).size() > 0) {
            JavaProjectGenerator.putSubprojects(helper, subprojects);
        }
        model.resetState();
    }

    public static void saveProject(final AntProjectHelper helper, final ProjectModel model) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                JavaProjectGenerator.putSourceFolders(helper, model.sourceFolders, ProjectModel.TYPE_JAVA);
                JavaProjectGenerator.putSourceViews(helper, model.sourceFolders, "packages");
                List sourceFolders = JavaProjectGenerator.getSourceFolders(helper, null);
                sourceFolders = model.updatePrincipalSourceFolders(sourceFolders, false);
                JavaProjectGenerator.putSourceFolders(helper, sourceFolders, null);
                AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)helper);
                JavaProjectGenerator.putJavaCompilationUnits(helper, aux, model.javaCompilationUnitsList);
                model.resetState();
                List exports = JavaProjectGenerator.guessExports(model.getEvaluator(), model.baseFolder, JavaProjectGenerator.getTargetMappings(helper), model.javaCompilationUnitsList);
                JavaProjectGenerator.putExports(helper, exports);
                List subprojects = JavaProjectGenerator.guessSubprojects(model.getEvaluator(), model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder);
                JavaProjectGenerator.putSubprojects(helper, subprojects);
                List buildFolders = JavaProjectGenerator.guessBuildFolders(model.getEvaluator(), model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder);
                JavaProjectGenerator.putBuildFolders(helper, buildFolders);
                return null;
            }
        });
    }

    List updatePrincipalSourceFolders(List allSourceFolders, boolean checkProjectDir) {
        String location;
        ArrayList<JavaProjectGenerator.SourceFolder> allSF = new ArrayList<JavaProjectGenerator.SourceFolder>(allSourceFolders);
        Iterator it = this.addedSourceFolders.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.SourceFolder _sf;
            location = (String)it.next();
            if (!this.isExternalSourceRoot(location)) continue;
            boolean exist = false;
            String label = "";
            Iterator it2 = allSF.iterator();
            while (it2.hasNext()) {
                _sf = (JavaProjectGenerator.SourceFolder)it2.next();
                if (_sf.location.equals(location) && _sf.type == null) {
                    exist = true;
                    break;
                }
                if (!_sf.location.equals(location) || _sf.type == null) continue;
                label = _sf.label;
            }
            if (exist) continue;
            _sf = new JavaProjectGenerator.SourceFolder();
            _sf.location = location;
            _sf.label = label;
            allSF.add(_sf);
        }
        it = this.removedSourceFolders.iterator();
        while (it.hasNext()) {
            location = (String)it.next();
            if (!this.isExternalSourceRoot(location)) continue;
            Iterator it2 = allSF.iterator();
            while (it2.hasNext()) {
                JavaProjectGenerator.SourceFolder _sf = (JavaProjectGenerator.SourceFolder)it2.next();
                if (!_sf.location.equals(location) || _sf.type != null) continue;
                it2.remove();
            }
        }
        if (checkProjectDir && !this.baseFolder.equals(this.nbProjectFolder)) {
            JavaProjectGenerator.SourceFolder gen = new JavaProjectGenerator.SourceFolder();
            gen.location = "${project.dir}";
            gen.label = this.baseFolder.getName();
            allSF.add(gen);
        }
        return allSF;
    }

    private boolean isExternalSourceRoot(String location) {
        File f;
        String nbProjectFolder_;
        String baseFolder_ = this.baseFolder.getAbsolutePath();
        if (!baseFolder_.endsWith(File.separator)) {
            baseFolder_ = baseFolder_ + File.separatorChar;
        }
        if (!(nbProjectFolder_ = this.nbProjectFolder.getAbsolutePath()).endsWith(File.separator)) {
            nbProjectFolder_ = nbProjectFolder_ + File.separatorChar;
        }
        if ((f = Util.resolveFile((PropertyEvaluator)this.evaluator, (File)this.baseFolder, (String)location)) == null) {
            return false;
        }
        location = f.getAbsolutePath();
        return !location.startsWith(baseFolder_) && !location.startsWith(nbProjectFolder_);
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getNBProjectFolder() {
        return this.nbProjectFolder;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int getSourceFoldersCount() {
        return this.sourceFolders.size();
    }

    public JavaProjectGenerator.SourceFolder getSourceFolder(int index) {
        return (JavaProjectGenerator.SourceFolder)this.sourceFolders.get(index);
    }

    public void moveSourceFolder(int fromIndex, int toIndex) {
        JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)this.sourceFolders.remove(fromIndex);
        this.sourceFolders.add(toIndex, sf);
    }

    public void addSourceFolder(JavaProjectGenerator.SourceFolder sf, boolean isTests) {
        JavaProjectGenerator.JavaCompilationUnit cu;
        List keys = this.createCompilationUnitKeys();
        boolean singleCU = ProjectModel.isSingleCompilationUnit(keys);
        if (singleCU) {
            cu = (JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get(0);
            if (cu.isTests != isTests) {
                this.updateCompilationUnits(true);
                singleCU = false;
            }
        }
        this.sourceFolders.add(sf);
        if (singleCU) {
            if (TYPE_JAVA.equals(sf.type)) {
                cu = (JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get(0);
                cu.packageRoots.add(sf.location);
            }
        } else {
            Iterator it = this.createCompilationUnitKeys().iterator();
            while (it.hasNext()) {
                CompilationUnitKey key = (CompilationUnitKey)it.next();
                this.getCompilationUnit(key, isTests);
            }
        }
        if (this.removedSourceFolders.contains(sf.location)) {
            this.removedSourceFolders.remove(sf.location);
        } else {
            this.addedSourceFolders.add(sf.location);
        }
        this.fireChangeEvent();
    }

    public void removeSourceFolder(int index) {
        JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)this.sourceFolders.get(index);
        if (TYPE_JAVA.equals(sf.type)) {
            this.removeSourceLocation(sf.location);
        }
        this.sourceFolders.remove(index);
        if (this.addedSourceFolders.contains(sf.location)) {
            this.addedSourceFolders.remove(sf.location);
        } else {
            this.removedSourceFolders.add(sf.location);
        }
        this.fireChangeEvent();
    }

    public void clearSourceFolders() {
        this.sourceFolders.clear();
        this.javaCompilationUnitsList.clear();
        this.fireChangeEvent();
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String sourceLevel) {
        if (this.sourceLevel == null && sourceLevel == null || this.sourceLevel != null && this.sourceLevel.equals(sourceLevel)) {
            return;
        }
        this.sourceLevel = sourceLevel;
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            cu.sourceLevel = sourceLevel;
        }
    }

    public boolean canHaveSeparateClasspath() {
        return this.sourceFolders.size() > 1 || this.javaCompilationUnitsList.size() > 1;
    }

    public boolean canCreateSingleCompilationUnit() {
        boolean testCU = false;
        boolean sourceCU = false;
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            if (cu.isTests) {
                testCU = true;
                continue;
            }
            sourceCU = true;
        }
        return !testCU || !sourceCU;
    }

    public static boolean isSingleCompilationUnit(List compilationUnitKeys) {
        return compilationUnitKeys.size() == 1 && ((CompilationUnitKey)compilationUnitKeys.get((int)0)).label == null;
    }

    public List createCompilationUnitKeys() {
        CompilationUnitKey cul;
        ArrayList<CompilationUnitKey> l = new ArrayList<CompilationUnitKey>();
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            cul = new CompilationUnitKey();
            cul.locations = cu.packageRoots;
            cul.label = null;
            l.add(cul);
        }
        it = this.sourceFolders.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)it.next();
            if (!TYPE_JAVA.equals(sf.type)) continue;
            cul = new CompilationUnitKey();
            cul.locations = new ArrayList();
            cul.locations.add(sf.location);
            cul.label = sf.label;
            int index = l.indexOf(cul);
            if (index != -1) {
                CompilationUnitKey cul_ = (CompilationUnitKey)l.get(index);
                cul_.label = sf.label;
                continue;
            }
            boolean found = false;
            Iterator it2 = this.javaCompilationUnitsList.iterator();
            while (it2.hasNext()) {
                JavaProjectGenerator.JavaCompilationUnit cu_ = (JavaProjectGenerator.JavaCompilationUnit)it2.next();
                if (!cu_.packageRoots.contains(sf.location)) continue;
                found = true;
                break;
            }
            if (found) continue;
            l.add(cul);
        }
        return l;
    }

    public void updateCompilationUnits(boolean separateClasspath) {
        if (separateClasspath) {
            String classpath = null;
            List output = null;
            if (this.javaCompilationUnitsList.size() > 0) {
                List classpaths = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).classpath;
                if (classpaths != null) {
                    Iterator it = classpaths.iterator();
                    while (it.hasNext()) {
                        JavaProjectGenerator.JavaCompilationUnit.CP cp = (JavaProjectGenerator.JavaCompilationUnit.CP)it.next();
                        if (!cp.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                        classpath = cp.classpath;
                        break;
                    }
                }
                output = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).output;
            }
            this.javaCompilationUnitsList.clear();
            Iterator it = this.sourceFolders.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)it.next();
                JavaProjectGenerator.JavaCompilationUnit cu = new JavaProjectGenerator.JavaCompilationUnit();
                cu.packageRoots = new ArrayList();
                cu.packageRoots.add(sf.location);
                if (classpath != null) {
                    JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
                    cp.mode = CLASSPATH_MODE_COMPILE;
                    cp.classpath = classpath;
                    cu.classpath = new ArrayList();
                    cu.classpath.add(cp);
                }
                if (output != null) {
                    cu.output = new ArrayList();
                    cu.output.addAll(output);
                }
                cu.sourceLevel = this.sourceLevel;
                this.javaCompilationUnitsList.add(cu);
            }
        } else {
            JavaProjectGenerator.JavaCompilationUnit cu;
            ArrayList<String> packageRoots = new ArrayList<String>();
            Iterator it = this.sourceFolders.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)it.next();
                packageRoots.add(sf.location);
            }
            LinkedHashSet<String> classpath = new LinkedHashSet<String>();
            LinkedHashSet output = new LinkedHashSet();
            it = this.javaCompilationUnitsList.iterator();
            while (it.hasNext()) {
                cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
                if (cu.output != null) {
                    output.addAll(cu.output);
                }
                if (cu.classpath == null) continue;
                Iterator it2 = cu.classpath.iterator();
                while (it2.hasNext()) {
                    JavaProjectGenerator.JavaCompilationUnit.CP cp = (JavaProjectGenerator.JavaCompilationUnit.CP)it2.next();
                    if (!cp.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                    String[] cpa = PropertyUtils.tokenizePath((String)cp.classpath);
                    for (int i = 0; i < cpa.length; ++i) {
                        classpath.add(cpa[i]);
                    }
                }
            }
            this.javaCompilationUnitsList.clear();
            cu = new JavaProjectGenerator.JavaCompilationUnit();
            cu.packageRoots = packageRoots;
            JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
            if (classpath.size() > 0) {
                StringBuffer cp_ = new StringBuffer();
                it = classpath.iterator();
                while (it.hasNext()) {
                    String item = (String)it.next();
                    cp_.append(item);
                    if (!it.hasNext()) continue;
                    cp_.append(File.pathSeparatorChar);
                }
                cp.classpath = cp_.toString();
                cp.mode = CLASSPATH_MODE_COMPILE;
                cu.classpath = new ArrayList();
                cu.classpath.add(cp);
            }
            cu.output = new ArrayList(output);
            cu.sourceLevel = this.sourceLevel;
            this.javaCompilationUnitsList.add(cu);
        }
        this.fireChangeEvent();
    }

    public JavaProjectGenerator.JavaCompilationUnit getCompilationUnit(CompilationUnitKey key, boolean isTests) {
        JavaProjectGenerator.JavaCompilationUnit cu;
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            if (!((Object)cu.packageRoots).equals(key.locations)) continue;
            return cu;
        }
        cu = new JavaProjectGenerator.JavaCompilationUnit();
        cu.packageRoots = key.locations;
        cu.sourceLevel = this.sourceLevel;
        cu.isTests = isTests;
        this.javaCompilationUnitsList.add(cu);
        return cu;
    }

    private void removeSourceLocation(String location) {
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            if (cu.packageRoots.contains(location)) {
                cu.packageRoots.remove(location);
            }
            if (cu.packageRoots.size() != 0) continue;
            it.remove();
        }
    }

    private static void updateStyle(List sources) {
        Iterator it = sources.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)it.next();
            if (!$assertionsDisabled && !sf.type.equals(TYPE_JAVA)) {
                throw new AssertionError();
            }
            sf.style = "packages";
        }
    }

    void setSourceFolders(List list) {
        this.sourceFolders = list;
    }

    List getSourceFolders() {
        return this.sourceFolders;
    }

    void setJavaCompilationUnits(List list) {
        this.javaCompilationUnitsList = list;
    }

    List getJavaCompilationUnits() {
        return this.javaCompilationUnitsList;
    }

    public static String getDefaultSourceLevel() {
        JavaPlatform platform = JavaPlatform.getDefault();
        SpecificationVersion sv = platform.getSpecification().getVersion();
        if (sv.compareTo((Object)JDK_MAX_SUPPORTED_VERSION) > 0) {
            sv = JDK_MAX_SUPPORTED_VERSION;
        }
        return sv.toString();
    }

    public boolean isTestSourceFolder(int index) {
        return this.isTestSourceFolder(this.getSourceFolder(index));
    }

    public boolean isTestSourceFolder(JavaProjectGenerator.SourceFolder sf) {
        Iterator it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = (JavaProjectGenerator.JavaCompilationUnit)it.next();
            if (!cu.packageRoots.contains(sf.location)) continue;
            return cu.isTests;
        }
        return false;
    }

    static {
        $assertionsDisabled = !ProjectModel.class.desiredAssertionStatus();
        JDK_MAX_SUPPORTED_VERSION = new SpecificationVersion("1.5");
    }

    public static class CompilationUnitKey {
        public List locations;
        public String label;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnitKey)) {
                return false;
            }
            CompilationUnitKey cul = (CompilationUnitKey)o;
            return ((Object)this.locations).equals(cul.locations);
        }

        public int hashCode() {
            return ((Object)this.locations).hashCode() * 7;
        }

        public String toString() {
            return "PM.CUK:[label=" + this.label + ", locations=" + this.locations + ", this=" + super.toString() + "]";
        }
    }
}

