/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class PropertyUtils {
    private static Map globalPropertyProviders;
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH;
    private static final Pattern VALID_PROPERTY_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        String nbuser = System.getProperty("netbeans.user");
        if (nbuser != null) {
            return FileUtil.normalizeFile((File)new File(nbuser, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                File ubp = PropertyUtils.userBuildProperties();
                if (ubp != null && ubp.isFile() && ubp.canRead()) {
                    EditableProperties editableProperties;
                    FileInputStream is = new FileInputStream(ubp);
                    try {
                        EditableProperties properties = new EditableProperties(true);
                        properties.load(is);
                        editableProperties = properties;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                    }
                    ((InputStream)is).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties properties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    block15: {
                        File ubp = PropertyUtils.userBuildProperties();
                        if (ubp != null) {
                            FileObject bp = FileUtil.toFileObject((File)ubp);
                            if (bp == null) {
                                if (!ubp.exists()) {
                                    ubp.getParentFile().mkdirs();
                                    new FileOutputStream(ubp).close();
                                    if (!$assertionsDisabled && !ubp.isFile()) {
                                        throw new AssertionError((Object)("Did not actually make " + ubp));
                                    }
                                }
                                if ((bp = FileUtil.toFileObject((File)ubp)) == null) {
                                    ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + ubp + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                    FileOutputStream os = new FileOutputStream(ubp);
                                    try {
                                        properties.store(os);
                                    }
                                    finally {
                                        ((OutputStream)os).close();
                                    }
                                    return null;
                                }
                            }
                            FileLock lock = bp.lock();
                            try {
                                OutputStream os = bp.getOutputStream(lock);
                                try {
                                    properties.store(os);
                                    break block15;
                                }
                                finally {
                                    os.close();
                                }
                            }
                            finally {
                                lock.releaseLock();
                            }
                        }
                        throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    }
                    return null;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File ubp = PropertyUtils.userBuildProperties();
        if (ubp != null) {
            PropertyProvider pp;
            Reference globalPropertyProvider = (Reference)globalPropertyProviders.get(ubp);
            if (globalPropertyProvider != null && (pp = (PropertyProvider)globalPropertyProvider.get()) != null) {
                return pp;
            }
            PropertyProvider gpp = PropertyUtils.propertiesFilePropertyProvider(ubp);
            globalPropertyProviders.put(ubp, new SoftReference<PropertyProvider>(gpp));
            return gpp;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.EMPTY_MAP);
    }

    public static PropertyProvider propertiesFilePropertyProvider(File propertiesFile) {
        if (!$assertionsDisabled && propertiesFile == null) {
            throw new AssertionError();
        }
        return new FilePropertyProvider(propertiesFile);
    }

    private static Map evaluateAll(Map predefs, List defs) {
        HashMap<String, String> m = new HashMap<String, String>(predefs);
        Iterator it = defs.iterator();
        while (it.hasNext()) {
            List sorted;
            Map curr = (Map)it.next();
            HashMap<String, Set> dependOnSiblings = new HashMap<String, Set>();
            Iterator it2 = curr.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                String prop = (String)entry.getKey();
                if (m.containsKey(prop)) continue;
                String rawval = (String)entry.getValue();
                Object o = PropertyUtils.subst(rawval, m, curr.keySet());
                if (o instanceof String) {
                    m.put(prop, (String)o);
                    continue;
                }
                dependOnSiblings.put(prop, (Set)o);
            }
            HashSet toSort = new HashSet(dependOnSiblings.keySet());
            it2 = dependOnSiblings.values().iterator();
            while (it2.hasNext()) {
                toSort.addAll((Set)((Object)it2.next()));
            }
            try {
                sorted = Utilities.topologicalSort(toSort, dependOnSiblings);
            }
            catch (TopologicalSortException e) {
                return null;
            }
            Collections.reverse(sorted);
            it2 = sorted.iterator();
            while (it2.hasNext()) {
                String prop = (String)((Object)it2.next());
                if (m.containsKey(prop)) continue;
                String rawval = (String)curr.get(prop);
                m.put(prop, (String)PropertyUtils.subst(rawval, m, curr.keySet()));
            }
        }
        return m;
    }

    private static Object subst(String rawval, Map predefs, Set siblingProperties) {
        if (!$assertionsDisabled && rawval == null) {
            throw new AssertionError((Object)"null rawval passed in");
        }
        if (rawval.indexOf(36) == -1) {
            return rawval;
        }
        int idx = 0;
        StringBuffer val = new StringBuffer();
        HashSet<String> needed = new HashSet<String>();
        while (true) {
            int shell;
            if ((shell = rawval.indexOf(36, idx)) == -1 || shell == rawval.length() - 1) {
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                return needed;
            }
            char c = rawval.charAt(shell + 1);
            if (c == '$') {
                if (needed.isEmpty()) {
                    val.append('$');
                }
                idx += 2;
                continue;
            }
            if (c == '{') {
                int end = rawval.indexOf(125, shell + 2);
                if (end != -1) {
                    String otherprop = rawval.substring(shell + 2, end);
                    if (predefs.containsKey(otherprop)) {
                        if (needed.isEmpty()) {
                            val.append(rawval.substring(idx, shell));
                            val.append((String)predefs.get(otherprop));
                        }
                        idx = end + 1;
                        continue;
                    }
                    if (siblingProperties.contains(otherprop)) {
                        needed.add(otherprop);
                        idx = end + 1;
                        continue;
                    }
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx, end + 1));
                    }
                    idx = end + 1;
                    continue;
                }
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                return needed;
            }
            if (needed.isEmpty()) {
                val.append(rawval.substring(idx, idx + 2));
            }
            idx += 2;
        }
    }

    public static File resolveFile(File basedir, String filename) throws IllegalArgumentException {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            if (!$assertionsDisabled && !f.isAbsolute()) {
                throw new AssertionError();
            }
        }
        return FileUtil.normalizeFile((File)f);
    }

    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuffer b = new StringBuffer();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(PropertyUtils.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(file.toURI());
        if (!$assertionsDisabled && u.isAbsolute()) {
            throw new AssertionError((Object)(u + " from " + basedir + " and " + file + " with common root " + base));
        }
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject basedir, String filename) {
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            return basedir.getFileObject(filename);
        }
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)basedir), filename));
    }

    static String resolvePath(File basedir, String path) {
        StringBuffer b = new StringBuffer();
        String[] toks = PropertyUtils.tokenizePath(path);
        for (int i = 0; i < toks.length; ++i) {
            if (i > 0) {
                b.append(File.pathSeparatorChar);
            }
            b.append(PropertyUtils.resolveFile(basedir, toks[i]).getAbsolutePath());
        }
        return b.toString();
    }

    public static String[] tokenizePath(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    l.add(Character.toString(dosHack));
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            l.add(s);
        }
        if (dosHack != '\u0000') {
            l.add(Character.toString(dosHack));
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean isUsablePropertyName(String name) {
        return VALID_PROPERTY_NAME.matcher(name).matches();
    }

    public static String getUsablePropertyName(String name) {
        if (PropertyUtils.isUsablePropertyName(name)) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(sb.substring(i, i + 1))) continue;
            sb.replace(i, i + 1, "_");
        }
        return sb.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map defs) {
        return new FixedPropertyProvider(defs);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider preprovider, PropertyProvider[] providers) {
        return new SequentialPropertyEvaluator(preprovider, providers);
    }

    static {
        $assertionsDisabled = !PropertyUtils.class.desiredAssertionStatus();
        globalPropertyProviders = new HashMap();
        RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
        VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]");
    }

    static abstract class DelegatingPropertyProvider
    implements PropertyProvider,
    ChangeListener {
        private PropertyProvider delegate;
        private final List listeners = new ArrayList();
        private ChangeListener weakListener = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected DelegatingPropertyProvider(PropertyProvider delegate) {
            if (!$assertionsDisabled && delegate == null) {
                throw new AssertionError();
            }
            this.setDelegate(delegate);
        }

        protected final void setDelegate(PropertyProvider delegate) {
            if (delegate == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                if (!$assertionsDisabled && this.weakListener == null) {
                    throw new AssertionError();
                }
                this.delegate.removeChangeListener(this.weakListener);
            }
            this.delegate = delegate;
            this.weakListener = WeakListeners.change((ChangeListener)this, (Object)delegate);
            delegate.addChangeListener(this.weakListener);
            this.fireChange();
        }

        public final Map getProperties() {
            return this.delegate.getProperties();
        }

        public final synchronized void addChangeListener(ChangeListener listener) {
            this.listeners.add(listener);
        }

        public final synchronized void removeChangeListener(ChangeListener listener) {
            this.listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] ls;
            DelegatingPropertyProvider delegatingPropertyProvider = this;
            synchronized (delegatingPropertyProvider) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ls.length; ++i) {
                ls[i].stateChanged(ev);
            }
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            this.fireChange();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
        }
    }

    private static final class SequentialPropertyEvaluator
    implements PropertyEvaluator,
    ChangeListener {
        private final PropertyProvider preprovider;
        private final PropertyProvider[] providers;
        private Map defs;
        private final List listeners = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        public SequentialPropertyEvaluator(final PropertyProvider preprovider, final PropertyProvider[] providers) {
            this.preprovider = preprovider;
            this.providers = providers;
            this.defs = (Map)ProjectManager.mutex().readAccess(new Mutex.Action(){

                public Object run() {
                    return SequentialPropertyEvaluator.compose(preprovider, providers);
                }
            });
            if (preprovider != null) {
                preprovider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)preprovider));
            }
            for (int i = 0; i < providers.length; ++i) {
                providers[i].addChangeListener(WeakListeners.change((ChangeListener)this, (Object)providers[i]));
            }
        }

        public String getProperty(final String prop) {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

                public Object run() {
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    return (String)SequentialPropertyEvaluator.this.defs.get(prop);
                }
            });
        }

        public String evaluate(final String text) {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public Object run() {
                    if (text == null) {
                        throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
                    }
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    Object result = PropertyUtils.subst(text, SequentialPropertyEvaluator.this.defs, Collections.EMPTY_SET);
                    if (!$assertionsDisabled && !(result instanceof String)) {
                        throw new AssertionError((Object)("Unexpected result " + result + " from " + text + " on " + SequentialPropertyEvaluator.this.defs));
                    }
                    return (String)result;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
                }
            });
        }

        public Map getProperties() {
            return (Map)ProjectManager.mutex().readAccess(new Mutex.Action(){

                public Object run() {
                    return SequentialPropertyEvaluator.this.defs;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent e) {
            Map _newdefs;
            if (!($assertionsDisabled || ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess())) {
                throw new AssertionError();
            }
            Map newdefs = SequentialPropertyEvaluator.compose(this.preprovider, this.providers);
            Map _defs = this.defs != null ? this.defs : Collections.EMPTY_MAP;
            Map map = _newdefs = newdefs != null ? newdefs : Collections.EMPTY_MAP;
            if (!((Object)_defs).equals(_newdefs)) {
                PropertyChangeListener[] _listeners;
                Object oldval;
                HashSet props = new HashSet(_defs.keySet());
                props.addAll(_newdefs.keySet());
                LinkedList<PropertyChangeEvent> events = new LinkedList<PropertyChangeEvent>();
                Iterator it = props.iterator();
                while (it.hasNext()) {
                    String prop = (String)it.next();
                    if (!$assertionsDisabled && prop == null) {
                        throw new AssertionError();
                    }
                    oldval = (String)_defs.get(prop);
                    String newval = (String)_newdefs.get(prop);
                    if (newval != null) {
                        if (newval.equals(oldval)) {
                            continue;
                        }
                    } else if (!$assertionsDisabled && oldval == null) {
                        throw new AssertionError((Object)("should not have had " + prop));
                    }
                    events.add(new PropertyChangeEvent(this, prop, oldval, newval));
                }
                if (!$assertionsDisabled && events.isEmpty()) {
                    throw new AssertionError();
                }
                this.defs = newdefs;
                oldval = this.listeners;
                synchronized (oldval) {
                    _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
                }
                for (int i = 0; i < _listeners.length; ++i) {
                    Iterator it3 = events.iterator();
                    while (it3.hasNext()) {
                        _listeners[i].propertyChange((PropertyChangeEvent)it3.next());
                    }
                }
            }
        }

        private static Map compose(PropertyProvider preprovider, PropertyProvider[] providers) {
            Map predefs;
            if (!($assertionsDisabled || ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess())) {
                throw new AssertionError();
            }
            if (preprovider != null) {
                predefs = preprovider.getProperties();
                if (!$assertionsDisabled && !SequentialPropertyEvaluator.isStringStringMap(predefs)) {
                    throw new AssertionError((Object)("Bad map " + predefs + " from " + preprovider));
                }
            } else {
                predefs = Collections.EMPTY_MAP;
            }
            Map[] defs = new Map[providers.length];
            for (int i = 0; i < providers.length; ++i) {
                defs[i] = providers[i].getProperties();
                if (!$assertionsDisabled && !SequentialPropertyEvaluator.isStringStringMap(defs[i])) {
                    throw new AssertionError((Object)("Bad map " + defs[i] + " from " + providers[i]));
                }
            }
            Map result = PropertyUtils.evaluateAll(predefs, Arrays.asList(defs));
            if (!$assertionsDisabled && result != null && !SequentialPropertyEvaluator.isStringStringMap(result)) {
                throw new AssertionError((Object)("Bad map " + result + " from evaluateAll(" + predefs + ", " + defs + ")"));
            }
            return result;
        }

        private static boolean isStringStringMap(Map m) {
            Iterator i = m.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object k = e.getKey();
                if (k == null || !(k instanceof String)) {
                    return false;
                }
                Object v = e.getValue();
                if (v != null && v instanceof String) continue;
                return false;
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
        }
    }

    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map defs;

        public FixedPropertyProvider(Map defs) {
            this.defs = defs;
        }

        public Map getProperties() {
            return this.defs;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeSupportListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final List listeners = new ArrayList();
        private Map cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File properties) {
            this.properties = properties;
            FileChangeSupport.DEFAULT.addListener(this, properties);
        }

        public Map getProperties() {
            long currTime = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != currTime) {
                this.cachedTime = currTime;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Properties properties;
                FileInputStream is = new FileInputStream(this.properties);
                try {
                    Properties props = new Properties();
                    props.load(is);
                    properties = props;
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                ((InputStream)is).close();
                return properties;
            }
            return Collections.EMPTY_MAP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] ls;
            this.cachedTime = -1L;
            FilePropertyProvider filePropertyProvider = this;
            synchronized (filePropertyProvider) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            final ChangeEvent ev = new ChangeEvent(this);
            final Mutex.Action action = new Mutex.Action(){

                public Object run() {
                    for (int i = 0; i < ls.length; ++i) {
                        ls[i].stateChanged(ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess(action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable(){

                    public void run() {
                        ProjectManager.mutex().readAccess(action);
                    }
                });
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        public void fileCreated(FileChangeSupportEvent event) {
            this.fireChange();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            this.fireChange();
        }

        public void fileModified(FileChangeSupportEvent event) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }
}

