/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

public class StoreGroup {
    private Map models;
    private Set modifiedDocuments;
    private static final Integer BOOLEAN_KIND_TF;
    private static final Integer BOOLEAN_KIND_YN;
    private static final Integer BOOLEAN_KIND_ED;
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }

        public void removeUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }

        public void changedUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public StoreGroup() {
        this.models = new HashMap();
        this.modifiedDocuments = new HashSet();
    }

    public void store(EditableProperties editableProperties) {
        Iterator it = this.models.keySet().iterator();
        while (it.hasNext()) {
            String txt;
            String key = (String)it.next();
            Object[] params = (Object[])this.models.get(key);
            if (params[0] instanceof ButtonModel) {
                ButtonModel model = (ButtonModel)params[0];
                boolean value = model.isSelected();
                if (params[2] == Boolean.TRUE) {
                    value = !value;
                }
                editableProperties.setProperty(key, StoreGroup.encodeBoolean(value, (Integer)params[1]));
                continue;
            }
            if (!(params[0] instanceof Document) || !this.modifiedDocuments.contains(params[0])) continue;
            Document doc = (Document)params[0];
            try {
                txt = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                txt = "";
            }
            editableProperties.setProperty(key, txt);
        }
    }

    public final JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator evaluator, String propertyName) {
        return this.createBooleanButtonModel(evaluator, propertyName, false);
    }

    public final JToggleButton.ToggleButtonModel createInverseToggleButtonModel(PropertyEvaluator evaluator, String propertyName) {
        return this.createBooleanButtonModel(evaluator, propertyName, true);
    }

    public final Document createStringDocument(PropertyEvaluator evaluator, String propertyName) {
        this.checkModelDoesNotExist(propertyName);
        String value = evaluator.getProperty(propertyName);
        if (value == null) {
            value = "";
        }
        try {
            PlainDocument d = new PlainDocument();
            d.remove(0, d.getLength());
            d.insertString(0, value, null);
            d.addDocumentListener(this.documentListener);
            this.models.put(propertyName, new Object[]{d});
            return d;
        }
        catch (BadLocationException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Bad location exception from new document.");
            }
            return new PlainDocument();
        }
    }

    private void checkModelDoesNotExist(String propertyName) {
        if (this.models.get(propertyName) != null) {
            throw new IllegalArgumentException("Model for property " + propertyName + "already exists.");
        }
    }

    private final JToggleButton.ToggleButtonModel createBooleanButtonModel(PropertyEvaluator evaluator, String propName, boolean invert) {
        this.checkModelDoesNotExist(propName);
        String value = evaluator.getProperty(propName);
        boolean isSelected = false;
        Integer kind = BOOLEAN_KIND_TF;
        if (value != null) {
            String lowercaseValue = value.toLowerCase();
            if (lowercaseValue.equals("yes") || lowercaseValue.equals("no")) {
                kind = BOOLEAN_KIND_YN;
            } else if (lowercaseValue.equals("on") || lowercaseValue.equals("off")) {
                kind = BOOLEAN_KIND_ED;
            }
            if (lowercaseValue.equals("true") || lowercaseValue.equals("yes") || lowercaseValue.equals("on")) {
                isSelected = true;
            }
        }
        JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel();
        bm.setSelected(invert ? !isSelected : isSelected);
        this.models.put(propName, new Object[]{bm, kind, invert});
        return bm;
    }

    private static String encodeBoolean(boolean value, Integer kind) {
        if (kind == BOOLEAN_KIND_ED) {
            return value ? "on" : "off";
        }
        if (kind == BOOLEAN_KIND_YN) {
            return value ? "yes" : "no";
        }
        return value ? "true" : "false";
    }

    private void documentModified(Document d) {
        this.modifiedDocuments.add(d);
    }

    static {
        $assertionsDisabled = !StoreGroup.class.desiredAssertionStatus();
        BOOLEAN_KIND_TF = new Integer(0);
        BOOLEAN_KIND_YN = new Integer(1);
        BOOLEAN_KIND_ED = new Integer(2);
    }
}

