/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.CustomizeScriptPanel;
import org.apache.tools.ant.module.wizards.shortcut.IntroPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectFolderPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectKeyboardShortcutPanel;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

final class ShortcutIterator
implements WizardDescriptor.Iterator {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient ShortcutWizard wiz;
    private transient Set listeners = new HashSet(1);

    ShortcutIterator() {
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new IntroPanel.IntroWizardPanel(), new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_select_menu_to_add_to"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_TEXT_menu_locn"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_display_name_for_menu"), DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Menu")), true, "wizdata.folder.menu"), new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_select_toolbar"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_TEXT_toolbar_locn"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_display_name_for_toolbar"), DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Toolbars")), false, "wizdata.folder.tool"), new SelectKeyboardShortcutPanel.SelectKeyboardShortcutWizardPanel(), new CustomizeScriptPanel.CustomizeScriptWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_choose_options"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_add_to_menu"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_add_to_toolbar"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_make_keyboard_shortcut"), NbBundle.getMessage((Class)ShortcutIterator.class, (String)"SI_LBL_cust_script")};
    }

    void initialize(ShortcutWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        ((IntroPanel.IntroWizardPanel)this.panels[0]).initialize(wiz);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public String name() {
        return NbBundle.getMessage((Class)ShortcutIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    boolean showing(String prop) {
        Boolean s = (Boolean)this.wiz.getProperty(prop);
        return s == null || s != false;
    }

    private boolean showing(int index) throws NoSuchElementException {
        switch (index) {
            case 0: {
                return true;
            }
            case 1: {
                return this.showing("wizdata.show.menu");
            }
            case 2: {
                return this.showing("wizdata.show.tool");
            }
            case 3: {
                return this.showing("wizdata.show.keyb");
            }
            case 4: {
                return this.showing("wizdata.show.cust");
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        for (int i = this.index + 1; i < this.panels.length; ++i) {
            if (!this.showing(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        while (!this.showing(this.index)) {
            ++this.index;
        }
        if (this.index == 1) {
            this.fireChangeEvent();
        }
    }

    public void previousPanel() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        while (!this.showing(this.index)) {
            --this.index;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }
}

