/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.SendEmailPanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategy;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class SendEmailAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        JavaClass beanClass = JMIUtils.getJavaClassFromNode((Node)nodes[0]);
        FileObject srcFile = JavaModel.getFileObject((Resource)beanClass.getResource());
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)srcFile);
        J2eeModuleProvider pwm = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
        SendEmailPanel p = new SendEmailPanel(erc.getServiceLocatorName());
        final DialogDescriptor nd = new DialogDescriptor((Object)p, NbBundle.getMessage(SendEmailAction.class, (String)"LBL_SpecifyMailResource"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SendEmailPanel.class), null);
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("SendEmailPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    nd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        p.checkJndiName();
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (option == NotifyDescriptor.OK_OPTION) {
            try {
                String jndiName = this.generateJNDILookup(p.getJndiName(), erc, beanClass.getName());
                String serviceLocator = p.getServiceLocator();
                ServiceLocatorStrategy serviceLocatorStrategy = null;
                if (serviceLocator != null) {
                    serviceLocatorStrategy = ServiceLocatorStrategy.create(enterpriseProject, srcFile, serviceLocator);
                }
                this.generateMethods(enterpriseProject, beanClass, jndiName, p.getJndiName(), serviceLocatorStrategy);
                this.fixImports(beanClass);
                if (serviceLocator != null) {
                    erc.setServiceLocatorName(serviceLocator);
                }
            }
            catch (IOException ioe) {
                NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ioe.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(SendEmailAction.class, (String)"LBL_SendEmailAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String generateJNDILookup(String jndiName, EnterpriseReferenceContainer erc, String className) throws IOException {
        ResourceRef ref = erc.createResourceRef(className);
        ref.setResRefName(jndiName);
        ref.setResAuth("Container");
        ref.setResSharingScope("Shareable");
        ref.setResType("javax.mail.Session");
        return erc.addResourceRef(ref, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMethods(Project project, JavaClass ce, String jndiName, String simpleName, ServiceLocatorStrategy sl) {
        boolean rollback = true;
        try {
            JMIUtils.beginJmiTransaction((boolean)true);
            String memberName = JMIUtils.uniqueMemberName((JavaClass)ce, (String)simpleName, (String)"mailResource");
            if (Utils.isJavaEE5orHigher(project) && InjectionTargetQuery.isInjectionTarget((JavaClass)ce)) {
                this.generateInjectedField(ce, simpleName, memberName);
                this.generateSendMailMethod(ce, memberName, null);
            } else {
                String sessionGetter = this.generateLookupMethod(ce, jndiName, simpleName, sl);
                this.generateSendMailMethod(ce, memberName, sessionGetter);
            }
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixImports(JavaClass javaClass) {
        boolean rollback = true;
        try {
            JMIUtils.beginJmiTransaction((boolean)true);
            JMIUtils.fixImports((JavaClass)javaClass);
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    private void generateSendMailMethod(JavaClass ce, String sessionVariableName, String sessionGetter) {
        Method me = JMIUtils.createMethod((JavaClass)ce);
        me.setModifiers(2);
        String methodName = JMIUtils.uniqueMemberName((JavaClass)ce, (String)"sendMail", (String)"mailResource");
        me.setName(methodName);
        me.setType(JMIUtils.resolveType((String)"void"));
        List parameters = me.getParameters();
        parameters.add(JMIUtils.createParameter((Method)me, (String)"email", (Type)JMIUtils.resolveType((String)"String"), (boolean)false));
        parameters.add(JMIUtils.createParameter((Method)me, (String)"subject", (Type)JMIUtils.resolveType((String)"String"), (boolean)false));
        parameters.add(JMIUtils.createParameter((Method)me, (String)"body", (Type)JMIUtils.resolveType((String)"String"), (boolean)false));
        JMIUtils.addException((Method)me, (String)NamingException.class.getName());
        JMIUtils.addException((Method)me, (String)"javax.mail.MessagingException");
        me.setBodyText(this.getSendCode(sessionVariableName, sessionGetter));
        ce.getContents().add(me);
    }

    private String getSendCode(String sessionVariableName, String sessionGetter) {
        return (sessionGetter != null ? "javax.mail.Session " + sessionVariableName + " = " + sessionGetter + "();\n" : "") + "javax.mail.internet.MimeMessage message = new javax.mail.internet.MimeMessage(" + sessionVariableName + ");\n" + "message.setSubject(subject);\n" + "message.setRecipients(javax.mail.Message.RecipientType.TO, javax.mail.internet.InternetAddress.parse(email, false));\n" + "message.setText(body);\n" + "javax.mail.Transport.send(message);\n";
    }

    private String generateLookupMethod(JavaClass ce, String jndiName, String simpleName, ServiceLocatorStrategy sl) {
        Method me = JMIUtils.createMethod((JavaClass)ce);
        me.setModifiers(2);
        String sessionGetter = "get" + simpleName.substring(0, 1).toUpperCase() + simpleName.substring(1);
        sessionGetter = JMIUtils.uniqueMemberName((JavaClass)ce, (String)sessionGetter, (String)"mailResource");
        me.setName(sessionGetter);
        me.setType(JMIUtils.resolveType((String)"javax.mail.Session"));
        JMIUtils.addException((Method)me, (String)NamingException.class.getName());
        if (sl == null) {
            me.setBodyText(this.getSessionCode(jndiName));
        } else {
            me.setBodyText(this.getSessionCode(jndiName, sl, ce));
        }
        ce.getContents().add(me);
        return sessionGetter;
    }

    private String getSessionCode(String jndiName, ServiceLocatorStrategy sl, JavaClass target) {
        String mailLookupString = sl.genMailSession(jndiName, target);
        return "return (javax.mail.Session) " + mailLookupString + ";\n";
    }

    private String getSessionCode(String jndiName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\nreturn (javax.mail.Session) c.lookup(\"java:comp/env/{0}\");\n", jndiName);
    }

    private void generateInjectedField(JavaClass jc, String jndiName, String simpleName) {
        int modifier = InjectionTargetQuery.isStaticReferenceRequired((JavaClass)jc) ? 10 : 2;
        Field f = JMIGenerationUtil.createField((Element)jc, (String)simpleName, (int)modifier, (String)"javax.mail.Session");
        AttributeValue av = JMIGenerationUtil.createAttributeValue((Element)jc, (String)"name", (String)jndiName);
        Annotation a = JMIGenerationUtil.createAnnotation((Element)jc, (String)"javax.annotation.Resource", Collections.singletonList(av));
        f.getAnnotations().add(a);
        jc.getFeatures().add(0, f);
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return false;
        }
        JavaClass jc = JMIUtils.getJavaClassFromNode((Node)nodes[0]);
        if (jc == null) {
            return false;
        }
        FileObject srcFile = JavaModel.getFileObject((Resource)jc.getResource());
        Project project = FileOwnerQuery.getOwner((FileObject)srcFile);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
        if (serverInstanceId == null) {
            return true;
        }
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceId);
        if (platform == null) {
            return true;
        }
        if (!platform.getSupportedModuleTypes().contains(J2eeModule.EJB)) {
            return false;
        }
        return !jc.isInterface();
    }

    protected void initialize() {
        super.initialize();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        boolean enable = this.enable(actionContext.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]));
        return enable ? this : null;
    }
}

