/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;

    public JavadocForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        if (this.isRootOwner(binaryRoot, "build.classes.dir") || this.isRootOwner(binaryRoot, "dist.war")) {
            class R
            implements JavadocForBinaryQuery.Result,
            PropertyChangeListener {
                private List listeners;
                private URL[] result;

                public R() {
                    JavadocForBinaryQueryImpl.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavadocForBinaryQueryImpl.this.evaluator));
                }

                public synchronized URL[] getRoots() {
                    if (this.result == null) {
                        String javadocDir = JavadocForBinaryQueryImpl.this.evaluator.getProperty("dist.javadoc.dir");
                        if (javadocDir != null) {
                            File f = JavadocForBinaryQueryImpl.this.helper.resolveFile(javadocDir);
                            try {
                                URL url = f.toURI().toURL();
                                if (!f.exists()) {
                                    assert (!url.toExternalForm().endsWith("/")) : f;
                                    url = new URL(url.toExternalForm() + "/");
                                }
                                this.result = new URL[]{url};
                            }
                            catch (MalformedURLException e) {
                                this.result = new URL[0];
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        } else {
                            this.result = new URL[0];
                        }
                    }
                    return this.result;
                }

                public synchronized void addChangeListener(ChangeListener l) {
                    assert (l != null);
                    if (this.listeners == null) {
                        this.listeners = new ArrayList();
                    }
                    this.listeners.add(l);
                }

                public synchronized void removeChangeListener(ChangeListener l) {
                    assert (l != null);
                    if (this.listeners == null) {
                        return;
                    }
                    this.listeners.remove(l);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent event) {
                    if ("dist.javadoc.dir".equals(event.getPropertyName())) {
                        R r = this;
                        synchronized (r) {
                            this.result = null;
                        }
                        this.fireChange();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void fireChange() {
                    ChangeListener[] _listeners;
                    R r = this;
                    synchronized (r) {
                        if (this.listeners == null) {
                            return;
                        }
                        _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
                    }
                    ChangeEvent event = new ChangeEvent(this);
                    for (int i = 0; i < _listeners.length; ++i) {
                        _listeners[i].stateChanged(event);
                    }
                }
            }
            return new R();
        }
        return null;
    }

    private boolean isRootOwner(URL binaryRoot, String binaryProperty) {
        try {
            String outDir;
            if (FileUtil.getArchiveFile((URL)binaryRoot) != null) {
                binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
            }
            if ((outDir = this.evaluator.getProperty(binaryProperty)) != null) {
                File f = this.helper.resolveFile(outDir);
                URL url = f.toURI().toURL();
                if (!f.exists() && !f.getPath().toLowerCase().endsWith(".jar")) {
                    assert (!url.toExternalForm().endsWith("/")) : f;
                    url = new URL(url.toExternalForm() + "/");
                }
                return url.equals(binaryRoot) || binaryRoot.toExternalForm().startsWith(url.toExternalForm());
            }
        }
        catch (MalformedURLException malformedURL) {
            ErrorManager.getDefault().notify((Throwable)malformedURL);
        }
        return false;
    }
}

